/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf.ctx.state.geofencing;

import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.script.api.tbel.TbelCfArg;
import org.thingsboard.script.api.tbel.TbelCfGeofencingArg;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.util.ProtoUtils;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntryType;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldCtx;
import org.thingsboard.server.service.cf.ctx.state.HasLatestTs;
import org.thingsboard.server.service.cf.ctx.state.geofencing.GeofencingZoneState;

public class GeofencingArgumentEntry
implements ArgumentEntry,
HasLatestTs {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GeofencingArgumentEntry.class);
    private Map<EntityId, GeofencingZoneState> zoneStates;
    private boolean forceResetPrevious;

    public GeofencingArgumentEntry() {
    }

    public GeofencingArgumentEntry(EntityId entityId, TransportProtos.AttributeValueProto entry) {
        this(Map.of(entityId, ProtoUtils.fromProto((TransportProtos.AttributeValueProto)entry)));
    }

    public GeofencingArgumentEntry(Map<EntityId, KvEntry> entityIdkvEntryMap) {
        this.zoneStates = this.toZones(entityIdkvEntryMap);
    }

    public ArgumentEntryType getType() {
        return ArgumentEntryType.GEOFENCING;
    }

    public Object getValue() {
        return this.zoneStates;
    }

    public long getLatestTs() {
        return this.zoneStates.values().stream().mapToLong(GeofencingZoneState::getTs).max().orElse(-1L);
    }

    public boolean updateEntry(ArgumentEntry entry, CalculatedFieldCtx ctx) {
        if (!(entry instanceof GeofencingArgumentEntry)) {
            throw new IllegalArgumentException("Unsupported argument entry type for geofencing argument entry: " + String.valueOf(entry.getType()));
        }
        GeofencingArgumentEntry geofencingArgumentEntry = (GeofencingArgumentEntry)entry;
        if (geofencingArgumentEntry.isEmpty()) {
            this.zoneStates.clear();
            return true;
        }
        boolean updated = false;
        for (Map.Entry zoneEntry : geofencingArgumentEntry.getZoneStates().entrySet()) {
            if (!this.updateZone(zoneEntry)) continue;
            updated = true;
        }
        return updated;
    }

    public boolean isEmpty() {
        return this.zoneStates == null || this.zoneStates.isEmpty();
    }

    public TbelCfArg toTbelCfArg() {
        return new TbelCfGeofencingArg((Object)this.zoneStates);
    }

    private Map<EntityId, GeofencingZoneState> toZones(Map<EntityId, KvEntry> entityIdKvEntryMap) {
        return entityIdKvEntryMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new GeofencingZoneState((EntityId)entry.getKey(), (KvEntry)entry.getValue())));
    }

    private boolean updateZone(Map.Entry<EntityId, GeofencingZoneState> zoneEntry) {
        EntityId zoneId = zoneEntry.getKey();
        GeofencingZoneState newZoneState = zoneEntry.getValue();
        GeofencingZoneState existingZoneState = (GeofencingZoneState)this.zoneStates.get(zoneId);
        if (existingZoneState == null) {
            this.zoneStates.put(zoneId, newZoneState);
            return true;
        }
        if (newZoneState.getPerimeterDefinition() == null) {
            this.zoneStates.remove(zoneId);
            return true;
        }
        return existingZoneState.update(newZoneState);
    }

    @Generated
    public Map<EntityId, GeofencingZoneState> getZoneStates() {
        return this.zoneStates;
    }

    @Generated
    public boolean isForceResetPrevious() {
        return this.forceResetPrevious;
    }

    @Generated
    public void setZoneStates(Map<EntityId, GeofencingZoneState> zoneStates) {
        this.zoneStates = zoneStates;
    }

    @Generated
    public void setForceResetPrevious(boolean forceResetPrevious) {
        this.forceResetPrevious = forceResetPrevious;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeofencingArgumentEntry)) {
            return false;
        }
        GeofencingArgumentEntry other = (GeofencingArgumentEntry)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isForceResetPrevious() != other.isForceResetPrevious()) {
            return false;
        }
        Map this$zoneStates = this.getZoneStates();
        Map other$zoneStates = other.getZoneStates();
        return !(this$zoneStates == null ? other$zoneStates != null : !((Object)this$zoneStates).equals(other$zoneStates));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GeofencingArgumentEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isForceResetPrevious() ? 79 : 97);
        Map $zoneStates = this.getZoneStates();
        result = result * 59 + ($zoneStates == null ? 43 : ((Object)$zoneStates).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GeofencingArgumentEntry(zoneStates=" + String.valueOf(this.getZoneStates()) + ", forceResetPrevious=" + this.isForceResetPrevious() + ")";
    }
}

