/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf.ctx.state.alarm;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.common.util.KvUtil;
import org.thingsboard.rule.engine.action.TbAlarmResult;
import org.thingsboard.server.actors.TbActorRef;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmApiCallResult;
import org.thingsboard.server.common.data.alarm.AlarmCreateOrUpdateActiveRequest;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.alarm.AlarmUpdateRequest;
import org.thingsboard.server.common.data.alarm.rule.AlarmRule;
import org.thingsboard.server.common.data.alarm.rule.condition.AlarmCondition;
import org.thingsboard.server.common.data.alarm.rule.condition.AlarmConditionType;
import org.thingsboard.server.common.data.alarm.rule.condition.AlarmConditionValue;
import org.thingsboard.server.common.data.alarm.rule.condition.expression.AlarmConditionExpression;
import org.thingsboard.server.common.data.alarm.rule.condition.expression.AlarmConditionFilter;
import org.thingsboard.server.common.data.alarm.rule.condition.expression.ComplexOperation;
import org.thingsboard.server.common.data.alarm.rule.condition.expression.SimpleAlarmConditionExpression;
import org.thingsboard.server.common.data.alarm.rule.condition.expression.TbelAlarmConditionExpression;
import org.thingsboard.server.common.data.alarm.rule.condition.expression.predicate.BooleanFilterPredicate;
import org.thingsboard.server.common.data.alarm.rule.condition.expression.predicate.ComplexFilterPredicate;
import org.thingsboard.server.common.data.alarm.rule.condition.expression.predicate.KeyFilterPredicate;
import org.thingsboard.server.common.data.alarm.rule.condition.expression.predicate.NoDataFilterPredicate;
import org.thingsboard.server.common.data.alarm.rule.condition.expression.predicate.NumericFilterPredicate;
import org.thingsboard.server.common.data.alarm.rule.condition.expression.predicate.StringFilterPredicate;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.cf.CalculatedFieldType;
import org.thingsboard.server.common.data.cf.configuration.AlarmCalculatedFieldConfiguration;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.service.cf.AlarmCalculatedFieldResult;
import org.thingsboard.server.service.cf.CalculatedFieldResult;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.BaseCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldCtx;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.SingleValueArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.alarm.AlarmCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.alarm.AlarmEvalResult;
import org.thingsboard.server.service.cf.ctx.state.alarm.AlarmRuleState;

public class AlarmCalculatedFieldState
extends BaseCalculatedFieldState {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlarmCalculatedFieldState.class);
    private AlarmCalculatedFieldConfiguration configuration;
    private String alarmType;
    private final Map<AlarmSeverity, AlarmRuleState> createRuleStates = new TreeMap(Comparator.comparing(Enum::ordinal));
    private AlarmRuleState clearRuleState;
    private Alarm currentAlarm;
    private boolean initialFetchDone;

    public AlarmCalculatedFieldState(EntityId entityId) {
        super(entityId);
    }

    public void setCtx(CalculatedFieldCtx ctx, TbActorRef actorCtx) {
        super.setCtx(ctx, actorCtx);
        this.configuration = this.getConfiguration(ctx);
        this.alarmType = ctx.getCalculatedField().getName();
        Map createRules = this.configuration.getCreateRules();
        createRules.forEach((severity, rule) -> {
            AlarmRuleState ruleState = (AlarmRuleState)this.createRuleStates.get(severity);
            if (ruleState != null) {
                ruleState.setAlarmRule(rule);
            }
        });
        AlarmRule clearRule = this.configuration.getClearRule();
        if (clearRule != null && this.clearRuleState != null) {
            this.clearRuleState.setAlarmRule(clearRule);
        }
        if (this.currentAlarm != null && !this.currentAlarm.getType().equals(this.alarmType)) {
            this.currentAlarm = null;
            this.initialFetchDone = false;
        }
    }

    public void init(boolean restored) {
        super.init(restored);
        AtomicBoolean reevalNeeded = new AtomicBoolean(false);
        Map createRules = this.configuration.getCreateRules();
        for (AlarmSeverity severity : AlarmSeverity.values()) {
            AlarmRule rule = (AlarmRule)createRules.get(severity);
            if (rule != null) {
                this.createRuleStates.compute(severity, (__, ruleState) -> this.initRuleState(severity, rule, ruleState, reevalNeeded));
                continue;
            }
            AlarmRuleState state2 = (AlarmRuleState)this.createRuleStates.remove(severity);
            if (state2 == null) continue;
            this.clearState(state2);
        }
        AlarmRule clearRule = this.configuration.getClearRule();
        if (clearRule != null) {
            this.clearRuleState = this.initRuleState(null, clearRule, this.clearRuleState, reevalNeeded);
        } else if (this.clearRuleState != null) {
            this.clearState(this.clearRuleState);
            this.clearRuleState = null;
        }
        log.debug("Initialized create rule states {} and clear rule state {} for {}. Restored: {}, reeval needed: {}", new Object[]{this.createRuleStates, this.clearRuleState, this.configuration, restored, reevalNeeded});
        if (reevalNeeded.get()) {
            this.initCurrentAlarm(this.ctx);
            this.createOrClearAlarms(state -> {
                ScheduledFuture future;
                AlarmEvalResult evalResult;
                if (state.getCondition().getType() == AlarmConditionType.DURATION && ((evalResult = state.reeval(System.currentTimeMillis(), this.ctx)).getStatus() == AlarmEvalResult.Status.TRUE || evalResult.getStatus() == AlarmEvalResult.Status.NOT_YET_TRUE) && (future = this.ctx.scheduleReevaluation(evalResult.getLeftDuration(), this.actorCtx)) != null) {
                    state.setDurationCheckFuture(future);
                }
                return AlarmEvalResult.NOT_YET_TRUE;
            }, this.ctx);
        }
    }

    private AlarmRuleState initRuleState(AlarmSeverity severity, AlarmRule rule, AlarmRuleState ruleState, AtomicBoolean reevalNeeded) {
        if (ruleState == null) {
            ruleState = new AlarmRuleState(severity, rule, this);
        } else {
            ruleState.setAlarmRule(rule);
            ruleState.setActive(null);
            AlarmCondition condition = rule.getCondition();
            if (condition.hasSchedule() || condition.getType() == AlarmConditionType.DURATION && !ruleState.isEmpty()) {
                reevalNeeded.set(true);
            }
        }
        return ruleState;
    }

    public void reset() {
        super.reset();
        this.configuration = null;
    }

    public void close() {
        super.close();
        for (AlarmRuleState state : this.createRuleStates.values()) {
            this.clearState(state);
        }
        this.clearState(this.clearRuleState);
    }

    public ListenableFuture<CalculatedFieldResult> performCalculation(Map<String, ArgumentEntry> updatedArgs, CalculatedFieldCtx ctx) {
        this.initCurrentAlarm(ctx);
        TbAlarmResult result = this.createOrClearAlarms(state -> {
            if (updatedArgs != null) {
                long leftDuration;
                ScheduledFuture future;
                boolean newEvent = !updatedArgs.isEmpty();
                AlarmEvalResult evalResult = state.eval(newEvent, ctx);
                if (evalResult.getStatus() == AlarmEvalResult.Status.NOT_YET_TRUE && evalResult.getLeftDuration() > 0L && (future = ctx.scheduleReevaluation(leftDuration = evalResult.getLeftDuration(), this.actorCtx)) != null) {
                    state.setDurationCheckFuture(future);
                }
                return evalResult.withCause(AlarmEvalResult.Cause.NEW_EVENT);
            }
            return state.reeval(System.currentTimeMillis(), ctx).withCause(AlarmEvalResult.Cause.SCHEDULED_REEVALUATION);
        }, ctx);
        return Futures.immediateFuture((Object)AlarmCalculatedFieldResult.builder().alarmResult(result).build());
    }

    protected boolean updateEntry(ArgumentEntry existingArgumentEntry, ArgumentEntry newArgumentEntry, CalculatedFieldCtx ctx) {
        SingleValueArgumentEntry existingEntry;
        block5: {
            block4: {
                if (!(existingArgumentEntry instanceof SingleValueArgumentEntry)) break block4;
                existingEntry = (SingleValueArgumentEntry)existingArgumentEntry;
                if (newArgumentEntry instanceof SingleValueArgumentEntry) break block5;
            }
            return super.updateEntry(existingArgumentEntry, newArgumentEntry, ctx);
        }
        SingleValueArgumentEntry newEntry = (SingleValueArgumentEntry)newArgumentEntry;
        if (newEntry.getTs() < existingEntry.getTs() && existingEntry.isDefaultValue()) {
            existingEntry.setTs(newEntry.getTs());
        }
        return super.updateEntry((ArgumentEntry)existingEntry, (ArgumentEntry)newEntry, ctx);
    }

    public void processAlarmAction(Alarm alarm, ActionType action) {
        switch (1.$SwitchMap$org$thingsboard$server$common$data$audit$ActionType[action.ordinal()]) {
            case 1: {
                this.processAlarmAck(alarm);
                break;
            }
            case 2: {
                this.processAlarmClear(alarm);
                break;
            }
            case 3: {
                this.processAlarmDelete(alarm);
            }
        }
    }

    private void processAlarmClear(Alarm alarm) {
        this.currentAlarm = null;
        this.createRuleStates.values().forEach(arg_0 -> this.clearState(arg_0));
        this.clearState(this.clearRuleState);
    }

    private void processAlarmAck(Alarm alarm) {
        this.currentAlarm.setAcknowledged(alarm.isAcknowledged());
        this.currentAlarm.setAckTs(alarm.getAckTs());
    }

    private void processAlarmDelete(Alarm alarm) {
        this.processAlarmClear(alarm);
    }

    private TbAlarmResult createOrClearAlarms(Function<AlarmRuleState, AlarmEvalResult> evalFunction, CalculatedFieldCtx ctx) {
        AlarmEvalResult evalResult = null;
        AlarmRuleState resultState = null;
        AlarmRuleState.StateInfo resultStateInfo = null;
        for (Object state : this.createRuleStates.values()) {
            evalResult = evalFunction.apply((AlarmRuleState)state);
            log.debug("Evaluated create rule {} with args {}. Result: {}", new Object[]{state, this.arguments, evalResult});
            if (evalResult.getStatus() == AlarmEvalResult.Status.TRUE) {
                resultState = state;
                break;
            }
            if (evalResult.getStatus() != AlarmEvalResult.Status.FALSE) continue;
            this.clearState((AlarmRuleState)state);
        }
        TbAlarmResult result = null;
        if (resultState != null) {
            result = this.calculateAlarmResult(resultState, evalResult, ctx);
            resultStateInfo = resultState.getStateInfo();
            log.debug("Alarm result for state {}: {}", resultState, (Object)result);
            this.clearState(this.clearRuleState);
        } else if (this.currentAlarm != null && this.clearRuleState != null) {
            evalResult = evalFunction.apply(this.clearRuleState);
            log.debug("Evaluated clear rule {} with args {}. Result: {}", new Object[]{this.clearRuleState, this.arguments, evalResult});
            if (evalResult.getStatus() == AlarmEvalResult.Status.TRUE) {
                resultStateInfo = this.clearRuleState.getStateInfo();
                this.clearState(this.clearRuleState);
                for (AlarmRuleState state : this.createRuleStates.values()) {
                    this.clearState(state);
                }
                AlarmApiCallResult clearResult = ctx.getAlarmService().clearAlarm(ctx.getTenantId(), this.currentAlarm.getId(), System.currentTimeMillis(), this.createDetails(this.clearRuleState), false);
                if (clearResult.isCleared()) {
                    result = TbAlarmResult.builder().isCleared(true).alarm((Alarm)clearResult.getAlarm()).build();
                    resultState = this.clearRuleState;
                }
                this.currentAlarm = null;
            } else if (evalResult.getStatus() == AlarmEvalResult.Status.FALSE) {
                this.clearState(this.clearRuleState);
            }
        }
        if (result != null && resultState != null) {
            result.setConditionRepeats(resultStateInfo.eventCount());
            result.setConditionDuration(resultStateInfo.duration());
        }
        return result;
    }

    private void clearState(AlarmRuleState state) {
        if (state != null) {
            log.debug("Clearing rule state {}", (Object)state);
            state.clear();
        }
    }

    private void initCurrentAlarm(CalculatedFieldCtx ctx) {
        if (!this.initialFetchDone) {
            Alarm alarm = ctx.getAlarmService().findLatestActiveByOriginatorAndType(ctx.getTenantId(), this.entityId, this.alarmType);
            if (alarm != null && !alarm.getStatus().isCleared()) {
                this.currentAlarm = alarm;
            }
            this.initialFetchDone = true;
        }
    }

    private TbAlarmResult calculateAlarmResult(AlarmRuleState ruleState, AlarmEvalResult evalResult, CalculatedFieldCtx ctx) {
        AlarmSeverity severity = ruleState.getSeverity();
        if (this.currentAlarm != null) {
            AlarmSeverity oldSeverity = this.currentAlarm.getSeverity();
            if (severity.ordinal() > oldSeverity.ordinal()) {
                log.trace("Skipping alarm update for result state {} for eval result {} because severity is decreased", (Object)ruleState, (Object)evalResult);
                return null;
            }
            if (severity.ordinal() == oldSeverity.ordinal() && evalResult.getCause() == AlarmEvalResult.Cause.SCHEDULED_REEVALUATION) {
                log.trace("Skipping alarm update for result state {} for eval result {}", (Object)ruleState, (Object)evalResult);
                return null;
            }
            this.currentAlarm.setEndTs(System.currentTimeMillis());
            this.currentAlarm.setDetails(this.createDetails(ruleState));
            this.currentAlarm.setSeverity(severity);
            AlarmApiCallResult result = ctx.getAlarmService().updateAlarm(AlarmUpdateRequest.fromAlarm((Alarm)this.currentAlarm));
            this.currentAlarm = result.getAlarm();
            return TbAlarmResult.fromAlarmResult((AlarmApiCallResult)result);
        }
        Alarm newAlarm = new Alarm();
        newAlarm.setType(this.alarmType);
        newAlarm.setAcknowledged(false);
        newAlarm.setCleared(false);
        newAlarm.setSeverity(severity);
        long startTs = this.getLatestTimestamp();
        long currentTime = System.currentTimeMillis();
        if (startTs <= 0L || startTs > currentTime) {
            startTs = currentTime;
        }
        newAlarm.setStartTs(startTs);
        newAlarm.setEndTs(startTs);
        newAlarm.setDetails(this.createDetails(ruleState));
        newAlarm.setOriginator(this.entityId);
        newAlarm.setTenantId(ctx.getTenantId());
        newAlarm.setPropagate(this.configuration.isPropagate());
        newAlarm.setPropagateToOwner(this.configuration.isPropagateToOwner());
        newAlarm.setPropagateToOwnerHierarchy(this.configuration.isPropagateToOwnerHierarchy());
        newAlarm.setPropagateToTenant(this.configuration.isPropagateToTenant());
        if (this.configuration.getPropagateRelationTypes() != null) {
            newAlarm.setPropagateRelationTypes(this.configuration.getPropagateRelationTypes());
        }
        AlarmApiCallResult result = ctx.getAlarmService().createAlarm(AlarmCreateOrUpdateActiveRequest.fromAlarm((Alarm)newAlarm));
        this.currentAlarm = result.getAlarm();
        return TbAlarmResult.fromAlarmResult((AlarmApiCallResult)result);
    }

    private JsonNode createDetails(AlarmRuleState ruleState) {
        Object alarmDetails;
        String alarmDetailsStr = ruleState.getAlarmRule().getAlarmDetails();
        DashboardId dashboardId = ruleState.getAlarmRule().getDashboardId();
        if (StringUtils.isNotEmpty((String)alarmDetailsStr) || dashboardId != null) {
            ObjectNode newDetails = JacksonUtil.newObjectNode();
            if (StringUtils.isNotEmpty((String)alarmDetailsStr)) {
                for (Map.Entry entry : this.arguments.entrySet()) {
                    String key = (String)entry.getKey();
                    ArgumentEntry value = (ArgumentEntry)entry.getValue();
                    alarmDetailsStr = alarmDetailsStr.replaceAll(String.format("\\$\\{%s}", key), String.valueOf(value.getValue()));
                }
                newDetails.put("data", alarmDetailsStr);
            }
            if (dashboardId != null) {
                newDetails.put("dashboardId", dashboardId.getId().toString());
            }
            alarmDetails = newDetails;
        } else {
            alarmDetails = this.currentAlarm != null ? this.currentAlarm.getDetails() : JacksonUtil.newObjectNode();
        }
        return alarmDetails;
    }

    public boolean eval(AlarmConditionExpression expression, CalculatedFieldCtx ctx) {
        if (expression instanceof TbelAlarmConditionExpression) {
            TbelAlarmConditionExpression tbelExpression = (TbelAlarmConditionExpression)expression;
            Object result = ctx.evaluateTbelExpression(tbelExpression.getExpression(), (CalculatedFieldState)this).get();
            if (result instanceof Boolean) {
                Boolean booleanResult = (Boolean)result;
                return booleanResult;
            }
            throw new IllegalStateException("Condition expression returned non-boolean value: '" + String.valueOf(result) + "'");
        }
        SimpleAlarmConditionExpression simpleExpression = (SimpleAlarmConditionExpression)expression;
        ComplexOperation operation = simpleExpression.getOperation();
        if (operation == null) {
            operation = ComplexOperation.AND;
        }
        return switch (1.$SwitchMap$org$thingsboard$server$common$data$alarm$rule$condition$expression$ComplexOperation[operation.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> simpleExpression.getFilters().stream().allMatch(filter -> this.eval(this.getArgument(filter.getArgument()), filter));
            case 2 -> simpleExpression.getFilters().stream().anyMatch(filter -> this.eval(this.getArgument(filter.getArgument()), filter));
        };
    }

    private boolean eval(SingleValueArgumentEntry argument, AlarmConditionFilter filter) {
        ComplexOperation operation = filter.getOperation();
        if (operation == null) {
            operation = ComplexOperation.AND;
        }
        return switch (1.$SwitchMap$org$thingsboard$server$common$data$alarm$rule$condition$expression$ComplexOperation[operation.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> filter.getPredicates().stream().allMatch(predicate -> this.eval(argument, predicate));
            case 2 -> filter.getPredicates().stream().anyMatch(predicate -> this.eval(argument, predicate));
        };
    }

    private boolean eval(SingleValueArgumentEntry argument, KeyFilterPredicate predicate) {
        return switch (1.$SwitchMap$org$thingsboard$server$common$data$alarm$rule$condition$expression$predicate$FilterPredicateType[predicate.getType().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> this.evalStrPredicate(argument, (StringFilterPredicate)predicate);
            case 2 -> this.evalNumPredicate(argument, (NumericFilterPredicate)predicate);
            case 3 -> this.evalBooleanPredicate(argument, (BooleanFilterPredicate)predicate);
            case 4 -> this.evalNoDataPredicate(argument, (NoDataFilterPredicate)predicate);
            case 5 -> this.evalComplexPredicate(argument, (ComplexFilterPredicate)predicate);
        };
    }

    private boolean evalComplexPredicate(SingleValueArgumentEntry argument, ComplexFilterPredicate complexPredicate) {
        return switch (1.$SwitchMap$org$thingsboard$server$common$data$alarm$rule$condition$expression$ComplexOperation[complexPredicate.getOperation().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 2 -> {
                for (KeyFilterPredicate predicate : complexPredicate.getPredicates()) {
                    if (!this.eval(argument, predicate)) continue;
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                for (KeyFilterPredicate predicate : complexPredicate.getPredicates()) {
                    if (this.eval(argument, predicate)) continue;
                    yield false;
                }
                yield true;
            }
        };
    }

    private boolean evalBooleanPredicate(SingleValueArgumentEntry argument, BooleanFilterPredicate predicate) {
        Boolean value = KvUtil.getBoolValue((KvEntry)argument.getKvEntryValue());
        if (value == null) {
            return false;
        }
        Boolean predicateValue = (Boolean)this.resolveValue(predicate.getValue(), KvUtil::getBoolValue);
        if (predicateValue == null) {
            return false;
        }
        return switch (1.$SwitchMap$org$thingsboard$server$common$data$alarm$rule$condition$expression$predicate$BooleanFilterPredicate$BooleanOperation[predicate.getOperation().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> value.equals(predicateValue);
            case 2 -> !value.equals(predicateValue);
        };
    }

    private boolean evalNumPredicate(SingleValueArgumentEntry argument, NumericFilterPredicate predicate) {
        Double value = KvUtil.getDoubleValue((KvEntry)argument.getKvEntryValue());
        if (value == null) {
            return false;
        }
        Double predicateValue = (Double)this.resolveValue(predicate.getValue(), KvUtil::getDoubleValue);
        if (predicateValue == null) {
            return false;
        }
        return switch (1.$SwitchMap$org$thingsboard$server$common$data$alarm$rule$condition$expression$predicate$NumericFilterPredicate$NumericOperation[predicate.getOperation().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> {
                if (!value.equals(predicateValue)) {
                    yield true;
                }
                yield false;
            }
            case 2 -> value.equals(predicateValue);
            case 3 -> {
                if (value > predicateValue) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (value >= predicateValue) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                if (value < predicateValue) {
                    yield true;
                }
                yield false;
            }
            case 6 -> value <= predicateValue;
        };
    }

    private boolean evalStrPredicate(SingleValueArgumentEntry argument, StringFilterPredicate predicate) {
        String value = KvUtil.getStringValue((KvEntry)argument.getKvEntryValue());
        if (value == null) {
            return false;
        }
        String predicateValue = (String)this.resolveValue(predicate.getValue(), KvUtil::getStringValue);
        if (predicateValue == null) {
            return false;
        }
        if (predicate.isIgnoreCase()) {
            value = value.toLowerCase();
            predicateValue = predicateValue.toLowerCase();
        }
        return switch (1.$SwitchMap$org$thingsboard$server$common$data$alarm$rule$condition$expression$predicate$StringFilterPredicate$StringOperation[predicate.getOperation().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> value.contains(predicateValue);
            case 2 -> value.equals(predicateValue);
            case 3 -> value.startsWith(predicateValue);
            case 4 -> value.endsWith(predicateValue);
            case 5 -> {
                if (!value.equals(predicateValue)) {
                    yield true;
                }
                yield false;
            }
            case 6 -> {
                if (!value.contains(predicateValue)) {
                    yield true;
                }
                yield false;
            }
            case 7 -> StringUtils.equalsAny((String)value, (List)StringUtils.splitByCommaWithoutQuotes((String)predicateValue));
            case 8 -> !StringUtils.equalsAny((String)value, (List)StringUtils.splitByCommaWithoutQuotes((String)predicateValue));
        };
    }

    private boolean evalNoDataPredicate(SingleValueArgumentEntry argument, NoDataFilterPredicate predicate) {
        long passedMs = System.currentTimeMillis() - argument.getTs();
        long duration = (Long)this.resolveValue(predicate.getDuration(), KvUtil::getLongValue);
        if (duration > 0L) {
            long requiredDuration = predicate.getUnit().toMillis(duration);
            log.trace("[{}] No data for argument {} during {} ms, required duration: {} ms", new Object[]{this.ctx, argument, passedMs, requiredDuration});
            return passedMs >= requiredDuration;
        }
        return false;
    }

    protected <T> T resolveValue(AlarmConditionValue<T> conditionValue, Function<KvEntry, T> mapper) {
        String argument;
        SingleValueArgumentEntry entry;
        Object value = conditionValue.getStaticValue();
        if (value == null && (value = mapper.apply((KvEntry)(entry = this.getArgument(argument = conditionValue.getDynamicValueArgument())).getKvEntryValue())) == null) {
            throw new IllegalArgumentException("No proper value found for argument " + argument);
        }
        return (T)value;
    }

    protected SingleValueArgumentEntry getArgument(String key) {
        SingleValueArgumentEntry entry = (SingleValueArgumentEntry)this.arguments.get(key);
        if (entry == null) {
            throw new IllegalArgumentException("Argument '" + key + "' is missing");
        }
        return entry;
    }

    private AlarmCalculatedFieldConfiguration getConfiguration(CalculatedFieldCtx ctx) {
        return (AlarmCalculatedFieldConfiguration)ctx.getCalculatedField().getConfiguration();
    }

    protected void validateNewEntry(String key, ArgumentEntry newEntry) {
        if (!(newEntry instanceof SingleValueArgumentEntry)) {
            throw new IllegalArgumentException("Only single value arguments supported");
        }
    }

    public CalculatedFieldType getType() {
        return CalculatedFieldType.ALARM;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlarmCalculatedFieldState)) {
            return false;
        }
        AlarmCalculatedFieldState other = (AlarmCalculatedFieldState)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.initialFetchDone != other.initialFetchDone) {
            return false;
        }
        AlarmCalculatedFieldConfiguration this$configuration = this.configuration;
        AlarmCalculatedFieldConfiguration other$configuration = other.configuration;
        if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
            return false;
        }
        String this$alarmType = this.alarmType;
        String other$alarmType = other.alarmType;
        if (this$alarmType == null ? other$alarmType != null : !this$alarmType.equals(other$alarmType)) {
            return false;
        }
        Map this$createRuleStates = this.getCreateRuleStates();
        Map other$createRuleStates = other.getCreateRuleStates();
        if (this$createRuleStates == null ? other$createRuleStates != null : !((Object)this$createRuleStates).equals(other$createRuleStates)) {
            return false;
        }
        AlarmRuleState this$clearRuleState = this.getClearRuleState();
        AlarmRuleState other$clearRuleState = other.getClearRuleState();
        if (this$clearRuleState == null ? other$clearRuleState != null : !this$clearRuleState.equals(other$clearRuleState)) {
            return false;
        }
        Alarm this$currentAlarm = this.getCurrentAlarm();
        Alarm other$currentAlarm = other.getCurrentAlarm();
        return !(this$currentAlarm == null ? other$currentAlarm != null : !this$currentAlarm.equals(other$currentAlarm));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AlarmCalculatedFieldState;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.initialFetchDone ? 79 : 97);
        AlarmCalculatedFieldConfiguration $configuration = this.configuration;
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        String $alarmType = this.alarmType;
        result = result * 59 + ($alarmType == null ? 43 : $alarmType.hashCode());
        Map $createRuleStates = this.getCreateRuleStates();
        result = result * 59 + ($createRuleStates == null ? 43 : ((Object)$createRuleStates).hashCode());
        AlarmRuleState $clearRuleState = this.getClearRuleState();
        result = result * 59 + ($clearRuleState == null ? 43 : $clearRuleState.hashCode());
        Alarm $currentAlarm = this.getCurrentAlarm();
        result = result * 59 + ($currentAlarm == null ? 43 : $currentAlarm.hashCode());
        return result;
    }

    @Generated
    public Map<AlarmSeverity, AlarmRuleState> getCreateRuleStates() {
        return this.createRuleStates;
    }

    @Generated
    public AlarmRuleState getClearRuleState() {
        return this.clearRuleState;
    }

    @Generated
    public void setClearRuleState(AlarmRuleState clearRuleState) {
        this.clearRuleState = clearRuleState;
    }

    @Generated
    public Alarm getCurrentAlarm() {
        return this.currentAlarm;
    }
}

