/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf.ctx.state.aggregation.single;

import com.fasterxml.jackson.databind.JsonNode;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.script.api.tbel.TbelCfArg;
import org.thingsboard.server.common.data.cf.configuration.CalculatedFieldConfiguration;
import org.thingsboard.server.common.data.cf.configuration.aggregation.single.EntityAggregationCalculatedFieldConfiguration;
import org.thingsboard.server.common.data.cf.configuration.aggregation.single.interval.AggInterval;
import org.thingsboard.server.common.data.cf.configuration.aggregation.single.interval.Watermark;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntryType;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldCtx;
import org.thingsboard.server.service.cf.ctx.state.SingleValueArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.aggregation.single.AggIntervalEntry;
import org.thingsboard.server.service.cf.ctx.state.aggregation.single.AggIntervalEntryStatus;

public class EntityAggregationArgumentEntry
implements ArgumentEntry {
    private Map<AggIntervalEntry, AggIntervalEntryStatus> aggIntervals;
    private boolean forceResetPrevious;

    public EntityAggregationArgumentEntry(Map<AggIntervalEntry, AggIntervalEntryStatus> aggIntervals) {
        this.aggIntervals = aggIntervals;
    }

    public ArgumentEntryType getType() {
        return ArgumentEntryType.ENTITY_AGGREGATION;
    }

    public Object getValue() {
        return this.aggIntervals;
    }

    public boolean updateEntry(ArgumentEntry entry, CalculatedFieldCtx ctx) {
        if (entry instanceof EntityAggregationArgumentEntry) {
            EntityAggregationArgumentEntry entityAggEntry = (EntityAggregationArgumentEntry)entry;
            this.aggIntervals.putAll(entityAggEntry.getAggIntervals());
            return true;
        }
        if (entry instanceof SingleValueArgumentEntry) {
            long now;
            SingleValueArgumentEntry singleValueArgEntry = (SingleValueArgumentEntry)entry;
            long entryTs = singleValueArgEntry.getTs();
            if (this.updateExistingIntervals(singleValueArgEntry, entryTs, now = System.currentTimeMillis())) {
                return true;
            }
            return this.createNewInterval(entryTs, now, ctx);
        }
        return false;
    }

    private boolean updateExistingIntervals(SingleValueArgumentEntry entry, long entryTs, long now) {
        boolean updated = false;
        for (Map.Entry aggIntervalEntry : this.aggIntervals.entrySet()) {
            AggIntervalEntry interval = (AggIntervalEntry)aggIntervalEntry.getKey();
            AggIntervalEntryStatus status = (AggIntervalEntryStatus)aggIntervalEntry.getValue();
            if (entry.isForceResetPrevious()) {
                status.setLastArgsRefreshTs(now);
                updated = true;
                continue;
            }
            if (!interval.belongsToInterval(entryTs)) continue;
            status.setLastArgsRefreshTs(now);
            return true;
        }
        return updated;
    }

    private boolean createNewInterval(long entryTs, long now, CalculatedFieldCtx ctx) {
        CalculatedFieldConfiguration calculatedFieldConfiguration = ctx.getCalculatedField().getConfiguration();
        if (!(calculatedFieldConfiguration instanceof EntityAggregationCalculatedFieldConfiguration)) {
            return false;
        }
        EntityAggregationCalculatedFieldConfiguration config = (EntityAggregationCalculatedFieldConfiguration)calculatedFieldConfiguration;
        AggInterval interval = config.getInterval();
        Watermark watermark = config.getWatermark();
        long watermarkDuration = watermark == null ? 0L : TimeUnit.SECONDS.toMillis(watermark.getDuration());
        ZonedDateTime zdt = ZonedDateTime.ofInstant(Instant.ofEpochMilli(entryTs), interval.getZoneId());
        long startTs = interval.getDateTimeIntervalStartTs(zdt);
        long endTs = interval.getDateTimeIntervalEndTs(zdt);
        if (now - endTs > watermarkDuration) {
            return false;
        }
        AggIntervalEntry newInterval = new AggIntervalEntry(Long.valueOf(startTs), Long.valueOf(endTs));
        this.aggIntervals.computeIfAbsent(newInterval, i -> new AggIntervalEntryStatus(now));
        return true;
    }

    public boolean isEmpty() {
        return this.aggIntervals.isEmpty();
    }

    public JsonNode jsonValue() {
        return JacksonUtil.valueToTree((Object)this.aggIntervals);
    }

    public TbelCfArg toTbelCfArg() {
        return null;
    }

    @Generated
    public Map<AggIntervalEntry, AggIntervalEntryStatus> getAggIntervals() {
        return this.aggIntervals;
    }

    @Generated
    public boolean isForceResetPrevious() {
        return this.forceResetPrevious;
    }

    @Generated
    public void setAggIntervals(Map<AggIntervalEntry, AggIntervalEntryStatus> aggIntervals) {
        this.aggIntervals = aggIntervals;
    }

    @Generated
    public void setForceResetPrevious(boolean forceResetPrevious) {
        this.forceResetPrevious = forceResetPrevious;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityAggregationArgumentEntry)) {
            return false;
        }
        EntityAggregationArgumentEntry other = (EntityAggregationArgumentEntry)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isForceResetPrevious() != other.isForceResetPrevious()) {
            return false;
        }
        Map this$aggIntervals = this.getAggIntervals();
        Map other$aggIntervals = other.getAggIntervals();
        return !(this$aggIntervals == null ? other$aggIntervals != null : !((Object)this$aggIntervals).equals(other$aggIntervals));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EntityAggregationArgumentEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isForceResetPrevious() ? 79 : 97);
        Map $aggIntervals = this.getAggIntervals();
        result = result * 59 + ($aggIntervals == null ? 43 : ((Object)$aggIntervals).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EntityAggregationArgumentEntry(aggIntervals=" + String.valueOf(this.getAggIntervals()) + ", forceResetPrevious=" + this.isForceResetPrevious() + ")";
    }
}

