/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf.ctx.state.aggregation.function;

import java.math.BigDecimal;
import org.thingsboard.common.util.NumberUtils;
import org.thingsboard.server.common.data.cf.configuration.aggregation.AggFunction;
import org.thingsboard.server.service.cf.ctx.state.aggregation.function.BaseAggEntry;

public class SumAggEntry
extends BaseAggEntry {
    private BigDecimal sum = BigDecimal.ZERO;

    protected void doUpdate(double value) {
        if (value != 0.0) {
            this.sum = this.sum.add(BigDecimal.valueOf(value));
        }
    }

    protected Object prepareResult(Integer precision) {
        return NumberUtils.roundResult((double)this.sum.doubleValue(), (Integer)precision);
    }

    public AggFunction getType() {
        return AggFunction.SUM;
    }
}

