/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf.ctx.state.aggregation.function;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.thingsboard.common.util.NumberUtils;
import org.thingsboard.server.common.data.cf.configuration.aggregation.AggFunction;
import org.thingsboard.server.service.cf.ctx.state.aggregation.function.BaseAggEntry;

public class AvgAggEntry
extends BaseAggEntry {
    private BigDecimal sum = BigDecimal.ZERO;
    private long count = 0L;

    protected void doUpdate(double value) {
        if (value != 0.0) {
            this.sum = this.sum.add(BigDecimal.valueOf(value));
        }
        ++this.count;
    }

    protected Object prepareResult(Integer precision) {
        double result = this.sum.divide(BigDecimal.valueOf(this.count), RoundingMode.HALF_UP).doubleValue();
        return NumberUtils.roundResult((double)result, (Integer)precision);
    }

    public AggFunction getType() {
        return AggFunction.AVG;
    }
}

