/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf.ctx.state.aggregation;

import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.thingsboard.script.api.tbel.TbelCfArg;
import org.thingsboard.script.api.tbel.TbelCfRelatedEntitiesArgumentValue;
import org.thingsboard.script.api.tbel.TbelCfSingleValueArg;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntryType;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldCtx;
import org.thingsboard.server.service.cf.ctx.state.HasEntityLimit;
import org.thingsboard.server.service.cf.ctx.state.HasLatestTs;
import org.thingsboard.server.service.cf.ctx.state.SingleValueArgumentEntry;

public class RelatedEntitiesArgumentEntry
implements ArgumentEntry,
HasLatestTs,
HasEntityLimit {
    private final Map<EntityId, ArgumentEntry> entityInputs;
    private boolean forceResetPrevious;

    public ArgumentEntryType getType() {
        return ArgumentEntryType.RELATED_ENTITIES;
    }

    public Object getValue() {
        return this.entityInputs;
    }

    public long getLatestTs() {
        long latestTs = -1L;
        for (ArgumentEntry entry : this.entityInputs.values()) {
            SingleValueArgumentEntry single;
            if (!(entry instanceof SingleValueArgumentEntry) || (single = (SingleValueArgumentEntry)entry).isDefaultValue()) continue;
            latestTs = Math.max(latestTs, single.getTs());
        }
        return latestTs;
    }

    public boolean updateEntry(ArgumentEntry entry, CalculatedFieldCtx ctx) {
        if (entry instanceof RelatedEntitiesArgumentEntry) {
            RelatedEntitiesArgumentEntry relatedEntitiesArgumentEntry = (RelatedEntitiesArgumentEntry)entry;
            this.checkEntityLimit(this.entityInputs.size(), ctx);
            this.entityInputs.putAll(relatedEntitiesArgumentEntry.entityInputs);
        } else if (entry instanceof SingleValueArgumentEntry) {
            SingleValueArgumentEntry singleValueArgumentEntry = (SingleValueArgumentEntry)entry;
            if (entry.isForceResetPrevious()) {
                this.checkEntityLimit(this.entityInputs.size(), ctx);
                this.entityInputs.put(singleValueArgumentEntry.getEntityId(), singleValueArgumentEntry);
            } else {
                ArgumentEntry argumentEntry = (ArgumentEntry)this.entityInputs.get(singleValueArgumentEntry.getEntityId());
                if (argumentEntry != null) {
                    argumentEntry.updateEntry((ArgumentEntry)singleValueArgumentEntry, ctx);
                } else {
                    this.checkEntityLimit(this.entityInputs.size(), ctx);
                    this.entityInputs.put(singleValueArgumentEntry.getEntityId(), singleValueArgumentEntry);
                }
            }
        } else {
            throw new IllegalArgumentException("Unsupported argument entry type for aggregation argument entry: " + String.valueOf(entry.getType()));
        }
        return true;
    }

    public boolean isEmpty() {
        return this.entityInputs.isEmpty();
    }

    public TbelCfArg toTbelCfArg() {
        Map<UUID, TbelCfSingleValueArg> inputs = this.entityInputs.entrySet().stream().collect(Collectors.toMap(e -> ((EntityId)e.getKey()).getId(), e -> (TbelCfSingleValueArg)((ArgumentEntry)e.getValue()).toTbelCfArg()));
        return new TbelCfRelatedEntitiesArgumentValue(inputs);
    }

    @Generated
    public Map<EntityId, ArgumentEntry> getEntityInputs() {
        return this.entityInputs;
    }

    @Generated
    public boolean isForceResetPrevious() {
        return this.forceResetPrevious;
    }

    @Generated
    public void setForceResetPrevious(boolean forceResetPrevious) {
        this.forceResetPrevious = forceResetPrevious;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelatedEntitiesArgumentEntry)) {
            return false;
        }
        RelatedEntitiesArgumentEntry other = (RelatedEntitiesArgumentEntry)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isForceResetPrevious() != other.isForceResetPrevious()) {
            return false;
        }
        Map this$entityInputs = this.getEntityInputs();
        Map other$entityInputs = other.getEntityInputs();
        return !(this$entityInputs == null ? other$entityInputs != null : !((Object)this$entityInputs).equals(other$entityInputs));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RelatedEntitiesArgumentEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isForceResetPrevious() ? 79 : 97);
        Map $entityInputs = this.getEntityInputs();
        result = result * 59 + ($entityInputs == null ? 43 : ((Object)$entityInputs).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RelatedEntitiesArgumentEntry(entityInputs=" + String.valueOf(this.getEntityInputs()) + ", forceResetPrevious=" + this.isForceResetPrevious() + ")";
    }

    @ConstructorProperties(value={"entityInputs", "forceResetPrevious"})
    @Generated
    public RelatedEntitiesArgumentEntry(Map<EntityId, ArgumentEntry> entityInputs, boolean forceResetPrevious) {
        this.entityInputs = entityInputs;
        this.forceResetPrevious = forceResetPrevious;
    }
}

