/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf.ctx.state;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import lombok.Generated;
import net.objecthunter.exp4j.Expression;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.common.util.NumberUtils;
import org.thingsboard.server.actors.TbActorRef;
import org.thingsboard.server.common.data.cf.CalculatedFieldType;
import org.thingsboard.server.common.data.cf.configuration.Output;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.service.cf.CalculatedFieldResult;
import org.thingsboard.server.service.cf.TelemetryCalculatedFieldResult;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.BaseCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldCtx;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.TsRollingArgumentEntry;

public class SimpleCalculatedFieldState
extends BaseCalculatedFieldState {
    private ThreadLocal<Expression> expression;

    public SimpleCalculatedFieldState(EntityId entityId) {
        super(entityId);
    }

    public void setCtx(CalculatedFieldCtx ctx, TbActorRef actorCtx) {
        super.setCtx(ctx, actorCtx);
        this.expression = (ThreadLocal)ctx.getSimpleExpressions().get(ctx.getExpression());
    }

    public ListenableFuture<CalculatedFieldResult> performCalculation(Map<String, ArgumentEntry> updatedArgs, CalculatedFieldCtx ctx) {
        double expressionResult = ctx.evaluateSimpleExpression((Expression)this.expression.get(), (CalculatedFieldState)this);
        Output output = ctx.getOutput();
        Object result = NumberUtils.roundResult((double)expressionResult, (Integer)output.getDecimalsByDefault());
        JsonNode outputResult = this.createResultJson(output.getName(), result);
        return Futures.immediateFuture((Object)TelemetryCalculatedFieldResult.builder().outputStrategy(output.getStrategy()).type(output.getType()).scope(output.getScope()).result(outputResult).build());
    }

    private JsonNode createResultJson(String outputName, Object result) {
        ObjectNode valuesNode = JacksonUtil.newObjectNode();
        if (result instanceof Double) {
            Double doubleValue = (Double)result;
            valuesNode.put(outputName, doubleValue);
        } else if (result instanceof Integer) {
            Integer integerValue = (Integer)result;
            valuesNode.put(outputName, integerValue);
        } else {
            valuesNode.set(outputName, JacksonUtil.valueToTree((Object)result));
        }
        return this.toResultNode(valuesNode);
    }

    protected void validateNewEntry(String key, ArgumentEntry newEntry) {
        if (newEntry instanceof TsRollingArgumentEntry) {
            throw new IllegalArgumentException("Unsupported argument type detected for argument: " + key + ". Rolling argument entry is not supported for simple calculated fields.");
        }
    }

    public CalculatedFieldType getType() {
        return CalculatedFieldType.SIMPLE;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleCalculatedFieldState)) {
            return false;
        }
        SimpleCalculatedFieldState other = (SimpleCalculatedFieldState)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ThreadLocal this$expression = this.expression;
        ThreadLocal other$expression = other.expression;
        return !(this$expression == null ? other$expression != null : !this$expression.equals(other$expression));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SimpleCalculatedFieldState;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ThreadLocal $expression = this.expression;
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        return result;
    }
}

