/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf.ctx.state;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Map;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.actors.TbActorRef;
import org.thingsboard.server.common.data.cf.CalculatedFieldType;
import org.thingsboard.server.common.data.cf.configuration.Output;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.service.cf.CalculatedFieldResult;
import org.thingsboard.server.service.cf.TelemetryCalculatedFieldResult;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.BaseCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldCtx;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldScriptEngine;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldState;

public class ScriptCalculatedFieldState
extends BaseCalculatedFieldState {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScriptCalculatedFieldState.class);
    protected CalculatedFieldScriptEngine tbelExpression;

    public ScriptCalculatedFieldState(EntityId entityId) {
        super(entityId);
    }

    public void setCtx(CalculatedFieldCtx ctx, TbActorRef actorCtx) {
        super.setCtx(ctx, actorCtx);
        this.tbelExpression = (CalculatedFieldScriptEngine)ctx.getTbelExpressions().get(ctx.getExpression());
    }

    public ListenableFuture<CalculatedFieldResult> performCalculation(Map<String, ArgumentEntry> updatedArgs, CalculatedFieldCtx ctx) {
        ListenableFuture resultFuture = ctx.evaluateTbelExpression(this.tbelExpression, (CalculatedFieldState)this);
        Output output = ctx.getOutput();
        return Futures.transform((ListenableFuture)resultFuture, result -> TelemetryCalculatedFieldResult.builder().outputStrategy(output.getStrategy()).type(output.getType()).scope(output.getScope()).result(JacksonUtil.valueToTree((Object)result)).build(), (Executor)MoreExecutors.directExecutor());
    }

    public CalculatedFieldType getType() {
        return CalculatedFieldType.SCRIPT;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScriptCalculatedFieldState)) {
            return false;
        }
        ScriptCalculatedFieldState other = (ScriptCalculatedFieldState)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CalculatedFieldScriptEngine this$tbelExpression = this.tbelExpression;
        CalculatedFieldScriptEngine other$tbelExpression = other.tbelExpression;
        return !(this$tbelExpression == null ? other$tbelExpression != null : !this$tbelExpression.equals(other$tbelExpression));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ScriptCalculatedFieldState;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        CalculatedFieldScriptEngine $tbelExpression = this.tbelExpression;
        result = result * 59 + ($tbelExpression == null ? 43 : $tbelExpression.hashCode());
        return result;
    }
}

