/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf.ctx.state;

import java.beans.ConstructorProperties;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.msg.queue.TbCallback;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.common.consumer.PartitionedQueueConsumerManager;
import org.thingsboard.server.queue.common.state.DefaultQueueStateService;
import org.thingsboard.server.queue.discovery.QueueKey;
import org.thingsboard.server.service.cf.AbstractCalculatedFieldStateService;
import org.thingsboard.server.service.cf.CfRocksDb;
import org.thingsboard.server.service.cf.ctx.CalculatedFieldEntityCtxId;

@Service
@ConditionalOnExpression(value="'${queue.type:null}'=='in-memory'")
public class RocksDBCalculatedFieldStateService
extends AbstractCalculatedFieldStateService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RocksDBCalculatedFieldStateService.class);
    private final CfRocksDb cfRocksDb;

    public void init(PartitionedQueueConsumerManager<TbProtoQueueMsg<TransportProtos.ToCalculatedFieldMsg>> eventConsumer) {
        this.stateService = new DefaultQueueStateService(eventConsumer);
    }

    protected void doPersist(CalculatedFieldEntityCtxId stateId, TransportProtos.CalculatedFieldStateProto stateMsgProto, TbCallback callback) {
        this.cfRocksDb.put(stateId.toKey(), stateMsgProto.toByteArray());
        callback.onSuccess();
    }

    protected void doRemove(CalculatedFieldEntityCtxId stateId, TbCallback callback) {
        this.cfRocksDb.delete(stateId.toKey());
        callback.onSuccess();
    }

    public void restore(QueueKey queueKey, Set<TopicPartitionInfo> partitions) {
        if (this.stateService.getPartitions().isEmpty()) {
            this.cfRocksDb.forEach((key, value) -> {
                TransportProtos.CalculatedFieldStateProto stateMsg;
                try {
                    stateMsg = TransportProtos.CalculatedFieldStateProto.parseFrom((byte[])value);
                }
                catch (Exception e) {
                    log.error("Failed to parse CalculatedFieldStateProto for key {}", key, (Object)e);
                    return;
                }
                this.processRestoredState(stateMsg, null, (TbCallback)new /* Unavailable Anonymous Inner Class!! */);
            });
        }
        super.restore(queueKey, partitions);
    }

    @ConstructorProperties(value={"cfRocksDb"})
    @Generated
    public RocksDBCalculatedFieldStateService(CfRocksDb cfRocksDb) {
        this.cfRocksDb = cfRocksDb;
    }
}

