/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf.ctx.state;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.Closeable;
import java.util.Map;
import org.thingsboard.server.actors.TbActorRef;
import org.thingsboard.server.common.data.cf.CalculatedFieldType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.service.cf.CalculatedFieldResult;
import org.thingsboard.server.service.cf.ctx.CalculatedFieldEntityCtxId;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldCtx;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.ScriptCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.SimpleCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.SingleValueArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.TsRollingArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.aggregation.RelatedEntitiesAggregationCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.aggregation.single.EntityAggregationCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.alarm.AlarmCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.geofencing.GeofencingArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.geofencing.GeofencingCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.propagation.PropagationCalculatedFieldState;
import org.thingsboard.server.utils.CalculatedFieldUtils;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=SimpleCalculatedFieldState.class, name="SIMPLE"), @JsonSubTypes.Type(value=ScriptCalculatedFieldState.class, name="SCRIPT"), @JsonSubTypes.Type(value=GeofencingCalculatedFieldState.class, name="GEOFENCING"), @JsonSubTypes.Type(value=AlarmCalculatedFieldState.class, name="ALARM"), @JsonSubTypes.Type(value=PropagationCalculatedFieldState.class, name="PROPAGATION"), @JsonSubTypes.Type(value=RelatedEntitiesAggregationCalculatedFieldState.class, name="RELATED_ENTITIES_AGGREGATION"), @JsonSubTypes.Type(value=EntityAggregationCalculatedFieldState.class, name="ENTITY_AGGREGATION")})
public interface CalculatedFieldState
extends Closeable {
    @JsonIgnore
    public CalculatedFieldType getType();

    public EntityId getEntityId();

    public Map<String, ArgumentEntry> getArguments();

    public JsonNode getArgumentsJson();

    public long getLatestTimestamp();

    public void setCtx(CalculatedFieldCtx var1, TbActorRef var2);

    public void init(boolean var1);

    public Map<String, ArgumentEntry> update(Map<String, ArgumentEntry> var1, CalculatedFieldCtx var2);

    public void reset();

    public ListenableFuture<CalculatedFieldResult> performCalculation(Map<String, ArgumentEntry> var1, CalculatedFieldCtx var2) throws Exception;

    @JsonIgnore
    public boolean isReady();

    public ReadinessStatus getReadinessStatus();

    public boolean isSizeExceedsLimit();

    @JsonIgnore
    default public boolean isSizeOk() {
        return !this.isSizeExceedsLimit();
    }

    public TopicPartitionInfo getPartition();

    public void setPartition(TopicPartitionInfo var1);

    public void checkStateSize(CalculatedFieldEntityCtxId var1, long var2);

    default public void checkArgumentSize(String name, ArgumentEntry entry, CalculatedFieldCtx ctx) {
        if (entry instanceof TsRollingArgumentEntry || entry instanceof GeofencingArgumentEntry) {
            return;
        }
        if (entry instanceof SingleValueArgumentEntry) {
            SingleValueArgumentEntry singleValueArgumentEntry = (SingleValueArgumentEntry)entry;
            if (ctx.getMaxSingleValueArgumentSize() > 0L && (long)CalculatedFieldUtils.toSingleValueArgumentProto((String)name, (SingleValueArgumentEntry)singleValueArgumentEntry).getSerializedSize() > ctx.getMaxSingleValueArgumentSize()) {
                throw new IllegalArgumentException("Single value size exceeds the maximum allowed limit. The argument will not be used for calculation.");
            }
        }
    }
}

