/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf.ctx.state;

import com.google.common.util.concurrent.ListenableFuture;
import java.io.Closeable;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import net.objecthunter.exp4j.Expression;
import org.mvel2.MVEL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.ExpressionUtils;
import org.thingsboard.script.api.tbel.TbelCfArg;
import org.thingsboard.script.api.tbel.TbelCfCtx;
import org.thingsboard.script.api.tbel.TbelCfSingleValueArg;
import org.thingsboard.script.api.tbel.TbelInvokeService;
import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.actors.TbActorRef;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldReevaluateMsg;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.alarm.rule.AlarmRule;
import org.thingsboard.server.common.data.alarm.rule.condition.expression.TbelAlarmConditionExpression;
import org.thingsboard.server.common.data.cf.CalculatedField;
import org.thingsboard.server.common.data.cf.CalculatedFieldType;
import org.thingsboard.server.common.data.cf.configuration.AlarmCalculatedFieldConfiguration;
import org.thingsboard.server.common.data.cf.configuration.Argument;
import org.thingsboard.server.common.data.cf.configuration.ArgumentType;
import org.thingsboard.server.common.data.cf.configuration.ArgumentsBasedCalculatedFieldConfiguration;
import org.thingsboard.server.common.data.cf.configuration.CalculatedFieldConfiguration;
import org.thingsboard.server.common.data.cf.configuration.ExpressionBasedCalculatedFieldConfiguration;
import org.thingsboard.server.common.data.cf.configuration.HasUseLatestTsConfig;
import org.thingsboard.server.common.data.cf.configuration.Output;
import org.thingsboard.server.common.data.cf.configuration.OutputStrategy;
import org.thingsboard.server.common.data.cf.configuration.PropagationCalculatedFieldConfiguration;
import org.thingsboard.server.common.data.cf.configuration.ReferencedEntityKey;
import org.thingsboard.server.common.data.cf.configuration.ScheduledUpdateSupportedCalculatedFieldConfiguration;
import org.thingsboard.server.common.data.cf.configuration.SimpleCalculatedFieldConfiguration;
import org.thingsboard.server.common.data.cf.configuration.aggregation.AggFunctionInput;
import org.thingsboard.server.common.data.cf.configuration.aggregation.AggInput;
import org.thingsboard.server.common.data.cf.configuration.aggregation.RelatedEntitiesAggregationCalculatedFieldConfiguration;
import org.thingsboard.server.common.data.cf.configuration.aggregation.single.EntityAggregationCalculatedFieldConfiguration;
import org.thingsboard.server.common.data.cf.configuration.aggregation.single.interval.Watermark;
import org.thingsboard.server.common.data.cf.configuration.geofencing.GeofencingCalculatedFieldConfiguration;
import org.thingsboard.server.common.data.id.CalculatedFieldId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.BasicKvEntry;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.common.data.util.CollectionsUtil;
import org.thingsboard.server.common.msg.TbActorMsg;
import org.thingsboard.server.common.util.ProtoUtils;
import org.thingsboard.server.dao.relation.RelationService;
import org.thingsboard.server.dao.util.TimeUtils;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.service.cf.CalculatedFieldProcessingService;
import org.thingsboard.server.service.cf.ctx.CalculatedFieldEntityCtxId;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldCtx;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldScriptEngine;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldTbelScriptEngine;
import org.thingsboard.server.service.cf.ctx.state.SingleValueArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.geofencing.ScheduledRefreshSupported;
import org.thingsboard.server.service.telemetry.AlarmSubscriptionService;

public class CalculatedFieldCtx
implements Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CalculatedFieldCtx.class);
    public static final long DISABLED_INTERVAL_VALUE = -1L;
    private CalculatedField calculatedField;
    private CalculatedFieldId cfId;
    private String cfName;
    private TenantId tenantId;
    private EntityId entityId;
    private CalculatedFieldType cfType;
    private final Map<String, Argument> arguments;
    private final Map<ReferencedEntityKey, Set<String>> mainEntityArguments;
    private final Map<EntityId, Map<ReferencedEntityKey, Set<String>>> linkedEntityArguments;
    private final Map<ReferencedEntityKey, Set<String>> dynamicEntityArguments;
    private final Map<ReferencedEntityKey, Set<String>> relatedEntityArguments;
    private final List<String> argNames;
    private Output output;
    private String expression;
    private boolean useLatestTs;
    private long lastReevaluationTs;
    private ActorSystemContext systemContext;
    private TbelInvokeService tbelInvokeService;
    private RelationService relationService;
    private AlarmSubscriptionService alarmService;
    private CalculatedFieldProcessingService cfProcessingService;
    private Map<String, CalculatedFieldScriptEngine> tbelExpressions;
    private Map<String, ThreadLocal<Expression>> simpleExpressions;
    private boolean initialized;
    private long maxStateSize;
    private long maxSingleValueArgumentSize;
    private long intermediateAggregationIntervalMillis;
    private boolean cfHasRelationPathQuerySource;
    private List<String> mainEntityGeofencingArgumentNames;
    private List<String> linkedEntityAndCurrentOwnerGeofencingArgumentNames;
    private List<String> relatedEntityArgumentNames;
    private long scheduledUpdateIntervalMillis;
    private long cfCheckReevaluationIntervalMillis;
    private long alarmReevaluationIntervalMillis;
    private long maxRelatedEntitiesPerCfArgument;
    private long minScheduledUpdateIntervalMillis;
    private long minDeduplicationIntervalMillis;
    private Argument propagationArgument;
    private boolean applyExpressionForResolvedArguments;

    public CalculatedFieldCtx(CalculatedField calculatedField, ActorSystemContext systemContext) {
        this.calculatedField = calculatedField;
        this.cfId = calculatedField.getId();
        this.cfName = calculatedField.getName();
        this.tenantId = calculatedField.getTenantId();
        this.entityId = calculatedField.getEntityId();
        this.cfType = calculatedField.getType();
        this.arguments = new HashMap();
        this.mainEntityArguments = new HashMap();
        this.linkedEntityArguments = new HashMap();
        this.dynamicEntityArguments = new HashMap();
        this.relatedEntityArguments = new HashMap();
        this.argNames = new ArrayList();
        this.mainEntityGeofencingArgumentNames = new ArrayList();
        this.linkedEntityAndCurrentOwnerGeofencingArgumentNames = new ArrayList();
        this.relatedEntityArgumentNames = new ArrayList();
        this.output = calculatedField.getConfiguration().getOutput();
        Object object = calculatedField.getConfiguration();
        if (object instanceof ArgumentsBasedCalculatedFieldConfiguration) {
            CalculatedFieldConfiguration calculatedFieldConfiguration;
            ArgumentsBasedCalculatedFieldConfiguration argBasedConfig = (ArgumentsBasedCalculatedFieldConfiguration)object;
            this.arguments.putAll(argBasedConfig.getArguments());
            object = this.arguments.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                EntityId refId = ((Argument)entry.getValue()).getRefEntityId();
                ReferencedEntityKey refKey = ((Argument)entry.getValue()).getRefEntityKey();
                if (refId == null) {
                    if (CalculatedFieldType.RELATED_ENTITIES_AGGREGATION.equals((Object)this.cfType)) {
                        this.relatedEntityArguments.compute(refKey, (key, existingNames) -> CollectionsUtil.addToSet((Set)existingNames, (Object)((String)entry.getKey())));
                        this.cfHasRelationPathQuerySource = true;
                        continue;
                    }
                    if (((Argument)entry.getValue()).hasRelationQuerySource()) {
                        this.cfHasRelationPathQuerySource = true;
                        continue;
                    }
                    if (((Argument)entry.getValue()).hasOwnerSource()) {
                        this.dynamicEntityArguments.compute(refKey, (key, existingNames) -> CollectionsUtil.addToSet((Set)existingNames, (Object)((String)entry.getKey())));
                        continue;
                    }
                    this.mainEntityArguments.compute(refKey, (key, existingNames) -> CollectionsUtil.addToSet((Set)existingNames, (Object)((String)entry.getKey())));
                    continue;
                }
                if (refId.equals(calculatedField.getEntityId())) {
                    this.mainEntityArguments.compute(refKey, (key, existingNames) -> CollectionsUtil.addToSet((Set)existingNames, (Object)((String)entry.getKey())));
                    continue;
                }
                this.linkedEntityArguments.computeIfAbsent(refId, key -> new HashMap()).compute(refKey, (key, existingNames) -> CollectionsUtil.addToSet((Set)existingNames, (Object)((String)entry.getKey())));
            }
            this.argNames.addAll(this.arguments.keySet());
            this.relatedEntityArgumentNames = this.relatedEntityArguments.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            if (argBasedConfig instanceof ExpressionBasedCalculatedFieldConfiguration) {
                ExpressionBasedCalculatedFieldConfiguration expressionBasedConfig = (ExpressionBasedCalculatedFieldConfiguration)argBasedConfig;
                this.expression = expressionBasedConfig.getExpression();
            }
            if ((calculatedFieldConfiguration = calculatedField.getConfiguration()) instanceof GeofencingCalculatedFieldConfiguration) {
                GeofencingCalculatedFieldConfiguration geofencingConfig = (GeofencingCalculatedFieldConfiguration)calculatedFieldConfiguration;
                geofencingConfig.getZoneGroups().forEach((zoneGroupName, config) -> {
                    if (config.isCfEntitySource(this.entityId)) {
                        this.mainEntityGeofencingArgumentNames.add(zoneGroupName);
                        return;
                    }
                    if (config.isLinkedCfEntitySource(this.entityId) || config.hasCurrentOwnerSource()) {
                        this.linkedEntityAndCurrentOwnerGeofencingArgumentNames.add(zoneGroupName);
                    }
                });
            }
            if ((calculatedFieldConfiguration = calculatedField.getConfiguration()) instanceof PropagationCalculatedFieldConfiguration) {
                PropagationCalculatedFieldConfiguration propagationConfig = (PropagationCalculatedFieldConfiguration)calculatedFieldConfiguration;
                this.propagationArgument = propagationConfig.toPropagationArgument();
                this.applyExpressionForResolvedArguments = propagationConfig.isApplyExpressionToResolvedArguments();
                this.cfHasRelationPathQuerySource = true;
            }
        }
        if ((object = calculatedField.getConfiguration()) instanceof ScheduledUpdateSupportedCalculatedFieldConfiguration) {
            ScheduledUpdateSupportedCalculatedFieldConfiguration scheduledConfig = (ScheduledUpdateSupportedCalculatedFieldConfiguration)object;
            long l = this.scheduledUpdateIntervalMillis = scheduledConfig.isScheduledUpdateEnabled() ? TimeUnit.SECONDS.toMillis(scheduledConfig.getScheduledUpdateInterval()) : -1L;
        }
        if ((object = calculatedField.getConfiguration()) instanceof HasUseLatestTsConfig) {
            HasUseLatestTsConfig hasUseLatestTsConfig = (HasUseLatestTsConfig)object;
            this.useLatestTs = hasUseLatestTsConfig.isUseLatestTs();
        }
        this.systemContext = systemContext;
        this.tbelInvokeService = systemContext.getTbelInvokeService();
        this.relationService = systemContext.getRelationService();
        this.alarmService = systemContext.getAlarmService();
        this.cfProcessingService = systemContext.getCalculatedFieldProcessingService();
        this.setTenantProfileProperties();
    }

    public boolean requiresScheduledReevaluation() {
        long now = System.currentTimeMillis();
        CalculatedFieldConfiguration calculatedFieldConfiguration = this.calculatedField.getConfiguration();
        if (calculatedFieldConfiguration instanceof EntityAggregationCalculatedFieldConfiguration) {
            EntityAggregationCalculatedFieldConfiguration entityAggregationConfig = (EntityAggregationCalculatedFieldConfiguration)calculatedFieldConfiguration;
            Watermark watermark = entityAggregationConfig.getWatermark();
            if (watermark != null && watermark.getDuration() > 0L) {
                return true;
            }
            if (this.lastReevaluationTs == 0L) {
                this.lastReevaluationTs = now;
                return true;
            }
            if (entityAggregationConfig.isProduceIntermediateResult() && now - this.lastReevaluationTs >= this.intermediateAggregationIntervalMillis) {
                this.lastReevaluationTs = now;
                return true;
            }
            ZonedDateTime lastReevaluationTime = TimeUtils.toZonedDateTime((long)this.lastReevaluationTs, (ZoneId)entityAggregationConfig.getInterval().getZoneId());
            long previousIntervalEndTs = entityAggregationConfig.getInterval().getDateTimeIntervalEndTs(lastReevaluationTime);
            if (now >= previousIntervalEndTs) {
                this.lastReevaluationTs = now;
                return true;
            }
        }
        boolean requiresScheduledReevaluation = this.calculatedField.getConfiguration().requiresScheduledReevaluation();
        if (this.calculatedField.getConfiguration() instanceof AlarmCalculatedFieldConfiguration && requiresScheduledReevaluation) {
            if (now - this.lastReevaluationTs >= this.alarmReevaluationIntervalMillis) {
                this.lastReevaluationTs = now;
                return true;
            }
            return false;
        }
        return requiresScheduledReevaluation;
    }

    public void init() {
        switch (1.$SwitchMap$org$thingsboard$server$common$data$cf$CalculatedFieldType[this.cfType.ordinal()]) {
            case 1: {
                this.initTbelExpression(this.expression);
                this.initialized = true;
                break;
            }
            case 2: {
                this.initialized = true;
                break;
            }
            case 3: {
                this.initSimpleExpression(this.expression);
                this.initialized = true;
                break;
            }
            case 4: {
                AlarmCalculatedFieldConfiguration configuration = (AlarmCalculatedFieldConfiguration)this.calculatedField.getConfiguration();
                configuration.getAllRules().map(rule -> ((AlarmRule)rule.getValue()).getCondition().getExpression()).forEach(expression -> {
                    if (expression instanceof TbelAlarmConditionExpression) {
                        TbelAlarmConditionExpression tbelExpression = (TbelAlarmConditionExpression)expression;
                        this.initTbelExpression(tbelExpression.getExpression());
                    }
                });
                this.initialized = true;
                break;
            }
            case 5: {
                if (this.applyExpressionForResolvedArguments) {
                    this.initTbelExpression(this.expression);
                }
                this.initialized = true;
                break;
            }
            case 6: {
                RelatedEntitiesAggregationCalculatedFieldConfiguration configuration = (RelatedEntitiesAggregationCalculatedFieldConfiguration)this.calculatedField.getConfiguration();
                configuration.getMetrics().forEach((key, metric) -> {
                    String filter;
                    AggInput patt16373$temp = metric.getInput();
                    if (patt16373$temp instanceof AggFunctionInput) {
                        AggFunctionInput functionInput = (AggFunctionInput)patt16373$temp;
                        this.initTbelExpression(functionInput.getFunction());
                    }
                    if ((filter = metric.getFilter()) != null && !filter.isEmpty()) {
                        this.initTbelExpression(filter);
                    }
                });
                this.initialized = true;
                break;
            }
            case 7: {
                this.initialized = true;
            }
        }
    }

    public void setTenantProfileProperties() {
        TenantProfile tenantProfile = this.systemContext.getTenantProfileCache().get(this.tenantId);
        if (tenantProfile == null) {
            throw new IllegalStateException("Tenant Profile not found for tenant: " + String.valueOf(this.tenantId));
        }
        tenantProfile.getProfileConfiguration().ifPresent(config -> {
            this.maxStateSize = config.getMaxStateSizeInKBytes() * 1024L;
            this.maxSingleValueArgumentSize = config.getMaxSingleValueArgumentSizeInKBytes() * 1024L;
            this.intermediateAggregationIntervalMillis = TimeUnit.SECONDS.toMillis(config.getIntermediateAggregationIntervalInSecForCF());
            this.cfCheckReevaluationIntervalMillis = TimeUnit.SECONDS.toMillis(config.getCfReevaluationCheckInterval());
            this.alarmReevaluationIntervalMillis = TimeUnit.SECONDS.toMillis(config.getAlarmsReevaluationInterval());
            this.maxRelatedEntitiesPerCfArgument = config.getMaxRelatedEntitiesToReturnPerCfArgument();
            this.minScheduledUpdateIntervalMillis = TimeUnit.SECONDS.toMillis(config.getMinAllowedScheduledUpdateIntervalInSecForCF());
            this.minDeduplicationIntervalMillis = TimeUnit.SECONDS.toMillis(config.getMinAllowedDeduplicationIntervalInSecForCF());
        });
    }

    public double evaluateSimpleExpression(Expression expression, CalculatedFieldState state) {
        for (Map.Entry entry : state.getArguments().entrySet()) {
            try {
                BasicKvEntry kvEntry = ((SingleValueArgumentEntry)entry.getValue()).getKvEntryValue();
                double value = switch (1.$SwitchMap$org$thingsboard$server$common$data$kv$DataType[kvEntry.getDataType().ordinal()]) {
                    default -> throw new IncompatibleClassChangeError();
                    case 1 -> kvEntry.getLongValue().map(Long::doubleValue).orElseThrow();
                    case 2 -> (Double)kvEntry.getDoubleValue().orElseThrow();
                    case 3 -> kvEntry.getBooleanValue().map(b -> b != false ? 1.0 : 0.0).orElseThrow();
                    case 4, 5 -> Double.parseDouble(kvEntry.getValueAsString());
                };
                expression.setVariable((String)entry.getKey(), value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Argument '" + (String)entry.getKey() + "' is not a number.");
            }
        }
        return expression.evaluate();
    }

    public ListenableFuture<Object> evaluateTbelExpression(String expression, CalculatedFieldState state) {
        return this.evaluateTbelExpression((CalculatedFieldScriptEngine)this.tbelExpressions.get(expression), state.getArguments(), state.getLatestTimestamp());
    }

    public ListenableFuture<Object> evaluateTbelExpression(CalculatedFieldScriptEngine expression, CalculatedFieldState state) {
        return this.evaluateTbelExpression(expression, state.getArguments(), state.getLatestTimestamp());
    }

    public ListenableFuture<Object> evaluateTbelExpression(String expression, Map<String, ArgumentEntry> entries, long latestTimestamp) {
        return this.evaluateTbelExpression((CalculatedFieldScriptEngine)this.tbelExpressions.get(expression), entries, latestTimestamp);
    }

    public ListenableFuture<Object> evaluateTbelExpression(CalculatedFieldScriptEngine expression, Map<String, ArgumentEntry> entries, long latestTimestamp) {
        LinkedHashMap<String, TbelCfArg> arguments = new LinkedHashMap<String, TbelCfArg>();
        ArrayList<Object> args = new ArrayList<Object>(this.argNames.size() + 1);
        args.add(new Object());
        for (String argName : this.argNames) {
            TbelCfArg arg = this.toTbelArgument(argName, entries);
            arguments.put(argName, arg);
            if (arg instanceof TbelCfSingleValueArg) {
                TbelCfSingleValueArg svArg = (TbelCfSingleValueArg)arg;
                args.add(svArg.getValue());
                continue;
            }
            args.add(arg);
        }
        args.set(0, new TbelCfCtx(arguments, latestTimestamp));
        return expression.executeScriptAsync(args.toArray());
    }

    public ScheduledFuture<?> scheduleReevaluation(long delayMs, TbActorRef actorCtx) {
        log.debug("[{}] Scheduling CF reevaluation in {} ms", (Object)this.cfId, (Object)delayMs);
        return this.systemContext.scheduleMsgWithDelay(actorCtx, (TbActorMsg)new CalculatedFieldReevaluateMsg(this.tenantId, this), delayMs);
    }

    private TbelCfArg toTbelArgument(String key, Map<String, ArgumentEntry> arguments) {
        return arguments.get(key).toTbelCfArg();
    }

    private void initTbelExpression(String expression) {
        if (this.tbelExpressions == null) {
            this.tbelExpressions = new HashMap();
        } else if (this.tbelExpressions.containsKey(expression)) {
            return;
        }
        try {
            CalculatedFieldScriptEngine engine = this.initEngine(this.tenantId, expression, this.tbelInvokeService);
            this.tbelExpressions.put(expression, engine);
        }
        catch (Exception e) {
            this.initialized = false;
            throw new RuntimeException("Failed to init calculated field ctx. Invalid expression syntax.", e);
        }
    }

    private void initSimpleExpression(String expression) {
        if (this.simpleExpressions == null) {
            this.simpleExpressions = new HashMap();
        } else if (this.simpleExpressions.containsKey(expression)) {
            return;
        }
        if (!this.isValidExpression(expression)) {
            this.initialized = false;
            throw new RuntimeException("Failed to init calculated field ctx. Invalid expression syntax.");
        }
        ThreadLocal<Expression> compiledExpression = ThreadLocal.withInitial(() -> ExpressionUtils.createExpression((String)expression, this.arguments.keySet()));
        this.simpleExpressions.put(expression, compiledExpression);
    }

    private CalculatedFieldScriptEngine initEngine(TenantId tenantId, String expression, TbelInvokeService tbelInvokeService) {
        if (tbelInvokeService == null) {
            throw new IllegalArgumentException("TBEL script engine is disabled!");
        }
        ArrayList<String> ctxAndArgNames = new ArrayList<String>(this.argNames.size() + 1);
        ctxAndArgNames.add("ctx");
        ctxAndArgNames.addAll(this.argNames);
        return new CalculatedFieldTbelScriptEngine(tenantId, tbelInvokeService, expression, (String[])ctxAndArgNames.toArray(String[]::new));
    }

    private boolean isValidExpression(String expression) {
        try {
            MVEL.compileExpression((String)expression);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean matches(List<AttributeKvEntry> values, AttributeScope scope) {
        return this.matchesAttributes(this.mainEntityArguments, values, scope);
    }

    public boolean linkMatches(EntityId entityId, List<AttributeKvEntry> values, AttributeScope scope) {
        Map map = (Map)this.linkedEntityArguments.get(entityId);
        return map != null && this.matchesAttributes(map, values, scope);
    }

    public boolean matches(List<TsKvEntry> values) {
        return this.matchesTimeSeries(this.mainEntityArguments, values);
    }

    public boolean linkMatches(EntityId entityId, List<TsKvEntry> values) {
        Map map = (Map)this.linkedEntityArguments.get(entityId);
        return map != null && this.matchesTimeSeries(map, values);
    }

    public boolean dynamicSourceMatches(List<TsKvEntry> values) {
        return this.matchesTimeSeries(this.dynamicEntityArguments, values);
    }

    public boolean dynamicSourceMatches(List<AttributeKvEntry> values, AttributeScope scope) {
        return this.matchesAttributes(this.dynamicEntityArguments, values, scope);
    }

    private boolean matchesAttributes(Map<ReferencedEntityKey, Set<String>> argMap, List<AttributeKvEntry> values, AttributeScope scope) {
        if (argMap.isEmpty() || values.isEmpty()) {
            return false;
        }
        for (AttributeKvEntry attrKv : values) {
            if (!argMap.containsKey(new ReferencedEntityKey(attrKv.getKey(), ArgumentType.ATTRIBUTE, scope))) continue;
            return true;
        }
        return false;
    }

    private boolean matchesTimeSeries(Map<ReferencedEntityKey, Set<String>> argMap, List<TsKvEntry> values) {
        if (argMap.isEmpty() || values.isEmpty()) {
            return false;
        }
        for (TsKvEntry tsKv : values) {
            ReferencedEntityKey latestKey = new ReferencedEntityKey(tsKv.getKey(), ArgumentType.TS_LATEST, null);
            if (argMap.containsKey(latestKey)) {
                return true;
            }
            ReferencedEntityKey rollingKey = new ReferencedEntityKey(tsKv.getKey(), ArgumentType.TS_ROLLING, null);
            if (!argMap.containsKey(rollingKey)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesKeys(List<String> keys, AttributeScope scope) {
        return this.matchesAttributesKeys(this.mainEntityArguments, keys, scope);
    }

    public boolean matchesKeys(List<String> keys) {
        return this.matchesTimeSeriesKeys(this.mainEntityArguments, keys);
    }

    public boolean matchesDynamicSourceKeys(List<String> keys, AttributeScope scope) {
        return this.matchesAttributesKeys(this.dynamicEntityArguments, keys, scope);
    }

    public boolean matchesDynamicSourceKeys(List<String> keys) {
        return this.matchesTimeSeriesKeys(this.dynamicEntityArguments, keys);
    }

    private boolean matchesAttributesKeys(Map<ReferencedEntityKey, Set<String>> argMap, List<String> keys, AttributeScope scope) {
        if (argMap.isEmpty() || keys.isEmpty()) {
            return false;
        }
        for (String key : keys) {
            ReferencedEntityKey attrKey = new ReferencedEntityKey(key, ArgumentType.ATTRIBUTE, scope);
            if (!argMap.containsKey(attrKey)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesTimeSeriesKeys(Map<ReferencedEntityKey, Set<String>> argMap, List<String> keys) {
        if (argMap.isEmpty() || keys.isEmpty()) {
            return false;
        }
        for (String key : keys) {
            ReferencedEntityKey latestKey = new ReferencedEntityKey(key, ArgumentType.TS_LATEST, null);
            if (argMap.containsKey(latestKey)) {
                return true;
            }
            ReferencedEntityKey rollingKey = new ReferencedEntityKey(key, ArgumentType.TS_ROLLING, null);
            if (!argMap.containsKey(rollingKey)) continue;
            return true;
        }
        return false;
    }

    public boolean linkMatchesAttrKeys(EntityId entityId, List<String> keys, AttributeScope scope) {
        Map map = (Map)this.linkedEntityArguments.get(entityId);
        return map != null && this.matchesAttributesKeys(map, keys, scope);
    }

    public boolean linkMatchesTsKeys(EntityId entityId, List<String> keys) {
        Map map = (Map)this.linkedEntityArguments.get(entityId);
        return map != null && this.matchesTimeSeriesKeys(map, keys);
    }

    public boolean relatedEntityMatches(List<TsKvEntry> values) {
        return this.matchesTimeSeries(this.relatedEntityArguments, values);
    }

    public boolean relatedEntityMatches(List<AttributeKvEntry> values, AttributeScope scope) {
        return this.matchesAttributes(this.relatedEntityArguments, values, scope);
    }

    public boolean matchesRelatedEntityKeys(List<String> keys, AttributeScope scope) {
        return this.matchesAttributesKeys(this.relatedEntityArguments, keys, scope);
    }

    public boolean matchesRelatedEntityKeys(List<String> keys) {
        return this.matchesTimeSeriesKeys(this.relatedEntityArguments, keys);
    }

    public boolean relatedEntityMatches(TransportProtos.CalculatedFieldTelemetryMsgProto proto) {
        if (!proto.getTsDataList().isEmpty()) {
            List<TsKvEntry> updatedTelemetry = proto.getTsDataList().stream().map(ProtoUtils::fromProto).toList();
            return this.relatedEntityMatches(updatedTelemetry);
        }
        if (!proto.getAttrDataList().isEmpty()) {
            AttributeScope scope = AttributeScope.valueOf((String)proto.getScope().name());
            List<AttributeKvEntry> updatedTelemetry = proto.getAttrDataList().stream().map(ProtoUtils::fromProto).toList();
            return this.relatedEntityMatches(updatedTelemetry, scope);
        }
        if (!proto.getRemovedTsKeysList().isEmpty()) {
            return this.matchesRelatedEntityKeys((List)proto.getRemovedTsKeysList());
        }
        return this.matchesRelatedEntityKeys((List)proto.getRemovedAttrKeysList(), AttributeScope.valueOf((String)proto.getScope().name()));
    }

    public boolean dynamicSourceMatches(TransportProtos.CalculatedFieldTelemetryMsgProto proto) {
        if (!proto.getTsDataList().isEmpty()) {
            List<TsKvEntry> updatedTelemetry = proto.getTsDataList().stream().map(ProtoUtils::fromProto).toList();
            return this.dynamicSourceMatches(updatedTelemetry);
        }
        if (!proto.getAttrDataList().isEmpty()) {
            AttributeScope scope = AttributeScope.valueOf((String)proto.getScope().name());
            List<AttributeKvEntry> updatedTelemetry = proto.getAttrDataList().stream().map(ProtoUtils::fromProto).toList();
            return this.dynamicSourceMatches(updatedTelemetry, scope);
        }
        if (!proto.getRemovedTsKeysList().isEmpty()) {
            return this.matchesDynamicSourceKeys((List)proto.getRemovedTsKeysList());
        }
        return this.matchesDynamicSourceKeys((List)proto.getRemovedAttrKeysList(), AttributeScope.valueOf((String)proto.getScope().name()));
    }

    public boolean linkMatches(EntityId entityId, TransportProtos.CalculatedFieldTelemetryMsgProto proto) {
        if (!proto.getTsDataList().isEmpty()) {
            List<TsKvEntry> updatedTelemetry = proto.getTsDataList().stream().map(ProtoUtils::fromProto).toList();
            return this.linkMatches(entityId, updatedTelemetry);
        }
        if (!proto.getAttrDataList().isEmpty()) {
            AttributeScope scope = AttributeScope.valueOf((String)proto.getScope().name());
            List<AttributeKvEntry> updatedTelemetry = proto.getAttrDataList().stream().map(ProtoUtils::fromProto).toList();
            return this.linkMatches(entityId, updatedTelemetry, scope);
        }
        if (!proto.getRemovedTsKeysList().isEmpty()) {
            return this.linkMatchesTsKeys(entityId, (List)proto.getRemovedTsKeysList());
        }
        return this.linkMatchesAttrKeys(entityId, (List)proto.getRemovedAttrKeysList(), AttributeScope.valueOf((String)proto.getScope().name()));
    }

    public Map<ReferencedEntityKey, Set<String>> getLinkedAndDynamicArgs(EntityId entityId) {
        HashMap<ReferencedEntityKey, Set<String>> argNames = new HashMap<ReferencedEntityKey, Set<String>>();
        Map linkedArgNames = (Map)this.linkedEntityArguments.get(entityId);
        if (linkedArgNames != null && !linkedArgNames.isEmpty()) {
            argNames.putAll(linkedArgNames);
        }
        if (this.dynamicEntityArguments != null && !this.dynamicEntityArguments.isEmpty()) {
            argNames.putAll(this.dynamicEntityArguments);
        }
        return argNames;
    }

    public CalculatedFieldEntityCtxId toCalculatedFieldEntityCtxId() {
        return new CalculatedFieldEntityCtxId(this.tenantId, this.cfId, this.entityId);
    }

    public boolean hasRefreshContextOnlyChanges(CalculatedFieldCtx other) {
        OutputStrategy otherOutputStrategy;
        OutputStrategy thisOutputStrategy;
        if (this.output != null && (thisOutputStrategy = this.output.getStrategy()).hasRefreshContextOnlyChanges(otherOutputStrategy = other.getCalculatedField().getConfiguration().getOutput().getStrategy())) {
            return true;
        }
        CalculatedFieldConfiguration calculatedFieldConfiguration = this.calculatedField.getConfiguration();
        if (calculatedFieldConfiguration instanceof EntityAggregationCalculatedFieldConfiguration) {
            EntityAggregationCalculatedFieldConfiguration thisConfig = (EntityAggregationCalculatedFieldConfiguration)calculatedFieldConfiguration;
            calculatedFieldConfiguration = other.getCalculatedField().getConfiguration();
            if (calculatedFieldConfiguration instanceof EntityAggregationCalculatedFieldConfiguration) {
                EntityAggregationCalculatedFieldConfiguration otherConfig = (EntityAggregationCalculatedFieldConfiguration)calculatedFieldConfiguration;
                if (thisConfig.isProduceIntermediateResult() != otherConfig.isProduceIntermediateResult()) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasContextOnlyChanges(CalculatedFieldCtx other) {
        SimpleCalculatedFieldConfiguration otherConfig;
        SimpleCalculatedFieldConfiguration thisConfig;
        if (this.calculatedField.getConfiguration() instanceof ExpressionBasedCalculatedFieldConfiguration && !Objects.equals(this.expression, other.expression)) {
            return true;
        }
        if (this.output != null && this.output.hasContextOnlyChanges(other.output)) {
            return true;
        }
        CalculatedFieldConfiguration calculatedFieldConfiguration = this.calculatedField.getConfiguration();
        if (calculatedFieldConfiguration instanceof SimpleCalculatedFieldConfiguration) {
            thisConfig = (SimpleCalculatedFieldConfiguration)calculatedFieldConfiguration;
            calculatedFieldConfiguration = other.calculatedField.getConfiguration();
            if (calculatedFieldConfiguration instanceof SimpleCalculatedFieldConfiguration) {
                otherConfig = (SimpleCalculatedFieldConfiguration)calculatedFieldConfiguration;
                if (thisConfig.isUseLatestTs() != otherConfig.isUseLatestTs()) {
                    return true;
                }
            }
        }
        if (this.cfType == CalculatedFieldType.ALARM) {
            if (!this.calculatedField.getName().equals(other.getCalculatedField().getName())) {
                return true;
            }
            thisConfig = (AlarmCalculatedFieldConfiguration)this.calculatedField.getConfiguration();
            if (!thisConfig.rulesEqual((AlarmCalculatedFieldConfiguration)(otherConfig = (AlarmCalculatedFieldConfiguration)other.getCalculatedField().getConfiguration()), AlarmRule::equals)) {
                return true;
            }
            if (!thisConfig.propagationSettingsEqual((AlarmCalculatedFieldConfiguration)otherConfig)) {
                return true;
            }
        }
        if (this.scheduledUpdateIntervalMillis != other.scheduledUpdateIntervalMillis) {
            return true;
        }
        calculatedFieldConfiguration = this.calculatedField.getConfiguration();
        if (calculatedFieldConfiguration instanceof RelatedEntitiesAggregationCalculatedFieldConfiguration) {
            thisConfig = (RelatedEntitiesAggregationCalculatedFieldConfiguration)calculatedFieldConfiguration;
            calculatedFieldConfiguration = other.getCalculatedField().getConfiguration();
            if (calculatedFieldConfiguration instanceof RelatedEntitiesAggregationCalculatedFieldConfiguration) {
                otherConfig = (RelatedEntitiesAggregationCalculatedFieldConfiguration)calculatedFieldConfiguration;
                if (thisConfig.getDeduplicationIntervalInSec() != otherConfig.getDeduplicationIntervalInSec() || !thisConfig.getMetrics().equals(otherConfig.getMetrics()) || thisConfig.isUseLatestTs() != otherConfig.isUseLatestTs()) {
                    return true;
                }
            }
        }
        if ((calculatedFieldConfiguration = this.calculatedField.getConfiguration()) instanceof EntityAggregationCalculatedFieldConfiguration) {
            thisConfig = (EntityAggregationCalculatedFieldConfiguration)calculatedFieldConfiguration;
            calculatedFieldConfiguration = other.getCalculatedField().getConfiguration();
            if (calculatedFieldConfiguration instanceof EntityAggregationCalculatedFieldConfiguration) {
                boolean watermarkChanged;
                otherConfig = (EntityAggregationCalculatedFieldConfiguration)calculatedFieldConfiguration;
                boolean metricsChanged = !Objects.equals(thisConfig.getMetrics(), otherConfig.getMetrics());
                boolean bl = watermarkChanged = !Objects.equals(thisConfig.getWatermark(), otherConfig.getWatermark());
                if (metricsChanged || watermarkChanged) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasStateChanges(CalculatedFieldCtx other) {
        AlarmCalculatedFieldConfiguration otherConfig;
        AlarmCalculatedFieldConfiguration thisConfig;
        if (!this.arguments.equals(other.arguments)) {
            return true;
        }
        if (this.cfType == CalculatedFieldType.ALARM && !(thisConfig = (AlarmCalculatedFieldConfiguration)this.calculatedField.getConfiguration()).rulesEqual(otherConfig = (AlarmCalculatedFieldConfiguration)other.getCalculatedField().getConfiguration(), (thisRule, otherRule) -> thisRule.getCondition().getType() == otherRule.getCondition().getType())) {
            return true;
        }
        if (this.hasGeofencingZoneGroupConfigurationChanges(other)) {
            return true;
        }
        if (this.hasRelatedEntitiesAggregationConfigurationChanges(other)) {
            return true;
        }
        return this.hasEntityAggregationConfigurationChanges(other);
    }

    private boolean hasGeofencingZoneGroupConfigurationChanges(CalculatedFieldCtx other) {
        CalculatedFieldConfiguration calculatedFieldConfiguration = this.calculatedField.getConfiguration();
        if (calculatedFieldConfiguration instanceof GeofencingCalculatedFieldConfiguration) {
            GeofencingCalculatedFieldConfiguration thisConfig = (GeofencingCalculatedFieldConfiguration)calculatedFieldConfiguration;
            calculatedFieldConfiguration = other.calculatedField.getConfiguration();
            if (calculatedFieldConfiguration instanceof GeofencingCalculatedFieldConfiguration) {
                GeofencingCalculatedFieldConfiguration otherConfig = (GeofencingCalculatedFieldConfiguration)calculatedFieldConfiguration;
                return !thisConfig.getZoneGroups().equals(otherConfig.getZoneGroups());
            }
        }
        return false;
    }

    private boolean hasRelatedEntitiesAggregationConfigurationChanges(CalculatedFieldCtx other) {
        CalculatedFieldConfiguration calculatedFieldConfiguration = this.calculatedField.getConfiguration();
        if (calculatedFieldConfiguration instanceof RelatedEntitiesAggregationCalculatedFieldConfiguration) {
            RelatedEntitiesAggregationCalculatedFieldConfiguration thisConfig = (RelatedEntitiesAggregationCalculatedFieldConfiguration)calculatedFieldConfiguration;
            calculatedFieldConfiguration = other.calculatedField.getConfiguration();
            if (calculatedFieldConfiguration instanceof RelatedEntitiesAggregationCalculatedFieldConfiguration) {
                RelatedEntitiesAggregationCalculatedFieldConfiguration otherConfig = (RelatedEntitiesAggregationCalculatedFieldConfiguration)calculatedFieldConfiguration;
                return !thisConfig.getRelation().equals((Object)otherConfig.getRelation());
            }
        }
        return false;
    }

    private boolean hasEntityAggregationConfigurationChanges(CalculatedFieldCtx other) {
        CalculatedFieldConfiguration calculatedFieldConfiguration = this.calculatedField.getConfiguration();
        if (calculatedFieldConfiguration instanceof EntityAggregationCalculatedFieldConfiguration) {
            EntityAggregationCalculatedFieldConfiguration thisConfig = (EntityAggregationCalculatedFieldConfiguration)calculatedFieldConfiguration;
            calculatedFieldConfiguration = other.calculatedField.getConfiguration();
            if (calculatedFieldConfiguration instanceof EntityAggregationCalculatedFieldConfiguration) {
                EntityAggregationCalculatedFieldConfiguration otherConfig = (EntityAggregationCalculatedFieldConfiguration)calculatedFieldConfiguration;
                return !thisConfig.getInterval().equals(otherConfig.getInterval());
            }
        }
        return false;
    }

    private boolean isScheduledUpdateDisabled() {
        return this.scheduledUpdateIntervalMillis == -1L;
    }

    public boolean hasRelatedEntities() {
        return this.cfHasRelationPathQuerySource;
    }

    public boolean shouldFetchRelatedEntities(CalculatedFieldState state) {
        if (!this.cfHasRelationPathQuerySource) {
            return false;
        }
        if (this.isScheduledUpdateDisabled()) {
            return false;
        }
        if (!(state instanceof ScheduledRefreshSupported)) {
            return false;
        }
        ScheduledRefreshSupported scheduledRefreshSupported = (ScheduledRefreshSupported)state;
        if (scheduledRefreshSupported.getLastScheduledRefreshTs() == -1L) {
            return true;
        }
        return scheduledRefreshSupported.getLastScheduledRefreshTs() < System.currentTimeMillis() - Math.max(this.scheduledUpdateIntervalMillis, this.minScheduledUpdateIntervalMillis);
    }

    @Override
    public void close() {
        try {
            if (this.tbelExpressions != null) {
                this.tbelExpressions.values().forEach(CalculatedFieldScriptEngine::destroy);
            }
            if (this.simpleExpressions != null) {
                this.simpleExpressions.values().forEach(ThreadLocal::remove);
            }
        }
        catch (Exception e) {
            log.warn("Failed to stop {}", (Object)this, (Object)e);
        }
    }

    public String getSizeExceedsLimitMessage() {
        return "Failed to init CF state. State size exceeds limit of " + this.maxStateSize / 1024L + "Kb!";
    }

    public boolean hasCurrentOwnerSourceArguments() {
        return !this.dynamicEntityArguments.isEmpty();
    }

    public String toString() {
        return "CalculatedFieldCtx{cfId=" + String.valueOf(this.cfId) + ", cfType=" + String.valueOf(this.cfType) + ", entityId=" + String.valueOf(this.entityId) + "}";
    }

    @Generated
    public CalculatedField getCalculatedField() {
        return this.calculatedField;
    }

    @Generated
    public CalculatedFieldId getCfId() {
        return this.cfId;
    }

    @Generated
    public String getCfName() {
        return this.cfName;
    }

    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public EntityId getEntityId() {
        return this.entityId;
    }

    @Generated
    public CalculatedFieldType getCfType() {
        return this.cfType;
    }

    @Generated
    public Map<String, Argument> getArguments() {
        return this.arguments;
    }

    @Generated
    public Map<ReferencedEntityKey, Set<String>> getMainEntityArguments() {
        return this.mainEntityArguments;
    }

    @Generated
    public Map<EntityId, Map<ReferencedEntityKey, Set<String>>> getLinkedEntityArguments() {
        return this.linkedEntityArguments;
    }

    @Generated
    public Map<ReferencedEntityKey, Set<String>> getDynamicEntityArguments() {
        return this.dynamicEntityArguments;
    }

    @Generated
    public Map<ReferencedEntityKey, Set<String>> getRelatedEntityArguments() {
        return this.relatedEntityArguments;
    }

    @Generated
    public List<String> getArgNames() {
        return this.argNames;
    }

    @Generated
    public Output getOutput() {
        return this.output;
    }

    @Generated
    public String getExpression() {
        return this.expression;
    }

    @Generated
    public boolean isUseLatestTs() {
        return this.useLatestTs;
    }

    @Generated
    public long getLastReevaluationTs() {
        return this.lastReevaluationTs;
    }

    @Generated
    public ActorSystemContext getSystemContext() {
        return this.systemContext;
    }

    @Generated
    public TbelInvokeService getTbelInvokeService() {
        return this.tbelInvokeService;
    }

    @Generated
    public RelationService getRelationService() {
        return this.relationService;
    }

    @Generated
    public AlarmSubscriptionService getAlarmService() {
        return this.alarmService;
    }

    @Generated
    public CalculatedFieldProcessingService getCfProcessingService() {
        return this.cfProcessingService;
    }

    @Generated
    public Map<String, CalculatedFieldScriptEngine> getTbelExpressions() {
        return this.tbelExpressions;
    }

    @Generated
    public Map<String, ThreadLocal<Expression>> getSimpleExpressions() {
        return this.simpleExpressions;
    }

    @Generated
    public boolean isInitialized() {
        return this.initialized;
    }

    @Generated
    public long getMaxStateSize() {
        return this.maxStateSize;
    }

    @Generated
    public long getMaxSingleValueArgumentSize() {
        return this.maxSingleValueArgumentSize;
    }

    @Generated
    public long getIntermediateAggregationIntervalMillis() {
        return this.intermediateAggregationIntervalMillis;
    }

    @Generated
    public boolean isCfHasRelationPathQuerySource() {
        return this.cfHasRelationPathQuerySource;
    }

    @Generated
    public List<String> getMainEntityGeofencingArgumentNames() {
        return this.mainEntityGeofencingArgumentNames;
    }

    @Generated
    public List<String> getLinkedEntityAndCurrentOwnerGeofencingArgumentNames() {
        return this.linkedEntityAndCurrentOwnerGeofencingArgumentNames;
    }

    @Generated
    public List<String> getRelatedEntityArgumentNames() {
        return this.relatedEntityArgumentNames;
    }

    @Generated
    public long getScheduledUpdateIntervalMillis() {
        return this.scheduledUpdateIntervalMillis;
    }

    @Generated
    public long getCfCheckReevaluationIntervalMillis() {
        return this.cfCheckReevaluationIntervalMillis;
    }

    @Generated
    public long getAlarmReevaluationIntervalMillis() {
        return this.alarmReevaluationIntervalMillis;
    }

    @Generated
    public long getMaxRelatedEntitiesPerCfArgument() {
        return this.maxRelatedEntitiesPerCfArgument;
    }

    @Generated
    public long getMinScheduledUpdateIntervalMillis() {
        return this.minScheduledUpdateIntervalMillis;
    }

    @Generated
    public long getMinDeduplicationIntervalMillis() {
        return this.minDeduplicationIntervalMillis;
    }

    @Generated
    public Argument getPropagationArgument() {
        return this.propagationArgument;
    }

    @Generated
    public boolean isApplyExpressionForResolvedArguments() {
        return this.applyExpressionForResolvedArguments;
    }

    @Generated
    public void setCalculatedField(CalculatedField calculatedField) {
        this.calculatedField = calculatedField;
    }

    @Generated
    public void setCfId(CalculatedFieldId cfId) {
        this.cfId = cfId;
    }

    @Generated
    public void setCfName(String cfName) {
        this.cfName = cfName;
    }

    @Generated
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setEntityId(EntityId entityId) {
        this.entityId = entityId;
    }

    @Generated
    public void setCfType(CalculatedFieldType cfType) {
        this.cfType = cfType;
    }

    @Generated
    public void setOutput(Output output) {
        this.output = output;
    }

    @Generated
    public void setExpression(String expression) {
        this.expression = expression;
    }

    @Generated
    public void setUseLatestTs(boolean useLatestTs) {
        this.useLatestTs = useLatestTs;
    }

    @Generated
    public void setLastReevaluationTs(long lastReevaluationTs) {
        this.lastReevaluationTs = lastReevaluationTs;
    }

    @Generated
    public void setSystemContext(ActorSystemContext systemContext) {
        this.systemContext = systemContext;
    }

    @Generated
    public void setTbelInvokeService(TbelInvokeService tbelInvokeService) {
        this.tbelInvokeService = tbelInvokeService;
    }

    @Generated
    public void setRelationService(RelationService relationService) {
        this.relationService = relationService;
    }

    @Generated
    public void setAlarmService(AlarmSubscriptionService alarmService) {
        this.alarmService = alarmService;
    }

    @Generated
    public void setCfProcessingService(CalculatedFieldProcessingService cfProcessingService) {
        this.cfProcessingService = cfProcessingService;
    }

    @Generated
    public void setTbelExpressions(Map<String, CalculatedFieldScriptEngine> tbelExpressions) {
        this.tbelExpressions = tbelExpressions;
    }

    @Generated
    public void setSimpleExpressions(Map<String, ThreadLocal<Expression>> simpleExpressions) {
        this.simpleExpressions = simpleExpressions;
    }

    @Generated
    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    @Generated
    public void setMaxStateSize(long maxStateSize) {
        this.maxStateSize = maxStateSize;
    }

    @Generated
    public void setMaxSingleValueArgumentSize(long maxSingleValueArgumentSize) {
        this.maxSingleValueArgumentSize = maxSingleValueArgumentSize;
    }

    @Generated
    public void setIntermediateAggregationIntervalMillis(long intermediateAggregationIntervalMillis) {
        this.intermediateAggregationIntervalMillis = intermediateAggregationIntervalMillis;
    }

    @Generated
    public void setCfHasRelationPathQuerySource(boolean cfHasRelationPathQuerySource) {
        this.cfHasRelationPathQuerySource = cfHasRelationPathQuerySource;
    }

    @Generated
    public void setMainEntityGeofencingArgumentNames(List<String> mainEntityGeofencingArgumentNames) {
        this.mainEntityGeofencingArgumentNames = mainEntityGeofencingArgumentNames;
    }

    @Generated
    public void setLinkedEntityAndCurrentOwnerGeofencingArgumentNames(List<String> linkedEntityAndCurrentOwnerGeofencingArgumentNames) {
        this.linkedEntityAndCurrentOwnerGeofencingArgumentNames = linkedEntityAndCurrentOwnerGeofencingArgumentNames;
    }

    @Generated
    public void setRelatedEntityArgumentNames(List<String> relatedEntityArgumentNames) {
        this.relatedEntityArgumentNames = relatedEntityArgumentNames;
    }

    @Generated
    public void setScheduledUpdateIntervalMillis(long scheduledUpdateIntervalMillis) {
        this.scheduledUpdateIntervalMillis = scheduledUpdateIntervalMillis;
    }

    @Generated
    public void setCfCheckReevaluationIntervalMillis(long cfCheckReevaluationIntervalMillis) {
        this.cfCheckReevaluationIntervalMillis = cfCheckReevaluationIntervalMillis;
    }

    @Generated
    public void setAlarmReevaluationIntervalMillis(long alarmReevaluationIntervalMillis) {
        this.alarmReevaluationIntervalMillis = alarmReevaluationIntervalMillis;
    }

    @Generated
    public void setMaxRelatedEntitiesPerCfArgument(long maxRelatedEntitiesPerCfArgument) {
        this.maxRelatedEntitiesPerCfArgument = maxRelatedEntitiesPerCfArgument;
    }

    @Generated
    public void setMinScheduledUpdateIntervalMillis(long minScheduledUpdateIntervalMillis) {
        this.minScheduledUpdateIntervalMillis = minScheduledUpdateIntervalMillis;
    }

    @Generated
    public void setMinDeduplicationIntervalMillis(long minDeduplicationIntervalMillis) {
        this.minDeduplicationIntervalMillis = minDeduplicationIntervalMillis;
    }

    @Generated
    public void setPropagationArgument(Argument propagationArgument) {
        this.propagationArgument = propagationArgument;
    }

    @Generated
    public void setApplyExpressionForResolvedArguments(boolean applyExpressionForResolvedArguments) {
        this.applyExpressionForResolvedArguments = applyExpressionForResolvedArguments;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculatedFieldCtx)) {
            return false;
        }
        CalculatedFieldCtx other = (CalculatedFieldCtx)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isUseLatestTs() != other.isUseLatestTs()) {
            return false;
        }
        if (this.getLastReevaluationTs() != other.getLastReevaluationTs()) {
            return false;
        }
        if (this.isInitialized() != other.isInitialized()) {
            return false;
        }
        if (this.getMaxStateSize() != other.getMaxStateSize()) {
            return false;
        }
        if (this.getMaxSingleValueArgumentSize() != other.getMaxSingleValueArgumentSize()) {
            return false;
        }
        if (this.getIntermediateAggregationIntervalMillis() != other.getIntermediateAggregationIntervalMillis()) {
            return false;
        }
        if (this.isCfHasRelationPathQuerySource() != other.isCfHasRelationPathQuerySource()) {
            return false;
        }
        if (this.getScheduledUpdateIntervalMillis() != other.getScheduledUpdateIntervalMillis()) {
            return false;
        }
        if (this.getCfCheckReevaluationIntervalMillis() != other.getCfCheckReevaluationIntervalMillis()) {
            return false;
        }
        if (this.getAlarmReevaluationIntervalMillis() != other.getAlarmReevaluationIntervalMillis()) {
            return false;
        }
        if (this.getMaxRelatedEntitiesPerCfArgument() != other.getMaxRelatedEntitiesPerCfArgument()) {
            return false;
        }
        if (this.getMinScheduledUpdateIntervalMillis() != other.getMinScheduledUpdateIntervalMillis()) {
            return false;
        }
        if (this.getMinDeduplicationIntervalMillis() != other.getMinDeduplicationIntervalMillis()) {
            return false;
        }
        if (this.isApplyExpressionForResolvedArguments() != other.isApplyExpressionForResolvedArguments()) {
            return false;
        }
        CalculatedField this$calculatedField = this.getCalculatedField();
        CalculatedField other$calculatedField = other.getCalculatedField();
        if (this$calculatedField == null ? other$calculatedField != null : !this$calculatedField.equals(other$calculatedField)) {
            return false;
        }
        CalculatedFieldId this$cfId = this.getCfId();
        CalculatedFieldId other$cfId = other.getCfId();
        if (this$cfId == null ? other$cfId != null : !this$cfId.equals(other$cfId)) {
            return false;
        }
        String this$cfName = this.getCfName();
        String other$cfName = other.getCfName();
        if (this$cfName == null ? other$cfName != null : !this$cfName.equals(other$cfName)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        EntityId this$entityId = this.getEntityId();
        EntityId other$entityId = other.getEntityId();
        if (this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId)) {
            return false;
        }
        CalculatedFieldType this$cfType = this.getCfType();
        CalculatedFieldType other$cfType = other.getCfType();
        if (this$cfType == null ? other$cfType != null : !this$cfType.equals(other$cfType)) {
            return false;
        }
        Map this$arguments = this.getArguments();
        Map other$arguments = other.getArguments();
        if (this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments)) {
            return false;
        }
        Map this$mainEntityArguments = this.getMainEntityArguments();
        Map other$mainEntityArguments = other.getMainEntityArguments();
        if (this$mainEntityArguments == null ? other$mainEntityArguments != null : !((Object)this$mainEntityArguments).equals(other$mainEntityArguments)) {
            return false;
        }
        Map this$linkedEntityArguments = this.getLinkedEntityArguments();
        Map other$linkedEntityArguments = other.getLinkedEntityArguments();
        if (this$linkedEntityArguments == null ? other$linkedEntityArguments != null : !((Object)this$linkedEntityArguments).equals(other$linkedEntityArguments)) {
            return false;
        }
        Map this$dynamicEntityArguments = this.getDynamicEntityArguments();
        Map other$dynamicEntityArguments = other.getDynamicEntityArguments();
        if (this$dynamicEntityArguments == null ? other$dynamicEntityArguments != null : !((Object)this$dynamicEntityArguments).equals(other$dynamicEntityArguments)) {
            return false;
        }
        Map this$relatedEntityArguments = this.getRelatedEntityArguments();
        Map other$relatedEntityArguments = other.getRelatedEntityArguments();
        if (this$relatedEntityArguments == null ? other$relatedEntityArguments != null : !((Object)this$relatedEntityArguments).equals(other$relatedEntityArguments)) {
            return false;
        }
        List this$argNames = this.getArgNames();
        List other$argNames = other.getArgNames();
        if (this$argNames == null ? other$argNames != null : !((Object)this$argNames).equals(other$argNames)) {
            return false;
        }
        Output this$output = this.getOutput();
        Output other$output = other.getOutput();
        if (this$output == null ? other$output != null : !this$output.equals(other$output)) {
            return false;
        }
        String this$expression = this.getExpression();
        String other$expression = other.getExpression();
        if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
            return false;
        }
        ActorSystemContext this$systemContext = this.getSystemContext();
        ActorSystemContext other$systemContext = other.getSystemContext();
        if (this$systemContext == null ? other$systemContext != null : !this$systemContext.equals(other$systemContext)) {
            return false;
        }
        TbelInvokeService this$tbelInvokeService = this.getTbelInvokeService();
        TbelInvokeService other$tbelInvokeService = other.getTbelInvokeService();
        if (this$tbelInvokeService == null ? other$tbelInvokeService != null : !this$tbelInvokeService.equals(other$tbelInvokeService)) {
            return false;
        }
        RelationService this$relationService = this.getRelationService();
        RelationService other$relationService = other.getRelationService();
        if (this$relationService == null ? other$relationService != null : !this$relationService.equals(other$relationService)) {
            return false;
        }
        AlarmSubscriptionService this$alarmService = this.getAlarmService();
        AlarmSubscriptionService other$alarmService = other.getAlarmService();
        if (this$alarmService == null ? other$alarmService != null : !this$alarmService.equals(other$alarmService)) {
            return false;
        }
        CalculatedFieldProcessingService this$cfProcessingService = this.getCfProcessingService();
        CalculatedFieldProcessingService other$cfProcessingService = other.getCfProcessingService();
        if (this$cfProcessingService == null ? other$cfProcessingService != null : !this$cfProcessingService.equals(other$cfProcessingService)) {
            return false;
        }
        Map this$tbelExpressions = this.getTbelExpressions();
        Map other$tbelExpressions = other.getTbelExpressions();
        if (this$tbelExpressions == null ? other$tbelExpressions != null : !((Object)this$tbelExpressions).equals(other$tbelExpressions)) {
            return false;
        }
        Map this$simpleExpressions = this.getSimpleExpressions();
        Map other$simpleExpressions = other.getSimpleExpressions();
        if (this$simpleExpressions == null ? other$simpleExpressions != null : !((Object)this$simpleExpressions).equals(other$simpleExpressions)) {
            return false;
        }
        List this$mainEntityGeofencingArgumentNames = this.getMainEntityGeofencingArgumentNames();
        List other$mainEntityGeofencingArgumentNames = other.getMainEntityGeofencingArgumentNames();
        if (this$mainEntityGeofencingArgumentNames == null ? other$mainEntityGeofencingArgumentNames != null : !((Object)this$mainEntityGeofencingArgumentNames).equals(other$mainEntityGeofencingArgumentNames)) {
            return false;
        }
        List this$linkedEntityAndCurrentOwnerGeofencingArgumentNames = this.getLinkedEntityAndCurrentOwnerGeofencingArgumentNames();
        List other$linkedEntityAndCurrentOwnerGeofencingArgumentNames = other.getLinkedEntityAndCurrentOwnerGeofencingArgumentNames();
        if (this$linkedEntityAndCurrentOwnerGeofencingArgumentNames == null ? other$linkedEntityAndCurrentOwnerGeofencingArgumentNames != null : !((Object)this$linkedEntityAndCurrentOwnerGeofencingArgumentNames).equals(other$linkedEntityAndCurrentOwnerGeofencingArgumentNames)) {
            return false;
        }
        List this$relatedEntityArgumentNames = this.getRelatedEntityArgumentNames();
        List other$relatedEntityArgumentNames = other.getRelatedEntityArgumentNames();
        if (this$relatedEntityArgumentNames == null ? other$relatedEntityArgumentNames != null : !((Object)this$relatedEntityArgumentNames).equals(other$relatedEntityArgumentNames)) {
            return false;
        }
        Argument this$propagationArgument = this.getPropagationArgument();
        Argument other$propagationArgument = other.getPropagationArgument();
        return !(this$propagationArgument == null ? other$propagationArgument != null : !this$propagationArgument.equals(other$propagationArgument));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalculatedFieldCtx;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseLatestTs() ? 79 : 97);
        long $lastReevaluationTs = this.getLastReevaluationTs();
        result = result * 59 + (int)($lastReevaluationTs >>> 32 ^ $lastReevaluationTs);
        result = result * 59 + (this.isInitialized() ? 79 : 97);
        long $maxStateSize = this.getMaxStateSize();
        result = result * 59 + (int)($maxStateSize >>> 32 ^ $maxStateSize);
        long $maxSingleValueArgumentSize = this.getMaxSingleValueArgumentSize();
        result = result * 59 + (int)($maxSingleValueArgumentSize >>> 32 ^ $maxSingleValueArgumentSize);
        long $intermediateAggregationIntervalMillis = this.getIntermediateAggregationIntervalMillis();
        result = result * 59 + (int)($intermediateAggregationIntervalMillis >>> 32 ^ $intermediateAggregationIntervalMillis);
        result = result * 59 + (this.isCfHasRelationPathQuerySource() ? 79 : 97);
        long $scheduledUpdateIntervalMillis = this.getScheduledUpdateIntervalMillis();
        result = result * 59 + (int)($scheduledUpdateIntervalMillis >>> 32 ^ $scheduledUpdateIntervalMillis);
        long $cfCheckReevaluationIntervalMillis = this.getCfCheckReevaluationIntervalMillis();
        result = result * 59 + (int)($cfCheckReevaluationIntervalMillis >>> 32 ^ $cfCheckReevaluationIntervalMillis);
        long $alarmReevaluationIntervalMillis = this.getAlarmReevaluationIntervalMillis();
        result = result * 59 + (int)($alarmReevaluationIntervalMillis >>> 32 ^ $alarmReevaluationIntervalMillis);
        long $maxRelatedEntitiesPerCfArgument = this.getMaxRelatedEntitiesPerCfArgument();
        result = result * 59 + (int)($maxRelatedEntitiesPerCfArgument >>> 32 ^ $maxRelatedEntitiesPerCfArgument);
        long $minScheduledUpdateIntervalMillis = this.getMinScheduledUpdateIntervalMillis();
        result = result * 59 + (int)($minScheduledUpdateIntervalMillis >>> 32 ^ $minScheduledUpdateIntervalMillis);
        long $minDeduplicationIntervalMillis = this.getMinDeduplicationIntervalMillis();
        result = result * 59 + (int)($minDeduplicationIntervalMillis >>> 32 ^ $minDeduplicationIntervalMillis);
        result = result * 59 + (this.isApplyExpressionForResolvedArguments() ? 79 : 97);
        CalculatedField $calculatedField = this.getCalculatedField();
        result = result * 59 + ($calculatedField == null ? 43 : $calculatedField.hashCode());
        CalculatedFieldId $cfId = this.getCfId();
        result = result * 59 + ($cfId == null ? 43 : $cfId.hashCode());
        String $cfName = this.getCfName();
        result = result * 59 + ($cfName == null ? 43 : $cfName.hashCode());
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        EntityId $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        CalculatedFieldType $cfType = this.getCfType();
        result = result * 59 + ($cfType == null ? 43 : $cfType.hashCode());
        Map $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        Map $mainEntityArguments = this.getMainEntityArguments();
        result = result * 59 + ($mainEntityArguments == null ? 43 : ((Object)$mainEntityArguments).hashCode());
        Map $linkedEntityArguments = this.getLinkedEntityArguments();
        result = result * 59 + ($linkedEntityArguments == null ? 43 : ((Object)$linkedEntityArguments).hashCode());
        Map $dynamicEntityArguments = this.getDynamicEntityArguments();
        result = result * 59 + ($dynamicEntityArguments == null ? 43 : ((Object)$dynamicEntityArguments).hashCode());
        Map $relatedEntityArguments = this.getRelatedEntityArguments();
        result = result * 59 + ($relatedEntityArguments == null ? 43 : ((Object)$relatedEntityArguments).hashCode());
        List $argNames = this.getArgNames();
        result = result * 59 + ($argNames == null ? 43 : ((Object)$argNames).hashCode());
        Output $output = this.getOutput();
        result = result * 59 + ($output == null ? 43 : $output.hashCode());
        String $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        ActorSystemContext $systemContext = this.getSystemContext();
        result = result * 59 + ($systemContext == null ? 43 : $systemContext.hashCode());
        TbelInvokeService $tbelInvokeService = this.getTbelInvokeService();
        result = result * 59 + ($tbelInvokeService == null ? 43 : $tbelInvokeService.hashCode());
        RelationService $relationService = this.getRelationService();
        result = result * 59 + ($relationService == null ? 43 : $relationService.hashCode());
        AlarmSubscriptionService $alarmService = this.getAlarmService();
        result = result * 59 + ($alarmService == null ? 43 : $alarmService.hashCode());
        CalculatedFieldProcessingService $cfProcessingService = this.getCfProcessingService();
        result = result * 59 + ($cfProcessingService == null ? 43 : $cfProcessingService.hashCode());
        Map $tbelExpressions = this.getTbelExpressions();
        result = result * 59 + ($tbelExpressions == null ? 43 : ((Object)$tbelExpressions).hashCode());
        Map $simpleExpressions = this.getSimpleExpressions();
        result = result * 59 + ($simpleExpressions == null ? 43 : ((Object)$simpleExpressions).hashCode());
        List $mainEntityGeofencingArgumentNames = this.getMainEntityGeofencingArgumentNames();
        result = result * 59 + ($mainEntityGeofencingArgumentNames == null ? 43 : ((Object)$mainEntityGeofencingArgumentNames).hashCode());
        List $linkedEntityAndCurrentOwnerGeofencingArgumentNames = this.getLinkedEntityAndCurrentOwnerGeofencingArgumentNames();
        result = result * 59 + ($linkedEntityAndCurrentOwnerGeofencingArgumentNames == null ? 43 : ((Object)$linkedEntityAndCurrentOwnerGeofencingArgumentNames).hashCode());
        List $relatedEntityArgumentNames = this.getRelatedEntityArgumentNames();
        result = result * 59 + ($relatedEntityArgumentNames == null ? 43 : ((Object)$relatedEntityArgumentNames).hashCode());
        Argument $propagationArgument = this.getPropagationArgument();
        result = result * 59 + ($propagationArgument == null ? 43 : $propagationArgument.hashCode());
        return result;
    }
}

