/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.EntityId;

public class TenantEntityProfileCache {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<EntityId, Set<EntityId>> allEntities = new HashMap();

    public void removeProfileId(EntityId profileId) {
        this.lock.writeLock().lock();
        try {
            this.allEntities.remove(profileId);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void removeEntityId(EntityId entityId) {
        this.lock.writeLock().lock();
        try {
            this.allEntities.values().forEach(set -> set.remove(entityId));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void remove(EntityId profileId, EntityId entityId) {
        this.lock.writeLock().lock();
        try {
            this.removeSafely(this.allEntities, profileId, entityId);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void add(EntityId profileId, EntityId entityId) {
        this.lock.writeLock().lock();
        try {
            if (EntityType.DEVICE.equals((Object)profileId.getEntityType()) || EntityType.ASSET.equals((Object)profileId.getEntityType())) {
                throw new RuntimeException("Entity type '" + String.valueOf(profileId.getEntityType()) + "' is not a profileId.");
            }
            this.allEntities.computeIfAbsent(profileId, k -> new HashSet()).add(entityId);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void update(EntityId oldProfileId, EntityId newProfileId, EntityId entityId) {
        this.remove(oldProfileId, entityId);
        this.add(newProfileId, entityId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<EntityId> getEntityIdsByProfileId(EntityId profileId) {
        this.lock.readLock().lock();
        try {
            Set entities = this.allEntities.getOrDefault(profileId, Collections.emptySet());
            ArrayList<EntityId> result = new ArrayList<EntityId>(entities.size());
            result.addAll(entities);
            ArrayList<EntityId> arrayList = result;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void removeSafely(Map<EntityId, Set<EntityId>> map, EntityId profileId, EntityId entityId) {
        Set<EntityId> set = map.get(profileId);
        if (set != null) {
            set.remove(entityId);
        }
    }
}

