/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf;

import com.google.common.util.concurrent.FutureCallback;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.rule.engine.api.AttributesDeleteRequest;
import org.thingsboard.rule.engine.api.AttributesSaveRequest;
import org.thingsboard.rule.engine.api.TimeseriesDeleteRequest;
import org.thingsboard.rule.engine.api.TimeseriesSaveRequest;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.cf.CalculatedField;
import org.thingsboard.server.common.data.cf.CalculatedFieldLink;
import org.thingsboard.server.common.data.cf.CalculatedFieldType;
import org.thingsboard.server.common.data.cf.configuration.CalculatedFieldConfiguration;
import org.thingsboard.server.common.data.cf.configuration.aggregation.RelatedEntitiesAggregationCalculatedFieldConfiguration;
import org.thingsboard.server.common.data.id.CalculatedFieldId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.AttributesSaveResult;
import org.thingsboard.server.common.data.kv.TimeseriesSaveResult;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.relation.EntityRelationPathQuery;
import org.thingsboard.server.common.data.relation.EntitySearchDirection;
import org.thingsboard.server.common.data.relation.RelationPathLevel;
import org.thingsboard.server.common.util.ProtoUtils;
import org.thingsboard.server.dao.relation.RelationService;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueCallback;
import org.thingsboard.server.service.cf.CalculatedFieldCache;
import org.thingsboard.server.service.cf.CalculatedFieldQueueService;
import org.thingsboard.server.service.cf.DefaultCalculatedFieldQueueService;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldCtx;
import org.thingsboard.server.utils.CalculatedFieldUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DefaultCalculatedFieldQueueService
implements CalculatedFieldQueueService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultCalculatedFieldQueueService.class);
    public static final TbQueueCallback DUMMY_TB_QUEUE_CALLBACK = new /* Unavailable Anonymous Inner Class!! */;
    private final CalculatedFieldCache calculatedFieldCache;
    private final TbClusterService clusterService;
    private final RelationService relationService;

    public void pushRequestToQueue(TimeseriesSaveRequest request, TimeseriesSaveResult result, FutureCallback<Void> callback) {
        TenantId tenantId = request.getTenantId();
        EntityId entityId = request.getEntityId();
        List entries = request.getEntries();
        this.checkEntityAndPushToQueue(tenantId, entityId, cf -> cf.matches(entries), cf -> cf.linkMatches(entityId, entries), cf -> cf.dynamicSourceMatches(request.getEntries()), cf -> cf.relatedEntityMatches(entries), () -> this.toCalculatedFieldTelemetryMsgProto(request, result), callback);
    }

    public void pushRequestToQueue(TimeseriesSaveRequest request, FutureCallback<Void> callback) {
        this.pushRequestToQueue(request, null, callback);
    }

    public void pushRequestToQueue(AttributesSaveRequest request, AttributesSaveResult result, FutureCallback<Void> callback) {
        TenantId tenantId = request.getTenantId();
        EntityId entityId = request.getEntityId();
        List entries = request.getEntries();
        AttributeScope scope = request.getScope();
        this.checkEntityAndPushToQueue(tenantId, entityId, cf -> cf.matches(entries, scope), cf -> cf.linkMatches(entityId, entries, scope), cf -> cf.dynamicSourceMatches(request.getEntries(), request.getScope()), cf -> cf.relatedEntityMatches(entries, scope), () -> this.toCalculatedFieldTelemetryMsgProto(request, result), callback);
    }

    public void pushRequestToQueue(AttributesSaveRequest request, FutureCallback<Void> callback) {
        this.pushRequestToQueue(request, null, callback);
    }

    public void pushRequestToQueue(AttributesDeleteRequest request, List<String> result, FutureCallback<Void> callback) {
        TenantId tenantId = request.getTenantId();
        EntityId entityId = request.getEntityId();
        AttributeScope scope = request.getScope();
        this.checkEntityAndPushToQueue(tenantId, entityId, cf -> cf.matchesKeys(result, scope), cf -> cf.linkMatchesAttrKeys(entityId, result, scope), cf -> cf.matchesDynamicSourceKeys(result, request.getScope()), cf -> cf.matchesRelatedEntityKeys(result, scope), () -> this.toCalculatedFieldTelemetryMsgProto(request, result), callback);
    }

    public void pushRequestToQueue(TimeseriesDeleteRequest request, List<String> result, FutureCallback<Void> callback) {
        TenantId tenantId = request.getTenantId();
        EntityId entityId = request.getEntityId();
        this.checkEntityAndPushToQueue(tenantId, entityId, cf -> cf.matchesKeys(result), cf -> cf.linkMatchesTsKeys(entityId, result), cf -> cf.matchesDynamicSourceKeys(result), cf -> cf.matchesRelatedEntityKeys(result), () -> this.toCalculatedFieldTelemetryMsgProto(request, result), callback);
    }

    private void checkEntityAndPushToQueue(TenantId tenantId, EntityId entityId, Predicate<CalculatedFieldCtx> mainEntityFilter, Predicate<CalculatedFieldCtx> linkedEntityFilter, Predicate<CalculatedFieldCtx> dynamicSourceFilter, Predicate<CalculatedFieldCtx> relatedEntityFilter, Supplier<TransportProtos.ToCalculatedFieldMsg> msg, FutureCallback<Void> callback) {
        boolean send;
        if (EntityType.TENANT.equals((Object)entityId.getEntityType())) {
            tenantId = (TenantId)entityId;
        }
        if (send = this.checkEntityForCalculatedFields(tenantId, entityId, mainEntityFilter, linkedEntityFilter, dynamicSourceFilter, relatedEntityFilter)) {
            TransportProtos.ToCalculatedFieldMsg calculatedFieldMsg = msg.get();
            this.clusterService.pushMsgToCalculatedFields(tenantId, entityId, calculatedFieldMsg, DefaultCalculatedFieldQueueService.wrap(callback));
        } else if (callback != null) {
            callback.onSuccess(null);
        }
    }

    private boolean checkEntityForCalculatedFields(TenantId tenantId, EntityId entityId, Predicate<CalculatedFieldCtx> filter, Predicate<CalculatedFieldCtx> linkedEntityFilter, Predicate<CalculatedFieldCtx> dynamicSourceFilter, Predicate<CalculatedFieldCtx> relatedEntityFilter) {
        if (!CalculatedField.isSupportedRefEntity((EntityId)entityId)) {
            return false;
        }
        if (this.calculatedFieldCache.hasCalculatedFields(tenantId, entityId, filter)) {
            return true;
        }
        List links = this.calculatedFieldCache.getCalculatedFieldLinksByEntityId(entityId);
        for (CalculatedFieldLink link : links) {
            CalculatedFieldCtx ctx = this.calculatedFieldCache.getCalculatedFieldCtx(link.calculatedFieldId());
            if (ctx == null || !linkedEntityFilter.test(ctx)) continue;
            return true;
        }
        for (EntityId dynamicEntity : this.calculatedFieldCache.getDynamicEntities(tenantId, entityId)) {
            if (this.calculatedFieldCache.getCalculatedFieldCtxsByEntityId(dynamicEntity).stream().anyMatch(dynamicSourceFilter)) {
                return true;
            }
            EntityId dynamicEntityProfileId = this.calculatedFieldCache.getProfileId(tenantId, dynamicEntity);
            if (!this.calculatedFieldCache.getCalculatedFieldCtxsByEntityId(dynamicEntityProfileId).stream().anyMatch(dynamicSourceFilter)) continue;
            return true;
        }
        boolean hasMatchesEntityAggCfs = this.calculatedFieldCache.getCalculatedFieldCtxsByType(CalculatedFieldType.ENTITY_AGGREGATION).anyMatch(filter);
        if (hasMatchesEntityAggCfs) {
            return true;
        }
        List<CalculatedFieldCtx> relatedEntitiesAggregationCfs = this.calculatedFieldCache.getCalculatedFieldCtxsByType(CalculatedFieldType.RELATED_ENTITIES_AGGREGATION).filter(relatedEntityFilter).toList();
        for (CalculatedFieldCtx cfCtx : relatedEntitiesAggregationCfs) {
            EntitySearchDirection inverseDirection;
            RelationPathLevel inverseRelation;
            List byRelationPathQuery;
            CalculatedFieldConfiguration calculatedFieldConfiguration = cfCtx.getCalculatedField().getConfiguration();
            if (!(calculatedFieldConfiguration instanceof RelatedEntitiesAggregationCalculatedFieldConfiguration)) continue;
            RelatedEntitiesAggregationCalculatedFieldConfiguration aggConfig = (RelatedEntitiesAggregationCalculatedFieldConfiguration)calculatedFieldConfiguration;
            RelationPathLevel relation = aggConfig.getRelation();
            if ((byRelationPathQuery = this.relationService.findByRelationPathQuery(tenantId, new EntityRelationPathQuery(entityId, List.of(inverseRelation = new RelationPathLevel(inverseDirection = (switch (2.$SwitchMap$org$thingsboard$server$common$data$relation$EntitySearchDirection[relation.direction().ordinal()]) {
                default -> throw new IncompatibleClassChangeError();
                case 1 -> EntitySearchDirection.TO;
                case 2 -> EntitySearchDirection.FROM;
            }), relation.relationType()))))).isEmpty()) continue;
            EntityId cfEntityId = cfCtx.getEntityId();
            for (EntityRelation entityRelation : byRelationPathQuery) {
                EntityId relatedId;
                EntityId entityId2 = relatedId = inverseDirection == EntitySearchDirection.FROM ? entityRelation.getTo() : entityRelation.getFrom();
                if (!cfEntityId.equals(relatedId) && !cfEntityId.equals(this.calculatedFieldCache.getProfileId(tenantId, relatedId))) continue;
                return true;
            }
        }
        return false;
    }

    private TransportProtos.ToCalculatedFieldMsg toCalculatedFieldTelemetryMsgProto(TimeseriesSaveRequest request, TimeseriesSaveResult result) {
        TransportProtos.CalculatedFieldTelemetryMsgProto.Builder telemetryMsg = this.buildTelemetryMsgProto(request.getTenantId(), request.getEntityId(), request.getPreviousCalculatedFieldIds(), request.getTbMsgId(), request.getTbMsgType());
        List entries = request.getEntries();
        List versions = result != null ? result.getVersions() : Collections.emptyList();
        for (int i = 0; i < entries.size(); ++i) {
            TransportProtos.TsKvProto.Builder tsProtoBuilder = ProtoUtils.toTsKvProto((TsKvEntry)((TsKvEntry)entries.get(i))).toBuilder();
            if (versions != null && !versions.isEmpty() && versions.get(i) != null) {
                tsProtoBuilder.setVersion(((Long)versions.get(i)).longValue());
            }
            telemetryMsg.addTsData(tsProtoBuilder.build());
        }
        return TransportProtos.ToCalculatedFieldMsg.newBuilder().setTelemetryMsg(telemetryMsg).build();
    }

    private TransportProtos.ToCalculatedFieldMsg toCalculatedFieldTelemetryMsgProto(AttributesSaveRequest request, AttributesSaveResult result) {
        TransportProtos.ToCalculatedFieldMsg.Builder msg = TransportProtos.ToCalculatedFieldMsg.newBuilder();
        TransportProtos.CalculatedFieldTelemetryMsgProto.Builder telemetryMsg = this.buildTelemetryMsgProto(request.getTenantId(), request.getEntityId(), request.getPreviousCalculatedFieldIds(), request.getTbMsgId(), request.getTbMsgType());
        telemetryMsg.setScope(TransportProtos.AttributeScopeProto.valueOf((String)request.getScope().name()));
        List entries = request.getEntries();
        List versions = result.versions();
        for (int i = 0; i < entries.size(); ++i) {
            TransportProtos.AttributeValueProto.Builder attrProtoBuilder = ProtoUtils.toProto((AttributeKvEntry)((AttributeKvEntry)entries.get(i))).toBuilder();
            if (versions != null && !versions.isEmpty() && versions.get(i) != null) {
                attrProtoBuilder.setVersion(((Long)versions.get(i)).longValue());
            }
            telemetryMsg.addAttrData(attrProtoBuilder.build());
        }
        msg.setTelemetryMsg(telemetryMsg.build());
        return msg.build();
    }

    private TransportProtos.ToCalculatedFieldMsg toCalculatedFieldTelemetryMsgProto(AttributesDeleteRequest request, List<String> removedKeys) {
        TransportProtos.CalculatedFieldTelemetryMsgProto telemetryMsg = this.buildTelemetryMsgProto(request.getTenantId(), request.getEntityId(), request.getPreviousCalculatedFieldIds(), request.getTbMsgId(), request.getTbMsgType()).setScope(TransportProtos.AttributeScopeProto.valueOf((String)request.getScope().name())).addAllRemovedAttrKeys(removedKeys).build();
        return TransportProtos.ToCalculatedFieldMsg.newBuilder().setTelemetryMsg(telemetryMsg).build();
    }

    private TransportProtos.ToCalculatedFieldMsg toCalculatedFieldTelemetryMsgProto(TimeseriesDeleteRequest request, List<String> removedKeys) {
        TransportProtos.CalculatedFieldTelemetryMsgProto telemetryMsg = this.buildTelemetryMsgProto(request.getTenantId(), request.getEntityId(), request.getPreviousCalculatedFieldIds(), request.getTbMsgId(), request.getTbMsgType()).addAllRemovedTsKeys(removedKeys).build();
        return TransportProtos.ToCalculatedFieldMsg.newBuilder().setTelemetryMsg(telemetryMsg).build();
    }

    private TransportProtos.CalculatedFieldTelemetryMsgProto.Builder buildTelemetryMsgProto(TenantId tenantId, EntityId entityId, List<CalculatedFieldId> calculatedFieldIds, UUID tbMsgId, TbMsgType tbMsgType) {
        TransportProtos.CalculatedFieldTelemetryMsgProto.Builder telemetryMsg = TransportProtos.CalculatedFieldTelemetryMsgProto.newBuilder();
        if (EntityType.TENANT.equals((Object)entityId.getEntityType())) {
            tenantId = (TenantId)entityId;
        }
        telemetryMsg.setTenantIdMSB(tenantId.getId().getMostSignificantBits());
        telemetryMsg.setTenantIdLSB(tenantId.getId().getLeastSignificantBits());
        telemetryMsg.setEntityType(entityId.getEntityType().name());
        telemetryMsg.setEntityIdMSB(entityId.getId().getMostSignificantBits());
        telemetryMsg.setEntityIdLSB(entityId.getId().getLeastSignificantBits());
        if (calculatedFieldIds != null) {
            for (CalculatedFieldId cfId : calculatedFieldIds) {
                telemetryMsg.addPreviousCalculatedFields(CalculatedFieldUtils.toProto((CalculatedFieldId)cfId));
            }
        }
        if (tbMsgId != null) {
            telemetryMsg.setTbMsgIdMSB(tbMsgId.getMostSignificantBits());
            telemetryMsg.setTbMsgIdLSB(tbMsgId.getLeastSignificantBits());
        }
        if (tbMsgType != null) {
            telemetryMsg.setTbMsgType(tbMsgType.name());
        }
        return telemetryMsg;
    }

    private static TbQueueCallback wrap(FutureCallback<Void> callback) {
        if (callback != null) {
            return new FutureCallbackWrapper(callback);
        }
        return DUMMY_TB_QUEUE_CALLBACK;
    }

    @ConstructorProperties(value={"calculatedFieldCache", "clusterService", "relationService"})
    @Generated
    public DefaultCalculatedFieldQueueService(CalculatedFieldCache calculatedFieldCache, TbClusterService clusterService, RelationService relationService) {
        this.calculatedFieldCache = calculatedFieldCache;
        this.clusterService = clusterService;
        this.relationService = relationService;
    }
}

