/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.JsonElement;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.function.TriConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.rule.engine.api.AttributesSaveRequest;
import org.thingsboard.rule.engine.api.TimeseriesSaveRequest;
import org.thingsboard.server.actors.calculatedField.MultipleTbCallback;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.adaptor.JsonConverter;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.cf.CalculatedField;
import org.thingsboard.server.common.data.cf.CalculatedFieldType;
import org.thingsboard.server.common.data.cf.configuration.Argument;
import org.thingsboard.server.common.data.cf.configuration.ArgumentType;
import org.thingsboard.server.common.data.cf.configuration.AttributesImmediateOutputStrategy;
import org.thingsboard.server.common.data.cf.configuration.CalculatedFieldConfiguration;
import org.thingsboard.server.common.data.cf.configuration.CfArgumentDynamicSourceConfiguration;
import org.thingsboard.server.common.data.cf.configuration.OutputStrategy;
import org.thingsboard.server.common.data.cf.configuration.OutputType;
import org.thingsboard.server.common.data.cf.configuration.RelationPathQueryDynamicSourceConfiguration;
import org.thingsboard.server.common.data.cf.configuration.TimeSeriesImmediateOutputStrategy;
import org.thingsboard.server.common.data.cf.configuration.aggregation.AggFunction;
import org.thingsboard.server.common.data.cf.configuration.aggregation.AggMetric;
import org.thingsboard.server.common.data.cf.configuration.aggregation.RelatedEntitiesAggregationCalculatedFieldConfiguration;
import org.thingsboard.server.common.data.cf.configuration.aggregation.single.EntityAggregationCalculatedFieldConfiguration;
import org.thingsboard.server.common.data.cf.configuration.aggregation.single.interval.AggInterval;
import org.thingsboard.server.common.data.id.CalculatedFieldId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.Aggregation;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.BaseReadTsKvQuery;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.ReadTsKvQuery;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.relation.EntityRelationPathQuery;
import org.thingsboard.server.common.data.relation.RelationPathLevel;
import org.thingsboard.server.common.data.tenant.profile.DefaultTenantProfileConfiguration;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.common.msg.queue.TbCallback;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.relation.RelationService;
import org.thingsboard.server.dao.timeseries.TimeseriesService;
import org.thingsboard.server.dao.usagerecord.ApiLimitService;
import org.thingsboard.server.dao.util.KvUtils;
import org.thingsboard.server.queue.TbQueueCallback;
import org.thingsboard.server.service.cf.AbstractCalculatedFieldProcessingService;
import org.thingsboard.server.service.cf.PropagationCalculatedFieldResult;
import org.thingsboard.server.service.cf.TelemetryCalculatedFieldResult;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldCtx;
import org.thingsboard.server.service.cf.ctx.state.aggregation.single.AggIntervalEntry;
import org.thingsboard.server.service.security.permission.OwnersCacheService;
import org.thingsboard.server.service.telemetry.TelemetrySubscriptionService;
import org.thingsboard.server.utils.CalculatedFieldArgumentUtils;

public abstract class AbstractCalculatedFieldProcessingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractCalculatedFieldProcessingService.class);
    protected final AttributesService attributesService;
    protected final TimeseriesService timeseriesService;
    protected final TelemetrySubscriptionService tsSubService;
    protected final ApiLimitService apiLimitService;
    protected final RelationService relationService;
    protected final OwnersCacheService ownersCacheService;
    protected final TbClusterService clusterService;
    protected ListeningExecutorService calculatedFieldCallbackExecutor;

    @PostConstruct
    public void init() {
        this.calculatedFieldCallbackExecutor = MoreExecutors.listeningDecorator((ExecutorService)ThingsBoardExecutors.newWorkStealingPool((int)Math.max(4, Runtime.getRuntime().availableProcessors()), (String)this.getExecutorNamePrefix()));
    }

    @PreDestroy
    public void stop() {
        if (this.calculatedFieldCallbackExecutor != null) {
            this.calculatedFieldCallbackExecutor.shutdownNow();
        }
    }

    protected abstract String getExecutorNamePrefix();

    protected ListenableFuture<Map<String, ArgumentEntry>> fetchArguments(CalculatedFieldCtx ctx, EntityId entityId, long ts) {
        Map argFutures;
        switch (4.$SwitchMap$org$thingsboard$server$common$data$cf$CalculatedFieldType[ctx.getCfType().ordinal()]) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 1: {
                Map map = this.fetchGeofencingCalculatedFieldArguments(ctx, entityId, false, ts);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                Map map = this.getBaseCalculatedFieldArguments(ctx, entityId, ts);
                break;
            }
            case 6: {
                Map map = this.fetchRelatedEntitiesAggArguments(ctx, entityId, ts);
                break;
            }
            case 7: {
                Map map = argFutures = this.fetchEntityAggArguments(ctx, entityId, ts);
            }
        }
        if (ctx.getCfType() == CalculatedFieldType.PROPAGATION) {
            argFutures.put("propagationCtx", this.fetchPropagationCalculatedFieldArgument(ctx, entityId));
        }
        return Futures.whenAllComplete(argFutures.values()).call(() -> this.resolveArgumentFutures(argFutures), MoreExecutors.directExecutor());
    }

    private Map<String, ListenableFuture<ArgumentEntry>> getBaseCalculatedFieldArguments(CalculatedFieldCtx ctx, EntityId entityId, long ts) {
        HashMap<String, ListenableFuture<ArgumentEntry>> futures = new HashMap<String, ListenableFuture<ArgumentEntry>>();
        for (Map.Entry entry : ctx.getArguments().entrySet()) {
            EntityId argEntityId = this.resolveEntityId(ctx.getTenantId(), entityId, (Argument)entry.getValue());
            ListenableFuture argValueFuture = this.fetchArgumentValue(ctx.getTenantId(), argEntityId, (Argument)entry.getValue(), ts);
            futures.put((String)entry.getKey(), (ListenableFuture<ArgumentEntry>)argValueFuture);
        }
        return futures;
    }

    protected EntityId resolveEntityId(TenantId tenantId, EntityId entityId, Argument argument) {
        if (argument.getRefEntityId() != null) {
            return argument.getRefEntityId();
        }
        if (!argument.hasOwnerSource()) {
            return entityId;
        }
        return this.resolveOwnerArgument(tenantId, entityId);
    }

    protected Map<String, ArgumentEntry> resolveArgumentFutures(Map<String, ListenableFuture<ArgumentEntry>> argFutures) {
        return argFutures.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.resolveArgumentValue((String)entry.getKey(), (ListenableFuture)entry.getValue())));
    }

    protected ArgumentEntry resolveArgumentValue(String key, ListenableFuture<ArgumentEntry> future) {
        try {
            return (ArgumentEntry)future.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            throw new RuntimeException("Failed to fetch '" + key + "' argument: " + cause.getMessage(), cause);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to fetch '" + key + "' argument!", e);
        }
    }

    protected ListenableFuture<ArgumentEntry> fetchPropagationCalculatedFieldArgument(CalculatedFieldCtx ctx, EntityId entityId) {
        ListenableFuture propagationEntityIds = this.fromDynamicSource(ctx.getTenantId(), entityId, ctx.getPropagationArgument());
        return Futures.transform((ListenableFuture)propagationEntityIds, ArgumentEntry::createPropagationArgument, (Executor)MoreExecutors.directExecutor());
    }

    protected Map<String, ListenableFuture<ArgumentEntry>> fetchGeofencingCalculatedFieldArguments(CalculatedFieldCtx ctx, EntityId entityId, boolean dynamicArgumentsOnly, long startTs) {
        HashMap<String, ListenableFuture<ArgumentEntry>> argFutures = new HashMap<String, ListenableFuture<ArgumentEntry>>();
        Set entries = ctx.getArguments().entrySet();
        if (dynamicArgumentsOnly) {
            entries = entries.stream().filter(entry -> ((Argument)entry.getValue()).hasRelationQuerySource()).collect(Collectors.toSet());
        }
        block7: for (Map.Entry entry2 : entries) {
            switch ((String)entry2.getKey()) {
                case "latitude": 
                case "longitude": {
                    argFutures.put((String)entry2.getKey(), (ListenableFuture<ArgumentEntry>)this.fetchArgumentValue(ctx.getTenantId(), entityId, (Argument)entry2.getValue(), startTs));
                    continue block7;
                }
            }
            ListenableFuture resolvedEntityIdsFuture = this.resolveGeofencingEntityIds(ctx.getTenantId(), entityId, entry2);
            argFutures.put((String)entry2.getKey(), (ListenableFuture<ArgumentEntry>)Futures.transformAsync((ListenableFuture)resolvedEntityIdsFuture, resolvedEntityIds -> this.fetchGeofencingArgumentValue(ctx.getTenantId(), resolvedEntityIds, (Argument)entry2.getValue(), startTs), (Executor)MoreExecutors.directExecutor()));
        }
        return argFutures;
    }

    private Map<String, ListenableFuture<ArgumentEntry>> fetchRelatedEntitiesAggArguments(CalculatedFieldCtx ctx, EntityId entityId, long ts) {
        CalculatedFieldConfiguration calculatedFieldConfiguration = ctx.getCalculatedField().getConfiguration();
        if (!(calculatedFieldConfiguration instanceof RelatedEntitiesAggregationCalculatedFieldConfiguration)) {
            return Collections.emptyMap();
        }
        RelatedEntitiesAggregationCalculatedFieldConfiguration config = (RelatedEntitiesAggregationCalculatedFieldConfiguration)calculatedFieldConfiguration;
        ListenableFuture relatedEntitiesFut = this.resolveRelatedEntities(ctx.getTenantId(), entityId, config.getRelation());
        return config.getArguments().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Futures.transformAsync((ListenableFuture)relatedEntitiesFut, relatedEntities -> this.fetchRelatedEntitiesArgumentEntry(ctx.getTenantId(), relatedEntities, (Argument)entry.getValue(), ts), (Executor)MoreExecutors.directExecutor())));
    }

    private Map<String, ListenableFuture<ArgumentEntry>> fetchEntityAggArguments(CalculatedFieldCtx ctx, EntityId entityId, long ts) {
        CalculatedFieldConfiguration calculatedFieldConfiguration = ctx.getCalculatedField().getConfiguration();
        if (!(calculatedFieldConfiguration instanceof EntityAggregationCalculatedFieldConfiguration)) {
            return Collections.emptyMap();
        }
        EntityAggregationCalculatedFieldConfiguration config = (EntityAggregationCalculatedFieldConfiguration)calculatedFieldConfiguration;
        return config.getArguments().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.fetchTimeSeries(ctx.getTenantId(), entityId, (Argument)entry.getValue(), config.getInterval(), ts)));
    }

    protected ListenableFuture<List<EntityId>> resolveRelatedEntities(TenantId tenantId, EntityId entityId, RelationPathLevel relation) {
        Predicate<EntityRelation> filter = entityRelation -> CalculatedField.isSupportedRefEntity((EntityId)entityRelation.getFrom()) && CalculatedField.isSupportedRefEntity((EntityId)entityRelation.getTo());
        ListenableFuture relationsFut = this.relationService.findFilteredRelationsByPathQueryAsync(tenantId, new EntityRelationPathQuery(entityId, List.of(relation)), filter);
        return Futures.transform((ListenableFuture)relationsFut, relations -> {
            if (relations == null) {
                return Collections.emptyList();
            }
            return switch (4.$SwitchMap$org$thingsboard$server$common$data$relation$EntitySearchDirection[relation.direction().ordinal()]) {
                default -> throw new IncompatibleClassChangeError();
                case 1 -> relations.stream().map(EntityRelation::getTo).toList();
                case 2 -> relations.stream().map(EntityRelation::getFrom).toList();
            };
        }, (Executor)this.calculatedFieldCallbackExecutor);
    }

    private ListenableFuture<List<EntityId>> resolveGeofencingEntityIds(TenantId tenantId, EntityId entityId, Map.Entry<String, Argument> entry) {
        Argument value = entry.getValue();
        if (value.getRefEntityId() != null) {
            return Futures.immediateFuture(List.of(value.getRefEntityId()));
        }
        if (!value.hasDynamicSource()) {
            return Futures.immediateFuture(List.of(entityId));
        }
        return this.fromDynamicSource(tenantId, entityId, value);
    }

    private ListenableFuture<List<EntityId>> fromDynamicSource(TenantId tenantId, EntityId entityId, Argument value) {
        CfArgumentDynamicSourceConfiguration refDynamicSourceConfiguration = value.getRefDynamicSourceConfiguration();
        return switch (4.$SwitchMap$org$thingsboard$server$common$data$cf$configuration$CFArgumentDynamicSourceType[refDynamicSourceConfiguration.getType().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> Futures.immediateFuture(List.of(this.resolveOwnerArgument(tenantId, entityId)));
            case 2 -> {
                RelationPathQueryDynamicSourceConfiguration configuration = (RelationPathQueryDynamicSourceConfiguration)refDynamicSourceConfiguration;
                Predicate<EntityRelation> filter = entityRelation -> CalculatedField.isSupportedRefEntity((EntityId)entityRelation.getFrom()) && CalculatedField.isSupportedRefEntity((EntityId)entityRelation.getTo());
                yield Futures.transform((ListenableFuture)this.relationService.findFilteredRelationsByPathQueryAsync(tenantId, configuration.toRelationPathQuery(entityId), filter), arg_0 -> ((RelationPathQueryDynamicSourceConfiguration)configuration).resolveEntityIds(arg_0), (Executor)this.calculatedFieldCallbackExecutor);
            }
        };
    }

    private EntityId resolveOwnerArgument(TenantId tenantId, EntityId entityId) {
        return this.ownersCacheService.getOwner(tenantId, entityId);
    }

    private ListenableFuture<ArgumentEntry> fetchGeofencingArgumentValue(TenantId tenantId, List<EntityId> geofencingEntities, Argument argument, long startTs) {
        if (argument.getRefEntityKey().getType() != ArgumentType.ATTRIBUTE) {
            throw new IllegalStateException("Unsupported argument key type: " + String.valueOf(argument.getRefEntityKey().getType()));
        }
        ListenableFuture geofencingEntityIdToKvEntryMapFutures = Futures.allAsList((Iterable)this.fetchGeofencingEntityIdToKvEntriesFutures(tenantId, geofencingEntities, argument, startTs));
        return Futures.transform((ListenableFuture)geofencingEntityIdToKvEntryMapFutures, entries -> ArgumentEntry.createGeofencingValueArgument(entries.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))), (Executor)MoreExecutors.directExecutor());
    }

    protected List<ListenableFuture<Map.Entry<EntityId, AttributeKvEntry>>> fetchGeofencingEntityIdToKvEntriesFutures(TenantId tenantId, List<EntityId> geofencingEntities, Argument argument, long startTs) {
        return geofencingEntities.stream().map(entityId -> {
            AttributeScope scope = argument.getRefEntityKey().getScope();
            String key = argument.getRefEntityKey().getKey();
            ListenableFuture attributesFuture = this.attributesService.find(tenantId, entityId, scope, key);
            return Futures.transform((ListenableFuture)attributesFuture, resultOpt -> Map.entry(entityId, resultOpt.orElseGet(() -> CalculatedFieldArgumentUtils.createDefaultAttributeEntry((Argument)argument, (long)startTs))), (Executor)this.calculatedFieldCallbackExecutor);
        }).collect(Collectors.toList());
    }

    private ListenableFuture<ArgumentEntry> fetchRelatedEntitiesArgumentEntry(TenantId tenantId, List<EntityId> aggEntities, Argument argument, long startTs) {
        List<ListenableFuture> futures = aggEntities.stream().map(entityId -> {
            ListenableFuture argumentEntryFut = this.fetchArgumentValue(tenantId, entityId, argument, startTs);
            return Futures.transform((ListenableFuture)argumentEntryFut, argumentEntry -> Map.entry(entityId, ArgumentEntry.createSingleValueArgument((EntityId)entityId, (ArgumentEntry)argumentEntry)), (Executor)MoreExecutors.directExecutor());
        }).toList();
        ListenableFuture allFutures = Futures.allAsList(futures);
        return Futures.transform((ListenableFuture)allFutures, entries -> ArgumentEntry.createAggArgument(entries.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))), (Executor)MoreExecutors.directExecutor());
    }

    protected ListenableFuture<ArgumentEntry> fetchArgumentValue(TenantId tenantId, EntityId entityId, Argument argument, long startTs) {
        return switch (4.$SwitchMap$org$thingsboard$server$common$data$cf$configuration$ArgumentType[argument.getRefEntityKey().getType().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> this.fetchTsRolling(tenantId, entityId, argument, startTs);
            case 2 -> this.fetchAttribute(tenantId, entityId, argument, startTs);
            case 3 -> this.fetchTsLatest(tenantId, entityId, argument, startTs);
        };
    }

    protected ArgumentEntry fetchMetricDuringInterval(TenantId tenantId, EntityId entityId, String argKey, AggMetric metric, AggIntervalEntry interval) {
        AggFunction function = metric.getFunction();
        long intervalMs = interval.getEndTs() - interval.getStartTs();
        BaseReadTsKvQuery query = new BaseReadTsKvQuery(argKey, interval.getStartTs().longValue(), interval.getEndTs().longValue(), intervalMs, 1, Aggregation.valueOf((String)function.name()));
        ListenableFuture argumentEntryFut = this.fetchTimeSeriesInternal(tenantId, entityId, (ReadTsKvQuery)query, timeSeries -> CalculatedFieldArgumentUtils.transformAggMetricArgument((List)timeSeries, (String)argKey, (AggMetric)metric));
        return this.resolveArgumentValue(argKey, argumentEntryFut);
    }

    private ListenableFuture<ArgumentEntry> fetchTimeSeries(TenantId tenantId, EntityId entityId, Argument argument, AggInterval interval, long queryEndTs) {
        long intervalStartTs = interval.getCurrentIntervalStartTs();
        long intervalEndTs = interval.getCurrentIntervalEndTs();
        BaseReadTsKvQuery query = new BaseReadTsKvQuery(argument.getRefEntityKey().getKey(), intervalStartTs, queryEndTs, 0L, 1, Aggregation.NONE);
        return this.fetchTimeSeriesInternal(tenantId, entityId, (ReadTsKvQuery)query, timeSeries -> CalculatedFieldArgumentUtils.transformAggregationArgument((List)timeSeries, (long)intervalStartTs, (long)intervalEndTs));
    }

    private ListenableFuture<ArgumentEntry> fetchTsRolling(TenantId tenantId, EntityId entityId, Argument argument, long queryEndTs) {
        long argTimeWindow = argument.getTimeWindow() == 0L ? queryEndTs : argument.getTimeWindow();
        long startInterval = queryEndTs - argTimeWindow;
        ReadTsKvQuery query = this.buildTsRollingQuery(tenantId, argument, startInterval, queryEndTs);
        return this.fetchTimeSeriesInternal(tenantId, entityId, query, tsRolling -> CalculatedFieldArgumentUtils.transformTsRollingArgument((List)tsRolling, (int)query.getLimit(), (long)argTimeWindow));
    }

    protected ListenableFuture<ArgumentEntry> fetchAttribute(TenantId tenantId, EntityId entityId, Argument argument, long defaultLastUpdateTs) {
        log.trace("[{}][{}] Fetching attribute for key {}", new Object[]{tenantId, entityId, argument.getRefEntityKey()});
        ListenableFuture attributeOptFuture = this.attributesService.find(tenantId, entityId, argument.getRefEntityKey().getScope(), argument.getRefEntityKey().getKey());
        return Futures.transform((ListenableFuture)attributeOptFuture, attrOpt -> {
            log.debug("[{}][{}] Fetched attribute for key {}: {}", new Object[]{tenantId, entityId, argument.getRefEntityKey(), attrOpt});
            return CalculatedFieldArgumentUtils.transformSingleValueArgument((KvEntry)((KvEntry)attrOpt.orElseGet(() -> CalculatedFieldArgumentUtils.createDefaultAttributeEntry((Argument)argument, (long)defaultLastUpdateTs))));
        }, (Executor)this.calculatedFieldCallbackExecutor);
    }

    protected ListenableFuture<ArgumentEntry> fetchTsLatest(TenantId tenantId, EntityId entityId, Argument argument, long defaultTs) {
        String timeseriesKey = argument.getRefEntityKey().getKey();
        log.trace("[{}][{}] Fetching latest timeseries {}", new Object[]{tenantId, entityId, timeseriesKey});
        return Futures.transform((ListenableFuture)this.timeseriesService.findLatest(tenantId, entityId, timeseriesKey), result -> {
            log.debug("[{}][{}] Fetched latest timeseries {}: {}", new Object[]{tenantId, entityId, timeseriesKey, result});
            return CalculatedFieldArgumentUtils.transformSingleValueArgument((KvEntry)((KvEntry)result.orElseGet(() -> CalculatedFieldArgumentUtils.createDefaultTsKvEntry((Argument)argument, (long)defaultTs))));
        }, (Executor)this.calculatedFieldCallbackExecutor);
    }

    private ListenableFuture<ArgumentEntry> fetchTimeSeriesInternal(TenantId tenantId, EntityId entityId, ReadTsKvQuery query, Function<List<TsKvEntry>, ArgumentEntry> transformArgument) {
        log.trace("[{}][{}] Fetching timeseries for query {}", new Object[]{tenantId, entityId, query});
        ListenableFuture tsRollingFuture = this.timeseriesService.findAll(tenantId, entityId, List.of(query));
        return Futures.transform((ListenableFuture)tsRollingFuture, tsRolling -> {
            log.debug("[{}][{}] Fetched {} timeseries for query {}", new Object[]{tenantId, entityId, tsRolling == null ? 0 : tsRolling.size(), query});
            return (ArgumentEntry)transformArgument.apply((List<TsKvEntry>)tsRolling);
        }, (Executor)this.calculatedFieldCallbackExecutor);
    }

    private ReadTsKvQuery buildTsRollingQuery(TenantId tenantId, Argument argument, long startTs, long endTs) {
        long maxDataPoints = this.apiLimitService.getLimit(tenantId, DefaultTenantProfileConfiguration::getMaxDataPointsPerRollingArg);
        int argumentLimit = argument.getLimit();
        int limit = argumentLimit == 0 || (long)argumentLimit > maxDataPoints ? (int)maxDataPoints : argumentLimit;
        return new BaseReadTsKvQuery(argument.getRefEntityKey().getKey(), startTs, endTs, 0L, limit, Aggregation.NONE);
    }

    protected void handlePropagationResults(PropagationCalculatedFieldResult propagationResult, TbCallback callback, TriConsumer<EntityId, TelemetryCalculatedFieldResult, TbCallback> telemetryResultHandler) {
        List propagationEntityIds = propagationResult.getEntityIds();
        if (propagationEntityIds.isEmpty()) {
            callback.onSuccess();
            return;
        }
        if (propagationEntityIds.size() == 1) {
            EntityId propagationEntityId = (EntityId)propagationEntityIds.get(0);
            telemetryResultHandler.accept((Object)propagationEntityId, (Object)propagationResult.getResult(), (Object)callback);
            return;
        }
        MultipleTbCallback multipleTbCallback = new MultipleTbCallback(propagationEntityIds.size(), callback);
        for (EntityId propagationEntityId : propagationEntityIds) {
            telemetryResultHandler.accept((Object)propagationEntityId, (Object)propagationResult.getResult(), (Object)multipleTbCallback);
        }
    }

    protected void sendMsgToRuleEngine(TenantId tenantId, EntityId entityId, TbCallback callback, TbMsg msg) {
        try {
            this.clusterService.pushMsgToRuleEngine(tenantId, entityId, msg, (TbQueueCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            log.warn("[{}][{}] Failed to push message to rule engine: {}", new Object[]{tenantId, entityId, msg, e});
            callback.onFailure((Throwable)e);
        }
    }

    protected void saveTelemetryResult(TenantId tenantId, EntityId entityId, String cfName, TelemetryCalculatedFieldResult cfResult, List<CalculatedFieldId> cfIds, TbCallback callback) {
        OutputType type = cfResult.getType();
        JsonElement jsonResult = cfResult.toJsonElement();
        log.trace("[{}][{}] Saving CF result: {}", new Object[]{tenantId, entityId, jsonResult});
        switch (4.$SwitchMap$org$thingsboard$server$common$data$cf$configuration$OutputType[type.ordinal()]) {
            case 1: {
                this.saveAttributes(tenantId, entityId, jsonResult, cfResult.getOutputStrategy(), cfResult.getScope(), cfName, cfIds, callback);
                break;
            }
            case 2: {
                this.saveTimeSeries(tenantId, entityId, jsonResult, cfResult.getOutputStrategy(), cfIds, System.currentTimeMillis(), callback);
            }
        }
    }

    private void saveAttributes(TenantId tenantId, EntityId entityId, JsonElement jsonResult, OutputStrategy outputStrategy, AttributeScope scope, String cfName, List<CalculatedFieldId> cfIds, TbCallback callback) {
        if (!(outputStrategy instanceof AttributesImmediateOutputStrategy)) {
            callback.onFailure((Throwable)new IllegalArgumentException("Only AttributeImmediateOutputStrategy is supported."));
        } else {
            AttributesImmediateOutputStrategy attOutputStrategy = (AttributesImmediateOutputStrategy)outputStrategy;
            AttributesSaveRequest.Strategy strategy = new AttributesSaveRequest.Strategy(attOutputStrategy.isSaveAttribute(), attOutputStrategy.isSendWsUpdate(), attOutputStrategy.isProcessCfs());
            List newAttributes = JsonConverter.convertToAttributes((JsonElement)jsonResult);
            if (!attOutputStrategy.isUpdateAttributesOnlyOnValueChange()) {
                this.saveAttributesInternal(tenantId, entityId, scope, cfName, cfIds, newAttributes, strategy, attOutputStrategy.isSendAttributesUpdatedNotification(), callback);
                return;
            }
            List keys = newAttributes.stream().map(KvEntry::getKey).collect(Collectors.toList());
            ListenableFuture findFuture = this.attributesService.find(tenantId, entityId, scope, keys);
            DonAsynchron.withCallback((ListenableFuture)findFuture, existingAttributes -> {
                List changed = KvUtils.filterChangedAttr((List)existingAttributes, (List)newAttributes);
                if (changed.isEmpty()) {
                    callback.onSuccess();
                    return;
                }
                this.saveAttributesInternal(tenantId, entityId, scope, cfName, cfIds, changed, strategy, attOutputStrategy.isSendAttributesUpdatedNotification(), callback);
            }, arg_0 -> ((TbCallback)callback).onFailure(arg_0), (Executor)MoreExecutors.directExecutor());
        }
    }

    private void saveAttributesInternal(TenantId tenantId, EntityId entityId, AttributeScope scope, String cfName, List<CalculatedFieldId> cfIds, List<AttributeKvEntry> entries, AttributesSaveRequest.Strategy strategy, boolean sendAttributesUpdatedNotification, TbCallback callback) {
        this.tsSubService.saveAttributes(AttributesSaveRequest.builder().tenantId(tenantId).entityId(entityId).scope(scope).entries(entries).strategy(strategy).previousCalculatedFieldIds(cfIds).callback((FutureCallback)new /* Unavailable Anonymous Inner Class!! */).build());
    }

    private void saveTimeSeries(TenantId tenantId, EntityId entityId, JsonElement jsonResult, OutputStrategy outputStrategy, List<CalculatedFieldId> cfIds, long ts, TbCallback callback) {
        if (!(outputStrategy instanceof TimeSeriesImmediateOutputStrategy)) {
            callback.onFailure((Throwable)new IllegalArgumentException("Only TimeSeriesImmediateOutputStrategy is supported."));
        } else {
            TimeSeriesImmediateOutputStrategy tsOutputStrategy = (TimeSeriesImmediateOutputStrategy)outputStrategy;
            TimeseriesSaveRequest.Strategy strategy = new TimeseriesSaveRequest.Strategy(tsOutputStrategy.isSaveTimeSeries(), tsOutputStrategy.isSaveLatest(), tsOutputStrategy.isSendWsUpdate(), tsOutputStrategy.isProcessCfs());
            this.saveTimeSeriesInternal(tenantId, entityId, jsonResult, Long.valueOf(tsOutputStrategy.getTtl()), cfIds, ts, strategy, callback);
        }
    }

    protected void saveReprocessingTimeSeriesResult(TenantId tenantId, EntityId entityId, JsonElement jsonResult, long ts, TimeseriesSaveRequest.Strategy strategy, TbCallback callback) {
        log.trace("[{}][{}] Saving CF reprocessing result: {}", new Object[]{tenantId, entityId, jsonResult});
        this.saveTimeSeriesInternal(tenantId, entityId, jsonResult, null, null, ts, strategy, callback);
    }

    private void saveTimeSeriesInternal(TenantId tenantId, EntityId entityId, JsonElement jsonResult, Long ttl, List<CalculatedFieldId> cfIds, long ts, TimeseriesSaveRequest.Strategy strategy, TbCallback callback) {
        Map tsKvMap = JsonConverter.convertToTelemetry((JsonElement)jsonResult, (long)ts);
        if (tsKvMap.isEmpty()) {
            callback.onSuccess();
            return;
        }
        List tsEntries = KvUtils.toTsKvEntryList((Map)tsKvMap);
        TimeseriesSaveRequest.Builder builder = TimeseriesSaveRequest.builder().tenantId(tenantId).entityId(entityId).entries(tsEntries).strategy(strategy).callback((FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
        if (ttl != null) {
            builder.ttl(ttl.longValue());
        }
        if (cfIds != null && !cfIds.isEmpty()) {
            builder.previousCalculatedFieldIds(cfIds);
        }
        this.tsSubService.saveTimeseries(builder.build());
    }

    private void sendAttributesUpdatedMsg(TenantId tenantId, EntityId entityId, AttributeScope scope, String cfName, List<AttributeKvEntry> entries) {
        ObjectNode entityNode = JacksonUtil.newObjectNode();
        if (entries != null) {
            entries.forEach(attributeKvEntry -> JacksonUtil.addKvEntry((ObjectNode)entityNode, (KvEntry)attributeKvEntry));
        }
        TbMsg attributesUpdatedMsg = TbMsg.newMsg().type(TbMsgType.ATTRIBUTES_UPDATED).originator(entityId).data(JacksonUtil.toString((Object)entityNode)).metaData(new TbMsgMetaData(Map.of("calculatedFieldName", cfName, "scope", scope.name()))).build();
        this.sendMsgToRuleEngine(tenantId, entityId, TbCallback.EMPTY, attributesUpdatedMsg);
    }

    @ConstructorProperties(value={"attributesService", "timeseriesService", "tsSubService", "apiLimitService", "relationService", "ownersCacheService", "clusterService"})
    @Generated
    public AbstractCalculatedFieldProcessingService(AttributesService attributesService, TimeseriesService timeseriesService, TelemetrySubscriptionService tsSubService, ApiLimitService apiLimitService, RelationService relationService, OwnersCacheService ownersCacheService, TbClusterService clusterService) {
        this.attributesService = attributesService;
        this.timeseriesService = timeseriesService;
        this.tsSubService = tsSubService;
        this.apiLimitService = apiLimitService;
        this.relationService = relationService;
        this.ownersCacheService = ownersCacheService;
        this.clusterService = clusterService;
    }

    @Generated
    public AttributesService getAttributesService() {
        return this.attributesService;
    }

    @Generated
    public TimeseriesService getTimeseriesService() {
        return this.timeseriesService;
    }

    @Generated
    public TelemetrySubscriptionService getTsSubService() {
        return this.tsSubService;
    }

    @Generated
    public ApiLimitService getApiLimitService() {
        return this.apiLimitService;
    }

    @Generated
    public RelationService getRelationService() {
        return this.relationService;
    }

    @Generated
    public OwnersCacheService getOwnersCacheService() {
        return this.ownersCacheService;
    }

    @Generated
    public TbClusterService getClusterService() {
        return this.clusterService;
    }

    @Generated
    public ListeningExecutorService getCalculatedFieldCallbackExecutor() {
        return this.calculatedFieldCallbackExecutor;
    }

    @Generated
    public void setCalculatedFieldCallbackExecutor(ListeningExecutorService calculatedFieldCallbackExecutor) {
        this.calculatedFieldCallbackExecutor = calculatedFieldCallbackExecutor;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractCalculatedFieldProcessingService)) {
            return false;
        }
        AbstractCalculatedFieldProcessingService other = (AbstractCalculatedFieldProcessingService)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        AttributesService this$attributesService = this.getAttributesService();
        AttributesService other$attributesService = other.getAttributesService();
        if (this$attributesService == null ? other$attributesService != null : !this$attributesService.equals(other$attributesService)) {
            return false;
        }
        TimeseriesService this$timeseriesService = this.getTimeseriesService();
        TimeseriesService other$timeseriesService = other.getTimeseriesService();
        if (this$timeseriesService == null ? other$timeseriesService != null : !this$timeseriesService.equals(other$timeseriesService)) {
            return false;
        }
        TelemetrySubscriptionService this$tsSubService = this.getTsSubService();
        TelemetrySubscriptionService other$tsSubService = other.getTsSubService();
        if (this$tsSubService == null ? other$tsSubService != null : !this$tsSubService.equals(other$tsSubService)) {
            return false;
        }
        ApiLimitService this$apiLimitService = this.getApiLimitService();
        ApiLimitService other$apiLimitService = other.getApiLimitService();
        if (this$apiLimitService == null ? other$apiLimitService != null : !this$apiLimitService.equals(other$apiLimitService)) {
            return false;
        }
        RelationService this$relationService = this.getRelationService();
        RelationService other$relationService = other.getRelationService();
        if (this$relationService == null ? other$relationService != null : !this$relationService.equals(other$relationService)) {
            return false;
        }
        OwnersCacheService this$ownersCacheService = this.getOwnersCacheService();
        OwnersCacheService other$ownersCacheService = other.getOwnersCacheService();
        if (this$ownersCacheService == null ? other$ownersCacheService != null : !this$ownersCacheService.equals(other$ownersCacheService)) {
            return false;
        }
        TbClusterService this$clusterService = this.getClusterService();
        TbClusterService other$clusterService = other.getClusterService();
        if (this$clusterService == null ? other$clusterService != null : !this$clusterService.equals(other$clusterService)) {
            return false;
        }
        ListeningExecutorService this$calculatedFieldCallbackExecutor = this.getCalculatedFieldCallbackExecutor();
        ListeningExecutorService other$calculatedFieldCallbackExecutor = other.getCalculatedFieldCallbackExecutor();
        return !(this$calculatedFieldCallbackExecutor == null ? other$calculatedFieldCallbackExecutor != null : !this$calculatedFieldCallbackExecutor.equals(other$calculatedFieldCallbackExecutor));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractCalculatedFieldProcessingService;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AttributesService $attributesService = this.getAttributesService();
        result = result * 59 + ($attributesService == null ? 43 : $attributesService.hashCode());
        TimeseriesService $timeseriesService = this.getTimeseriesService();
        result = result * 59 + ($timeseriesService == null ? 43 : $timeseriesService.hashCode());
        TelemetrySubscriptionService $tsSubService = this.getTsSubService();
        result = result * 59 + ($tsSubService == null ? 43 : $tsSubService.hashCode());
        ApiLimitService $apiLimitService = this.getApiLimitService();
        result = result * 59 + ($apiLimitService == null ? 43 : $apiLimitService.hashCode());
        RelationService $relationService = this.getRelationService();
        result = result * 59 + ($relationService == null ? 43 : $relationService.hashCode());
        OwnersCacheService $ownersCacheService = this.getOwnersCacheService();
        result = result * 59 + ($ownersCacheService == null ? 43 : $ownersCacheService.hashCode());
        TbClusterService $clusterService = this.getClusterService();
        result = result * 59 + ($clusterService == null ? 43 : $clusterService.hashCode());
        ListeningExecutorService $calculatedFieldCallbackExecutor = this.getCalculatedFieldCallbackExecutor();
        result = result * 59 + ($calculatedFieldCallbackExecutor == null ? 43 : $calculatedFieldCallbackExecutor.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AbstractCalculatedFieldProcessingService(attributesService=" + String.valueOf(this.getAttributesService()) + ", timeseriesService=" + String.valueOf(this.getTimeseriesService()) + ", tsSubService=" + String.valueOf(this.getTsSubService()) + ", apiLimitService=" + String.valueOf(this.getApiLimitService()) + ", relationService=" + String.valueOf(this.getRelationService()) + ", ownersCacheService=" + String.valueOf(this.getOwnersCacheService()) + ", clusterService=" + String.valueOf(this.getClusterService()) + ", calculatedFieldCallbackExecutor=" + String.valueOf(this.getCalculatedFieldCallbackExecutor()) + ")";
    }
}

