/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.ai;

import com.fasterxml.jackson.core.io.JsonStringEncoder;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.FluentFuture;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.ModelProvider;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.response.ChatResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.ai.model.chat.AiChatModelConfig;
import org.thingsboard.server.common.data.ai.model.chat.Langchain4jChatModelConfigurer;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.dao.secret.SecretConfigurationService;
import org.thingsboard.server.service.ai.AiChatModelService;
import org.thingsboard.server.service.ai.AiRequestsExecutor;

@Service
class AiChatModelServiceImpl
implements AiChatModelService {
    private final Langchain4jChatModelConfigurer chatModelConfigurer;
    private final AiRequestsExecutor aiRequestsExecutor;
    private final SecretConfigurationService secretConfigurationService;

    public <C extends AiChatModelConfig<C>> FluentFuture<ChatResponse> sendChatRequestAsync(TenantId tenantId, AiChatModelConfig<C> chatModelConfig, ChatRequest chatRequest) {
        AiChatModelConfig modelConfigWithSecretsReplaced = this.replaceSecrets(tenantId, chatModelConfig);
        ChatModel langChainChatModel = modelConfigWithSecretsReplaced.configure(this.chatModelConfigurer);
        if (langChainChatModel.provider() == ModelProvider.GITHUB_MODELS) {
            chatRequest = this.prepareGithubChatRequest(chatRequest);
        }
        return this.aiRequestsExecutor.sendChatRequestAsync(langChainChatModel, chatRequest);
    }

    private <C extends AiChatModelConfig<C>> AiChatModelConfig<C> replaceSecrets(TenantId tenantId, AiChatModelConfig<C> chatModelConfig) {
        JsonNode modelConfigJson = JacksonUtil.valueToTree(chatModelConfig);
        this.secretConfigurationService.replaceSecretUsages(tenantId, modelConfigJson);
        return (AiChatModelConfig)JacksonUtil.convertValue((Object)modelConfigJson, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    private ChatRequest prepareGithubChatRequest(ChatRequest chatRequest) {
        List messages = chatRequest.messages().stream().map(arg_0 -> this.prepareUserMessage(arg_0)).collect(Collectors.toList());
        return ChatRequest.builder().messages(messages).responseFormat(chatRequest.responseFormat()).build();
    }

    private ChatMessage prepareUserMessage(ChatMessage message) {
        if (message instanceof UserMessage) {
            UserMessage userMessage = (UserMessage)message;
            List newContents = userMessage.contents().stream().map(arg_0 -> this.prepareContent(arg_0)).collect(Collectors.toList());
            return UserMessage.from(newContents);
        }
        return message;
    }

    private Content prepareContent(Content content) {
        if (content instanceof TextContent) {
            TextContent txt = (TextContent)content;
            return new TextContent(new String(JsonStringEncoder.getInstance().quoteAsString(txt.text())));
        }
        return content;
    }

    @ConstructorProperties(value={"chatModelConfigurer", "aiRequestsExecutor", "secretConfigurationService"})
    @Generated
    public AiChatModelServiceImpl(Langchain4jChatModelConfigurer chatModelConfigurer, AiRequestsExecutor aiRequestsExecutor, SecretConfigurationService secretConfigurationService) {
        this.chatModelConfigurer = chatModelConfigurer;
        this.aiRequestsExecutor = aiRequestsExecutor;
        this.secretConfigurationService = secretConfigurationService;
    }
}

