/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.install;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;
import org.thingsboard.server.install.ThingsboardInstallException;
import org.thingsboard.server.service.component.ComponentDiscoveryService;
import org.thingsboard.server.service.install.DatabaseEntitiesUpgradeService;
import org.thingsboard.server.service.install.DatabaseSchemaSettingsService;
import org.thingsboard.server.service.install.EntityDatabaseSchemaService;
import org.thingsboard.server.service.install.InstallScripts;
import org.thingsboard.server.service.install.NoSqlKeyspaceService;
import org.thingsboard.server.service.install.SystemDataLoaderService;
import org.thingsboard.server.service.install.TsDatabaseSchemaService;
import org.thingsboard.server.service.install.TsLatestDatabaseSchemaService;
import org.thingsboard.server.service.install.migrate.TsLatestMigrateService;
import org.thingsboard.server.service.install.update.CacheCleanupService;
import org.thingsboard.server.service.install.update.DataUpdateService;

@Service
@Profile(value={"install"})
public class ThingsboardInstallService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThingsboardInstallService.class);
    @Value(value="${install.upgrade:false}")
    private Boolean isUpgrade;
    @Value(value="${install.upgrade.from_version:}")
    private String upgradeFromVersion;
    @Value(value="${install.load_demo:false}")
    private Boolean loadDemo;
    @Value(value="${state.persistToTelemetry:false}")
    private boolean persistToTelemetry;
    @Autowired
    private EntityDatabaseSchemaService entityDatabaseSchemaService;
    @Autowired(required=false)
    private NoSqlKeyspaceService noSqlKeyspaceService;
    @Autowired
    private TsDatabaseSchemaService tsDatabaseSchemaService;
    @Autowired(required=false)
    private TsLatestDatabaseSchemaService tsLatestDatabaseSchemaService;
    @Autowired
    private DatabaseEntitiesUpgradeService databaseEntitiesUpgradeService;
    @Autowired
    private ComponentDiscoveryService componentDiscoveryService;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private SystemDataLoaderService systemDataLoaderService;
    @Autowired
    private DataUpdateService dataUpdateService;
    @Autowired
    private CacheCleanupService cacheCleanupService;
    @Autowired(required=false)
    private TsLatestMigrateService latestMigrateService;
    @Autowired
    private InstallScripts installScripts;
    @Autowired
    private DatabaseSchemaSettingsService databaseSchemaVersionService;

    public void performInstall() {
        try {
            if (this.isUpgrade.booleanValue()) {
                if ("cassandra-latest-to-postgres".equals(this.upgradeFromVersion)) {
                    log.info("Migrating ThingsBoard latest timeseries data from cassandra to SQL database ...");
                    this.latestMigrateService.migrate();
                } else {
                    boolean updateFromCE = "CE".equals(this.upgradeFromVersion);
                    this.databaseSchemaVersionService.validateSchemaSettings(updateFromCE);
                    if (updateFromCE) {
                        log.info("Upgrading ThingsBoard Edge from version CE to PE ...");
                    } else {
                        String fromVersion = this.databaseSchemaVersionService.getDbSchemaVersion();
                        String toVersion = this.databaseSchemaVersionService.getPackageSchemaVersion();
                        log.info("Upgrading ThingsBoard Edge from version {} to {} ...", (Object)fromVersion, (Object)toVersion);
                    }
                    this.cacheCleanupService.clearCache();
                    this.databaseEntitiesUpgradeService.upgradeDatabase(updateFromCE);
                    this.entityDatabaseSchemaService.createDatabaseSchema(false);
                    this.entityDatabaseSchemaService.createOrUpdateViewsAndFunctions();
                    this.entityDatabaseSchemaService.createOrUpdateDeviceInfoView(this.persistToTelemetry);
                    this.entityDatabaseSchemaService.createDatabaseIndexes();
                    this.systemDataLoaderService.updateDefaultNotificationConfigs(false);
                    this.dataUpdateService.updateData(updateFromCE);
                    log.info("Updating system data...");
                    this.systemDataLoaderService.loadSystemWidgets();
                    this.installScripts.loadSystemImagesAndResources();
                    this.installScripts.generateSysAdminEncryptionKey();
                    this.databaseSchemaVersionService.updateSchemaVersion();
                    this.entityDatabaseSchemaService.generateClusterIdIfNotExist();
                    this.dataUpdateService.postUpdateData();
                }
                log.info("Upgrade finished successfully!");
            } else {
                log.info("Starting ThingsBoard Edge Installation...");
                log.info("Installing DataBase schema for entities...");
                this.entityDatabaseSchemaService.createDatabaseSchema();
                this.databaseSchemaVersionService.createSchemaSettings();
                this.entityDatabaseSchemaService.createOrUpdateViewsAndFunctions();
                this.entityDatabaseSchemaService.createOrUpdateDeviceInfoView(this.persistToTelemetry);
                log.info("Installing DataBase schema for timeseries...");
                if (this.noSqlKeyspaceService != null) {
                    this.noSqlKeyspaceService.createDatabaseSchema();
                }
                this.tsDatabaseSchemaService.createDatabaseSchema();
                if (this.tsLatestDatabaseSchemaService != null) {
                    this.tsLatestDatabaseSchemaService.createDatabaseSchema();
                }
                log.info("Loading system data...");
                this.componentDiscoveryService.discoverComponents();
                this.systemDataLoaderService.createDefaultTenantProfiles();
                this.systemDataLoaderService.createRandomJwtSettings();
                this.systemDataLoaderService.loadSystemWidgets();
                this.systemDataLoaderService.createQueues();
                this.installScripts.loadSystemImagesAndResources();
                this.installScripts.generateSysAdminEncryptionKey();
                this.entityDatabaseSchemaService.generateClusterIdIfNotExist();
                log.info("Installation finished successfully!");
            }
        }
        catch (Exception e) {
            log.error("Unexpected error during ThingsBoard Edge installation!", (Throwable)e);
            throw new ThingsboardInstallException("Unexpected error during ThingsBoard Edge installation!", (Throwable)e);
        }
        finally {
            SpringApplication.exit((ApplicationContext)this.context, (ExitCodeGenerator[])new ExitCodeGenerator[0]);
        }
    }
}

