/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.HasImage;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.WidgetTypeId;
import org.thingsboard.server.common.data.id.WidgetsBundleId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.common.data.widget.WidgetsBundle;
import org.thingsboard.server.common.data.widget.WidgetsBundleFilter;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.dao.resource.ImageService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.widgets.bundle.TbWidgetsBundleService;
import org.thingsboard.server.service.security.model.SecurityUser;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class WidgetsBundleController
extends BaseController {
    private final TbWidgetsBundleService tbWidgetsBundleService;
    private final ImageService imageService;
    private static final String WIDGET_BUNDLE_DESCRIPTION = "Widget Bundle represents a group(bundle) of widgets. Widgets are grouped into bundle by type or use case. ";
    private static final String FULL_SEARCH_PARAM_DESCRIPTION = "Optional boolean parameter indicating extended search of widget bundles by description and by name / description of related widget types";
    private static final String SCADA_FIRST_PARAM_DESCRIPTION = "Optional boolean parameter indicating whether to fetch widgets bundles with SCADA symbols first. Works only when fullSearch parameter is enabled";
    private static final String TENANT_BUNDLES_ONLY_DESCRIPTION = "Optional boolean parameter to include only tenant-level bundles without system";

    @ApiOperation(value="Get Widget Bundle (getWidgetsBundleById)", notes="Get the Widget Bundle based on the provided Widget Bundle Id. Widget Bundle represents a group(bundle) of widgets. Widgets are grouped into bundle by type or use case. \n\nAvailable for any authorized user. ")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/widgetsBundle/{widgetsBundleId}"})
    public WidgetsBundle getWidgetsBundleById(@Parameter(description="A string value representing the widget bundle id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="widgetsBundleId") String strWidgetsBundleId, @Parameter(description="Inline images as a data URL (Base64)") @RequestParam(value="inlineImages", required=false) boolean inlineImages) throws ThingsboardException {
        WidgetsBundleController.checkParameter((String)"widgetsBundleId", (String)strWidgetsBundleId);
        WidgetsBundleId widgetsBundleId = new WidgetsBundleId(this.toUUID(strWidgetsBundleId));
        WidgetsBundle result = this.checkWidgetsBundleId(widgetsBundleId, Operation.READ);
        if (inlineImages) {
            result = (WidgetsBundle)this.imageService.inlineImage((HasImage)result);
        }
        return result;
    }

    @ApiOperation(value="Create Or Update Widget Bundle (saveWidgetsBundle)", notes="Create or update the Widget Bundle. Widget Bundle represents a group(bundle) of widgets. Widgets are grouped into bundle by type or use case.  When creating the bundle, platform generates Widget Bundle Id as [time-based UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_1_(date-time_and_MAC_address)). The newly created Widget Bundle Id will be present in the response. Specify existing Widget Bundle id to update the Widget Bundle. Referencing non-existing Widget Bundle Id will cause 'Not Found' error.\n\nWidget Bundle alias is unique in the scope of tenant. Special Tenant Id '13814000-1dd2-11b2-8080-808080808080' is automatically used if the create bundle request is sent by user with 'SYS_ADMIN' authority.Remove 'id', 'tenantId' from the request body example (below) to create new Widgets Bundle entity.\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @PostMapping(value={"/widgetsBundle"})
    public WidgetsBundle saveWidgetsBundle(@Parameter(description="A JSON value representing the Widget Bundle.", required=true) @RequestBody WidgetsBundle widgetsBundle) throws Exception {
        SecurityUser currentUser = this.getCurrentUser();
        if (Authority.SYS_ADMIN.equals((Object)currentUser.getAuthority())) {
            widgetsBundle.setTenantId(TenantId.SYS_TENANT_ID);
        } else {
            widgetsBundle.setTenantId(currentUser.getTenantId());
        }
        this.checkEntity((EntityId)widgetsBundle.getId(), (TenantEntity)widgetsBundle, Resource.WIDGETS_BUNDLE);
        return this.tbWidgetsBundleService.save(widgetsBundle, currentUser);
    }

    @ApiOperation(value="Update widgets bundle widgets types list (updateWidgetsBundleWidgetTypes)", notes="Updates widgets bundle widgets list.\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @PostMapping(value={"/widgetsBundle/{widgetsBundleId}/widgetTypes"})
    @ResponseStatus(value=HttpStatus.OK)
    public void updateWidgetsBundleWidgetTypes(@Parameter(description="A string value representing the widget bundle id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="widgetsBundleId") String strWidgetsBundleId, @Parameter(description="Ordered list of widget type Ids to be included by widgets bundle") @RequestBody List<String> strWidgetTypeIds) throws Exception {
        WidgetsBundleController.checkParameter((String)"widgetsBundleId", (String)strWidgetsBundleId);
        WidgetsBundleId widgetsBundleId = new WidgetsBundleId(this.toUUID(strWidgetsBundleId));
        this.checkWidgetsBundleId(widgetsBundleId, Operation.WRITE);
        this.checkNotNull(strWidgetTypeIds);
        LinkedHashSet<WidgetTypeId> widgetTypeIds = new LinkedHashSet<WidgetTypeId>();
        SecurityUser currentUser = this.getCurrentUser();
        TenantId tenantId = currentUser.getTenantId();
        for (String strWidgetTypeId : strWidgetTypeIds) {
            WidgetTypeId widgetTypeId = new WidgetTypeId(this.toUUID(strWidgetTypeId));
            if (widgetTypeIds.contains(widgetTypeId) || !this.widgetTypeService.widgetTypeExistsByTenantIdAndWidgetTypeId(tenantId, widgetTypeId)) continue;
            widgetTypeIds.add(widgetTypeId);
        }
        this.tbWidgetsBundleService.updateWidgetsBundleWidgetTypes(widgetsBundleId, new ArrayList(widgetTypeIds), (User)currentUser);
    }

    @ApiOperation(value="Update widgets bundle widgets list from widget type FQNs list (updateWidgetsBundleWidgetFqns)", notes="Updates widgets bundle widgets list from widget type FQNs list.\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @PostMapping(value={"/widgetsBundle/{widgetsBundleId}/widgetTypeFqns"})
    @ResponseStatus(value=HttpStatus.OK)
    public void updateWidgetsBundleWidgetFqns(@Parameter(description="A string value representing the widget bundle id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="widgetsBundleId") String strWidgetsBundleId, @Parameter(description="Ordered list of widget type FQNs to be included by widgets bundle") @RequestBody List<String> widgetTypeFqns) throws Exception {
        WidgetsBundleController.checkParameter((String)"widgetsBundleId", (String)strWidgetsBundleId);
        WidgetsBundleId widgetsBundleId = new WidgetsBundleId(this.toUUID(strWidgetsBundleId));
        this.checkWidgetsBundleId(widgetsBundleId, Operation.WRITE);
        this.checkNotNull(widgetTypeFqns);
        SecurityUser currentUser = this.getCurrentUser();
        this.tbWidgetsBundleService.updateWidgetsBundleWidgetFqns(widgetsBundleId, widgetTypeFqns, (User)currentUser);
    }

    @ApiOperation(value="Delete widgets bundle (deleteWidgetsBundle)", notes="Deletes the widget bundle. Referencing non-existing Widget Bundle Id will cause an error.\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @DeleteMapping(value={"/widgetsBundle/{widgetsBundleId}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteWidgetsBundle(@Parameter(description="A string value representing the widget bundle id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="widgetsBundleId") String strWidgetsBundleId) throws ThingsboardException {
        WidgetsBundleController.checkParameter((String)"widgetsBundleId", (String)strWidgetsBundleId);
        WidgetsBundleId widgetsBundleId = new WidgetsBundleId(this.toUUID(strWidgetsBundleId));
        WidgetsBundle widgetsBundle = this.checkWidgetsBundleId(widgetsBundleId, Operation.DELETE);
        this.tbWidgetsBundleService.delete(widgetsBundle, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Get Widget Bundles (getWidgetsBundles)", notes="Returns a page of Widget Bundle objects available for current user. Widget Bundle represents a group(bundle) of widgets. Widgets are grouped into bundle by type or use case.  You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for any authorized user. ")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/widgetsBundles"}, params={"pageSize", "page"})
    public PageData<WidgetsBundle> getWidgetsBundles(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the widget bundle title.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "title", "tenantId"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder, @Parameter(description="Optional boolean parameter to include only tenant-level bundles without system") @RequestParam(required=false) Boolean tenantOnly, @Parameter(description="Optional boolean parameter indicating extended search of widget bundles by description and by name / description of related widget types") @RequestParam(required=false) Boolean fullSearch, @Parameter(description="Optional boolean parameter indicating whether to fetch widgets bundles with SCADA symbols first. Works only when fullSearch parameter is enabled") @RequestParam(required=false) Boolean scadaFirst) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.WIDGETS_BUNDLE, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        WidgetsBundleFilter widgetsBundleFilter = WidgetsBundleFilter.builder().tenantId(this.getTenantId()).fullSearch(fullSearch != null && fullSearch != false).scadaFirst(scadaFirst != null && scadaFirst != false).build();
        if (Authority.SYS_ADMIN.equals((Object)this.getCurrentUser().getAuthority())) {
            return (PageData)this.checkNotNull((Object)this.widgetsBundleService.findSystemWidgetsBundlesByPageLink(widgetsBundleFilter, pageLink));
        }
        if (tenantOnly != null && tenantOnly.booleanValue()) {
            return (PageData)this.checkNotNull((Object)this.widgetsBundleService.findTenantWidgetsBundlesByTenantIdAndPageLink(widgetsBundleFilter, pageLink));
        }
        return (PageData)this.checkNotNull((Object)this.widgetsBundleService.findAllTenantWidgetsBundlesByTenantIdAndPageLink(widgetsBundleFilter, pageLink));
    }

    @ApiOperation(value="Get all Widget Bundles (getWidgetsBundles)", notes="Returns an array of Widget Bundle objects that are available for current user.Widget Bundle represents a group(bundle) of widgets. Widgets are grouped into bundle by type or use case.  \n\nAvailable for any authorized user. ")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/widgetsBundles"})
    public List<WidgetsBundle> getWidgetsBundles() throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.WIDGETS_BUNDLE, Operation.READ);
        if (Authority.SYS_ADMIN.equals((Object)this.getCurrentUser().getAuthority())) {
            return (List)this.checkNotNull((Object)this.widgetsBundleService.findSystemWidgetsBundles(this.getTenantId()));
        }
        TenantId tenantId = this.getCurrentUser().getTenantId();
        return (List)this.checkNotNull((Object)this.widgetsBundleService.findAllTenantWidgetsBundlesByTenantId(tenantId));
    }

    @ApiOperation(value="Get Widgets Bundles By Ids (getWidgetsBundlesByIds)", notes="Requested widgets bundles must be system level or owned by tenant of the user which is performing the request. \n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/widgetsBundles"}, params={"widgetsBundleIds"})
    public List<WidgetsBundle> getWidgetsBundlesByIds(@Parameter(description="A list of widgets bundle ids, separated by comma ','", array=@ArraySchema(schema=@Schema(type="string")), required=true) @RequestParam(value="widgetsBundleIds") Set<UUID> widgetsBundleUUIDs) throws ThingsboardException {
        if (!this.accessControlService.hasPermission(this.getCurrentUser(), Resource.WIDGETS_BUNDLE, Operation.READ)) {
            return Collections.emptyList();
        }
        ArrayList<WidgetsBundleId> widgetsBundleIds = new ArrayList<WidgetsBundleId>();
        for (UUID widgetsBundleUUID : widgetsBundleUUIDs) {
            widgetsBundleIds.add(new WidgetsBundleId(widgetsBundleUUID));
        }
        return this.widgetsBundleService.findSystemOrTenantWidgetsBundlesByIds(this.getTenantId(), widgetsBundleIds);
    }

    @ConstructorProperties(value={"tbWidgetsBundleService", "imageService"})
    @Generated
    public WidgetsBundleController(TbWidgetsBundleService tbWidgetsBundleService, ImageService imageService) {
        this.tbWidgetsBundleService = tbWidgetsBundleService;
        this.imageService = imageService;
    }
}

