/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.common.data.security.model.mfa.PlatformTwoFaSettings;
import org.thingsboard.server.common.data.security.model.mfa.account.AccountTwoFaSettings;
import org.thingsboard.server.common.data.security.model.mfa.account.TwoFaAccountConfig;
import org.thingsboard.server.common.data.security.model.mfa.provider.TwoFaProviderConfig;
import org.thingsboard.server.common.data.security.model.mfa.provider.TwoFaProviderType;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.controller.TwoFactorAuthConfigController;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.security.auth.mfa.TwoFactorAuthService;
import org.thingsboard.server.service.security.auth.mfa.config.TwoFaConfigManager;
import org.thingsboard.server.service.security.model.SecurityUser;

@RestController
@RequestMapping(value={"/api/2fa"})
@TbCoreComponent
public class TwoFactorAuthConfigController
extends BaseController {
    private final TwoFaConfigManager twoFaConfigManager;
    private final TwoFactorAuthService twoFactorAuthService;

    @ApiOperation(value="Get account 2FA settings (getAccountTwoFaSettings)", notes="Get user's account 2FA configuration. Configuration contains configs for different 2FA providers.\n\nExample:\n```\n{\n  \"configs\": {\n    \"EMAIL\": {\n      \"providerType\": \"EMAIL\",\n      \"useByDefault\": true,\n      \"email\": \"tenant@thingsboard.org\"\n    },\n    \"TOTP\": {\n      \"providerType\": \"TOTP\",\n      \"useByDefault\": false,\n      \"authUrl\": \"otpauth://totp/TB%202FA:tenant@thingsboard.org?issuer=TB+2FA&secret=P6Z2TLYTASOGP6LCJZAD24ETT5DACNNX\"\n    },\n    \"SMS\": {\n      \"providerType\": \"SMS\",\n      \"useByDefault\": false,\n      \"phoneNumber\": \"+380501253652\"\n    }\n  }\n}\n```\n\nAvailable for any authorized user. ")
    @GetMapping(value={"/account/settings"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER', 'MFA_CONFIGURATION_TOKEN')")
    public AccountTwoFaSettings getAccountTwoFaSettings() throws ThingsboardException {
        SecurityUser user = this.getCurrentUser();
        this.accessControlService.checkPermission(user, Resource.PROFILE, Operation.WRITE);
        return this.twoFaConfigManager.getAccountTwoFaSettings(user.getTenantId(), (User)user).orElse(null);
    }

    @ApiOperation(value="Generate 2FA account config (generateTwoFaAccountConfig)", notes="Generate new 2FA account config template for specified provider type. \n\nFor TOTP, this will return a corresponding account config template with a generated OTP auth URL (with new random secret key for each API call) that can be then converted to a QR code to scan with an authenticator app. Example:\n```\n{\n  \"providerType\": \"TOTP\",\n  \"useByDefault\": false,\n  \"authUrl\": \"otpauth://totp/TB%202FA:tenant@thingsboard.org?issuer=TB+2FA&secret=PNJDNWJVAK4ZTUYT7RFGPQLXA7XGU7PX\"\n}\n```\n\nFor EMAIL, the generated config will contain email from user's account:\n```\n{\n  \"providerType\": \"EMAIL\",\n  \"useByDefault\": false,\n  \"email\": \"tenant@thingsboard.org\"\n}\n```\n\nFor SMS 2FA this method will just return a config with empty/default values as there is nothing to generate/preset:\n```\n{\n  \"providerType\": \"SMS\",\n  \"useByDefault\": false,\n  \"phoneNumber\": null\n}\n```\n\nWill throw an error (Bad Request) if the provider is not configured for usage. \n\nAvailable for any authorized user. ")
    @PostMapping(value={"/account/config/generate"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER', 'MFA_CONFIGURATION_TOKEN')")
    public TwoFaAccountConfig generateTwoFaAccountConfig(@Parameter(description="2FA provider type to generate new account config for", schema=@Schema(defaultValue="TOTP", requiredMode=Schema.RequiredMode.REQUIRED)) @RequestParam TwoFaProviderType providerType) throws Exception {
        SecurityUser user = this.getCurrentUser();
        this.accessControlService.checkPermission(user, Resource.PROFILE, Operation.WRITE);
        return this.twoFactorAuthService.generateNewAccountConfig((User)user, providerType);
    }

    @ApiOperation(value="Submit 2FA account config (submitTwoFaAccountConfig)", notes="Submit 2FA account config to prepare for a future verification. Basically, this method will send a verification code for a given account config, if this has sense for a chosen 2FA provider. This code is needed to then verify and save the account config.\n\nExample of EMAIL 2FA account config:\n```\n{\n  \"providerType\": \"EMAIL\",\n  \"useByDefault\": true,\n  \"email\": \"separate-email-for-2fa@thingsboard.org\"\n}\n```\n\nExample of SMS 2FA account config:\n```\n{\n  \"providerType\": \"SMS\",\n  \"useByDefault\": false,\n  \"phoneNumber\": \"+38012312321\"\n}\n```\n\nFor TOTP this method does nothing.\n\nWill throw an error (Bad Request) if submitted account config is not valid, or if the provider is not configured for usage. \n\nAvailable for any authorized user. ")
    @PostMapping(value={"/account/config/submit"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER', 'MFA_CONFIGURATION_TOKEN')")
    public void submitTwoFaAccountConfig(@Valid @RequestBody TwoFaAccountConfig accountConfig) throws Exception {
        SecurityUser user = this.getCurrentUser();
        this.accessControlService.checkPermission(user, Resource.PROFILE, Operation.WRITE);
        this.twoFactorAuthService.prepareVerificationCode(user, accountConfig, false);
    }

    @ApiOperation(value="Verify and save 2FA account config (verifyAndSaveTwoFaAccountConfig)", notes="Checks the verification code for submitted config, and if it is correct, saves the provided account config. \n\nReturns whole account's 2FA settings object.\nWill throw an error (Bad Request) if the provider is not configured for usage. \n\nAvailable for any authorized user. ")
    @PostMapping(value={"/account/config"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER', 'MFA_CONFIGURATION_TOKEN')")
    public AccountTwoFaSettings verifyAndSaveTwoFaAccountConfig(@Valid @RequestBody TwoFaAccountConfig accountConfig, @RequestParam(required=false) String verificationCode) throws Exception {
        SecurityUser user = this.getCurrentUser();
        this.accessControlService.checkPermission(user, Resource.PROFILE, Operation.WRITE);
        if (this.twoFaConfigManager.getTwoFaAccountConfig(user.getTenantId(), (User)user, accountConfig.getProviderType()).isPresent()) {
            throw new IllegalArgumentException("2FA provider is already configured");
        }
        boolean verificationSuccess = accountConfig.getProviderType() != TwoFaProviderType.BACKUP_CODE ? this.twoFactorAuthService.checkVerificationCode(user, verificationCode, accountConfig, false) : true;
        if (verificationSuccess) {
            return this.twoFaConfigManager.saveTwoFaAccountConfig(user.getTenantId(), (User)user, accountConfig);
        }
        throw new IllegalArgumentException("Verification code is incorrect");
    }

    @ApiOperation(value="Update 2FA account config (updateTwoFaAccountConfig)", notes="Update config for a given provider type. \nUpdate request example:\n```\n{\n  \"useByDefault\": true\n}\n```\nReturns whole account's 2FA settings object.\n\n\nAvailable for any authorized user. ")
    @PutMapping(value={"/account/config"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    public AccountTwoFaSettings updateTwoFaAccountConfig(@RequestParam TwoFaProviderType providerType, @RequestBody TwoFaAccountConfigUpdateRequest updateRequest) throws ThingsboardException {
        SecurityUser user = this.getCurrentUser();
        this.accessControlService.checkPermission(user, Resource.PROFILE, Operation.WRITE);
        TwoFaAccountConfig accountConfig = (TwoFaAccountConfig)this.twoFaConfigManager.getTwoFaAccountConfig(user.getTenantId(), (User)user, providerType).orElseThrow(() -> new IllegalArgumentException("Config for " + String.valueOf(providerType) + " 2FA provider not found"));
        accountConfig.setUseByDefault(updateRequest.isUseByDefault());
        return this.twoFaConfigManager.saveTwoFaAccountConfig(user.getTenantId(), (User)user, accountConfig);
    }

    @ApiOperation(value="Delete 2FA account config (deleteTwoFaAccountConfig)", notes="Delete 2FA config for a given 2FA provider type. \nReturns whole account's 2FA settings object.\n\n\nAvailable for any authorized user. ")
    @DeleteMapping(value={"/account/config"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    public AccountTwoFaSettings deleteTwoFaAccountConfig(@RequestParam TwoFaProviderType providerType) throws ThingsboardException {
        SecurityUser user = this.getCurrentUser();
        this.accessControlService.checkPermission(user, Resource.PROFILE, Operation.WRITE);
        return this.twoFaConfigManager.deleteTwoFaAccountConfig(user.getTenantId(), (User)user, providerType);
    }

    @ApiOperation(value="Get available 2FA providers (getAvailableTwoFaProviders)", notes="Get the list of provider types available for user to use (the ones configured by tenant or sysadmin).\nExample of response:\n```\n[\n  \"TOTP\",\n  \"EMAIL\",\n  \"SMS\"\n]\n```\n\nAvailable for any authorized user. ")
    @GetMapping(value={"/providers"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER', 'MFA_CONFIGURATION_TOKEN')")
    public List<TwoFaProviderType> getAvailableTwoFaProviders() throws ThingsboardException {
        return this.twoFaConfigManager.getPlatformTwoFaSettings(this.getTenantId(), true).map(PlatformTwoFaSettings::getProviders).orElse(Collections.emptyList()).stream().map(TwoFaProviderConfig::getProviderType).collect(Collectors.toList());
    }

    @ApiOperation(value="Get platform 2FA settings (getPlatformTwoFaSettings)", notes="Get platform settings for 2FA. The settings are described for savePlatformTwoFaSettings API method. If 2FA is not configured, then an empty response will be returned.\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @GetMapping(value={"/settings"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    public PlatformTwoFaSettings getPlatformTwoFaSettings() throws ThingsboardException {
        SecurityUser user = this.getCurrentUser();
        if (user.getAuthority() == Authority.SYS_ADMIN) {
            this.accessControlService.checkPermission(user, Resource.ADMIN_SETTINGS, Operation.READ);
        } else {
            this.accessControlService.checkPermission(user, Resource.WHITE_LABELING, Operation.READ);
        }
        return this.twoFaConfigManager.getPlatformTwoFaSettings(user.getTenantId(), false).orElse(null);
    }

    @ApiOperation(value="Save platform 2FA settings (savePlatformTwoFaSettings)", notes="Save 2FA settings for platform. The settings have following properties:\n- `useSystemTwoFactorAuthSettings` - option for tenant admins to use 2FA settings configured by sysadmin. If this param is set to true, then the settings will not be validated for constraints (if it is a tenant admin; for sysadmin this param is ignored).\n- `providers` - the list of 2FA providers' configs. Users will only be allowed to use 2FA providers from this list. \n\n- `minVerificationCodeSendPeriod` - minimal period in seconds to wait after verification code send request to send next request. \n- `verificationCodeCheckRateLimit` - rate limit configuration for verification code checking.\nThe format is standard: 'amountOfRequests:periodInSeconds'. The value of '1:60' would limit verification code checking requests to one per minute.\n- `maxVerificationFailuresBeforeUserLockout` - maximum number of verification failures before a user gets disabled.\n- `totalAllowedTimeForVerification` - total amount of time in seconds allotted for verification. Basically, this property sets a lifetime for pre-verification token. If not set, default value of 30 minutes is used.\n\n\nTOTP 2FA provider config has following settings:\n- `issuerName` - issuer name that will be displayed in an authenticator app near a username. Must not be blank.\n\nFor SMS 2FA provider:\n- `smsVerificationMessageTemplate` - verification message template.  Available template variables are ${code} and ${userEmail}. It must not be blank and must contain verification code variable.\n- `verificationCodeLifetime` - verification code lifetime in seconds. Required to be positive.\n\nFor EMAIL provider type:\n- `verificationCodeLifetime` - the same as for SMS.\n\nExample of the settings:\n```\n{\n  \"useSystemTwoFactorAuthSettings\": false,\n  \"providers\": [\n    {\n      \"providerType\": \"TOTP\",\n      \"issuerName\": \"TB\"\n    },\n    {\n      \"providerType\": \"EMAIL\",\n      \"verificationCodeLifetime\": 60\n    },\n    {\n      \"providerType\": \"SMS\",\n      \"verificationCodeLifetime\": 60,\n      \"smsVerificationMessageTemplate\": \"Here is your verification code: ${code}\"\n    }\n  ],\n  \"minVerificationCodeSendPeriod\": 60,\n  \"verificationCodeCheckRateLimit\": \"3:900\",\n  \"maxVerificationFailuresBeforeUserLockout\": 10,\n  \"totalAllowedTimeForVerification\": 600\n}\n```\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PostMapping(value={"/settings"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    public PlatformTwoFaSettings savePlatformTwoFaSettings(@Parameter(description="Settings value", required=true) @RequestBody PlatformTwoFaSettings twoFaSettings) throws ThingsboardException {
        SecurityUser user = this.getCurrentUser();
        if (user.getAuthority() == Authority.SYS_ADMIN) {
            this.accessControlService.checkPermission(user, Resource.ADMIN_SETTINGS, Operation.WRITE);
        } else {
            this.accessControlService.checkPermission(user, Resource.WHITE_LABELING, Operation.WRITE);
        }
        return this.twoFaConfigManager.savePlatformTwoFaSettings(user.getTenantId(), twoFaSettings);
    }

    @ConstructorProperties(value={"twoFaConfigManager", "twoFactorAuthService"})
    @Generated
    public TwoFactorAuthConfigController(TwoFaConfigManager twoFaConfigManager, TwoFactorAuthService twoFactorAuthService) {
        this.twoFaConfigManager = twoFaConfigManager;
        this.twoFactorAuthService = twoFactorAuthService;
    }
}

