/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.cache.limits.RateLimitService;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.limit.LimitedApi;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.common.data.trendz.TrendzConfiguration;
import org.thingsboard.server.common.data.trendz.TrendzHealthcheckResult;
import org.thingsboard.server.common.data.trendz.TrendzSettings;
import org.thingsboard.server.common.data.trendz.TrendzSynchronizationResult;
import org.thingsboard.server.common.data.trendz.TrendzSynchronizationResultType;
import org.thingsboard.server.common.data.trendz.TrendzSynchronizationStatus;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.dao.trendz.TrendzSettingsService;
import org.thingsboard.server.dao.trendz.TrendzSyncService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.security.model.SecurityUser;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api/trendz"})
public class TrendzController
extends BaseController {
    private static final String TRENDZ_PUBLIC_SYNC_ENDPOINT_RATE_LIMIT = "1:60";
    private final TrendzSyncService trendzSyncService;
    private final TrendzSettingsService trendzSettingsService;
    private final RateLimitService rateLimitService;

    @ApiOperation(value="Get Trendz configuration (getTrendzConfig)", notes="Retrieves Trendz configuration (URLs). Returns trendzUrl and tbUrl.\n\nAvailable for users with 'SYS_ADMIN' authority.")
    @GetMapping(value={"/config"})
    @PreAuthorize(value="hasAuthority('SYS_ADMIN')")
    public TrendzConfiguration getTrendzConfig(@AuthenticationPrincipal SecurityUser user) throws ThingsboardException {
        this.accessControlService.checkPermission(user, Resource.ADMIN_SETTINGS, Operation.READ);
        TrendzSettings settings = this.trendzSettingsService.findTrendzSettings();
        return settings != null ? settings.configuration() : new TrendzConfiguration(null, null);
    }

    @ApiOperation(value="Save Trendz configuration (saveTrendzConfig)", notes="Saves Trendz configuration (URLs only, without triggering synchronization). Request body example:\n```json\n{\n  \"trendzUrl\": \"https://trendz.domain.com\",\n  \"tbUrl\": \"https://thingsboard.domain.com\"\n}\n```\n\nAvailable for users with 'SYS_ADMIN' authority.")
    @PostMapping(value={"/config"})
    @PreAuthorize(value="hasAuthority('SYS_ADMIN')")
    public TrendzConfiguration saveTrendzConfig(@RequestBody TrendzConfiguration config, @AuthenticationPrincipal SecurityUser user) throws ThingsboardException {
        this.accessControlService.checkPermission(user, Resource.ADMIN_SETTINGS, Operation.WRITE);
        TrendzSettings trendzSettings = this.trendzSettingsService.findTrendzSettings();
        if (trendzSettings != null && trendzSettings.configuration() != null && trendzSettings.configuration().equals((Object)config)) {
            return trendzSettings.configuration();
        }
        TrendzSynchronizationResult syncResult = new TrendzSynchronizationResult(null, Long.valueOf(0L), TrendzSynchronizationResultType.SYNC_NOT_INITIALIZED, TrendzSynchronizationStatus.NOT_AVAILABLE);
        TrendzSettings newSettings = new TrendzSettings(config, syncResult);
        this.trendzSettingsService.saveTrendzSettings(newSettings);
        return config;
    }

    @ApiOperation(value="Get Trendz synchronization result (getTrendzSyncResult)", notes="Retrieves Trendz synchronization result and status. Returns trendzVersion, updatedTs, resultType, and status.\n\nAvailable for any authorized user. ")
    @GetMapping(value={"/sync"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    public TrendzSynchronizationResult getTrendzSyncResult() {
        TrendzSettings settings = this.trendzSettingsService.findTrendzSettings();
        if (settings != null && settings.synchronizationResult() != null) {
            return settings.synchronizationResult();
        }
        return new TrendzSynchronizationResult(null, Long.valueOf(0L), TrendzSynchronizationResultType.SYNC_NOT_INITIALIZED, TrendzSynchronizationStatus.NOT_AVAILABLE);
    }

    @ApiOperation(value="Perform Trendz healthcheck (performTrendzHealthcheck)", notes="Performs healthcheck for Trendz integration. Returns version, type, status, and message. Can only be performed if Trendz is already synchronized and integration is enabled.\n\nAvailable for any authorized user. ")
    @GetMapping(value={"/healthcheck"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    public TrendzHealthcheckResult performTrendzHealthcheck() {
        return this.trendzSyncService.performHealthcheck();
    }

    @ApiOperation(value="Connect to Trendz (connectToTrendz)", notes="Initiates synchronization with Trendz (Connect button action). Uses Trendz configuration from settings or falls back to environment variables. Generates API key, saves configuration, checks Trendz version, and performs initial sync. \n\nAvailable for users with 'SYS_ADMIN' authority.")
    @PostMapping(value={"/connect"})
    @PreAuthorize(value="hasAuthority('SYS_ADMIN')")
    public TrendzSynchronizationResult connectToTrendz(@AuthenticationPrincipal SecurityUser user) throws ThingsboardException {
        this.accessControlService.checkPermission(user, Resource.ADMIN_SETTINGS, Operation.WRITE);
        TrendzSettings result = this.trendzSyncService.performSync();
        return result.synchronizationResult();
    }

    @ApiOperation(value="Public connect to Trendz (publicConnectToTrendz)", notes="Initiates synchronization with Trendz if Trendz is not synced yet. Uses Trendz configuration from settings or falls back to environment variables. Generates API key, saves configuration, checks Trendz version, and performs initial sync.")
    @PostMapping(value={"/public/connect"})
    public void publicConnectToTrendz() {
        try {
            if (this.rateLimitService.checkRateLimit(LimitedApi.TRENDZ_PUBLIC_SYNC, (Object)TenantId.SYS_TENANT_ID, TRENDZ_PUBLIC_SYNC_ENDPOINT_RATE_LIMIT)) {
                this.trendzSyncService.performSyncIfNeeded();
            } else {
                this.log.warn("Failed to perform Trendz public synchronization: rate limit");
            }
        }
        catch (Exception e) {
            this.log.error("Failed to perform Trendz public synchronization.", (Throwable)e);
        }
    }

    @ConstructorProperties(value={"trendzSyncService", "trendzSettingsService", "rateLimitService"})
    @Generated
    public TrendzController(TrendzSyncService trendzSyncService, TrendzSettingsService trendzSettingsService, RateLimitService rateLimitService) {
        this.trendzSyncService = trendzSyncService;
        this.trendzSettingsService = trendzSettingsService;
        this.rateLimitService = rateLimitService;
    }
}

