/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.TenantInfo;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.dao.tenant.TenantService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.tenant.TbTenantService;
import org.thingsboard.server.service.security.model.SecurityUser;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class TenantController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantController.class);
    private static final String TENANT_INFO_DESCRIPTION = "The Tenant Info object extends regular Tenant object and includes Tenant Profile name. ";
    private final TenantService tenantService;
    private final TbTenantService tbTenantService;

    @ApiOperation(value="Get Tenant (getTenantById)", notes="Fetch the Tenant object based on the provided Tenant Id. \n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @GetMapping(value={"/tenant/{tenantId}"})
    public Tenant getTenantById(@Parameter(description="A string value representing the tenant id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="tenantId") String strTenantId) throws ThingsboardException {
        TenantController.checkParameter((String)"tenantId", (String)strTenantId);
        TenantId tenantId = TenantId.fromUUID((UUID)this.toUUID(strTenantId));
        Tenant tenant = this.checkTenantId(tenantId, Operation.READ);
        this.checkDashboardInfo(tenant.getAdditionalInfo(), "homeDashboardId");
        return tenant;
    }

    @ApiOperation(value="Get Tenant Info (getTenantInfoById)", notes="Fetch the Tenant Info object based on the provided Tenant Id. The Tenant Info object extends regular Tenant object and includes Tenant Profile name. \n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @GetMapping(value={"/tenant/info/{tenantId}"})
    public TenantInfo getTenantInfoById(@Parameter(description="A string value representing the tenant id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="tenantId") String strTenantId) throws ThingsboardException {
        TenantController.checkParameter((String)"tenantId", (String)strTenantId);
        TenantId tenantId = TenantId.fromUUID((UUID)this.toUUID(strTenantId));
        return this.checkTenantInfoId(tenantId, Operation.READ);
    }

    @ApiOperation(value="Create Or update Tenant (saveTenant)", notes="Create or update the Tenant. When creating tenant, platform generates Tenant Id as [time-based UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_1_(date-time_and_MAC_address)). Default Rule Chain and Device profile are also generated for the new tenants automatically. The newly created Tenant Id will be present in the response. Specify existing Tenant Id id to update the Tenant. Referencing non-existing Tenant Id will cause 'Not Found' error.Remove 'id', 'tenantId' from the request body example (below) to create new Tenant entity.\n\nAvailable for users with 'SYS_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('SYS_ADMIN')")
    @PostMapping(value={"/tenant"})
    public Tenant saveTenant(@Parameter(description="A JSON value representing the tenant.") @RequestBody Tenant tenant) throws Exception {
        this.checkEntity((EntityId)tenant.getId(), (TenantEntity)tenant, Resource.TENANT);
        return this.tbTenantService.save(tenant);
    }

    @ApiOperation(value="Delete Tenant (deleteTenant)", notes="Deletes the tenant, it's customers, rule chains, devices and all other related entities. Referencing non-existing tenant Id will cause an error.\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @DeleteMapping(value={"/tenant/{tenantId}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteTenant(@Parameter(description="A string value representing the tenant id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="tenantId") String strTenantId) throws Exception {
        TenantController.checkParameter((String)"tenantId", (String)strTenantId);
        TenantId tenantId = TenantId.fromUUID((UUID)this.toUUID(strTenantId));
        Tenant tenant = this.checkTenantId(tenantId, Operation.DELETE);
        this.tbTenantService.delete(tenant);
    }

    @ApiOperation(value="Get Tenants (getTenants)", notes="Returns a page of tenants registered in the platform. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'SYS_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('SYS_ADMIN')")
    @GetMapping(value={"/tenants"}, params={"pageSize", "page"})
    public PageData<Tenant> getTenants(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the tenant name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "title", "email", "country", "state", "city", "address", "address2", "zip", "phone", "email"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.TENANT, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        return (PageData)this.checkNotNull((Object)this.tenantService.findTenants(pageLink));
    }

    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @GetMapping(value={"/tenants"}, params={"tenantIds"})
    public List<Tenant> getTenantsByIds(@Parameter(description="A list of tenant ids, separated by comma ','", array=@ArraySchema(schema=@Schema(type="string"))) @RequestParam(value="tenantIds") Set<UUID> tenantUUIDs) throws ThingsboardException {
        SecurityUser user = this.getCurrentUser();
        TenantId tenantId = user.getTenantId();
        ArrayList<TenantId> tenantIds = new ArrayList<TenantId>();
        for (UUID tenantUUID : tenantUUIDs) {
            tenantIds.add(TenantId.fromUUID((UUID)tenantUUID));
        }
        List tenants = this.tenantService.findTenantsByIds(tenantId, tenantIds);
        return this.filterTenantsByReadPermission(tenants);
    }

    @ApiOperation(value="Get Tenants Info (getTenants)", notes="Returns a page of tenant info objects registered in the platform. The Tenant Info object extends regular Tenant object and includes Tenant Profile name. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'SYS_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('SYS_ADMIN')")
    @GetMapping(value={"/tenantInfos"}, params={"pageSize", "page"})
    public PageData<TenantInfo> getTenantInfos(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the tenant name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "tenantProfileName", "title", "email", "country", "state", "city", "address", "address2", "zip", "phone", "email"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.TENANT, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        return (PageData)this.checkNotNull((Object)this.tenantService.findTenantInfos(pageLink));
    }

    private List<Tenant> filterTenantsByReadPermission(List<Tenant> tenants) {
        return tenants.stream().filter(tenant -> {
            try {
                return this.accessControlService.hasPermission(this.getCurrentUser(), Resource.TENANT, Operation.READ, (EntityId)tenant.getId(), (TenantEntity)tenant);
            }
            catch (ThingsboardException e) {
                return false;
            }
        }).toList();
    }

    @ConstructorProperties(value={"tenantService", "tbTenantService"})
    @Generated
    public TenantController(TenantService tenantService, TbTenantService tbTenantService) {
        this.tenantService = tenantService;
        this.tbTenantService = tbTenantService;
    }
}

