/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.ResourceSubType;
import org.thingsboard.server.common.data.ResourceType;
import org.thingsboard.server.common.data.TbResource;
import org.thingsboard.server.common.data.TbResourceDeleteResult;
import org.thingsboard.server.common.data.TbResourceInfo;
import org.thingsboard.server.common.data.TbResourceInfoFilter;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.HasId;
import org.thingsboard.server.common.data.id.TbResourceId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.lwm2m.LwM2mObject;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.common.data.util.ThrowingSupplier;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.resource.TbResourceService;
import org.thingsboard.server.service.security.model.SecurityUser;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class TbResourceController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbResourceController.class);
    private static final String DOWNLOAD_RESOURCE_IF_NOT_CHANGED = "Download Resource based on the provided Resource Id or return 304 status code if resource was not changed.";
    private final TbResourceService tbResourceService;
    public static final String RESOURCE_ID = "resourceId";

    @ApiOperation(value="Download Resource (downloadResource)", notes="Download Resource based on the provided Resource Id.\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @GetMapping(value={"/resource/{resourceId}/download"})
    public ResponseEntity<ByteArrayResource> downloadResource(@Parameter(description="A string value representing the resource id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="resourceId") String strResourceId) throws ThingsboardException {
        TbResourceController.checkParameter((String)"resourceId", (String)strResourceId);
        TbResourceId resourceId = new TbResourceId(this.toUUID(strResourceId));
        TbResource tbResource = this.checkResourceId(resourceId, Operation.READ);
        ByteArrayResource resource = new ByteArrayResource(tbResource.getData());
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment;filename=" + tbResource.getFileName()})).header("x-filename", new String[]{tbResource.getFileName()})).contentLength(resource.contentLength()).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)resource);
    }

    @ApiOperation(value="Download resource (downloadResource)", notes="Download resource with a given type and key for the given scope\n\nAvailable for any authorized user. ")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/resource/{resourceType}/{scope}/{key}"})
    public ResponseEntity<ByteArrayResource> downloadResourceIfChanged(@Parameter(description="Type of the resource", schema=@Schema(allowableValues={"lwm2m_model", "jks", "pkcs_12", "js_module", "dashboard"})) @PathVariable(value="resourceType") String resourceTypeStr, @Parameter(description="Scope of the resource", schema=@Schema(allowableValues={"system", "tenant"})) @PathVariable String scope, @Parameter(description="Key of the resource, e.g. 'extension.js'") @PathVariable String key, @RequestHeader(name="If-None-Match", required=false) String etag) throws ThingsboardException {
        ResourceType resourceType = ResourceType.valueOf((String)resourceTypeStr.toUpperCase());
        return this.downloadResourceIfChanged(() -> this.checkResourceInfo(scope, resourceType, key, Operation.READ), etag);
    }

    @ApiOperation(value="Download LWM2M Resource (downloadLwm2mResourceIfChanged)", notes="Download Resource based on the provided Resource Id or return 304 status code if resource was not changed.\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @GetMapping(value={"/resource/lwm2m/{resourceId}/download"}, produces={"application/xml"})
    public ResponseEntity<ByteArrayResource> downloadLwm2mResourceIfChanged(@Parameter(description="A string value representing the resource id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="resourceId") String strResourceId, @RequestHeader(name="If-None-Match", required=false) String etag) throws ThingsboardException {
        return this.downloadResourceIfChanged(strResourceId, etag);
    }

    @ApiOperation(value="Download PKCS_12 Resource (downloadPkcs12ResourceIfChanged)", notes="Download Resource based on the provided Resource Id or return 304 status code if resource was not changed.\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @RequestMapping(value={"/resource/pkcs12/{resourceId}/download"}, method={RequestMethod.GET}, produces={"application/x-pkcs12"})
    public ResponseEntity<ByteArrayResource> downloadPkcs12ResourceIfChanged(@Parameter(description="A string value representing the resource id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="resourceId") String strResourceId, @RequestHeader(name="If-None-Match", required=false) String etag) throws ThingsboardException {
        return this.downloadResourceIfChanged(strResourceId, etag);
    }

    @ApiOperation(value="Download JKS Resource (downloadJksResourceIfChanged)", notes="Download Resource based on the provided Resource Id or return 304 status code if resource was not changed.\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @GetMapping(value={"/resource/jks/{resourceId}/download"}, produces={"application/x-java-keystore"})
    public ResponseEntity<ByteArrayResource> downloadJksResourceIfChanged(@Parameter(description="A string value representing the resource id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="resourceId") String strResourceId, @RequestHeader(name="If-None-Match", required=false) String etag) throws ThingsboardException {
        return this.downloadResourceIfChanged(strResourceId, etag);
    }

    @ApiOperation(value="Download JS Resource (downloadJsResourceIfChanged)", notes="Download Resource based on the provided Resource Id or return 304 status code if resource was not changed.\n\nAvailable for any authorized user. ")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/resource/js/{resourceId}/download"}, produces={"application/javascript"})
    public ResponseEntity<ByteArrayResource> downloadJsResourceIfChanged(@Parameter(description="A string value representing the resource id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="resourceId") String strResourceId, @RequestHeader(name="If-None-Match", required=false) String etag) throws ThingsboardException {
        return this.downloadResourceIfChanged(strResourceId, etag);
    }

    @ApiOperation(value="Get Resource Info (getResourceInfoById)", notes="Fetch the Resource Info object based on the provided Resource Id. Resource Info is a lightweight object that includes main information about the Resource excluding the heavyweight data. \n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @GetMapping(value={"/resource/info/{resourceId}"})
    public TbResourceInfo getResourceInfoById(@Parameter(description="A string value representing the resource id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="resourceId") String strResourceId) throws ThingsboardException {
        TbResourceController.checkParameter((String)"resourceId", (String)strResourceId);
        TbResourceId resourceId = new TbResourceId(this.toUUID(strResourceId));
        return this.checkResourceInfoId(resourceId, Operation.READ);
    }

    @ApiOperation(value="Get resource info (getResourceInfo)", notes="Get info for the resource with the given type, scope and key. Resource Info is a lightweight object that includes main information about the Resource excluding the heavyweight data. \n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @GetMapping(value={"/resource/{resourceType}/{scope}/{key}/info"})
    public TbResourceInfo getResourceInfo(@Parameter(description="Type of the resource", schema=@Schema(allowableValues={"lwm2m_model", "jks", "pkcs_12", "js_module", "dashboard"})) @PathVariable(value="resourceType") String resourceTypeStr, @Parameter(description="Scope of the resource", schema=@Schema(allowableValues={"system", "tenant"})) @PathVariable String scope, @Parameter(description="Key of the resource, e.g. 'extension.js'") @PathVariable String key) throws ThingsboardException {
        ResourceType resourceType = ResourceType.valueOf((String)resourceTypeStr.toUpperCase());
        return this.checkResourceInfo(scope, resourceType, key, Operation.READ);
    }

    @ApiOperation(value="Get Resource (getResourceById)", notes="Fetch the Resource object based on the provided Resource Id. Resource is a heavyweight object that includes main information about the Resource and also data. \n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.", hidden=true)
    @Deprecated
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @GetMapping(value={"/resource/{resourceId}"})
    public TbResource getResourceById(@Parameter(description="A string value representing the resource id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="resourceId") String strResourceId) throws ThingsboardException {
        TbResourceController.checkParameter((String)"resourceId", (String)strResourceId);
        TbResourceId resourceId = new TbResourceId(this.toUUID(strResourceId));
        return this.checkResourceId(resourceId, Operation.READ);
    }

    @ApiOperation(value="Create Or Update Resource (saveResource)", notes="Create or update the Resource. When creating the Resource, platform generates Resource id as [time-based UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_1_(date-time_and_MAC_address)). The newly created Resource id will be present in the response. Specify existing Resource id to update the Resource. Referencing non-existing Resource Id will cause 'Not Found' error. \n\nResource combination of the title with the key is unique in the scope of tenant. Remove 'id', 'tenantId' from the request body example (below) to create new Resource entity.\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @Deprecated
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @PostMapping(value={"/resource"})
    public TbResourceInfo saveResource(@Parameter(description="A JSON value representing the Resource.") @RequestBody TbResource resource) throws Exception {
        resource.setTenantId(this.getTenantId());
        this.checkEntity((EntityId)resource.getId(), (TenantEntity)resource, Resource.TB_RESOURCE);
        return this.tbResourceService.save(resource, this.getCurrentUser());
    }

    @ApiOperation(value="Upload Resource via Multipart File (uploadResource)", notes="Create the Resource using multipart file upload. \n\nResource combination of the title with the key is unique in the scope of tenant. \n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @PostMapping(value={"/resource/upload"}, consumes={"multipart/form-data"})
    public TbResourceInfo uploadResource(@Parameter(description="Resource title.", example="Title") @RequestPart(name="title", required=false) String title, @Parameter(description="Resource type.") @RequestPart(name="resourceType") String resourceTypeStr, @Parameter(description="Resource descriptor (JSON).") @RequestPart(name="descriptor", required=false) String descriptor, @Parameter(description="Resource sub type.") @RequestPart(name="resourceSubType", required=false) String resourceSubTypeStr, @Parameter(description="Resource file.") @RequestPart MultipartFile file) throws Exception {
        TbResource resource = new TbResource();
        resource.setTenantId(this.getTenantId());
        resource.setTitle(StringUtils.isNotEmpty((CharSequence)title) ? title : file.getOriginalFilename());
        ResourceType resourceType = ResourceType.valueOf((String)resourceTypeStr);
        resource.setResourceType(resourceType);
        if (StringUtils.isNotEmpty((CharSequence)descriptor)) {
            resource.setDescriptor(JacksonUtil.toJsonNode((String)descriptor));
        } else {
            String mediaType = resourceType.getMediaType() != null ? resourceType.getMediaType() : file.getContentType();
            resource.setDescriptor((JsonNode)JacksonUtil.newObjectNode().put("mediaType", mediaType));
        }
        if (StringUtils.isNotEmpty((CharSequence)resourceSubTypeStr)) {
            resource.setResourceSubType(ResourceSubType.valueOf((String)resourceSubTypeStr));
        }
        resource.setFileName(file.getOriginalFilename());
        resource.setData(file.getBytes());
        this.checkEntity((EntityId)resource.getId(), (TenantEntity)resource, Resource.TB_RESOURCE);
        return this.tbResourceService.save(resource, this.getCurrentUser());
    }

    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @PutMapping(value={"/resource/{id}/data"}, consumes={"multipart/form-data"})
    public TbResourceInfo updateResourceData(@Parameter(description="Unique identifier of the Resource to update", required=true) @PathVariable UUID id, @Parameter(description="Resource file.") @RequestPart MultipartFile file) throws Exception {
        TbResourceId tbResourceId = new TbResourceId(id);
        TbResource resource = this.checkResourceId(tbResourceId, Operation.WRITE);
        resource.setFileName(file.getOriginalFilename());
        resource.setData(file.getBytes());
        return this.tbResourceService.save(resource, this.getCurrentUser());
    }

    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @PutMapping(value={"/resource/{id}/info"})
    public TbResourceInfo updateResourceInfo(@Parameter(description="Unique identifier of the Resource to update", required=true) @PathVariable UUID id, @Parameter(description="A JSON value representing the Resource Info.") @RequestBody TbResourceInfo resourceInfo) throws Exception {
        TbResourceId tbResourceId = new TbResourceId(id);
        this.checkResourceInfoId(tbResourceId, Operation.WRITE);
        resourceInfo.setId((UUIDBased)tbResourceId);
        TbResource resource = new TbResource(resourceInfo);
        return this.tbResourceService.save(resource, this.getCurrentUser());
    }

    @ApiOperation(value="Get Resource Infos (getResources)", notes="Returns a page of Resource Info objects owned by tenant or sysadmin. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. Resource Info is a lightweight object that includes main information about the Resource excluding the heavyweight data. \n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @GetMapping(value={"/resource"})
    public PageData<TbResourceInfo> getResources(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="A string value representing the resource type.", schema=@Schema(allowableValues={"LWM2M_MODEL", "JKS", "PKCS_12", "JS_MODULE"})) @RequestParam(required=false) String resourceType, @Parameter(description="A string value representing the resource sub-type.", schema=@Schema(allowableValues={"EXTENSION", "MODULE"})) @RequestParam(required=false) String resourceSubType, @Parameter(description="The case insensitive 'substring' filter based on the resource title.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "title", "resourceType", "tenantId"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.TB_RESOURCE, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        TbResourceInfoFilter.TbResourceInfoFilterBuilder filter = TbResourceInfoFilter.builder();
        filter.tenantId(this.getTenantId());
        HashSet<ResourceType> resourceTypes = new HashSet<ResourceType>();
        if (StringUtils.isNotEmpty((CharSequence)resourceType)) {
            resourceTypes.add(ResourceType.valueOf((String)resourceType));
            if (StringUtils.isNotEmpty((CharSequence)resourceSubType)) {
                filter.resourceSubTypes(Set.of(ResourceSubType.valueOf((String)resourceSubType)));
            }
        } else {
            Collections.addAll(resourceTypes, ResourceType.values());
            resourceTypes.remove(ResourceType.JS_MODULE);
            resourceTypes.remove(ResourceType.IMAGE);
            resourceTypes.remove(ResourceType.DASHBOARD);
        }
        filter.resourceTypes(resourceTypes);
        if (Authority.SYS_ADMIN.equals((Object)this.getCurrentUser().getAuthority())) {
            return (PageData)this.checkNotNull((Object)this.resourceService.findTenantResourcesByTenantId(filter.build(), pageLink));
        }
        return (PageData)this.checkNotNull((Object)this.resourceService.findAllTenantResourcesByTenantId(filter.build(), pageLink));
    }

    @ApiOperation(value="Get Resource Infos by ids (getSystemOrTenantResourcesByIds)")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @GetMapping(value={"/resource"}, params={"resourceIds"})
    public List<TbResourceInfo> getSystemOrTenantResourcesByIds(@Parameter(description="A list of resource ids, separated by comma ','", array=@ArraySchema(schema=@Schema(type="string"))) @RequestParam(value="resourceIds") Set<UUID> resourceUuids) throws ThingsboardException {
        SecurityUser user = this.getCurrentUser();
        ArrayList<TbResourceId> resourceIds = new ArrayList<TbResourceId>();
        for (UUID resourceId : resourceUuids) {
            resourceIds.add(new TbResourceId(resourceId));
        }
        List resources = this.resourceService.findSystemOrTenantResourcesByIds(user.getTenantId(), resourceIds);
        for (TbResourceInfo resourceInfo : resources) {
            this.checkEntity(user, (HasId)resourceInfo, Operation.READ);
        }
        return resources;
    }

    @ApiOperation(value="Get All Resource Infos (getAllResources)", notes="Returns a page of Resource Info objects owned by tenant. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. Resource Info is a lightweight object that includes main information about the Resource excluding the heavyweight data. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/resource/tenant"})
    public PageData<TbResourceInfo> getTenantResources(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the resource title.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "title", "resourceType", "tenantId"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.TB_RESOURCE, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        TbResourceInfoFilter filter = TbResourceInfoFilter.builder().tenantId(this.getTenantId()).resourceTypes(EnumSet.allOf(ResourceType.class)).build();
        return (PageData)this.checkNotNull((Object)this.resourceService.findTenantResourcesByTenantId(filter, pageLink));
    }

    @ApiOperation(value="Get LwM2M Objects (getLwm2mListObjectsPage)", notes="Returns a page of LwM2M objects parsed from Resources with type 'LWM2M_MODEL' owned by tenant or sysadmin. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. LwM2M Object is a object that includes information about the LwM2M model which can be used in transport configuration for the LwM2M device profile. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/resource/lwm2m/page"})
    public List<LwM2mObject> getLwm2mListObjectsPage(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the resource title.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"id", "name"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        PageLink pageLink = new PageLink(pageSize, page, textSearch);
        return (List)this.checkNotNull((Object)this.tbResourceService.findLwM2mObjectPage(this.getTenantId(), sortProperty, sortOrder, pageLink));
    }

    @ApiOperation(value="Get LwM2M Objects (getLwm2mListObjects)", notes="Returns a page of LwM2M objects parsed from Resources with type 'LWM2M_MODEL' owned by tenant or sysadmin. You can specify parameters to filter the results. LwM2M Object is a object that includes information about the LwM2M model which can be used in transport configuration for the LwM2M device profile. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/resource/lwm2m"})
    public List<LwM2mObject> getLwm2mListObjects(@Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"}, requiredMode=Schema.RequiredMode.REQUIRED)) @RequestParam String sortOrder, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"id", "name"}, requiredMode=Schema.RequiredMode.REQUIRED)) @RequestParam String sortProperty, @Parameter(description="LwM2M Object ids.", array=@ArraySchema(schema=@Schema(type="string")), required=true) @RequestParam(required=false) String[] objectIds) throws ThingsboardException {
        return (List)this.checkNotNull((Object)this.tbResourceService.findLwM2mObject(this.getTenantId(), sortOrder, sortProperty, objectIds));
    }

    @ApiOperation(value="Delete Resource (deleteResource)", notes="Deletes the Resource. Referencing non-existing Resource Id will cause an error.\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @DeleteMapping(value={"/resource/{resourceId}"})
    public ResponseEntity<TbResourceDeleteResult> deleteResource(@Parameter(description="A string value representing the resource id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="resourceId") String strResourceId, @RequestParam(name="force", required=false) boolean force) throws ThingsboardException {
        TbResourceController.checkParameter((String)"resourceId", (String)strResourceId);
        TbResourceId resourceId = new TbResourceId(this.toUUID(strResourceId));
        TbResource tbResource = this.checkResourceId(resourceId, Operation.DELETE);
        TbResourceDeleteResult tbResourceDeleteResult = this.tbResourceService.delete((TbResourceInfo)tbResource, force, (User)this.getCurrentUser());
        return (tbResourceDeleteResult.isSuccess() ? ResponseEntity.ok() : ResponseEntity.badRequest()).body((Object)tbResourceDeleteResult);
    }

    private ResponseEntity<ByteArrayResource> downloadResourceIfChanged(String strResourceId, String etag) throws ThingsboardException {
        TbResourceController.checkParameter((String)"resourceId", (String)strResourceId);
        TbResourceId resourceId = new TbResourceId(this.toUUID(strResourceId));
        return this.downloadResourceIfChanged(() -> this.checkResourceInfoId(resourceId, Operation.READ), etag);
    }

    private ResponseEntity<ByteArrayResource> downloadResourceIfChanged(ThrowingSupplier<TbResourceInfo> resourceInfoProvider, String etag) throws ThingsboardException {
        TbResourceInfo resourceInfo = (TbResourceInfo)resourceInfoProvider.get();
        if (etag != null && (etag = StringUtils.remove((String)etag, (char)'\"')).equals(resourceInfo.getEtag())) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_MODIFIED).eTag(resourceInfo.getEtag())).build();
        }
        byte[] data = this.resourceService.getResourceData(resourceInfo.getTenantId(), resourceInfo.getId());
        ByteArrayResource resource = new ByteArrayResource(data);
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment;filename=" + resourceInfo.getFileName()})).header("x-filename", new String[]{resourceInfo.getFileName()})).contentLength(resource.contentLength()).header("Content-Type", new String[]{resourceInfo.getResourceType().getMediaType()})).cacheControl(CacheControl.noCache())).eTag(resourceInfo.getEtag())).body((Object)resource);
    }

    private TbResourceInfo checkResourceInfo(String scope, ResourceType resourceType, String key, Operation operation) throws ThingsboardException {
        TenantId tenantId;
        if (scope.equals("tenant")) {
            tenantId = this.getTenantId();
        } else if (scope.equals("system")) {
            tenantId = TenantId.SYS_TENANT_ID;
        } else {
            throw new IllegalArgumentException("Invalid scope");
        }
        TbResourceInfo resourceInfo = this.resourceService.findResourceInfoByTenantIdAndKey(tenantId, resourceType, key);
        this.checkEntity(this.getCurrentUser(), (HasId)((TbResourceInfo)this.checkNotNull((Object)resourceInfo)), operation);
        return resourceInfo;
    }

    @ConstructorProperties(value={"tbResourceService"})
    @Generated
    public TbResourceController(TbResourceService tbResourceService) {
        this.tbResourceService = tbResourceService;
    }
}

