/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseServiceClient;
import com.google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseServiceSettings;
import com.google.recaptchaenterprise.v1.Assessment;
import com.google.recaptchaenterprise.v1.CreateAssessmentRequest;
import com.google.recaptchaenterprise.v1.Event;
import com.google.recaptchaenterprise.v1.ProjectName;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.MailService;
import org.thingsboard.rule.engine.api.NotificationCenter;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.NotificationTargetId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.mobile.app.MobileApp;
import org.thingsboard.server.common.data.mobile.bundle.MobileAppBundle;
import org.thingsboard.server.common.data.notification.NotificationType;
import org.thingsboard.server.common.data.notification.info.NotificationInfo;
import org.thingsboard.server.common.data.oauth2.PlatformType;
import org.thingsboard.server.common.data.permission.GroupPermission;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.common.data.security.UserCredentials;
import org.thingsboard.server.common.data.security.model.JwtPair;
import org.thingsboard.server.common.data.selfregistration.AbstractCaptchaParams;
import org.thingsboard.server.common.data.selfregistration.CaptchaParams;
import org.thingsboard.server.common.data.selfregistration.EnterpriseCaptchaParams;
import org.thingsboard.server.common.data.selfregistration.MobileRedirectParams;
import org.thingsboard.server.common.data.selfregistration.MobileSelfRegistrationParams;
import org.thingsboard.server.common.data.selfregistration.SelfRegistrationParams;
import org.thingsboard.server.common.data.selfregistration.SignUpField;
import org.thingsboard.server.common.data.selfregistration.SignUpFieldId;
import org.thingsboard.server.common.data.selfregistration.V2CaptchaParams;
import org.thingsboard.server.common.data.selfregistration.V3CaptchaParams;
import org.thingsboard.server.common.data.selfregistration.WebSelfRegistrationParams;
import org.thingsboard.server.common.data.signup.SignUpRequest;
import org.thingsboard.server.common.data.signup.SignUpResult;
import org.thingsboard.server.common.data.wl.WhiteLabeling;
import org.thingsboard.server.common.data.wl.WhiteLabelingType;
import org.thingsboard.server.config.SignUpConfig;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.dao.service.DataValidator;
import org.thingsboard.server.data.RecaptchaValidationResult;
import org.thingsboard.server.exception.DataValidationException;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.security.auth.rest.RestAuthenticationDetails;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.model.UserPrincipal;
import org.thingsboard.server.service.security.model.token.JwtTokenFactory;
import org.thingsboard.server.service.security.system.SystemSecurityService;
import org.thingsboard.server.utils.MiscUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class SignUpController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SignUpController.class);
    private static final String SELF_REGISTRATION_SETTINGS_WAS_NOT_FOUND = "Self registration settings was not found";
    private static final String SELF_REGISTRATION_SETTINGS_IS_NOT_ALLOWED = "Self registration is not allowed";
    private static final String WL_SETTINGS_WAS_NOT_FOUND = "White labeling settings was not found";
    private static final String INVALID_APP_SECRET = "Invalid Application Secret!";
    private static final String MOBILE_APP_BUNDLE_WAS_NOT_FOUND = "Mobile app bundle was not found";
    private static final String PRIVACY_POLICY_ACCEPTED = "privacyPolicyAccepted";
    private static final String TERMS_OF_USE_ACCEPTED = "termsOfUseAccepted";
    private RestTemplate restTemplate;
    @Autowired
    private SignUpConfig signUpConfig;
    @Autowired
    private MailService mailService;
    @Autowired
    private NotificationCenter notificationCenter;
    @Autowired
    private BCryptPasswordEncoder passwordEncoder;
    @Autowired
    private JwtTokenFactory tokenFactory;
    @Autowired
    private SystemSecurityService systemSecurityService;

    @PostConstruct
    public void init() throws Exception {
        this.restTemplate = new RestTemplate();
    }

    @ApiOperation(value="User Sign Up (signUp)", notes="Process user sign up request. Creates the Customer and corresponding User based on self Registration parameters for the domain. See [Self Registration Controller](/swagger-ui.html#/self-registration-controller) for more details.  The result is either 'SUCCESS' or 'INACTIVE_USER_EXISTS'. If Success, the user will receive an email with instruction to activate the account. The content of the email is customizable via the mail templates.")
    @PostMapping(value={"/noauth/signup"})
    public SignUpResult signUp(@Parameter(description="A JSON value representing the signup request.", required=true) @RequestBody SignUpRequest signUpRequest, HttpServletRequest request) throws ThingsboardException, IOException {
        TenantId tenantId;
        SelfRegistrationParams selfRegistrationParams;
        if (!StringUtils.isEmpty((String)signUpRequest.getPkgName())) {
            this.validateAppSecret(signUpRequest);
            MobileAppBundle mobileAppBundle = this.checkMobileSRSettings(signUpRequest.getPkgName(), signUpRequest.getPlatform());
            selfRegistrationParams = mobileAppBundle.getSelfRegistrationParams();
            tenantId = mobileAppBundle.getTenantId();
        } else {
            WhiteLabeling whiteLabeling = this.checkWebSRSettings(request.getServerName());
            selfRegistrationParams = (SelfRegistrationParams)JacksonUtil.treeToValue((JsonNode)whiteLabeling.getSettings(), WebSelfRegistrationParams.class);
            tenantId = whiteLabeling.getTenantId();
        }
        this.validateSelfRegistrationAllowed(selfRegistrationParams);
        this.validateRequiredFields(signUpRequest, selfRegistrationParams);
        String email = (String)signUpRequest.getFields().get(SignUpFieldId.EMAIL);
        String firstName = (String)signUpRequest.getFields().get(SignUpFieldId.FIRST_NAME);
        String lastName = (String)signUpRequest.getFields().get(SignUpFieldId.LAST_NAME);
        String password = (String)signUpRequest.getFields().get(SignUpFieldId.PASSWORD);
        CaptchaParams captcha = selfRegistrationParams.getCaptcha();
        if (captcha instanceof EnterpriseCaptchaParams) {
            EnterpriseCaptchaParams captchaParams = (EnterpriseCaptchaParams)captcha;
            this.validateEnterpriseReCaptcha(signUpRequest, request, captchaParams);
        } else if (captcha instanceof V2CaptchaParams || captcha instanceof V3CaptchaParams) {
            this.validateReCaptcha(signUpRequest.getRecaptchaResponse(), request.getRemoteAddr(), ((AbstractCaptchaParams)captcha).getSecretKey());
        } else {
            throw new DataValidationException("Error validating captcha: wrong captcha version");
        }
        DataValidator.validateEmail((String)email);
        User existingUser = this.userService.findUserByEmail(tenantId, email);
        if (existingUser != null) {
            UserCredentials credentials = this.userService.findUserCredentialsByUserId(tenantId, existingUser.getId());
            if (credentials.isEnabled()) {
                throw new DataValidationException("User with email '" + existingUser.getEmail() + "'  is already registered!");
            }
            return SignUpResult.INACTIVE_USER_EXISTS;
        }
        this.systemSecurityService.validatePassword(password, null);
        Customer savedCustomer = this.createCustomer(signUpRequest, selfRegistrationParams, tenantId);
        EntityGroup savedUsersGroup = this.createCustomerUserGroup(selfRegistrationParams, savedCustomer);
        User savedUser = this.createUser(signUpRequest, selfRegistrationParams, savedCustomer);
        this.entityGroupService.addEntityToEntityGroup(tenantId, savedUsersGroup.getId(), (EntityId)savedUser.getId());
        UserCredentials savedUserCredentials = this.saveUserCredentials(savedUser, signUpRequest);
        try {
            this.sendEmailVerification(tenantId, request, savedUserCredentials, email, null, signUpRequest.getPkgName(), signUpRequest.getPlatform());
        }
        catch (ThingsboardException e) {
            this.customerService.deleteCustomer(tenantId, savedCustomer.getId());
            throw e;
        }
        this.sendUserActivityNotification(tenantId, NotificationType.USER_REGISTERED, Optional.ofNullable(firstName).orElse("") + " " + Optional.ofNullable(lastName).orElse(""), email, selfRegistrationParams.getNotificationRecipient());
        this.logEntityActionService.logEntityAction(tenantId, (EntityId)savedCustomer.getId(), (HasName)savedCustomer, savedCustomer.getId(), ActionType.ADDED, null, new Object[0]);
        this.logEntityActionService.logEntityAction(tenantId, (EntityId)savedUser.getId(), (HasName)savedUser, savedUser.getCustomerId(), ActionType.ADDED, null, new Object[0]);
        this.logEntityActionService.logEntityAction(tenantId, (EntityId)savedUser.getId(), (HasName)savedUser, savedCustomer.getId(), ActionType.ADDED_TO_ENTITY_GROUP, null, new Object[]{savedUsersGroup.toString(), savedUsersGroup.getName()});
        return SignUpResult.SUCCESS;
    }

    private void sendEmailVerification(TenantId tenantId, HttpServletRequest request, UserCredentials userCredentials, String targetEmail, String baseUrl, String pkgName, PlatformType platformType) throws ThingsboardException {
        if (baseUrl == null) {
            baseUrl = MiscUtils.constructBaseUrl((HttpServletRequest)request);
        }
        String activationLink = String.format("%s/api/noauth/activateEmail?emailCode=%s", baseUrl, userCredentials.getActivateToken());
        if (!StringUtils.isEmpty((String)pkgName)) {
            this.checkNotNull((Object)platformType);
            activationLink = String.format("%s&pkgName=%s&platform=%s", activationLink, pkgName, platformType);
        }
        try {
            this.mailService.sendActivationEmail(tenantId, activationLink, userCredentials.getActivationTokenTtl(), targetEmail);
        }
        catch (Exception e) {
            throw new ThingsboardException("Temporarily unable to send activation email", ThingsboardErrorCode.GENERAL);
        }
    }

    private void sendUserActivityNotification(TenantId tenantId, NotificationType notificationType, String userFullName, String userEmail, NotificationTargetId recipient) {
        if (recipient == null) {
            return;
        }
        try {
            NotificationInfo notificationInfo;
            if (notificationType == NotificationType.USER_ACTIVATED) {
                notificationInfo = NotificationInfo.userActivated((String)userFullName, (String)userEmail);
            } else if (notificationType == NotificationType.USER_REGISTERED) {
                notificationInfo = NotificationInfo.userRegistered((String)userFullName, (String)userEmail);
            } else {
                return;
            }
            this.notificationCenter.sendSystemNotification(tenantId, recipient, notificationType, notificationInfo);
        }
        catch (Exception e) {
            log.error("Failed to send {} notification about user {}", new Object[]{notificationType, userEmail, e});
        }
    }

    @ApiOperation(value="Resend Activation Email (resendEmailActivation)", notes="Request to resend the activation email for the user. Checks that user was not activated yet.")
    @PostMapping(value={"/noauth/resendEmailActivation"})
    public void resendEmailActivation(@Parameter(description="Email of the user.", required=true, example="john.doe@company.com") @RequestParam(value="email") String email, @Parameter(description="Optional package name of the mobile application.") @RequestParam(required=false) String pkgName, @Parameter(description="Platform type", schema=@Schema(allowableValues={"ANDROID", "IOS"})) @RequestParam(required=false) PlatformType platform, HttpServletRequest request) throws ThingsboardException {
        UserCredentials credentials;
        TenantId tenantId;
        if (!StringUtils.isEmpty((String)pkgName)) {
            MobileAppBundle mobileAppBundle = this.checkMobileSRSettings(pkgName, platform);
            tenantId = mobileAppBundle.getTenantId();
        } else {
            WhiteLabeling whiteLabeling = this.checkWebSRSettings(request.getServerName());
            tenantId = whiteLabeling.getTenantId();
        }
        User existingUser = this.userService.findUserByEmail(TenantId.SYS_TENANT_ID, email);
        if (existingUser != null) {
            credentials = this.userService.findUserCredentialsByUserId(existingUser.getTenantId(), existingUser.getId());
            if (credentials.isEnabled()) {
                throw new DataValidationException("User with email '" + existingUser.getEmail() + "'  is already active!");
            }
        } else {
            throw new DataValidationException("User with email '" + email + "'  is not registered!");
        }
        credentials = this.userService.checkUserActivationToken(tenantId, credentials);
        this.sendEmailVerification(tenantId, request, credentials, email, null, pkgName, platform);
    }

    @ApiOperation(value="Activate User using code from Email (activateEmail)", notes="Activate the user using code(link) from the activation email. Validates the code an redirects according to the signup flow. Checks that user was not activated yet.")
    @GetMapping(value={"/noauth/activateEmail"}, params={"emailCode"})
    public ResponseEntity<String> activateEmail(@Parameter(description="Activation token.", required=true) @RequestParam(value="emailCode") String emailCode, @Parameter(description="Optional package name of the mobile application.") @RequestParam(required=false) String pkgName, @Parameter(description="Platform type", schema=@Schema(allowableValues={"ANDROID", "IOS"})) @RequestParam(required=false) PlatformType platform, HttpServletRequest request) {
        HttpStatus responseStatus;
        HttpHeaders headers = new HttpHeaders();
        UserCredentials userCredentials = this.userService.findUserCredentialsByActivateToken(TenantId.SYS_TENANT_ID, emailCode);
        if (userCredentials != null) {
            Object emailVerifiedURI = null;
            try {
                if (!StringUtils.isEmpty((String)pkgName)) {
                    MobileAppBundle mobileAppBundle = this.checkMobileSRSettings(pkgName, platform);
                    MobileRedirectParams redirect = mobileAppBundle.getSelfRegistrationParams().getRedirect();
                    emailVerifiedURI = redirect.getScheme() + "://" + redirect.getHost() + "/signup/emailVerified";
                } else {
                    emailVerifiedURI = "/signup/emailVerified";
                }
                URI location = new URI((String)emailVerifiedURI + "?emailCode=" + emailCode);
                headers.setLocation(location);
                responseStatus = HttpStatus.PERMANENT_REDIRECT;
            }
            catch (URISyntaxException | ThingsboardException e) {
                log.error("Unable to create URI with address [{}]", emailVerifiedURI);
                responseStatus = HttpStatus.BAD_REQUEST;
            }
        } else {
            responseStatus = HttpStatus.CONFLICT;
        }
        return new ResponseEntity((MultiValueMap)headers, (HttpStatusCode)responseStatus);
    }

    @ApiOperation(value="Mobile Login redirect (mobileLogin)", notes="This method generates redirect to the special link that is handled by mobile application. Useful for email verification flow on mobile app.")
    @GetMapping(value={"/noauth/login"}, params={"pkgName, platform"})
    public ResponseEntity<String> mobileLogin(@Parameter(description="Mobile app package name. Used to identify the application and build the redirect link.", required=true) @RequestParam(value="pkgName") String pkgName, @Parameter(description="Platform type", schema=@Schema(allowableValues={"ANDROID", "IOS"}), required=true) @RequestParam PlatformType platform) throws ThingsboardException {
        HttpStatus responseStatus;
        HttpHeaders headers = new HttpHeaders();
        MobileAppBundle mobileAppBundle = this.checkMobileSRSettings(pkgName, platform);
        MobileRedirectParams redirect = mobileAppBundle.getSelfRegistrationParams().getRedirect();
        String redirectURI = redirect.getScheme() + "://" + redirect.getHost() + "/login";
        try {
            URI location = new URI(redirectURI);
            headers.setLocation(location);
            responseStatus = HttpStatus.PERMANENT_REDIRECT;
        }
        catch (URISyntaxException e) {
            log.error("Unable to create URI with address [{}]", (Object)redirectURI);
            responseStatus = HttpStatus.BAD_REQUEST;
        }
        return new ResponseEntity((MultiValueMap)headers, (HttpStatusCode)responseStatus);
    }

    @ApiOperation(value="Activate and login using code from Email (activateUserByEmailCode)", notes="Activate the user using code(link) from the activation email and return the JWT Token. Sends the notification and email about user activation. Checks that user was not activated yet.")
    @PostMapping(value={"/noauth/activateByEmailCode"})
    public JwtPair activateUserByEmailCode(@Parameter(description="Activation token.", required=true) @RequestParam(value="emailCode") String emailCode, @Parameter(description="Optional package name of the mobile application.") @RequestParam(required=false) String pkgName, @Parameter(description="Platform type", schema=@Schema(allowableValues={"ANDROID", "IOS"})) @RequestParam(required=false) PlatformType platform, HttpServletRequest request) throws ThingsboardException {
        TenantId tenantId;
        MobileSelfRegistrationParams selfRegistrationParams;
        if (!StringUtils.isEmpty((String)pkgName)) {
            MobileAppBundle mobileAppBundle = this.checkMobileSRSettings(pkgName, platform);
            selfRegistrationParams = mobileAppBundle.getSelfRegistrationParams();
            tenantId = mobileAppBundle.getTenantId();
        } else {
            WhiteLabeling whiteLabeling = this.checkWebSRSettings(request.getServerName());
            selfRegistrationParams = (SelfRegistrationParams)JacksonUtil.treeToValue((JsonNode)whiteLabeling.getSettings(), WebSelfRegistrationParams.class);
            tenantId = whiteLabeling.getTenantId();
        }
        UserCredentials userCredentials = this.userService.findUserCredentialsByActivateToken(TenantId.SYS_TENANT_ID, emailCode);
        if (userCredentials == null) {
            throw new ThingsboardException("Invalid email code!", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        if (userCredentials.getPassword() == null) {
            throw new ThingsboardException("Unable to activate user!", ThingsboardErrorCode.PERMISSION_DENIED);
        }
        String encodedPassword = userCredentials.getPassword();
        UserCredentials credentials = this.userService.activateUserCredentials(TenantId.SYS_TENANT_ID, emailCode, encodedPassword);
        User user = this.userService.findUserById(TenantId.SYS_TENANT_ID, credentials.getUserId());
        this.setPrivacyPolicyAccepted(user);
        this.setTermsOfUseAccepted(user);
        user = this.userService.saveUser(tenantId, user);
        UserPrincipal principal = new UserPrincipal(UserPrincipal.Type.USER_NAME, user.getEmail());
        SecurityUser securityUser = new SecurityUser(user, credentials.isEnabled(), principal, this.getMergedUserPermissions(user, false));
        String baseUrl = MiscUtils.constructBaseUrl((HttpServletRequest)request);
        String loginUrl = !StringUtils.isEmpty((String)pkgName) ? String.format("%s/api/noauth/login?pkgName=%s", baseUrl, pkgName) : String.format("%s/login", baseUrl);
        String email = user.getEmail();
        try {
            this.mailService.sendAccountActivatedEmail(tenantId, loginUrl, email);
        }
        catch (Exception e) {
            log.warn("Unable to send account activated email for {}: {}", (Object)email, (Object)e.getMessage());
        }
        this.sendUserActivityNotification(tenantId, NotificationType.USER_ACTIVATED, user.getFirstName() + " " + user.getLastName(), email, selfRegistrationParams.getNotificationRecipient());
        this.systemSecurityService.logLoginAction(user, (Object)new RestAuthenticationDetails(request), ActionType.LOGIN, null);
        return this.tokenFactory.createTokenPair(securityUser);
    }

    private void setPrivacyPolicyAccepted(User user) {
        JsonNode additionalInfo = user.getAdditionalInfo();
        if (!(additionalInfo instanceof ObjectNode)) {
            additionalInfo = JacksonUtil.newObjectNode();
        }
        ((ObjectNode)additionalInfo).put("privacyPolicyAccepted", true);
        user.setAdditionalInfo(additionalInfo);
    }

    private boolean isPrivacyPolicyAccepted(User user) {
        JsonNode additionalInfo = user.getAdditionalInfo();
        if (additionalInfo != null && additionalInfo.has("privacyPolicyAccepted")) {
            return additionalInfo.get("privacyPolicyAccepted").asBoolean();
        }
        return false;
    }

    @ApiOperation(value="Check privacy policy (privacyPolicyAccepted)", notes="Checks that current user accepted the privacy policy.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/signup/privacyPolicyAccepted"})
    @ResponseBody
    public Boolean privacyPolicyAccepted() throws ThingsboardException {
        SecurityUser securityUser = this.getCurrentUser();
        User user = this.userService.findUserById(securityUser.getTenantId(), securityUser.getId());
        return this.isPrivacyPolicyAccepted(user);
    }

    @ApiOperation(value="Accept privacy policy (acceptPrivacyPolicy)", notes="Accept privacy policy by the current user.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/signup/acceptPrivacyPolicy"})
    public JsonNode acceptPrivacyPolicy() throws ThingsboardException {
        SecurityUser securityUser = this.getCurrentUser();
        User user = this.userService.findUserById(securityUser.getTenantId(), securityUser.getId());
        this.setPrivacyPolicyAccepted(user);
        user = this.userService.saveUser(securityUser.getTenantId(), user);
        UserPrincipal principal = new UserPrincipal(UserPrincipal.Type.USER_NAME, user.getEmail());
        securityUser = new SecurityUser(user, true, principal, this.getMergedUserPermissions(user, false));
        JwtPair tokenPair = this.tokenFactory.createTokenPair(securityUser);
        ObjectNode tokenObject = JacksonUtil.newObjectNode();
        tokenObject.put("token", tokenPair.getToken());
        tokenObject.put("refreshToken", tokenPair.getRefreshToken());
        return tokenObject;
    }

    private void setTermsOfUseAccepted(User user) {
        JsonNode additionalInfo = user.getAdditionalInfo();
        if (!(additionalInfo instanceof ObjectNode)) {
            additionalInfo = JacksonUtil.newObjectNode();
        }
        ((ObjectNode)additionalInfo).put("termsOfUseAccepted", true);
        user.setAdditionalInfo(additionalInfo);
    }

    private boolean isTermsOfUseAccepted(User user) {
        JsonNode additionalInfo = user.getAdditionalInfo();
        if (additionalInfo != null && additionalInfo.has("termsOfUseAccepted")) {
            return additionalInfo.get("termsOfUseAccepted").asBoolean();
        }
        return false;
    }

    @ApiOperation(value="Check Terms Of User (termsOfUseAccepted)", notes="Checks that current user accepted the privacy policy.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/signup/termsOfUseAccepted"})
    @ResponseBody
    public Boolean termsOfUseAccepted() throws ThingsboardException {
        SecurityUser securityUser = this.getCurrentUser();
        User user = this.userService.findUserById(securityUser.getTenantId(), securityUser.getId());
        return this.isTermsOfUseAccepted(user);
    }

    @ApiOperation(value="Accept Terms of Use (acceptTermsOfUse)", notes="Accept Terms of Use by the current user.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/signup/acceptTermsOfUse"})
    public JsonNode acceptTermsOfUse() throws ThingsboardException {
        SecurityUser securityUser = this.getCurrentUser();
        User user = this.userService.findUserById(securityUser.getTenantId(), securityUser.getId());
        this.setTermsOfUseAccepted(user);
        user = this.userService.saveUser(securityUser.getTenantId(), user);
        UserPrincipal principal = new UserPrincipal(UserPrincipal.Type.USER_NAME, user.getEmail());
        securityUser = new SecurityUser(user, true, principal, this.getMergedUserPermissions(user, false));
        JwtPair tokenPair = this.tokenFactory.createTokenPair(securityUser);
        ObjectNode tokenObject = JacksonUtil.newObjectNode();
        tokenObject.put("token", tokenPair.getToken());
        tokenObject.put("refreshToken", tokenPair.getRefreshToken());
        return tokenObject;
    }

    private void validateReCaptcha(String userResponse, String ipAddress, String recaptchaSecretKey) throws ThingsboardException {
        SignUpController.checkParameter((String)"Recaptcha response", (String)userResponse);
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"secret", (Object)recaptchaSecretKey);
        parameters.add((Object)"response", (Object)userResponse);
        parameters.add((Object)"remoteip", (Object)ipAddress);
        log.debug("Validating reCAPTCHA:\n    verification url: {}\n    verification parameters: {}", (Object)this.signUpConfig.getRecaptchaVerificationUrl(), (Object)parameters);
        try {
            RecaptchaValidationResult result = (RecaptchaValidationResult)this.restTemplate.postForEntity(this.signUpConfig.getRecaptchaVerificationUrl(), (Object)parameters, RecaptchaValidationResult.class, new Object[0]).getBody();
            log.debug("reCAPTCHA validation finished: {}", (Object)result);
            if (result.isFailure()) {
                log.error("reCAPTCHA validation failed: {}", (Object)result);
                throw new DataValidationException("Invalid reCaptcha response!");
            }
        }
        catch (RestClientException ex) {
            log.error("Error validating reCAPTCHA. User response: [{}], verification URL: [{}]", (Object)userResponse, (Object)this.signUpConfig.getRecaptchaVerificationUrl());
            throw new ThingsboardException("Error validating reCAPTCHA", (Throwable)ex, ThingsboardErrorCode.GENERAL);
        }
    }

    private void validateEnterpriseReCaptcha(SignUpRequest signUpRequest, HttpServletRequest request, EnterpriseCaptchaParams captchaParams) throws IOException {
        try (RecaptchaEnterpriseServiceClient client = RecaptchaEnterpriseServiceClient.create((RecaptchaEnterpriseServiceSettings)((RecaptchaEnterpriseServiceSettings.Builder)RecaptchaEnterpriseServiceSettings.newBuilder().setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)ServiceAccountCredentials.fromStream((InputStream)new ByteArrayInputStream(captchaParams.getServiceAccountCredentials().getBytes()))))).build());){
            String siteKey;
            if (signUpRequest.getPlatform() == PlatformType.ANDROID) {
                siteKey = captchaParams.getAndroidKey();
            } else if (signUpRequest.getPlatform() == PlatformType.IOS) {
                siteKey = captchaParams.getIosKey();
            } else {
                log.error("Error validating reCAPTCHA. Wrong platform type: [{}]", (Object)signUpRequest.getPlatform());
                throw new DataValidationException("Error validating reCAPTCHA: platform could not be detected");
            }
            Event event = Event.newBuilder().setSiteKey(siteKey).setToken(signUpRequest.getRecaptchaResponse()).setUserIpAddress(request.getRemoteAddr()).setUserAgent(request.getHeader("User-Agent")).build();
            CreateAssessmentRequest createAssessmentRequest = CreateAssessmentRequest.newBuilder().setParent(ProjectName.of((String)captchaParams.getProjectId()).toString()).setAssessment(Assessment.newBuilder().setEvent(event).build()).build();
            Assessment response = client.createAssessment(createAssessmentRequest);
            if (!response.getTokenProperties().getValid()) {
                log.error("Error validating reCAPTCHA. Invalid reCaptcha response: [{}] ", (Object)response.getTokenProperties());
                throw new DataValidationException("Error validating reCAPTCHA: Invalid reCaptcha response");
            }
            if (!response.getTokenProperties().getAction().equals(captchaParams.getLogActionName())) {
                log.error("Error validating reCAPTCHA. Wrong recaptcha action name: [{}]", (Object)response.getTokenProperties().getAction());
                throw new DataValidationException("Error validating reCAPTCHA: recaptcha action name");
            }
            float recaptchaScore = response.getRiskAnalysis().getScore();
            if ((double)recaptchaScore < 0.95) {
                log.error("Error validating reCAPTCHA. Low score: [{}]", (Object)Float.valueOf(recaptchaScore));
                throw new DataValidationException("Error validating reCAPTCHA: score is low");
            }
        }
    }

    private void validateRequiredFields(SignUpRequest signUpRequest, SelfRegistrationParams selfRegistrationParams) throws ThingsboardException {
        Map signUpRequestFields = signUpRequest.getFields();
        List selfRegisterSignUpFields = selfRegistrationParams.getSignUpFields();
        if (selfRegisterSignUpFields != null) {
            for (SignUpField field : selfRegisterSignUpFields) {
                if (!field.isRequired() || !field.getId().isValidate()) continue;
                this.checkNotNull((Object)((String)signUpRequestFields.get(field.getId())));
            }
        } else {
            this.checkNotNull((Object)((String)signUpRequestFields.get(SignUpFieldId.EMAIL)));
            this.checkNotNull((Object)((String)signUpRequestFields.get(SignUpFieldId.PASSWORD)));
            this.checkNotNull((Object)((String)signUpRequestFields.get(SignUpFieldId.FIRST_NAME)));
            this.checkNotNull((Object)((String)signUpRequestFields.get(SignUpFieldId.LAST_NAME)));
        }
    }

    private EntityGroup createCustomerUserGroup(SelfRegistrationParams selfRegistrationParams, Customer savedCustomer) {
        TenantId tenantId = savedCustomer.getTenantId();
        EntityGroup usersEntityGroup = this.entityGroupService.findOrCreateUserGroup(tenantId, (EntityId)savedCustomer.getId(), "Self Registration Users", "Autogenerated Self Registration group");
        List permissions = selfRegistrationParams.getPermissions();
        for (GroupPermission permission : permissions) {
            permission.setTenantId(tenantId);
            permission.setUserGroupId(usersEntityGroup.getId());
            if (permission.getEntityGroupId() != null) {
                EntityGroup entityGroup = this.entityGroupService.findEntityGroupById(tenantId, permission.getEntityGroupId());
                if (entityGroup == null) continue;
                permission.setEntityGroupType(entityGroup.getType());
                this.groupPermissionService.saveGroupPermission(tenantId, permission);
                continue;
            }
            this.groupPermissionService.saveGroupPermission(tenantId, permission);
        }
        return usersEntityGroup;
    }

    private User createUser(SignUpRequest signUpRequest, SelfRegistrationParams selfRegistrationParams, Customer savedCustomer) throws ThingsboardException {
        User user = new User();
        Map signUpRequestFields = signUpRequest.getFields();
        user.setFirstName((String)signUpRequestFields.get(SignUpFieldId.FIRST_NAME));
        user.setLastName((String)signUpRequestFields.get(SignUpFieldId.LAST_NAME));
        user.setEmail((String)signUpRequestFields.get(SignUpFieldId.EMAIL));
        user.setPhone((String)signUpRequestFields.get(SignUpFieldId.PHONE));
        user.setAuthority(Authority.CUSTOMER_USER);
        user.setTenantId(savedCustomer.getTenantId());
        user.setCustomerId(savedCustomer.getId());
        ObjectNode objectNode = JacksonUtil.newObjectNode();
        objectNode.put("lang", "en_US");
        Optional.ofNullable(selfRegistrationParams.getDefaultDashboard()).ifPresent(dashboardParams -> {
            objectNode.put("defaultDashboardId", dashboardParams.getId());
            objectNode.put("defaultDashboardFullscreen", dashboardParams.isFullscreen());
        });
        Optional.ofNullable(selfRegistrationParams.getHomeDashboard()).ifPresent(homeDashboardParams -> {
            objectNode.put("homeDashboardId", homeDashboardParams.getId());
            objectNode.put("homeDashboardHideToolbar", homeDashboardParams.isHideToolbar());
        });
        user.setAdditionalInfo((JsonNode)objectNode);
        return (User)this.checkNotNull((Object)this.userService.saveUser(savedCustomer.getTenantId(), user));
    }

    private Customer createCustomer(SignUpRequest signUpRequest, SelfRegistrationParams selfRegistrationParams, TenantId tenantId) throws ThingsboardException {
        Customer customer = new Customer();
        customer.setTenantId(tenantId);
        String customerTitlePrefix = Optional.ofNullable(selfRegistrationParams.getCustomerTitlePrefix()).orElse("");
        Map signUpRequestFields = signUpRequest.getFields();
        customer.setTitle(customerTitlePrefix + (String)signUpRequestFields.get(SignUpFieldId.EMAIL));
        customer.setOwnerId((EntityId)tenantId);
        customer.setEmail((String)signUpRequestFields.get(SignUpFieldId.EMAIL));
        customer.setCountry((String)signUpRequestFields.get(SignUpFieldId.COUNTRY));
        customer.setState((String)signUpRequestFields.get(SignUpFieldId.STATE));
        customer.setCity((String)signUpRequestFields.get(SignUpFieldId.CITY));
        customer.setAddress((String)signUpRequestFields.get(SignUpFieldId.ADDRESS));
        customer.setAddress2((String)signUpRequestFields.get(SignUpFieldId.ADDRESS2));
        customer.setZip((String)signUpRequestFields.get(SignUpFieldId.ZIP));
        customer.setPhone((String)signUpRequestFields.get(SignUpFieldId.PHONE));
        customer.setCustomMenuId(selfRegistrationParams.getCustomMenuId());
        Customer savedCustomer = (Customer)this.checkNotNull((Object)this.customerService.saveCustomer(customer));
        if (selfRegistrationParams.getCustomerGroupId() != null) {
            this.entityGroupService.addEntityToEntityGroup(tenantId, selfRegistrationParams.getCustomerGroupId(), (EntityId)savedCustomer.getId());
        }
        return savedCustomer;
    }

    private UserCredentials saveUserCredentials(User savedUser, SignUpRequest signUpRequest) {
        UserCredentials userCredentials = this.userService.findUserCredentialsByUserId(savedUser.getTenantId(), savedUser.getId());
        userCredentials.setPassword(this.passwordEncoder.encode((CharSequence)signUpRequest.getFields().get(SignUpFieldId.PASSWORD)));
        this.userService.saveUserCredentials(savedUser.getTenantId(), userCredentials);
        return userCredentials;
    }

    private void validateAppSecret(SignUpRequest signUpRequest) {
        MobileApp mobileApp = this.mobileAppService.findMobileAppByPkgNameAndPlatformType(signUpRequest.getPkgName(), signUpRequest.getPlatform());
        if (StringUtils.isEmpty((String)signUpRequest.getAppSecret()) || !signUpRequest.getAppSecret().equals(mobileApp.getAppSecret())) {
            throw new DataValidationException("Invalid Application Secret!");
        }
    }

    private MobileAppBundle checkMobileSRSettings(String pkgName, PlatformType platform) throws ThingsboardException {
        MobileAppBundle mobileAppBundle = this.mobileAppBundleService.findMobileAppBundleByPkgNameAndPlatform(TenantId.SYS_TENANT_ID, pkgName, platform, false);
        this.checkNotNull((Object)mobileAppBundle, "Mobile app bundle was not found");
        this.checkNotNull((Object)mobileAppBundle.getSelfRegistrationParams(), "Self registration settings was not found");
        return mobileAppBundle;
    }

    private WhiteLabeling checkWebSRSettings(String domain) throws ThingsboardException {
        WhiteLabeling whiteLabeling = this.whiteLabelingService.findWhiteLabelingByDomainAndType(domain, WhiteLabelingType.SELF_REGISTRATION);
        this.checkNotNull((Object)whiteLabeling, "White labeling settings was not found");
        this.checkNotNull((Object)whiteLabeling.getSettings(), "Self registration settings was not found");
        return whiteLabeling;
    }

    private void validateSelfRegistrationAllowed(SelfRegistrationParams selfRegistrationParams) {
        if (selfRegistrationParams.getEnabled() != null && !selfRegistrationParams.getEnabled().booleanValue()) {
            throw new DataValidationException("Self registration is not allowed");
        }
    }
}

