/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.AbstractRpcController;
import org.thingsboard.server.queue.util.TbCoreComponent;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api/plugins/rpc"})
public class RpcV1Controller
extends AbstractRpcController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RpcV1Controller.class);

    @ApiOperation(value="Send one-way RPC request (handleOneWayDeviceRPCRequest)", notes="Deprecated. See 'Rpc V 2 Controller' instead.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/oneway/{deviceId}"}, method={RequestMethod.POST})
    @ResponseBody
    public DeferredResult<ResponseEntity> handleOneWayDeviceRPCRequest(@Parameter(description="A string value representing the device id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="deviceId") String deviceIdStr, @Parameter(description="A JSON value representing the RPC request.") @RequestBody String requestBody) throws ThingsboardException {
        return this.handleDeviceRPCRequest(true, new DeviceId(UUID.fromString(deviceIdStr)), requestBody, HttpStatus.REQUEST_TIMEOUT, HttpStatus.CONFLICT);
    }

    @ApiOperation(value="Send two-way RPC request (handleTwoWayDeviceRPCRequest)", notes="Deprecated. See 'Rpc V 2 Controller' instead.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/twoway/{deviceId}"}, method={RequestMethod.POST})
    @ResponseBody
    public DeferredResult<ResponseEntity> handleTwoWayDeviceRPCRequest(@Parameter(description="A string value representing the device id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="deviceId") String deviceIdStr, @Parameter(description="A JSON value representing the RPC request.") @RequestBody String requestBody) throws ThingsboardException {
        return this.handleDeviceRPCRequest(false, new DeviceId(UUID.fromString(deviceIdStr)), requestBody, HttpStatus.REQUEST_TIMEOUT, HttpStatus.CONFLICT);
    }
}

