/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RoleId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.common.data.role.Role;
import org.thingsboard.server.common.data.role.RoleType;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.AutoCommitController;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.security.model.SecurityUser;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class RoleController
extends AutoCommitController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RoleController.class);
    public static final String ROLE_ID = "roleId";
    public static final String ROLE_SHORT_DESCRIPTION = "Role Contains a set of permissions. Role has two types. Generic Role may be assigned to the user group and will provide permissions for all entities of a certain type. Group Role may be assigned to both user and entity group and will provides permissions only for the entities that belong to specified entity group. The assignment of the Role to the User Group is done using [Group Permission Controller](/swagger-ui.html#/group-permission-controller).";
    public static final String ROLE_PERMISSIONS_DESCRIPTION = "Example of Generic Role with read-only permissions for any resource and all permissions for the 'DEVICE' and 'PROFILE' resources is listed below: \n\n```json\n{\n  \"name\": \"Read-Only User\",\n  \"type\": \"GENERIC\",\n  \"permissions\": {\n    \"ALL\": [\n      \"READ\",\n      \"RPC_CALL\",\n      \"READ_CREDENTIALS\",\n      \"READ_ATTRIBUTES\",\n      \"READ_TELEMETRY\"\n    ],\n    \"DEVICE\": [\n      \"ALL\"\n    ]\n    \"PROFILE\": [\n      \"ALL\"\n    ]\n  },\n  \"additionalInfo\": {\n    \"description\": \"Read-only permissions for everything, Write permissions for devices and own profile.\"\n  }\n}\n```\n\nExample of Group Role with read-only permissions. Note that the group role has no association with the resources. The type of the resource is taken from the entity group that this role is assigned to: \n\n```json\n{\n  \"name\": \"Entity Group Read-only User\",\n  \"type\": \"GROUP\",\n  \"permissions\": [\n    \"READ\",\n    \"RPC_CALL\",\n    \"READ_CREDENTIALS\",\n    \"READ_ATTRIBUTES\",\n    \"READ_TELEMETRY\"\n  ],\n  \"additionalInfo\": {\n    \"description\": \"Read-only permissions.\"\n  }\n}\n```\n\n";

    @ApiOperation(value="Get Role by Id (getRoleById)", notes="Fetch the Role object based on the provided Role Id. Role Contains a set of permissions. Role has two types. Generic Role may be assigned to the user group and will provide permissions for all entities of a certain type. Group Role may be assigned to both user and entity group and will provides permissions only for the entities that belong to specified entity group. The assignment of the Role to the User Group is done using [Group Permission Controller](/swagger-ui.html#/group-permission-controller). Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/role/{roleId}"})
    public Role getRoleById(@Parameter(description="A string value representing the role id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="roleId") String strRoleId) throws ThingsboardException {
        RoleController.checkParameter((String)"roleId", (String)strRoleId);
        return this.checkRoleId(new RoleId(this.toUUID(strRoleId)), Operation.READ);
    }

    @ApiOperation(value="Create Or Update Role (saveRole)", notes="Creates or Updates the Role. When creating Role, platform generates Role Id as [time-based UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_1_(date-time_and_MAC_address)). The newly created Role id will be present in the response. Specify existing Role id to update the permission. Referencing non-existing Group Permission Id will cause 'Not Found' error.\n\nRole Contains a set of permissions. Role has two types. Generic Role may be assigned to the user group and will provide permissions for all entities of a certain type. Group Role may be assigned to both user and entity group and will provides permissions only for the entities that belong to specified entity group. The assignment of the Role to the User Group is done using [Group Permission Controller](/swagger-ui.html#/group-permission-controller).\n\nExample of Generic Role with read-only permissions for any resource and all permissions for the 'DEVICE' and 'PROFILE' resources is listed below: \n\n```json\n{\n  \"name\": \"Read-Only User\",\n  \"type\": \"GENERIC\",\n  \"permissions\": {\n    \"ALL\": [\n      \"READ\",\n      \"RPC_CALL\",\n      \"READ_CREDENTIALS\",\n      \"READ_ATTRIBUTES\",\n      \"READ_TELEMETRY\"\n    ],\n    \"DEVICE\": [\n      \"ALL\"\n    ]\n    \"PROFILE\": [\n      \"ALL\"\n    ]\n  },\n  \"additionalInfo\": {\n    \"description\": \"Read-only permissions for everything, Write permissions for devices and own profile.\"\n  }\n}\n```\n\nExample of Group Role with read-only permissions. Note that the group role has no association with the resources. The type of the resource is taken from the entity group that this role is assigned to: \n\n```json\n{\n  \"name\": \"Entity Group Read-only User\",\n  \"type\": \"GROUP\",\n  \"permissions\": [\n    \"READ\",\n    \"RPC_CALL\",\n    \"READ_CREDENTIALS\",\n    \"READ_ATTRIBUTES\",\n    \"READ_TELEMETRY\"\n  ],\n  \"additionalInfo\": {\n    \"description\": \"Read-only permissions.\"\n  }\n}\n```\n\n Security check is performed to verify that the user has 'WRITE' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/role"})
    public Role saveRole(@Parameter(description="A JSON value representing the role.", required=true) @RequestBody Role role) throws Exception {
        SecurityUser currentUser = this.getCurrentUser();
        try {
            role.setTenantId(currentUser.getTenantId());
            if (Authority.CUSTOMER_USER.equals((Object)currentUser.getAuthority())) {
                role.setCustomerId(currentUser.getCustomerId());
            }
            this.checkEntity((EntityId)role.getId(), (TenantEntity)role, Resource.ROLE);
            Role savedRole = (Role)this.checkNotNull((Object)this.roleService.saveRole(this.getTenantId(), role));
            this.autoCommit((User)currentUser, (EntityId)savedRole.getId());
            this.userPermissionsService.onRoleUpdated(savedRole);
            this.logEntityActionService.logEntityAction(this.getTenantId(), (EntityId)savedRole.getId(), (HasName)savedRole, role.getId() == null ? ActionType.ADDED : ActionType.UPDATED, (User)currentUser, new Object[0]);
            return savedRole;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(this.getTenantId(), this.emptyId(EntityType.ROLE), (HasName)role, role.getId() == null ? ActionType.ADDED : ActionType.UPDATED, (User)currentUser, e, new Object[0]);
            throw e;
        }
    }

    @ApiOperation(value="Delete role (deleteRole)", notes="Deletes the role. Referencing non-existing role Id will cause an error.\n\n Security check is performed to verify that the user has 'DELETE' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @DeleteMapping(value={"/role/{roleId}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteRole(@Parameter(description="A string value representing the role id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="roleId") String strRoleId) throws Exception {
        RoleController.checkParameter((String)"roleId", (String)strRoleId);
        try {
            RoleId roleId = new RoleId(this.toUUID(strRoleId));
            Role role = this.checkRoleId(roleId, Operation.DELETE);
            if (this.isUsed(role.getId(), this.getTenantId())) {
                throw new ThingsboardException("Role can't be deleted because it used by user group permissions!", ThingsboardErrorCode.INVALID_ARGUMENTS);
            }
            this.roleService.deleteRole(this.getTenantId(), roleId);
            this.logEntityActionService.logEntityAction(this.getTenantId(), (EntityId)roleId, (HasName)role, ActionType.DELETED, (User)this.getCurrentUser(), new Object[]{strRoleId});
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(this.getTenantId(), this.emptyId(EntityType.ROLE), ActionType.DELETED, (User)this.getCurrentUser(), e, new Object[]{strRoleId});
            throw e;
        }
    }

    private boolean isUsed(RoleId roleId, TenantId tenantId) {
        return this.groupPermissionService.findGroupPermissionByTenantIdAndRoleId(tenantId, roleId, new PageLink(1)).getTotalElements() > 0L;
    }

    @ApiOperation(value="Get Roles (getRoles)", notes="Returns a page of roles that are available for the current user. Role Contains a set of permissions. Role has two types. Generic Role may be assigned to the user group and will provide permissions for all entities of a certain type. Group Role may be assigned to both user and entity group and will provides permissions only for the entities that belong to specified entity group. The assignment of the Role to the User Group is done using [Group Permission Controller](/swagger-ui.html#/group-permission-controller).You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/roles"}, params={"pageSize", "page"})
    public PageData<Role> getRoles(@Parameter(description="Maximum amount of entities in a one page", required=true, schema=@Schema(minimum="1")) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true, schema=@Schema(minimum="0")) @RequestParam int page, @Parameter(description="Type of the role", schema=@Schema(allowableValues={"GENERIC", "GROUP"})) @RequestParam(required=false) String type, @Parameter(description="The case insensitive 'substring' filter based on the role name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "type", "description"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.ROLE, Operation.READ);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        if (StringUtils.isNotBlank((String)type)) {
            if (Authority.TENANT_ADMIN.equals((Object)this.getCurrentUser().getAuthority())) {
                return (PageData)this.checkNotNull((Object)this.roleService.findRolesByTenantIdAndType(tenantId, pageLink, RoleType.valueOf((String)type)));
            }
            return (PageData)this.checkNotNull((Object)this.roleService.findRolesByTenantIdAndCustomerIdAndType(tenantId, this.getCurrentUser().getCustomerId(), this.checkStrRoleType("type", type), pageLink));
        }
        if (Authority.TENANT_ADMIN.equals((Object)this.getCurrentUser().getAuthority())) {
            return (PageData)this.checkNotNull((Object)this.roleService.findRolesByTenantId(tenantId, pageLink));
        }
        return (PageData)this.checkNotNull((Object)this.roleService.findRolesByTenantIdAndCustomerId(tenantId, this.getCurrentUser().getCustomerId(), pageLink));
    }

    @ApiOperation(value="Get Roles By Ids (getRolesByIds)", notes="Returns the list of rows based on their ids. \n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/roles"}, params={"roleIds"})
    public List<Role> getRolesByIds(@Parameter(description="A list of role ids, separated by comma ','", array=@ArraySchema(schema=@Schema(type="string"))) @RequestParam(value="roleIds") String[] strRoleIds) throws Exception {
        this.checkArrayParameter("roleIds", strRoleIds);
        if (!this.accessControlService.hasPermission(this.getCurrentUser(), Resource.ROLE, Operation.READ)) {
            return Collections.emptyList();
        }
        SecurityUser user = this.getCurrentUser();
        TenantId tenantId = user.getTenantId();
        ArrayList<RoleId> roleIds = new ArrayList<RoleId>();
        for (String strRoleId : strRoleIds) {
            roleIds.add(new RoleId(this.toUUID(strRoleId)));
        }
        List roles = (List)this.checkNotNull((Object)((List)this.roleService.findRolesByIdsAsync(tenantId, roleIds).get()));
        return this.filterRolesByReadPermission(roles);
    }

    private List<Role> filterRolesByReadPermission(List<Role> roles) {
        return roles.stream().filter(role -> {
            try {
                return this.accessControlService.hasPermission(this.getCurrentUser(), Resource.ROLE, Operation.READ, (EntityId)role.getId(), (TenantEntity)role);
            }
            catch (ThingsboardException e) {
                return false;
            }
        }).toList();
    }
}

