/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.ReportTemplateId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.common.data.report.ReportTemplate;
import org.thingsboard.server.common.data.report.ReportTemplateInfo;
import org.thingsboard.server.common.data.report.ReportTemplateQuery;
import org.thingsboard.server.common.data.report.ReportTemplateType;
import org.thingsboard.server.common.data.report.TbReportFormat;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.report.TbReportTemplateService;
import org.thingsboard.server.service.security.model.SecurityUser;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class ReportTemplateController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReportTemplateController.class);
    private static final String REPORT_TEMPLATE_INFO_DESCRIPTION = "Report Templates allows you to create reports according to the report template configuration. Report service uses report template configuration to generate report. See the 'Model' tab of the Response Class for more details. ";
    private static final String REPORT_TEMPLATE_DESCRIPTION = "Report Template extends Report Template Info object and adds 'configuration' - a JSON structure of report template configuration. See the 'Model' tab of the Response Class for more details. ";
    private static final String REPORT_TEMPLATE_QUERY_TYPE_ARRAY_DESCRIPTION = "A list of string values separated by comma ',' representing one of the ReportTemplateType enumeration value.";
    private static final String REPORT_TEMPLATE_QUERY_FORMAT_ARRAY_DESCRIPTION = "A list of string values separated by comma ',' representing one of the TbReportFormat enumeration value.";
    private static final String INVALID_REPORT_TEMPLATE_ID = "Referencing non-existing Report Template Id will cause 'Not Found' error.";
    public static final String REPORT_TEMPLATE_ID = "reportTemplateId";
    private final TbReportTemplateService tbReportTemplateService;

    @ApiOperation(value="Get Report Template (getReportTemplateById)", notes="Fetch the ReportTemplate object based on the provided report template Id. Report Template extends Report Template Info object and adds 'configuration' - a JSON structure of report template configuration. See the 'Model' tab of the Response Class for more details. Referencing non-existing Report Template Id will cause 'Not Found' error.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.\n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/reportTemplate/{reportTemplateId}"})
    public ReportTemplate getReportTemplateById(@Parameter(description="A string value representing the report template id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="reportTemplateId") String strReportTemplateId) throws ThingsboardException {
        ReportTemplateController.checkParameter((String)"reportTemplateId", (String)strReportTemplateId);
        ReportTemplateId reportTemplateId = new ReportTemplateId(this.toUUID(strReportTemplateId));
        return this.checkReportTemplateId(reportTemplateId, Operation.READ);
    }

    @ApiOperation(value="Get Report Template Info (getReportTemplateInfoById)", notes="Fetch the ReportTemplateInfo object based on the provided report template Id. Report Templates allows you to create reports according to the report template configuration. Report service uses report template configuration to generate report. See the 'Model' tab of the Response Class for more details. Referencing non-existing Report Template Id will cause 'Not Found' error.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.\n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/reportTemplate/info/{reportTemplateId}"})
    public ReportTemplateInfo getReportTemplateInfoById(@Parameter(description="A string value representing the report template id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="reportTemplateId") String strReportTemplateId) throws ThingsboardException {
        ReportTemplateController.checkParameter((String)"reportTemplateId", (String)strReportTemplateId);
        ReportTemplateId reportTemplateId = new ReportTemplateId(this.toUUID(strReportTemplateId));
        return this.checkReportTemplateInfoId(reportTemplateId, Operation.READ);
    }

    @ApiOperation(value="Save Report Template (saveReportTemplate)", notes="Creates or Updates report template. Report Template extends Report Template Info object and adds 'configuration' - a JSON structure of report template configuration. See the 'Model' tab of the Response Class for more details. When creating report template, platform generates report template Id as [time-based UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_1_(date-time_and_MAC_address)). The newly created report template id will be present in the response. Specify existing report template id to update the report template. Referencing non-existing report template Id will cause 'Not Found' error. Remove 'id', 'tenantId' and optionally 'customerId' from the request body example (below) to create new Report Template entity. \n\nAvailable for users with 'TENANT_ADMIN' authority.\n\n Security check is performed to verify that the user has 'WRITE' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/reportTemplate"})
    public ReportTemplate saveReportTemplate(@Parameter(description="A JSON value representing the Report Template.") @RequestBody ReportTemplate reportTemplate) throws Exception {
        SecurityUser currentUser = this.getCurrentUser();
        reportTemplate.setTenantId(currentUser.getTenantId());
        if (Authority.CUSTOMER_USER.equals((Object)currentUser.getAuthority())) {
            reportTemplate.setCustomerId(currentUser.getCustomerId());
        }
        this.checkEntity((EntityId)reportTemplate.getId(), (TenantEntity)reportTemplate, Resource.REPORT_TEMPLATE);
        return this.tbReportTemplateService.save(reportTemplate, (User)currentUser);
    }

    @ApiOperation(value="Delete Report Template (deleteReportTemplate)", notes="Deletes the report template. Referencing non-existing Report Template Id will cause 'Not Found' error.\n\n Security check is performed to verify that the user has 'DELETE' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @DeleteMapping(value={"/reportTemplate/{reportTemplateId}"})
    public void deleteReportTemplate(@Parameter(description="A string value representing the report template id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="reportTemplateId") String strReportTemplateId) throws Exception {
        ReportTemplateController.checkParameter((String)"reportTemplateId", (String)strReportTemplateId);
        ReportTemplateId reportTemplateId = new ReportTemplateId(this.toUUID(strReportTemplateId));
        ReportTemplate reportTemplate = this.checkReportTemplateId(reportTemplateId, Operation.DELETE);
        this.tbReportTemplateService.delete(reportTemplate, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Get All Report Templates for current user (getAllReportTemplateInfos)", notes="Returns a page of report template info objects owned by the tenant or the customer of a current user. Report Templates allows you to create reports according to the report template configuration. Report service uses report template configuration to generate report. See the 'Model' tab of the Response Class for more details.  You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/reportTemplateInfos/all"}, params={"pageSize", "page"})
    public PageData<ReportTemplateInfo> getAllReportTemplateInfos(@Parameter(description="A list of string values separated by comma ',' representing one of the ReportTemplateType enumeration value.", array=@ArraySchema(schema=@Schema(type="string", allowableValues={"REPORT", "SUB_REPORT"}))) @RequestParam(required=false) String[] typeList, @Parameter(description="A list of string values separated by comma ',' representing one of the TbReportFormat enumeration value.", array=@ArraySchema(schema=@Schema(type="string", allowableValues={"PDF", "CSV"}))) @RequestParam(required=false) String[] formatList, @Parameter(description="Include customer or sub-customer entities") @RequestParam(required=false) Boolean includeCustomers, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the report template name or customer title.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "ownerName"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.REPORT_TEMPLATE, Operation.READ);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        ArrayList<ReportTemplateType> reportTemplateTypeList = new ArrayList<ReportTemplateType>();
        if (typeList != null) {
            for (String strType : typeList) {
                if (StringUtils.isEmpty((String)strType)) continue;
                reportTemplateTypeList.add(ReportTemplateType.valueOf((String)strType));
            }
        }
        ArrayList<TbReportFormat> reportTemplateFormatList = new ArrayList<TbReportFormat>();
        if (formatList != null) {
            for (String strFormat : formatList) {
                if (StringUtils.isEmpty((String)strFormat)) continue;
                reportTemplateFormatList.add(TbReportFormat.valueOf((String)strFormat));
            }
        }
        ReportTemplateQuery query = ReportTemplateQuery.builder().pageLink(pageLink).includeCustomers(includeCustomers != null && includeCustomers != false).formatList(reportTemplateFormatList).typeList(reportTemplateTypeList).build();
        if (Authority.TENANT_ADMIN.equals((Object)this.getCurrentUser().getAuthority())) {
            return (PageData)this.checkNotNull((Object)this.reportTemplateService.findReportTemplates(tenantId, query));
        }
        CustomerId customerId = this.getCurrentUser().getCustomerId();
        return (PageData)this.checkNotNull((Object)this.reportTemplateService.findCustomerReportTemplates(tenantId, customerId, query));
    }

    @ApiOperation(value="Get report templates by Report Template Ids (getReportTemplatesByIds)", notes="Returns a list of ReportTemplateInfo objects based on the provided ids. Filters the list based on the user permissions. \n\nAvailable for users with 'TENANT_ADMIN' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/reportTemplates"}, params={"reportTemplateIds"})
    public List<ReportTemplateInfo> getReportTemplatesByIds(@Parameter(description="A list of report template ids, separated by comma ','", array=@ArraySchema(schema=@Schema(type="string")), required=true) @RequestParam(value="reportTemplateIds") String[] strReportTemplateIds) throws ThingsboardException, ExecutionException, InterruptedException {
        this.checkArrayParameter("reportTemplateIds", strReportTemplateIds);
        SecurityUser user = this.getCurrentUser();
        TenantId tenantId = user.getTenantId();
        ArrayList<ReportTemplateId> reportTemplateIds = new ArrayList<ReportTemplateId>();
        for (String strReportTemplateId : strReportTemplateIds) {
            reportTemplateIds.add(new ReportTemplateId(this.toUUID(strReportTemplateId)));
        }
        List reportTemplates = (List)this.checkNotNull((Object)this.reportTemplateService.findReportTemplateInfoByIds(tenantId, reportTemplateIds));
        return this.filterReportTemplatesByReadPermission(reportTemplates);
    }

    private List<ReportTemplateInfo> filterReportTemplatesByReadPermission(List<ReportTemplateInfo> reportTemplates) {
        return reportTemplates.stream().filter(reportTemplate -> {
            try {
                return this.accessControlService.hasPermission(this.getCurrentUser(), Resource.REPORT_TEMPLATE, Operation.READ, (EntityId)reportTemplate.getId(), (TenantEntity)reportTemplate);
            }
            catch (ThingsboardException e) {
                return false;
            }
        }).toList();
    }

    @ConstructorProperties(value={"tbReportTemplateService"})
    @Generated
    public ReportTemplateController(TbReportTemplateService tbReportTemplateService) {
        this.tbReportTemplateService = tbReportTemplateService;
    }
}

