/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.net.URISyntaxException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.mobile.app.MobileApp;
import org.thingsboard.server.common.data.mobile.app.StoreInfo;
import org.thingsboard.server.common.data.mobile.qrCodeSettings.QrCodeSettings;
import org.thingsboard.server.common.data.oauth2.PlatformType;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.common.data.security.model.JwtPair;
import org.thingsboard.server.common.data.wl.WhiteLabeling;
import org.thingsboard.server.common.data.wl.WhiteLabelingType;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.dao.mobile.QrCodeSettingService;
import org.thingsboard.server.dao.wl.WhiteLabelingService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.mobile.secret.MobileAppSecretService;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.system.SystemSecurityService;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@TbCoreComponent
public class QrCodeSettingsController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QrCodeSettingsController.class);
    @Value(value="${cache.specs.mobileSecretKey.timeToLiveInMinutes:2}")
    private int mobileSecretKeyTtl;
    @Value(value="${mobileApp.domain:thingsboard.cloud}")
    private String defaultAppDomain;
    public static final String ASSET_LINKS_PATTERN = "[{\n  \"relation\": [\"delegate_permission/common.handle_all_urls\"],\n  \"target\": {\n    \"namespace\": \"android_app\",\n    \"package_name\": \"%s\",\n    \"sha256_cert_fingerprints\":\n    [\"%s\"]\n  }\n}]";
    public static final String APPLE_APP_SITE_ASSOCIATION_PATTERN = "{\n    \"applinks\": {\n        \"apps\": [],\n        \"details\": [\n            {\n                \"appID\": \"%s\",\n                \"paths\": [ \"/api/noauth/qr\" ]\n            }\n        ]\n    }\n}";
    public static final String SECRET = "secret";
    public static final String SECRET_PARAM_DESCRIPTION = "A string value representing short-lived secret key";
    public static final String DEEP_LINK_PATTERN = "https://%s/api/noauth/qr?secret=%s&ttl=%s";
    private final SystemSecurityService systemSecurityService;
    private final MobileAppSecretService mobileAppSecretService;
    private final QrCodeSettingService qrCodeSettingService;
    private final WhiteLabelingService whiteLabelingService;

    @ApiOperation(value="Get associated android applications (getAssetLinks)")
    @GetMapping(value={"/.well-known/assetlinks.json"})
    public ResponseEntity<JsonNode> getAssetLinks(HttpServletRequest request) {
        StoreInfo storeInfo;
        String domainName = request.getServerName();
        WhiteLabeling loginWL = this.whiteLabelingService.findWhiteLabelingByDomainAndType(domainName, WhiteLabelingType.LOGIN);
        MobileApp mobileApp = this.qrCodeSettingService.findAppFromQrCodeSettings(loginWL != null ? loginWL.getTenantId() : TenantId.SYS_TENANT_ID, PlatformType.ANDROID);
        StoreInfo storeInfo2 = storeInfo = mobileApp != null ? mobileApp.getStoreInfo() : null;
        if (storeInfo != null && storeInfo.getSha256CertFingerprints() != null) {
            return ResponseEntity.ok((Object)JacksonUtil.toJsonNode((String)String.format("[{\n  \"relation\": [\"delegate_permission/common.handle_all_urls\"],\n  \"target\": {\n    \"namespace\": \"android_app\",\n    \"package_name\": \"%s\",\n    \"sha256_cert_fingerprints\":\n    [\"%s\"]\n  }\n}]", mobileApp.getPkgName(), storeInfo.getSha256CertFingerprints())));
        }
        return ResponseEntity.notFound().build();
    }

    @ApiOperation(value="Get associated ios applications (getAppleAppSiteAssociation)")
    @GetMapping(value={"/.well-known/apple-app-site-association"})
    public ResponseEntity<JsonNode> getAppleAppSiteAssociation(HttpServletRequest request) {
        StoreInfo storeInfo;
        String domainName = request.getServerName();
        WhiteLabeling loginWL = this.whiteLabelingService.findWhiteLabelingByDomainAndType(domainName, WhiteLabelingType.LOGIN);
        MobileApp mobileApp = this.qrCodeSettingService.findAppFromQrCodeSettings(loginWL != null ? loginWL.getTenantId() : TenantId.SYS_TENANT_ID, PlatformType.IOS);
        StoreInfo storeInfo2 = storeInfo = mobileApp != null ? mobileApp.getStoreInfo() : null;
        if (storeInfo != null && storeInfo.getAppId() != null) {
            return ResponseEntity.ok((Object)JacksonUtil.toJsonNode((String)String.format("{\n    \"applinks\": {\n        \"apps\": [],\n        \"details\": [\n            {\n                \"appID\": \"%s\",\n                \"paths\": [ \"/api/noauth/qr\" ]\n            }\n        ]\n    }\n}", storeInfo.getAppId())));
        }
        return ResponseEntity.notFound().build();
    }

    @ApiOperation(value="Create Or Update the Mobile application settings (saveMobileAppSettings)", notes="The request payload contains configuration for android/iOS applications and platform qr code widget settings.\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @PostMapping(value={"/api/mobile/qr/settings"})
    public QrCodeSettings saveQrCodeSettings(@Parameter(description="A JSON value representing the mobile apps configuration") @RequestBody QrCodeSettings qrCodeSettings) throws ThingsboardException {
        SecurityUser currentUser = this.getCurrentUser();
        this.accessControlService.checkPermission(currentUser, Resource.MOBILE_APP_SETTINGS, Operation.WRITE);
        qrCodeSettings.setTenantId(this.getTenantId());
        if (qrCodeSettings.getMobileAppBundleId() != null) {
            this.checkEntityId((EntityId)qrCodeSettings.getMobileAppBundleId(), Operation.READ);
        }
        return this.qrCodeSettingService.saveQrCodeSettings(currentUser.getTenantId(), qrCodeSettings);
    }

    @ApiOperation(value="Get Mobile application settings (getMobileAppSettings)", notes="The response payload contains configuration for android/iOS applications and platform qr code widget settings.\n\nAvailable for any authorized user. ")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/api/mobile/qr/settings"})
    public QrCodeSettings getQrCodeSettings() throws ThingsboardException {
        SecurityUser currentUser = this.getCurrentUser();
        this.accessControlService.checkPermission(currentUser, Resource.MOBILE_APP_SETTINGS, Operation.READ);
        return this.qrCodeSettingService.findQrCodeSettings(currentUser.getTenantId());
    }

    @ApiOperation(value="Get QR code configuration for home page (getMobileAppQrCodeConfig)", notes="The response payload contains ui configuration of qr code\n\nAvailable for any authorized user. ")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/api/mobile/qr/merged"})
    public QrCodeSettings getMergedMobileAppSettings() throws ThingsboardException {
        SecurityUser currentUser = this.getCurrentUser();
        this.accessControlService.checkPermission(currentUser, Resource.MOBILE_APP_SETTINGS, Operation.READ);
        return this.qrCodeSettingService.getMergedQrCodeSettings(currentUser.getTenantId());
    }

    @ApiOperation(value="Get the deep link to the associated mobile application (getMobileAppDeepLink)", notes="Fetch the url that takes user to linked mobile application \n\nAvailable for any authorized user. ")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/api/mobile/qr/deepLink"}, produces={"text/plain"})
    public String getMobileAppDeepLink(HttpServletRequest request) throws ThingsboardException, URISyntaxException {
        String platformDomain;
        SecurityUser currentUser = this.getCurrentUser();
        String secret = this.mobileAppSecretService.generateMobileAppSecret(this.getCurrentUser());
        String baseUrl = this.systemSecurityService.getBaseUrl(currentUser.getAuthority(), currentUser.getTenantId(), currentUser.getCustomerId(), request);
        try {
            platformDomain = new URI(baseUrl).getHost();
        }
        catch (URISyntaxException e) {
            log.debug("Failed to get host from base url: {}", (Object)baseUrl, (Object)e);
            platformDomain = this.defaultAppDomain;
        }
        QrCodeSettings qrCodeSettings = this.qrCodeSettingService.getMergedQrCodeSettings(currentUser.getTenantId());
        String appDomain = qrCodeSettings.isUseDefaultApp() ? this.defaultAppDomain : platformDomain;
        Object deepLink = String.format("https://%s/api/noauth/qr?secret=%s&ttl=%s", appDomain, secret, this.mobileSecretKeyTtl);
        if (!appDomain.equals(platformDomain)) {
            deepLink = (String)deepLink + "&host=" + baseUrl;
        }
        return "\"" + (String)deepLink + "\"";
    }

    @ApiOperation(value="Get User Token (getUserTokenByMobileSecret)", notes="Returns the token of the User based on the provided secret key.")
    @GetMapping(value={"/api/noauth/qr/{secret}"})
    public JwtPair getUserTokenByMobileSecret(@Parameter(description="A string value representing short-lived secret key") @PathVariable(value="secret") String secret) throws ThingsboardException {
        QrCodeSettingsController.checkParameter((String)"secret", (String)secret);
        return this.mobileAppSecretService.getJwtPair(secret);
    }

    @GetMapping(value={"/api/noauth/qr"})
    public ResponseEntity<?> getApplicationRedirect(@RequestHeader(value="User-Agent") String userAgent, HttpServletRequest request) {
        WhiteLabeling loginWL = this.whiteLabelingService.findWhiteLabelingByDomainAndType(request.getServerName(), WhiteLabelingType.LOGIN);
        QrCodeSettings qrCodeSettings = loginWL != null ? this.qrCodeSettingService.getMergedQrCodeSettings(loginWL.getTenantId()) : this.qrCodeSettingService.findQrCodeSettings(TenantId.SYS_TENANT_ID);
        if (userAgent.contains("Android") && qrCodeSettings.isAndroidEnabled()) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.FOUND).header("Location", new String[]{qrCodeSettings.getGooglePlayLink()})).build();
        }
        if ((userAgent.contains("iPhone") || userAgent.contains("iPad")) && qrCodeSettings.isIosEnabled()) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.FOUND).header("Location", new String[]{qrCodeSettings.getAppStoreLink()})).build();
        }
        return this.response(HttpStatus.NOT_FOUND);
    }

    @ConstructorProperties(value={"systemSecurityService", "mobileAppSecretService", "qrCodeSettingService", "whiteLabelingService"})
    @Generated
    public QrCodeSettingsController(SystemSecurityService systemSecurityService, MobileAppSecretService mobileAppSecretService, QrCodeSettingService qrCodeSettingService, WhiteLabelingService whiteLabelingService) {
        this.systemSecurityService = systemSecurityService;
        this.mobileAppSecretService = mobileAppSecretService;
        this.qrCodeSettingService = qrCodeSettingService;
        this.whiteLabelingService = whiteLabelingService;
    }
}

