/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import java.beans.ConstructorProperties;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.OAuth2ClientId;
import org.thingsboard.server.common.data.oauth2.OAuth2Client;
import org.thingsboard.server.common.data.oauth2.OAuth2ClientInfo;
import org.thingsboard.server.common.data.oauth2.OAuth2ClientLoginInfo;
import org.thingsboard.server.common.data.oauth2.PlatformType;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.dao.oauth2.OAuth2ClientService;
import org.thingsboard.server.dao.oauth2.OAuth2Configuration;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.oauth2client.TbOauth2ClientService;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.utils.MiscUtils;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class OAuth2Controller
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OAuth2Controller.class);
    private final OAuth2Configuration oAuth2Configuration;
    private final TbOauth2ClientService tbOauth2ClientService;

    @ApiOperation(value="Get OAuth2 clients (getOAuth2Clients)", notes="Get the list of OAuth2 clients to log in with, available for such domain scheme (HTTP or HTTPS) (if x-forwarded-proto request header is present - the scheme is known from it) and domain name and port (port may be known from x-forwarded-port header)")
    @PostMapping(value={"/noauth/oauth2Clients"})
    public List<OAuth2ClientLoginInfo> getOAuth2Clients(HttpServletRequest request, @Parameter(description="Mobile application package name, to find OAuth2 clients where there is configured mobile application with such package name") @RequestParam(required=false) String pkgName, @Parameter(description="Platform type to search OAuth2 clients for which the usage with this platform type is allowed in the settings. If platform type is not one of allowable values - it will just be ignored", schema=@Schema(allowableValues={"WEB", "ANDROID", "IOS"})) @RequestParam(required=false) String platform) {
        if (log.isDebugEnabled()) {
            log.debug("Executing getOAuth2Clients: [{}][{}][{}]", new Object[]{request.getScheme(), request.getServerName(), request.getServerPort()});
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String header = (String)headerNames.nextElement();
                log.debug("Header: {} {}", (Object)header, (Object)request.getHeader(header));
            }
        }
        PlatformType platformType = null;
        if (StringUtils.isNotEmpty((String)platform)) {
            platformType = PlatformType.valueOf((String)platform);
        }
        if (StringUtils.isNotEmpty((String)pkgName)) {
            return this.oAuth2ClientService.findOAuth2ClientLoginInfosByMobilePkgNameAndPlatformType(pkgName, platformType);
        }
        return this.oAuth2ClientService.findOAuth2ClientLoginInfosByDomainName(MiscUtils.getDomainNameAndPort((HttpServletRequest)request));
    }

    @ApiOperation(value="Save OAuth2 Client (saveOAuth2Client)", notes="\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/oauth2/client"})
    public OAuth2Client saveOAuth2Client(@RequestBody @Valid OAuth2Client oAuth2Client) throws Exception {
        SecurityUser currentUser = this.getCurrentUser();
        oAuth2Client.setTenantId(currentUser.getTenantId());
        oAuth2Client.setCustomerId(currentUser.getCustomerId());
        this.checkEntity((EntityId)((OAuth2ClientId)oAuth2Client.getId()), (TenantEntity)oAuth2Client, Resource.OAUTH2_CLIENT);
        return this.tbOauth2ClientService.save(oAuth2Client, (User)currentUser);
    }

    @ApiOperation(value="Get OAuth2 Client infos (findOAuth2ClientInfos)", notes="\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/oauth2/client/infos"})
    public PageData<OAuth2ClientInfo> findOAuth2ClientInfos(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="Case-insensitive 'substring' filter based on client's title") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by") @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)") @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.OAUTH2_CLIENT, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        return this.oAuth2ClientService.findOAuth2ClientInfosByTenantIdAndCustomerId(this.getTenantId(), this.getCurrentUser().getCustomerId(), pageLink);
    }

    @ApiOperation(value="Get OAuth2 Client infos By Ids (findOAuth2ClientInfosByIds)", notes="Fetch OAuth2 Client info objects based on the provided ids. \n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/oauth2/client/infos"}, params={"clientIds"})
    public List<OAuth2ClientInfo> findOAuth2ClientInfosByIds(@Parameter(description="A list of oauth2 ids, separated by comma ','", array=@ArraySchema(schema=@Schema(type="string")), required=true) @RequestParam(value="clientIds") UUID[] clientIds) throws ThingsboardException {
        List oAuth2ClientIds = this.getOAuth2ClientIds(clientIds);
        return this.oAuth2ClientService.findOAuth2ClientInfosByIds(this.getTenantId(), oAuth2ClientIds);
    }

    @ApiOperation(value="Get OAuth2 Client by id (getOAuth2ClientById)", notes="\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/oauth2/client/{id}"})
    public OAuth2Client getOAuth2ClientById(@PathVariable UUID id) throws ThingsboardException {
        OAuth2ClientId oAuth2ClientId = new OAuth2ClientId(id);
        return (OAuth2Client)this.checkEntityId((EntityId)oAuth2ClientId, (arg_0, arg_1) -> ((OAuth2ClientService)this.oAuth2ClientService).findOAuth2ClientById(arg_0, arg_1), Operation.READ);
    }

    @ApiOperation(value="Delete oauth2 client (deleteOauth2Client)", notes="Deletes the oauth2 client. Referencing non-existing oauth2 client Id will cause an error.\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @DeleteMapping(value={"/oauth2/client/{id}"})
    public void deleteOauth2Client(@PathVariable UUID id) throws Exception {
        OAuth2ClientId oAuth2ClientId = new OAuth2ClientId(id);
        OAuth2Client oAuth2Client = this.checkOauth2ClientId(oAuth2ClientId, Operation.DELETE);
        this.tbOauth2ClientService.delete(oAuth2Client, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Get OAuth2 log in processing URL (getLoginProcessingUrl)", notes="Returns the URL enclosed in double quotes. After successful authentication with OAuth2 provider, it makes a redirect to this path so that the platform can do further log in processing. This URL may be configured as 'security.oauth2.loginProcessingUrl' property in yml configuration file, or as 'SECURITY_OAUTH2_LOGIN_PROCESSING_URL' env variable. By default it is '/login/oauth2/code/'\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/oauth2/loginProcessingUrl"})
    public String getLoginProcessingUrl() {
        return "\"" + this.oAuth2Configuration.getLoginProcessingUrl() + "\"";
    }

    @ConstructorProperties(value={"oAuth2Configuration", "tbOauth2ClientService"})
    @Generated
    public OAuth2Controller(OAuth2Configuration oAuth2Configuration, TbOauth2ClientService tbOauth2ClientService) {
        this.oAuth2Configuration = oAuth2Configuration;
        this.tbOauth2ClientService = tbOauth2ClientService;
    }
}

