/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.rule.engine.api.JobManager;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.JobId;
import org.thingsboard.server.common.data.job.Job;
import org.thingsboard.server.common.data.job.JobFilter;
import org.thingsboard.server.common.data.job.JobStatus;
import org.thingsboard.server.common.data.job.JobType;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.queue.util.TbCoreComponent;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class JobController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobController.class);
    private final JobManager jobManager;

    @ApiOperation(value="Get job by id (getJobById)", notes="Fetches job info by id.\n\nExample of a RUNNING CF_REPROCESSING job response:\n```json\n{\n  \"id\": {\n    \"entityType\": \"JOB\",\n    \"id\": \"475e94e0-2f2d-11f0-8240-91e99922a704\"\n  },\n  \"createdTime\": 1747053196590,\n  \"tenantId\": {\n    \"entityType\": \"TENANT\",\n    \"id\": \"46859a00-2f2d-11f0-8240-91e99922a704\"\n  },\n  \"type\": \"CF_REPROCESSING\",\n  \"key\": \"474e4130-2f2d-11f0-8240-91e99922a704\",\n  \"entityId\": {\n    \"entityType\": \"DEVICE_PROFILE\",\n    \"id\": \"9fd41f20-31a1-11f0-933e-27998d6db02e\"\n   },\n  \"status\": \"RUNNING\",\n  \"configuration\": {\n    \"type\": \"CF_REPROCESSING\",\n    \"calculatedFieldId\": {\n      \"entityType\": \"CALCULATED_FIELD\",\n      \"id\": \"474e4130-2f2d-11f0-8240-91e99922a704\"\n    },\n    \"startTs\": 1747051995760,\n    \"endTs\": 1747052895760,\n    \"tasksKey\": \"c3cdbd42-799e-4d3a-9aad-9310f767aa36\",\n    \"toReprocess\": null\n  },\n  \"result\": {\n    \"jobType\": \"CF_REPROCESSING\",\n    \"successfulCount\": 1,\n    \"failedCount\": 0,\n    \"discardedCount\": 0,\n    \"totalCount\": 2,\n    \"results\": [],\n    \"generalError\": null,\n    \"startTs\": 1747323069445,\n    \"finishTs\": 1747323070585,\n    \"cancellationTs\": 0\n  }\n}\n\n```\n\nExample of a CF_REPROCESSING job with failures:\n```json\n{\n  ...,\n  \"status\": \"FAILED\",\n  ...,\n  \"result\": {\n    \"jobType\": \"CF_REPROCESSING\",\n    \"successfulCount\": 0,\n    \"failedCount\": 2,\n    \"discardedCount\": 0,\n    \"totalCount\": 2,\n    \"results\": [\n      {\n        \"jobType\": \"CF_REPROCESSING\",\n        \"key\": \"c3cdbd42-799e-4d3a-9aad-9310f767aa36\",\n        \"success\": false,\n        \"discarded\": false,\n        \"failure\": {\n          \"error\": \"Failed to fetch temperature: Failed to fetch timeseries data\",\n          \"entityInfo\": {\n            \"id\": {\n              \"entityType\": \"DEVICE\",\n              \"id\": \"9fd41f20-31a1-11f0-933e-27998d6db02e\"\n            },\n            \"name\": \"Test device 1\"\n          }\n        }\n      },\n      {\n        \"jobType\": \"CF_REPROCESSING\",\n        \"key\": \"c3cdbd42-799e-4d3a-9aad-9310f767aa36\",\n        \"success\": false,\n        \"discarded\": false,\n        \"failure\": {\n          \"error\": \"Failed to fetch temperature: Failed to fetch timeseries data\",\n          \"entityInfo\": {\n            \"id\": {\n              \"entityType\": \"DEVICE\",\n              \"id\": \"9ffc4090-31a1-11f0-933e-27998d6db02e\"\n            },\n            \"name\": \"Test device 2\"\n          }\n        }\n      }\n    ],\n    \"generalError\": null,\n    \"startTs\": 1747323069445,\n    \"finishTs\": 1747323070585,\n    \"cancellationTs\": 0\n  }\n}\n\n```\n\nExample of a FAILED job result with general error:\n```json\n{\n  ...,\n  \"status\": \"FAILED\",\n  ...,\n  \"result\": {\n    \"jobType\": \"CF_REPROCESSING\",\n    \"successfulCount\": 1,\n    \"failedCount\": 0,\n    \"discardedCount\": 0,\n    \"totalCount\": null,\n    \"results\": [],\n    \"generalError\": \"Timeout to find devices by profile\",\n    \"cancellationTs\": 0\n  }\n}\n\n```\n\nExample of a CANCELLED job result:\n```json\n{\n  ...,\n  \"status\": \"CANCELLED\",\n  ...,\n  \"result\": {\n    \"jobType\": \"CF_REPROCESSING\",\n    \"successfulCount\": 15,\n    \"failedCount\": 0,\n    \"discardedCount\": 85,\n    \"totalCount\": 100,\n    \"results\": [],\n    \"generalError\": null,\n    \"cancellationTs\": 1747065908414\n  }\n}\n\n```\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @GetMapping(value={"/job/{id}"})
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    public Job getJobById(@PathVariable UUID id) throws ThingsboardException {
        JobId jobId = new JobId(id);
        return this.checkJobId(jobId, Operation.READ);
    }

    @ApiOperation(value="Get jobs (getJobs)", notes="Returns the page of jobs.\n\nYou can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @GetMapping(value={"/jobs"})
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    public PageData<Job> getJobs(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="Case-insensitive 'substring' filter based on job's description") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by") @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)") @RequestParam(required=false) String sortOrder, @Parameter(description="Comma-separated list of job types to include. If empty - all job types are included.", array=@ArraySchema(schema=@Schema(type="string")), required=false) @RequestParam(required=false) List<JobType> types, @Parameter(description="Comma-separated list of job statuses to include. If empty - all job statuses are included.", array=@ArraySchema(schema=@Schema(type="string"))) @RequestParam(required=false) List<JobStatus> statuses, @Parameter(description="Comma-separated list of entity ids. If empty - jobs for all entities are included.", array=@ArraySchema(schema=@Schema(type="string"))) @RequestParam(required=false) List<UUID> entities, @Parameter(description="To only include jobs created after this timestamp.") @RequestParam(required=false) Long startTime, @Parameter(description="To only include jobs created before this timestamp.") @RequestParam(required=false) Long endTime) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.JOB, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        JobFilter filter = JobFilter.builder().types(types).statuses(statuses).entities(entities).startTime(startTime).endTime(endTime).build();
        return this.jobService.findJobsByFilter(this.getTenantId(), filter, pageLink);
    }

    @ApiOperation(value="Cancel job (cancelJob)", notes="Cancels the job. The status of the job must be QUEUED, PENDING or RUNNING.\n\nFor a running job, all the tasks not yet processed will be discarded.\n\nSee the example of a cancelled job result in getJobById method description.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PostMapping(value={"/job/{id}/cancel"})
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    public void cancelJob(@PathVariable UUID id) throws ThingsboardException {
        JobId jobId = new JobId(id);
        this.checkJobId(jobId, Operation.WRITE);
        this.jobManager.cancelJob(this.getTenantId(), jobId);
    }

    @ApiOperation(value="Reprocess job (reprocessJob)", notes="Reprocesses the job. Failures are located at job.result.results list. Platform iterates over this list and submits new tasks for them. Doesn't create new job entity but updates the existing one. Successfully reprocessed job will look the same as completed one.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PostMapping(value={"/job/{id}/reprocess"})
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    public void reprocessJob(@PathVariable UUID id) throws ThingsboardException {
        JobId jobId = new JobId(id);
        this.checkJobId(jobId, Operation.WRITE);
        this.jobManager.reprocessJob(this.getTenantId(), jobId);
    }

    @DeleteMapping(value={"/job/{id}"})
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    public void deleteJob(@PathVariable UUID id) throws ThingsboardException {
        JobId jobId = new JobId(id);
        this.checkJobId(jobId, Operation.DELETE);
        this.jobService.deleteJob(this.getTenantId(), jobId);
    }

    @ConstructorProperties(value={"jobManager"})
    @Generated
    public JobController(JobManager jobManager) {
        this.jobManager = jobManager;
    }
}

