/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.EventInfo;
import org.thingsboard.server.common.data.event.EventFilter;
import org.thingsboard.server.common.data.event.EventType;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.TimePageLink;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.dao.event.EventService;
import org.thingsboard.server.queue.util.TbCoreComponent;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class EventController
extends BaseController {
    private static final String EVENT_FILTER_DEFINITION = "# Event Filter Definition\n\n6 different eventFilter objects could be set for different event types. The eventType field is required. Others are optional. If some of them are set, the filtering will be applied according to them. See the examples below for all the fields used for each event type filtering. \n\nNote,\n\n * 'server' - string value representing the server name, identif   ier or ip address where the platform is running;\n * 'errorStr' - the case insensitive 'contains' filter based on error message.\n\n## Error Event Filter\n\n```json\n{\n   \"eventType\":\"ERROR\",\n   \"server\":\"ip-172-31-24-152\",\n   \"method\":\"onClusterEventMsg\",\n   \"errorStr\":\"Error Message\"\n}\n```\n\n * 'method' - string value representing the method name when the error happened.\n\n## Lifecycle Event Filter\n\n```json\n{\n   \"eventType\":\"LC_EVENT\",\n   \"server\":\"ip-172-31-24-152\",\n   \"event\":\"STARTED\",\n   \"status\":\"Success\",\n   \"errorStr\":\"Error Message\"\n}\n```\n\n * 'event' - string value representing the lifecycle event type;\n * 'status' - string value representing status of the lifecycle event.\n\n## Statistics Event Filter\n\n```json\n{\n   \"eventType\":\"STATS\",\n   \"server\":\"ip-172-31-24-152\",\n   \"messagesProcessed\":10,\n   \"errorsOccurred\":5\n}\n```\n\n * 'messagesProcessed' - the minimum number of successfully processed messages;\n * 'errorsOccurred' - the minimum number of errors occurred during messages processing.\n\n## Debug Rule Node Event Filter\n\n```json\n{\n   \"eventType\":\"DEBUG_RULE_NODE\",\n   \"msgDirectionType\":\"IN\",\n   \"server\":\"ip-172-31-24-152\",\n   \"dataSearch\":\"humidity\",\n   \"metadataSearch\":\"deviceName\",\n   \"entityName\":\"DEVICE\",\n   \"relationType\":\"Success\",\n   \"entityId\":\"de9d54a0-2b7a-11ec-a3cc-23386423d98f\",\n   \"msgType\":\"POST_TELEMETRY_REQUEST\",\n   \"isError\":\"false\",\n   \"errorStr\":\"Error Message\"\n}\n```\n\n## Debug Rule Chain Event Filter\n\n```json\n{\n   \"eventType\":\"DEBUG_RULE_CHAIN\",\n   \"msgDirectionType\":\"IN\",\n   \"server\":\"ip-172-31-24-152\",\n   \"dataSearch\":\"humidity\",\n   \"metadataSearch\":\"deviceName\",\n   \"entityName\":\"DEVICE\",\n   \"relationType\":\"Success\",\n   \"entityId\":\"de9d54a0-2b7a-11ec-a3cc-23386423d98f\",\n   \"msgType\":\"POST_TELEMETRY_REQUEST\",\n   \"isError\":\"false\",\n   \"errorStr\":\"Error Message\"\n}\n```\n\n * 'msgDirectionType' - string value representing msg direction type (incoming to entity or outcoming from entity);\n * 'dataSearch' - the case insensitive 'contains' filter based on data (key and value) for the message;\n * 'metadataSearch' - the case insensitive 'contains' filter based on metadata (key and value) for the message;\n * 'entityName' - string value representing the entity type;\n * 'relationType' - string value representing the type of message routing;\n * 'entityId' - string value representing the entity id in the event body (originator of the message);\n * 'msgType' - string value representing the message type;\n * 'isError' - boolean value to filter the errors.\n\n## Debug Calculated Field Event Filter\n\n```json\n{\n   \"eventType\":\"DEBUG_CALCULATED_FIELD\",\n   \"server\":\"ip-172-31-24-152\",\n   \"isError\":\"false\",\n   \"errorStr\":\"Error Message\"\n   \"entityId\":\"cf4b8741-f618-471f-ae08-d881ca7f9fe9\",\n   \"msgId\":\"5cf7d3a0-aee7-40dd-a737-ade05528e7eb\",\n   \"msgType\":\"POST_TELEMETRY_REQUEST\",\n   \"arguments\":\"{\n    \"x\": {\n      \"ts\": 1739432016629,\n      \"value\": 20\n    },\n    \"y\": {\n      \"ts\": 1739429717656,\n      \"value\": 12\n    }\n  }\",\n   \"result\":\"{\n    \"x + y\": 32\n  }\",\n}\n```\n\n * 'entityId' - string value representing the entity id in the event body;\n * 'entityType' - string value representing the entity type;\n * 'msgId' - string value representing the message id in the rule engine;\n * 'msgType' - string value representing the message type;\n * 'arguments' - string value representing the arguments that were used in the calculation performed;\n * 'result' - string value representing the result of a calculation;\n * 'isError' - boolean value to filter the errors.\n\n";
    @Autowired
    private EventService eventService;

    @ApiOperation(value="Get Events by type (getEvents)", notes="Returns a page of events for specified entity by specifying event type. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. ")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/events/{entityType}/{entityId}/{eventType}"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<EventInfo> getEvents(@Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true) @PathVariable(value="entityType") String strEntityType, @Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityId") String strEntityId, @Parameter(description="A string value representing event type", example="STATS", required=true) @PathVariable(value="eventType") String eventType, @Parameter(description="A string value representing the tenant id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @RequestParam(value="tenantId") String strTenantId, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The value is not used in searching.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"ts", "id"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder, @Parameter(description="Timestamp. Events with creation time before it won't be queried.") @RequestParam(required=false) Long startTime, @Parameter(description="Timestamp. Events with creation time after it won't be queried.") @RequestParam(required=false) Long endTime) throws ThingsboardException {
        EventController.checkParameter((String)"EntityId", (String)strEntityId);
        EventController.checkParameter((String)"EntityType", (String)strEntityType);
        TenantId tenantId = TenantId.fromUUID((UUID)this.toUUID(strTenantId));
        EntityId entityId = EntityIdFactory.getByTypeAndId((String)strEntityType, (String)strEntityId);
        this.checkEntityId(entityId, Operation.READ);
        TimePageLink pageLink = this.createTimePageLink(pageSize, page, textSearch, sortProperty, sortOrder, startTime, endTime);
        return (PageData)this.checkNotNull((Object)this.eventService.findEvents(tenantId, entityId, EventController.resolveEventType((String)eventType), pageLink));
    }

    @ApiOperation(value="Get Events (Deprecated)", notes="Returns a page of events for specified entity. Deprecated and will be removed in next minor release. The call was deprecated to improve the performance of the system. Current implementation will return 'Lifecycle' events only. Use 'Get events by type' or 'Get events by filter' instead. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. ")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/events/{entityType}/{entityId}"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<EventInfo> getEvents(@Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true) @PathVariable(value="entityType") String strEntityType, @Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityId") String strEntityId, @Parameter(description="A string value representing the tenant id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @RequestParam(value="tenantId") String strTenantId, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The value is not used in searching.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"ts", "id"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder, @Parameter(description="Timestamp. Events with creation time before it won't be queried.") @RequestParam(required=false) Long startTime, @Parameter(description="Timestamp. Events with creation time after it won't be queried.") @RequestParam(required=false) Long endTime) throws ThingsboardException {
        EventController.checkParameter((String)"EntityId", (String)strEntityId);
        EventController.checkParameter((String)"EntityType", (String)strEntityType);
        TenantId tenantId = TenantId.fromUUID((UUID)this.toUUID(strTenantId));
        EntityId entityId = EntityIdFactory.getByTypeAndId((String)strEntityType, (String)strEntityId);
        this.checkEntityId(entityId, Operation.READ);
        TimePageLink pageLink = this.createTimePageLink(pageSize, page, textSearch, sortProperty, sortOrder, startTime, endTime);
        return (PageData)this.checkNotNull((Object)this.eventService.findEvents(tenantId, entityId, EventType.LC_EVENT, pageLink));
    }

    @ApiOperation(value="Get Events by event filter (getEvents)", notes="Returns a page of events for the chosen entity by specifying the event filter. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\n# Event Filter Definition\n\n6 different eventFilter objects could be set for different event types. The eventType field is required. Others are optional. If some of them are set, the filtering will be applied according to them. See the examples below for all the fields used for each event type filtering. \n\nNote,\n\n * 'server' - string value representing the server name, identif   ier or ip address where the platform is running;\n * 'errorStr' - the case insensitive 'contains' filter based on error message.\n\n## Error Event Filter\n\n```json\n{\n   \"eventType\":\"ERROR\",\n   \"server\":\"ip-172-31-24-152\",\n   \"method\":\"onClusterEventMsg\",\n   \"errorStr\":\"Error Message\"\n}\n```\n\n * 'method' - string value representing the method name when the error happened.\n\n## Lifecycle Event Filter\n\n```json\n{\n   \"eventType\":\"LC_EVENT\",\n   \"server\":\"ip-172-31-24-152\",\n   \"event\":\"STARTED\",\n   \"status\":\"Success\",\n   \"errorStr\":\"Error Message\"\n}\n```\n\n * 'event' - string value representing the lifecycle event type;\n * 'status' - string value representing status of the lifecycle event.\n\n## Statistics Event Filter\n\n```json\n{\n   \"eventType\":\"STATS\",\n   \"server\":\"ip-172-31-24-152\",\n   \"messagesProcessed\":10,\n   \"errorsOccurred\":5\n}\n```\n\n * 'messagesProcessed' - the minimum number of successfully processed messages;\n * 'errorsOccurred' - the minimum number of errors occurred during messages processing.\n\n## Debug Rule Node Event Filter\n\n```json\n{\n   \"eventType\":\"DEBUG_RULE_NODE\",\n   \"msgDirectionType\":\"IN\",\n   \"server\":\"ip-172-31-24-152\",\n   \"dataSearch\":\"humidity\",\n   \"metadataSearch\":\"deviceName\",\n   \"entityName\":\"DEVICE\",\n   \"relationType\":\"Success\",\n   \"entityId\":\"de9d54a0-2b7a-11ec-a3cc-23386423d98f\",\n   \"msgType\":\"POST_TELEMETRY_REQUEST\",\n   \"isError\":\"false\",\n   \"errorStr\":\"Error Message\"\n}\n```\n\n## Debug Rule Chain Event Filter\n\n```json\n{\n   \"eventType\":\"DEBUG_RULE_CHAIN\",\n   \"msgDirectionType\":\"IN\",\n   \"server\":\"ip-172-31-24-152\",\n   \"dataSearch\":\"humidity\",\n   \"metadataSearch\":\"deviceName\",\n   \"entityName\":\"DEVICE\",\n   \"relationType\":\"Success\",\n   \"entityId\":\"de9d54a0-2b7a-11ec-a3cc-23386423d98f\",\n   \"msgType\":\"POST_TELEMETRY_REQUEST\",\n   \"isError\":\"false\",\n   \"errorStr\":\"Error Message\"\n}\n```\n\n * 'msgDirectionType' - string value representing msg direction type (incoming to entity or outcoming from entity);\n * 'dataSearch' - the case insensitive 'contains' filter based on data (key and value) for the message;\n * 'metadataSearch' - the case insensitive 'contains' filter based on metadata (key and value) for the message;\n * 'entityName' - string value representing the entity type;\n * 'relationType' - string value representing the type of message routing;\n * 'entityId' - string value representing the entity id in the event body (originator of the message);\n * 'msgType' - string value representing the message type;\n * 'isError' - boolean value to filter the errors.\n\n## Debug Calculated Field Event Filter\n\n```json\n{\n   \"eventType\":\"DEBUG_CALCULATED_FIELD\",\n   \"server\":\"ip-172-31-24-152\",\n   \"isError\":\"false\",\n   \"errorStr\":\"Error Message\"\n   \"entityId\":\"cf4b8741-f618-471f-ae08-d881ca7f9fe9\",\n   \"msgId\":\"5cf7d3a0-aee7-40dd-a737-ade05528e7eb\",\n   \"msgType\":\"POST_TELEMETRY_REQUEST\",\n   \"arguments\":\"{\n    \"x\": {\n      \"ts\": 1739432016629,\n      \"value\": 20\n    },\n    \"y\": {\n      \"ts\": 1739429717656,\n      \"value\": 12\n    }\n  }\",\n   \"result\":\"{\n    \"x + y\": 32\n  }\",\n}\n```\n\n * 'entityId' - string value representing the entity id in the event body;\n * 'entityType' - string value representing the entity type;\n * 'msgId' - string value representing the message id in the rule engine;\n * 'msgType' - string value representing the message type;\n * 'arguments' - string value representing the arguments that were used in the calculation performed;\n * 'result' - string value representing the result of a calculation;\n * 'isError' - boolean value to filter the errors.\n\n")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/events/{entityType}/{entityId}"}, method={RequestMethod.POST})
    @ResponseBody
    public PageData<EventInfo> getEvents(@Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true) @PathVariable(value="entityType") String strEntityType, @Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityId") String strEntityId, @Parameter(description="A string value representing the tenant id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @RequestParam(value="tenantId") String strTenantId, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="A JSON value representing the event filter.", required=true) @RequestBody EventFilter eventFilter, @Parameter(description="The value is not used in searching.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"ts", "id"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder, @Parameter(description="Timestamp. Events with creation time before it won't be queried.") @RequestParam(required=false) Long startTime, @Parameter(description="Timestamp. Events with creation time after it won't be queried.") @RequestParam(required=false) Long endTime) throws ThingsboardException {
        EventController.checkParameter((String)"EntityId", (String)strEntityId);
        EventController.checkParameter((String)"EntityType", (String)strEntityType);
        TenantId tenantId = TenantId.fromUUID((UUID)this.toUUID(strTenantId));
        EntityId entityId = EntityIdFactory.getByTypeAndId((String)strEntityType, (String)strEntityId);
        this.checkEntityId(entityId, Operation.READ);
        TimePageLink pageLink = this.createTimePageLink(pageSize, page, textSearch, sortProperty, sortOrder, startTime, endTime);
        return (PageData)this.checkNotNull((Object)this.eventService.findEventsByFilter(tenantId, entityId, eventFilter, pageLink));
    }

    @ApiOperation(value="Clear Events (clearEvents)", notes="Clears events by filter for specified entity.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/events/{entityType}/{entityId}/clear"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    public void clearEvents(@Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true) @PathVariable(value="entityType") String strEntityType, @Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityId") String strEntityId, @Parameter(description="Timestamp. Events with creation time before it won't be queried.") @RequestParam(required=false) Long startTime, @Parameter(description="Timestamp. Events with creation time after it won't be queried.") @RequestParam(required=false) Long endTime, @Parameter(description="# Event Filter Definition\n\n6 different eventFilter objects could be set for different event types. The eventType field is required. Others are optional. If some of them are set, the filtering will be applied according to them. See the examples below for all the fields used for each event type filtering. \n\nNote,\n\n * 'server' - string value representing the server name, identif   ier or ip address where the platform is running;\n * 'errorStr' - the case insensitive 'contains' filter based on error message.\n\n## Error Event Filter\n\n```json\n{\n   \"eventType\":\"ERROR\",\n   \"server\":\"ip-172-31-24-152\",\n   \"method\":\"onClusterEventMsg\",\n   \"errorStr\":\"Error Message\"\n}\n```\n\n * 'method' - string value representing the method name when the error happened.\n\n## Lifecycle Event Filter\n\n```json\n{\n   \"eventType\":\"LC_EVENT\",\n   \"server\":\"ip-172-31-24-152\",\n   \"event\":\"STARTED\",\n   \"status\":\"Success\",\n   \"errorStr\":\"Error Message\"\n}\n```\n\n * 'event' - string value representing the lifecycle event type;\n * 'status' - string value representing status of the lifecycle event.\n\n## Statistics Event Filter\n\n```json\n{\n   \"eventType\":\"STATS\",\n   \"server\":\"ip-172-31-24-152\",\n   \"messagesProcessed\":10,\n   \"errorsOccurred\":5\n}\n```\n\n * 'messagesProcessed' - the minimum number of successfully processed messages;\n * 'errorsOccurred' - the minimum number of errors occurred during messages processing.\n\n## Debug Rule Node Event Filter\n\n```json\n{\n   \"eventType\":\"DEBUG_RULE_NODE\",\n   \"msgDirectionType\":\"IN\",\n   \"server\":\"ip-172-31-24-152\",\n   \"dataSearch\":\"humidity\",\n   \"metadataSearch\":\"deviceName\",\n   \"entityName\":\"DEVICE\",\n   \"relationType\":\"Success\",\n   \"entityId\":\"de9d54a0-2b7a-11ec-a3cc-23386423d98f\",\n   \"msgType\":\"POST_TELEMETRY_REQUEST\",\n   \"isError\":\"false\",\n   \"errorStr\":\"Error Message\"\n}\n```\n\n## Debug Rule Chain Event Filter\n\n```json\n{\n   \"eventType\":\"DEBUG_RULE_CHAIN\",\n   \"msgDirectionType\":\"IN\",\n   \"server\":\"ip-172-31-24-152\",\n   \"dataSearch\":\"humidity\",\n   \"metadataSearch\":\"deviceName\",\n   \"entityName\":\"DEVICE\",\n   \"relationType\":\"Success\",\n   \"entityId\":\"de9d54a0-2b7a-11ec-a3cc-23386423d98f\",\n   \"msgType\":\"POST_TELEMETRY_REQUEST\",\n   \"isError\":\"false\",\n   \"errorStr\":\"Error Message\"\n}\n```\n\n * 'msgDirectionType' - string value representing msg direction type (incoming to entity or outcoming from entity);\n * 'dataSearch' - the case insensitive 'contains' filter based on data (key and value) for the message;\n * 'metadataSearch' - the case insensitive 'contains' filter based on metadata (key and value) for the message;\n * 'entityName' - string value representing the entity type;\n * 'relationType' - string value representing the type of message routing;\n * 'entityId' - string value representing the entity id in the event body (originator of the message);\n * 'msgType' - string value representing the message type;\n * 'isError' - boolean value to filter the errors.\n\n## Debug Calculated Field Event Filter\n\n```json\n{\n   \"eventType\":\"DEBUG_CALCULATED_FIELD\",\n   \"server\":\"ip-172-31-24-152\",\n   \"isError\":\"false\",\n   \"errorStr\":\"Error Message\"\n   \"entityId\":\"cf4b8741-f618-471f-ae08-d881ca7f9fe9\",\n   \"msgId\":\"5cf7d3a0-aee7-40dd-a737-ade05528e7eb\",\n   \"msgType\":\"POST_TELEMETRY_REQUEST\",\n   \"arguments\":\"{\n    \"x\": {\n      \"ts\": 1739432016629,\n      \"value\": 20\n    },\n    \"y\": {\n      \"ts\": 1739429717656,\n      \"value\": 12\n    }\n  }\",\n   \"result\":\"{\n    \"x + y\": 32\n  }\",\n}\n```\n\n * 'entityId' - string value representing the entity id in the event body;\n * 'entityType' - string value representing the entity type;\n * 'msgId' - string value representing the message id in the rule engine;\n * 'msgType' - string value representing the message type;\n * 'arguments' - string value representing the arguments that were used in the calculation performed;\n * 'result' - string value representing the result of a calculation;\n * 'isError' - boolean value to filter the errors.\n\n") @RequestBody EventFilter eventFilter) throws ThingsboardException {
        EventController.checkParameter((String)"EntityId", (String)strEntityId);
        EventController.checkParameter((String)"EntityType", (String)strEntityType);
        EntityId entityId = EntityIdFactory.getByTypeAndId((String)strEntityType, (String)strEntityId);
        this.checkEntityId(entityId, Operation.READ);
        this.eventService.removeEvents(this.getTenantId(), entityId, eventFilter, startTime, endTime);
    }

    private static EventType resolveEventType(String eventType) throws ThingsboardException {
        for (EventType et : EventType.values()) {
            if (!et.name().equalsIgnoreCase(eventType) && !et.getOldName().equalsIgnoreCase(eventType)) continue;
            return et;
        }
        throw new ThingsboardException("Event type: '" + eventType + "' is not supported!", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
    }
}

