/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.relation.EntityRelationInfo;
import org.thingsboard.server.common.data.relation.EntityRelationsQuery;
import org.thingsboard.server.common.data.relation.RelationTypeGroup;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.dao.service.ConstraintValidator;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.entity.relation.TbEntityRelationService;
import org.thingsboard.server.service.security.model.SecurityUser;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class EntityRelationController
extends BaseController {
    private final TbEntityRelationService tbEntityRelationService;
    public static final String TO_TYPE = "toType";
    public static final String FROM_ID = "fromId";
    public static final String FROM_TYPE = "fromType";
    public static final String RELATION_TYPE = "relationType";
    public static final String TO_ID = "toId";
    private static final String SECURITY_CHECKS_ENTITIES_DESCRIPTION = "\n\nIf the user has the authority of 'System Administrator', the server checks that 'from' and 'to' entities are owned by the sysadmin. If the user has the authority of 'Tenant Administrator', the server checks that 'from' and 'to' entities are owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the 'from' and 'to' entities are assigned to the same customer.";
    private static final String SECURITY_CHECKS_ENTITY_DESCRIPTION = "\n\nIf the user has the authority of 'System Administrator', the server checks that the entity is owned by the sysadmin. If the user has the authority of 'Tenant Administrator', the server checks that the entity is owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the entity is assigned to the same customer.";

    @ApiOperation(value="Create Relation (saveRelation)", notes="Creates or updates a relation between two entities in the platform. Relations unique key is a combination of from/to entity id and relation type group and relation type. \n\nIf the user has the authority of 'System Administrator', the server checks that 'from' and 'to' entities are owned by the sysadmin. If the user has the authority of 'Tenant Administrator', the server checks that 'from' and 'to' entities are owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the 'from' and 'to' entities are assigned to the same customer.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/relation"})
    public void saveRelation(@Parameter(description="A JSON value representing the relation.", required=true) @RequestBody EntityRelation relation) throws ThingsboardException {
        this.doSave(relation);
    }

    @ApiOperation(value="Create Relation (saveRelationV2)", notes="Creates or updates a relation between two entities in the platform. Relations unique key is a combination of from/to entity id and relation type group and relation type. \n\nIf the user has the authority of 'System Administrator', the server checks that 'from' and 'to' entities are owned by the sysadmin. If the user has the authority of 'Tenant Administrator', the server checks that 'from' and 'to' entities are owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the 'from' and 'to' entities are assigned to the same customer.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/v2/relation"})
    public EntityRelation saveRelationV2(@Parameter(description="A JSON value representing the relation.", required=true) @RequestBody EntityRelation relation) throws ThingsboardException {
        return this.doSave(relation);
    }

    private EntityRelation doSave(EntityRelation relation) throws ThingsboardException {
        if (relation.getTypeGroup() == null) {
            relation.setTypeGroup(RelationTypeGroup.COMMON);
        }
        ConstraintValidator.validateFields((Object)relation);
        this.checkCanCreateRelation(relation.getFrom());
        this.checkCanCreateRelation(relation.getTo());
        return this.tbEntityRelationService.save(this.getTenantId(), this.getCurrentUser().getCustomerId(), relation, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Delete Relation (deleteRelation)", notes="Deletes a relation between two entities in the platform. \n\nIf the user has the authority of 'System Administrator', the server checks that 'from' and 'to' entities are owned by the sysadmin. If the user has the authority of 'Tenant Administrator', the server checks that 'from' and 'to' entities are owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the 'from' and 'to' entities are assigned to the same customer.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @DeleteMapping(value={"/relation"}, params={"fromId", "fromType", "relationType", "toId", "toType"})
    public void deleteRelation(@Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @RequestParam(value="fromId") String strFromId, @Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true) @RequestParam(value="fromType") String strFromType, @Parameter(description="A string value representing relation type between entities. For example, 'Contains', 'Manages'. It can be any string value.", required=true) @RequestParam(value="relationType") String strRelationType, @Parameter(description="A string value representing relation type group. For example, 'COMMON'") @RequestParam(value="relationTypeGroup", required=false) String strRelationTypeGroup, @Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @RequestParam(value="toId") String strToId, @Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true) @RequestParam(value="toType") String strToType) throws ThingsboardException {
        this.doDelete(strFromId, strFromType, strRelationType, strRelationTypeGroup, strToId, strToType);
    }

    @ApiOperation(value="Delete Relation (deleteRelationV2)", notes="Deletes a relation between two entities in the platform. \n\nIf the user has the authority of 'System Administrator', the server checks that 'from' and 'to' entities are owned by the sysadmin. If the user has the authority of 'Tenant Administrator', the server checks that 'from' and 'to' entities are owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the 'from' and 'to' entities are assigned to the same customer.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @DeleteMapping(value={"/v2/relation"}, params={"fromId", "fromType", "relationType", "toId", "toType"})
    public EntityRelation deleteRelationV2(@Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @RequestParam(value="fromId") String strFromId, @Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true) @RequestParam(value="fromType") String strFromType, @Parameter(description="A string value representing relation type between entities. For example, 'Contains', 'Manages'. It can be any string value.", required=true) @RequestParam(value="relationType") String strRelationType, @Parameter(description="A string value representing relation type group. For example, 'COMMON'") @RequestParam(value="relationTypeGroup", required=false) String strRelationTypeGroup, @Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @RequestParam(value="toId") String strToId, @Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true) @RequestParam(value="toType") String strToType) throws ThingsboardException {
        return this.doDelete(strFromId, strFromType, strRelationType, strRelationTypeGroup, strToId, strToType);
    }

    private EntityRelation doDelete(String strFromId, String strFromType, String strRelationType, String strRelationTypeGroup, String strToId, String strToType) throws ThingsboardException {
        EntityRelationController.checkParameter((String)"fromId", (String)strFromId);
        EntityRelationController.checkParameter((String)"fromType", (String)strFromType);
        EntityRelationController.checkParameter((String)"toId", (String)strToId);
        EntityRelationController.checkParameter((String)"toType", (String)strToType);
        EntityId fromId = EntityIdFactory.getByTypeAndId((String)strFromType, (String)strFromId);
        EntityId toId = EntityIdFactory.getByTypeAndId((String)strToType, (String)strToId);
        this.checkCanCreateRelation(fromId);
        this.checkCanCreateRelation(toId);
        RelationTypeGroup relationTypeGroup = EntityRelationController.parseRelationTypeGroup((String)strRelationTypeGroup, (RelationTypeGroup)RelationTypeGroup.COMMON);
        EntityRelation relation = new EntityRelation(fromId, toId, strRelationType, relationTypeGroup);
        return this.tbEntityRelationService.delete(this.getTenantId(), this.getCurrentUser().getCustomerId(), relation, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Delete common relations (deleteCommonRelations)", notes="Deletes all the relations ('from' and 'to' direction) for the specified entity and relation type group: 'COMMON'. \n\nIf the user has the authority of 'System Administrator', the server checks that the entity is owned by the sysadmin. If the user has the authority of 'Tenant Administrator', the server checks that the entity is owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the entity is assigned to the same customer.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN','TENANT_ADMIN', 'CUSTOMER_USER')")
    @DeleteMapping(value={"/relations"}, params={"entityId", "entityType"})
    public void deleteRelations(@Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @RequestParam(value="entityId") String strId, @Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true) @RequestParam(value="entityType") String strType) throws ThingsboardException {
        EntityRelationController.checkParameter((String)"entityId", (String)strId);
        EntityRelationController.checkParameter((String)"entityType", (String)strType);
        EntityId entityId = EntityIdFactory.getByTypeAndId((String)strType, (String)strId);
        this.checkEntityId(entityId, Operation.WRITE);
        this.tbEntityRelationService.deleteCommonRelations(this.getTenantId(), this.getCurrentUser().getCustomerId(), entityId, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Get Relation (getRelation)", notes="Returns relation object between two specified entities if present. Otherwise throws exception. \n\nIf the user has the authority of 'System Administrator', the server checks that 'from' and 'to' entities are owned by the sysadmin. If the user has the authority of 'Tenant Administrator', the server checks that 'from' and 'to' entities are owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the 'from' and 'to' entities are assigned to the same customer.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/relation"}, params={"fromId", "fromType", "relationType", "toId", "toType"})
    public EntityRelation getRelation(@Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @RequestParam(value="fromId") String strFromId, @Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true) @RequestParam(value="fromType") String strFromType, @Parameter(description="A string value representing relation type between entities. For example, 'Contains', 'Manages'. It can be any string value.", required=true) @RequestParam(value="relationType") String strRelationType, @Parameter(description="A string value representing relation type group. For example, 'COMMON'") @RequestParam(value="relationTypeGroup", required=false) String strRelationTypeGroup, @Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @RequestParam(value="toId") String strToId, @Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true) @RequestParam(value="toType") String strToType) throws ThingsboardException {
        EntityRelationController.checkParameter((String)"fromId", (String)strFromId);
        EntityRelationController.checkParameter((String)"fromType", (String)strFromType);
        EntityRelationController.checkParameter((String)"toId", (String)strToId);
        EntityRelationController.checkParameter((String)"toType", (String)strToType);
        EntityId fromId = EntityIdFactory.getByTypeAndId((String)strFromType, (String)strFromId);
        EntityId toId = EntityIdFactory.getByTypeAndId((String)strToType, (String)strToId);
        this.checkEntityId(fromId, Operation.READ);
        this.checkEntityId(toId, Operation.READ);
        RelationTypeGroup typeGroup = EntityRelationController.parseRelationTypeGroup((String)strRelationTypeGroup, (RelationTypeGroup)RelationTypeGroup.COMMON);
        return (EntityRelation)this.checkNotNull((Object)this.relationService.getRelation(this.getTenantId(), fromId, toId, strRelationType, typeGroup));
    }

    @ApiOperation(value="Get List of Relations (findByFrom)", notes="Returns list of relation objects for the specified entity by the 'from' direction. \n\nIf the user has the authority of 'System Administrator', the server checks that the entity is owned by the sysadmin. If the user has the authority of 'Tenant Administrator', the server checks that the entity is owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the entity is assigned to the same customer.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/relations"}, params={"fromId", "fromType"})
    public List<EntityRelation> findByFrom(@Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @RequestParam(value="fromId") String strFromId, @Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true) @RequestParam(value="fromType") String strFromType, @Parameter(description="A string value representing relation type group. For example, 'COMMON'") @RequestParam(value="relationTypeGroup", required=false) String strRelationTypeGroup) throws ThingsboardException {
        EntityRelationController.checkParameter((String)"fromId", (String)strFromId);
        EntityRelationController.checkParameter((String)"fromType", (String)strFromType);
        EntityId entityId = EntityIdFactory.getByTypeAndId((String)strFromType, (String)strFromId);
        this.checkEntityId(entityId, Operation.READ);
        RelationTypeGroup typeGroup = EntityRelationController.parseRelationTypeGroup((String)strRelationTypeGroup, (RelationTypeGroup)RelationTypeGroup.COMMON);
        return (List)this.checkNotNull((Object)this.filterRelationsByReadPermission(this.relationService.findByFrom(this.getTenantId(), entityId, typeGroup)));
    }

    @ApiOperation(value="Get List of Relation Infos (findInfoByFrom)", notes="Returns list of relation info objects for the specified entity by the 'from' direction. \n\nIf the user has the authority of 'System Administrator', the server checks that the entity is owned by the sysadmin. If the user has the authority of 'Tenant Administrator', the server checks that the entity is owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the entity is assigned to the same customer. Relation Info is an extension of the default Relation object that contains information about the 'from' and 'to' entity names. ")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/relations/info"}, params={"fromId", "fromType"})
    public List<EntityRelationInfo> findInfoByFrom(@Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @RequestParam(value="fromId") String strFromId, @Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true) @RequestParam(value="fromType") String strFromType, @Parameter(description="A string value representing relation type group. For example, 'COMMON'") @RequestParam(value="relationTypeGroup", required=false) String strRelationTypeGroup) throws ThingsboardException, ExecutionException, InterruptedException {
        EntityRelationController.checkParameter((String)"fromId", (String)strFromId);
        EntityRelationController.checkParameter((String)"fromType", (String)strFromType);
        EntityId entityId = EntityIdFactory.getByTypeAndId((String)strFromType, (String)strFromId);
        this.checkEntityId(entityId, Operation.READ);
        RelationTypeGroup typeGroup = EntityRelationController.parseRelationTypeGroup((String)strRelationTypeGroup, (RelationTypeGroup)RelationTypeGroup.COMMON);
        return (List)this.checkNotNull((Object)this.filterRelationsByReadPermission((List)this.relationService.findInfoByFrom(this.getTenantId(), entityId, typeGroup).get()));
    }

    @ApiOperation(value="Get List of Relations (findByFrom)", notes="Returns list of relation objects for the specified entity by the 'from' direction and relation type. \n\nIf the user has the authority of 'System Administrator', the server checks that the entity is owned by the sysadmin. If the user has the authority of 'Tenant Administrator', the server checks that the entity is owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the entity is assigned to the same customer.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/relations"}, params={"fromId", "fromType", "relationType"})
    public List<EntityRelation> findByFrom(@Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @RequestParam(value="fromId") String strFromId, @Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true) @RequestParam(value="fromType") String strFromType, @Parameter(description="A string value representing relation type between entities. For example, 'Contains', 'Manages'. It can be any string value.", required=true) @RequestParam(value="relationType") String strRelationType, @Parameter(description="A string value representing relation type group. For example, 'COMMON'") @RequestParam(value="relationTypeGroup", required=false) String strRelationTypeGroup) throws ThingsboardException {
        EntityRelationController.checkParameter((String)"fromId", (String)strFromId);
        EntityRelationController.checkParameter((String)"fromType", (String)strFromType);
        EntityRelationController.checkParameter((String)"relationType", (String)strRelationType);
        EntityId entityId = EntityIdFactory.getByTypeAndId((String)strFromType, (String)strFromId);
        this.checkEntityId(entityId, Operation.READ);
        RelationTypeGroup typeGroup = EntityRelationController.parseRelationTypeGroup((String)strRelationTypeGroup, (RelationTypeGroup)RelationTypeGroup.COMMON);
        return (List)this.checkNotNull((Object)this.filterRelationsByReadPermission(this.relationService.findByFromAndType(this.getTenantId(), entityId, strRelationType, typeGroup)));
    }

    @ApiOperation(value="Get List of Relations (findByTo)", notes="Returns list of relation objects for the specified entity by the 'to' direction. \n\nIf the user has the authority of 'System Administrator', the server checks that the entity is owned by the sysadmin. If the user has the authority of 'Tenant Administrator', the server checks that the entity is owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the entity is assigned to the same customer.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/relations"}, params={"toId", "toType"})
    public List<EntityRelation> findByTo(@Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @RequestParam(value="toId") String strToId, @Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true) @RequestParam(value="toType") String strToType, @Parameter(description="A string value representing relation type group. For example, 'COMMON'") @RequestParam(value="relationTypeGroup", required=false) String strRelationTypeGroup) throws ThingsboardException {
        EntityRelationController.checkParameter((String)"toId", (String)strToId);
        EntityRelationController.checkParameter((String)"toType", (String)strToType);
        EntityId entityId = EntityIdFactory.getByTypeAndId((String)strToType, (String)strToId);
        this.checkEntityId(entityId, Operation.READ);
        RelationTypeGroup typeGroup = EntityRelationController.parseRelationTypeGroup((String)strRelationTypeGroup, (RelationTypeGroup)RelationTypeGroup.COMMON);
        return (List)this.checkNotNull((Object)this.filterRelationsByReadPermission(this.relationService.findByTo(this.getTenantId(), entityId, typeGroup)));
    }

    @ApiOperation(value="Get List of Relation Infos (findInfoByTo)", notes="Returns list of relation info objects for the specified entity by the 'to' direction. \n\nIf the user has the authority of 'System Administrator', the server checks that the entity is owned by the sysadmin. If the user has the authority of 'Tenant Administrator', the server checks that the entity is owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the entity is assigned to the same customer. Relation Info is an extension of the default Relation object that contains information about the 'from' and 'to' entity names. ")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/relations/info"}, params={"toId", "toType"})
    public List<EntityRelationInfo> findInfoByTo(@Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @RequestParam(value="toId") String strToId, @Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true) @RequestParam(value="toType") String strToType, @Parameter(description="A string value representing relation type group. For example, 'COMMON'") @RequestParam(value="relationTypeGroup", required=false) String strRelationTypeGroup) throws ThingsboardException, ExecutionException, InterruptedException {
        EntityRelationController.checkParameter((String)"toId", (String)strToId);
        EntityRelationController.checkParameter((String)"toType", (String)strToType);
        EntityId entityId = EntityIdFactory.getByTypeAndId((String)strToType, (String)strToId);
        this.checkEntityId(entityId, Operation.READ);
        RelationTypeGroup typeGroup = EntityRelationController.parseRelationTypeGroup((String)strRelationTypeGroup, (RelationTypeGroup)RelationTypeGroup.COMMON);
        return (List)this.checkNotNull((Object)this.filterRelationsByReadPermission((List)this.relationService.findInfoByTo(this.getTenantId(), entityId, typeGroup).get()));
    }

    @ApiOperation(value="Get List of Relations (findByTo)", notes="Returns list of relation objects for the specified entity by the 'to' direction and relation type. \n\nIf the user has the authority of 'System Administrator', the server checks that the entity is owned by the sysadmin. If the user has the authority of 'Tenant Administrator', the server checks that the entity is owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the entity is assigned to the same customer.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/relations"}, params={"toId", "toType", "relationType"})
    public List<EntityRelation> findByTo(@Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @RequestParam(value="toId") String strToId, @Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true) @RequestParam(value="toType") String strToType, @Parameter(description="A string value representing relation type between entities. For example, 'Contains', 'Manages'. It can be any string value.", required=true) @RequestParam(value="relationType") String strRelationType, @Parameter(description="A string value representing relation type group. For example, 'COMMON'") @RequestParam(value="relationTypeGroup", required=false) String strRelationTypeGroup) throws ThingsboardException {
        EntityRelationController.checkParameter((String)"toId", (String)strToId);
        EntityRelationController.checkParameter((String)"toType", (String)strToType);
        EntityRelationController.checkParameter((String)"relationType", (String)strRelationType);
        EntityId entityId = EntityIdFactory.getByTypeAndId((String)strToType, (String)strToId);
        this.checkEntityId(entityId, Operation.READ);
        RelationTypeGroup typeGroup = EntityRelationController.parseRelationTypeGroup((String)strRelationTypeGroup, (RelationTypeGroup)RelationTypeGroup.COMMON);
        return (List)this.checkNotNull((Object)this.filterRelationsByReadPermission(this.relationService.findByToAndType(this.getTenantId(), entityId, strRelationType, typeGroup)));
    }

    @ApiOperation(value="Find related entities (findByQuery)", notes="Returns all entities that are related to the specific entity. The entity id, relation type, entity types, depth of the search, and other query parameters defined using complex 'EntityRelationsQuery' object. See 'Model' tab of the Parameters for more info.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/relations"})
    public List<EntityRelation> findByQuery(@Parameter(description="A JSON value representing the entity relations query object.", required=true) @RequestBody EntityRelationsQuery query) throws ThingsboardException, ExecutionException, InterruptedException {
        this.checkNotNull((Object)query.getParameters());
        this.checkNotNull((Object)query.getFilters());
        this.checkEntityId(query.getParameters().getEntityId(), Operation.READ);
        return (List)this.checkNotNull((Object)this.filterRelationsByReadPermission((List)this.relationService.findByQuery(this.getTenantId(), query).get()));
    }

    @ApiOperation(value="Find related entity infos (findInfoByQuery)", notes="Returns all entity infos that are related to the specific entity. The entity id, relation type, entity types, depth of the search, and other query parameters defined using complex 'EntityRelationsQuery' object. See 'Model' tab of the Parameters for more info. Relation Info is an extension of the default Relation object that contains information about the 'from' and 'to' entity names. ")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/relations/info"})
    public List<EntityRelationInfo> findInfoByQuery(@Parameter(description="A JSON value representing the entity relations query object.", required=true) @RequestBody EntityRelationsQuery query) throws ThingsboardException, ExecutionException, InterruptedException {
        this.checkNotNull((Object)query.getParameters());
        this.checkNotNull((Object)query.getFilters());
        this.checkEntityId(query.getParameters().getEntityId(), Operation.READ);
        return (List)this.checkNotNull((Object)this.filterRelationsByReadPermission((List)this.relationService.findInfoByQuery(this.getTenantId(), query).get()));
    }

    private void checkCanCreateRelation(EntityId entityId) throws ThingsboardException {
        boolean isTenantAdminAndRelateToSelf;
        SecurityUser currentUser = this.getCurrentUser();
        boolean bl = isTenantAdminAndRelateToSelf = currentUser.isTenantAdmin() && currentUser.getTenantId().equals((Object)entityId);
        if (!isTenantAdminAndRelateToSelf) {
            this.checkEntityId(entityId, Operation.WRITE);
        }
    }

    private <T extends EntityRelation> List<T> filterRelationsByReadPermission(List<T> relationsByQuery) {
        return relationsByQuery.stream().filter(relationByQuery -> {
            try {
                this.checkEntityId(relationByQuery.getTo(), Operation.READ);
            }
            catch (ThingsboardException e) {
                return false;
            }
            try {
                this.checkEntityId(relationByQuery.getFrom(), Operation.READ);
            }
            catch (ThingsboardException e) {
                return false;
            }
            return true;
        }).toList();
    }

    private static RelationTypeGroup parseRelationTypeGroup(String strRelationTypeGroup, RelationTypeGroup defaultValue) {
        if (StringUtils.isBlank((String)strRelationTypeGroup)) {
            return defaultValue;
        }
        try {
            return RelationTypeGroup.valueOf((String)strRelationTypeGroup);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    @ConstructorProperties(value={"tbEntityRelationService"})
    @Generated
    public EntityRelationController(TbEntityRelationService tbEntityRelationService) {
        this.tbEntityRelationService = tbEntityRelationService;
    }
}

