/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.ContactBased;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.EntityInfo;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.ShortEntityView;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.group.EntityGroupInfo;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.RoleId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.ota.DeviceGroupOtaPackage;
import org.thingsboard.server.common.data.ota.OtaPackageType;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.GroupPermission;
import org.thingsboard.server.common.data.permission.MergedGroupPermissionInfo;
import org.thingsboard.server.common.data.permission.MergedGroupTypePermissionInfo;
import org.thingsboard.server.common.data.permission.MergedUserPermissions;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.common.data.permission.ShareGroupRequest;
import org.thingsboard.server.common.data.role.Role;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.AutoCommitController;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.dao.owner.OwnerService;
import org.thingsboard.server.dao.role.RoleService;
import org.thingsboard.server.dao.service.Validator;
import org.thingsboard.server.dao.user.UserService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.entity.group.TbEntityGroupService;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.permission.OwnersCacheService;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class EntityGroupController
extends AutoCommitController {
    private final TbEntityGroupService tbEntityGroupService;
    private final OwnersCacheService ownersCacheService;
    private final OwnerService ownerService;
    private final RoleService roleService;
    private final UserService userService;
    public static final String ENTITY_GROUP_DESCRIPTION = "Entity group allows you to group multiple entities of the same entity type (Device, Asset, Customer, User, Dashboard, etc). Entity Group always have an owner - particular Tenant or Customer. Each entity may belong to multiple groups simultaneously.";
    public static final String ENTITY_GROUP_INFO_DESCRIPTION = "Entity Group Info extends Entity Group object and adds 'ownerIds' - a list of owner ids.";
    private static final String ENTITY_GROUP_ENTITY_INFO_DESCRIPTION = "Entity Info is a lightweight object that contains only id and name of the entity group. ";
    private static final String ENTITY_GROUP_UNIQUE_KEY = "Entity group name is unique in the scope of owner and entity type. For example, you can't create two tenant device groups called 'Water meters'. However, you may create device and asset group with the same name. And also you may create groups with the same name for two different customers of the same tenant. ";
    private static final String OWNER_TYPE_DESCRIPTION = "Tenant or Customer";
    private static final String OWNER_ID_DESCRIPTION = "A string value representing the Tenant or Customer id";
    private static final String ENTITY_GROUP_TYPE_PARAMETER_DESCRIPTION = "Entity Group type";
    private static final String SHORT_ENTITY_VIEW_DESCRIPTION = "Short Entity View object contains the entity id and number of fields (attributes, telemetry, etc). List of those fields is configurable and defined in the group configuration.";

    @ApiOperation(value="Get Entity Group Info (getEntityGroupById)", notes="Fetch the Entity Group object based on the provided Entity Group Id. Entity group allows you to group multiple entities of the same entity type (Device, Asset, Customer, User, Dashboard, etc). Entity Group always have an owner - particular Tenant or Customer. Each entity may belong to multiple groups simultaneously.Entity Group Info extends Entity Group object and adds 'ownerIds' - a list of owner ids.\n\nEntity group name is unique in the scope of owner and entity type. For example, you can't create two tenant device groups called 'Water meters'. However, you may create device and asset group with the same name. And also you may create groups with the same name for two different customers of the same tenant. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for specified group.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/entityGroup/{entityGroupId}"})
    public EntityGroupInfo getEntityGroupById(@Parameter(description="A string value representing the Entity Group Id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityGroupId") String strEntityGroupId) throws ThingsboardException {
        EntityGroupController.checkParameter((String)"entityGroupId", (String)strEntityGroupId);
        EntityGroupId entityGroupId = new EntityGroupId(this.toUUID(strEntityGroupId));
        return this.checkEntityGroupId(entityGroupId, Operation.READ);
    }

    @ApiOperation(value="Get Entity Group Entity Info (getEntityGroupEntityInfoById)", notes="Fetch the Entity Group Entity Info object based on the provided Entity Group Id. Entity Info is a lightweight object that contains only id and name of the entity group. \n\nEntity group name is unique in the scope of owner and entity type. For example, you can't create two tenant device groups called 'Water meters'. However, you may create device and asset group with the same name. And also you may create groups with the same name for two different customers of the same tenant. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for specified group.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/entityGroupInfo/{entityGroupId}"})
    public EntityInfo getEntityGroupEntityInfoById(@Parameter(description="A string value representing the Entity Group Id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityGroupId") String strEntityGroupId) throws ThingsboardException {
        EntityGroupController.checkParameter((String)"entityGroupId", (String)strEntityGroupId);
        EntityGroupId entityGroupId = new EntityGroupId(this.toUUID(strEntityGroupId));
        EntityGroupInfo entityGroup = this.checkEntityGroupId(entityGroupId, Operation.READ);
        return new EntityInfo((EntityId)entityGroup.getId(), entityGroup.getName());
    }

    @ApiOperation(value="Get Entity Group by owner, type and name (getEntityGroupByOwnerAndNameAndType)", notes="Fetch the Entity Group object based on the provided Entity Group Id. Entity group allows you to group multiple entities of the same entity type (Device, Asset, Customer, User, Dashboard, etc). Entity Group always have an owner - particular Tenant or Customer. Each entity may belong to multiple groups simultaneously.Entity Group Info extends Entity Group object and adds 'ownerIds' - a list of owner ids.\n\nEntity group name is unique in the scope of owner and entity type. For example, you can't create two tenant device groups called 'Water meters'. However, you may create device and asset group with the same name. And also you may create groups with the same name for two different customers of the same tenant. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for specified group.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/entityGroup/{ownerType}/{ownerId}/{groupType}/{groupName}"})
    public EntityGroupInfo getEntityGroupByOwnerAndNameAndType(@Parameter(description="Tenant or Customer", required=true, schema=@Schema(allowableValues={"TENANT", "CUSTOMER"})) @PathVariable(value="ownerType") String strOwnerType, @Parameter(description="A string value representing the Tenant or Customer id", required=true, example="784f394c-42b6-435a-983c-b7beff2784f9") @PathVariable(value="ownerId") String strOwnerId, @Parameter(description="Entity Group type", required=true, schema=@Schema(allowableValues={"CUSTOMER", "ASSET", "DEVICE", "USER", "ENTITY_VIEW", "DASHBOARD", "EDGE"})) @PathVariable(value="groupType") String strGroupType, @Parameter(description="Entity Group name", required=true) @PathVariable(value="groupName") String groupName) throws ThingsboardException {
        EntityGroupController.checkParameter((String)"ownerId", (String)strOwnerId);
        EntityGroupController.checkParameter((String)"ownerType", (String)strOwnerType);
        EntityGroupController.checkParameter((String)"groupName", (String)groupName);
        EntityType groupType = this.checkStrEntityGroupType("groupType", strGroupType);
        EntityId ownerId = EntityIdFactory.getByTypeAndId((String)strOwnerType, (String)strOwnerId);
        this.checkEntityId(ownerId, Operation.READ);
        SecurityUser currentUser = this.getCurrentUser();
        Optional entityGroupOptional = this.entityGroupService.findOwnerEntityGroupInfo(currentUser.getTenantId(), ownerId, groupType, groupName);
        if (entityGroupOptional.isPresent()) {
            this.accessControlService.checkEntityGroupInfoPermission(this.getCurrentUser(), Operation.READ, (EntityGroupInfo)entityGroupOptional.get());
            return (EntityGroupInfo)entityGroupOptional.get();
        }
        throw new ThingsboardException("Requested item wasn't found!", ThingsboardErrorCode.ITEM_NOT_FOUND);
    }

    @ApiOperation(value="Create Or Update Entity Group (saveEntityGroup)", notes="Create or update the Entity Group. When creating Entity Group, platform generates Entity Group Id as [time-based UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_1_(date-time_and_MAC_address)). The newly created Entity Group Id will be present in the response. Specify existing Entity Group Id to update the group. Referencing non-existing Entity Group Id will cause 'Not Found' error.Remove 'id', 'tenantId' and optionally 'ownerId' from the request body example (below) to create new Entity Group entity. \n\nEntity group name is unique in the scope of owner and entity type. For example, you can't create two tenant device groups called 'Water meters'. However, you may create device and asset group with the same name. And also you may create groups with the same name for two different customers of the same tenant. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'WRITE' permission for specified group.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/entityGroup"})
    public EntityGroupInfo saveEntityGroup(@Parameter(description="A JSON value representing the entity group.", required=true) @RequestBody EntityGroup entityGroup) throws Exception {
        SecurityUser currentUser = this.getCurrentUser();
        this.checkEntityGroupType(entityGroup.getType());
        Operation operation = entityGroup.getId() == null ? Operation.CREATE : Operation.WRITE;
        EntityId parentEntityId = entityGroup.getOwnerId();
        if (operation == Operation.CREATE) {
            if (parentEntityId == null || parentEntityId.isNullUid()) {
                parentEntityId = currentUser.getOwnerId();
            } else if (!this.ownersCacheService.fetchOwnersHierarchy(this.getTenantId(), parentEntityId).contains(currentUser.getOwnerId())) {
                throw new ThingsboardException("Unable to create entity group: Invalid entity group ownerId!", ThingsboardErrorCode.PERMISSION_DENIED);
            }
        } else {
            Validator.validateEntityId((EntityId)parentEntityId, id -> "Incorrect entity group ownerId " + String.valueOf(id));
        }
        EntityGroupInfo entityGroupInfo = new EntityGroupInfo(entityGroup, this.ownersCacheService.fetchOwnersHierarchy(this.getTenantId(), parentEntityId));
        this.accessControlService.checkEntityGroupInfoPermission(currentUser, operation, entityGroupInfo);
        return this.tbEntityGroupService.save(this.getTenantId(), parentEntityId, entityGroup, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Delete Entity Group (deleteEntityGroup)", notes="Deletes the entity group but does not delete the entities in the group, since they are also present in reserved group 'All'. Referencing non-existing Entity Group Id will cause an error.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'DELETE' permission for specified group.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @DeleteMapping(value={"/entityGroup/{entityGroupId}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteEntityGroup(@Parameter(description="A string value representing the Entity Group Id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityGroupId") String strEntityGroupId) throws Exception {
        EntityGroupController.checkParameter((String)"entityGroupId", (String)strEntityGroupId);
        EntityGroupId entityGroupId = new EntityGroupId(this.toUUID(strEntityGroupId));
        EntityGroupInfo entityGroup = this.checkEntityGroupId(entityGroupId, Operation.DELETE);
        if (entityGroup.isGroupAll()) {
            throw new ThingsboardException("Unable to remove entity group: Removal of entity group 'All' is forbidden!", ThingsboardErrorCode.PERMISSION_DENIED);
        }
        if (this.entityGroupService.isTenantAdminUserGroup((EntityGroup)entityGroup)) {
            List entityGroupUsers = this.userService.findUsersByEntityGroupIds(List.of(entityGroupId), new PageLink(Integer.MAX_VALUE)).getData().stream().map(User::getId).collect(Collectors.toList());
            if (this.entityGroupService.containsLastTenantAdmin(this.getTenantId(), entityGroupUsers)) {
                throw new ThingsboardException("At least one tenant administrator must remain!", ThingsboardErrorCode.INVALID_ARGUMENTS);
            }
        } else if (EntityType.USER.equals((Object)entityGroup.getType()) && this.userService.existsInEntityGroup(this.getCurrentUser().getId(), entityGroupId)) {
            throw new ThingsboardException("Unable to remove the user group associated with the current user.", ThingsboardErrorCode.INVALID_ARGUMENTS);
        }
        ArrayList groupPermissions = new ArrayList((Collection)this.groupPermissionService.findGroupPermissionInfoListByTenantIdAndEntityGroupIdAsync(this.getTenantId(), entityGroupId).get());
        if (EntityType.USER.equals((Object)entityGroup.getType())) {
            groupPermissions.addAll((Collection)this.groupPermissionService.findGroupPermissionInfoListByTenantIdAndUserGroupIdAsync(this.getTenantId(), entityGroupId).get());
        }
        for (GroupPermission groupPermission : groupPermissions) {
            this.userPermissionsService.onGroupPermissionDeleted(groupPermission);
        }
        this.tbEntityGroupService.delete(this.getTenantId(), (EntityGroup)entityGroup, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Get Entity Groups by entity type (getEntityGroupsByType)", notes="Fetch the list of Entity Group Info objects based on the provided Entity Type. Entity group allows you to group multiple entities of the same entity type (Device, Asset, Customer, User, Dashboard, etc). Entity Group always have an owner - particular Tenant or Customer. Each entity may belong to multiple groups simultaneously.Entity Group Info extends Entity Group object and adds 'ownerIds' - a list of owner ids.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for specified group.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/entityGroups/{groupType}"})
    public List<EntityGroupInfo> getEntityGroupsByType(@Parameter(description="Entity Group type", required=true, schema=@Schema(allowableValues={"CUSTOMER", "ASSET", "DEVICE", "USER", "ENTITY_VIEW", "DASHBOARD", "EDGE"})) @PathVariable(value="groupType") String strGroupType, @Parameter(description="Whether to include shared entity groups.") @RequestParam(required=false) Boolean includeShared) throws ThingsboardException {
        EntityType groupType = this.checkStrEntityGroupType("groupType", strGroupType);
        MergedGroupTypePermissionInfo groupTypePermissionInfo = (MergedGroupTypePermissionInfo)this.getCurrentUser().getUserPermissions().getReadGroupPermissions().get(groupType);
        if (groupTypePermissionInfo.isHasGenericRead() || !groupTypePermissionInfo.getEntityGroupIds().isEmpty() && (includeShared == null || includeShared.booleanValue())) {
            PageData entityGroupInfos;
            if (groupTypePermissionInfo.isHasGenericRead()) {
                TenantId parentEntityId;
                Object object = parentEntityId = this.getCurrentUser().isTenantAdmin() ? this.getCurrentUser().getTenantId() : this.getCurrentUser().getCustomerId();
                entityGroupInfos = !groupTypePermissionInfo.getEntityGroupIds().isEmpty() && (includeShared == null || includeShared.booleanValue()) ? this.entityGroupService.findEntityGroupInfosByTypeOrIds(this.getTenantId(), (EntityId)parentEntityId, groupType, groupTypePermissionInfo.getEntityGroupIds(), new PageLink(Integer.MAX_VALUE)) : this.entityGroupService.findEntityGroupInfosByType(this.getTenantId(), (EntityId)parentEntityId, groupType, new PageLink(Integer.MAX_VALUE));
            } else {
                entityGroupInfos = this.entityGroupService.findEntityGroupInfosByIds(this.getTenantId(), groupTypePermissionInfo.getEntityGroupIds(), new PageLink(Integer.MAX_VALUE));
            }
            return entityGroupInfos.getData();
        }
        return Collections.emptyList();
    }

    @ApiOperation(value="Get Entity Groups by entity type and page link (getEntityGroupsByTypeAndPageLink)", notes="Returns a page of Entity Group Info objects based on the provided Entity Type and Page Link. Entity group allows you to group multiple entities of the same entity type (Device, Asset, Customer, User, Dashboard, etc). Entity Group always have an owner - particular Tenant or Customer. Each entity may belong to multiple groups simultaneously.Entity Group Info extends Entity Group object and adds 'ownerIds' - a list of owner ids.You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for specified group.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/entityGroups/{groupType}"}, params={"pageSize", "page"})
    public PageData<EntityGroupInfo> getEntityGroupsByTypeAndPageLink(@Parameter(description="Entity Group type", required=true, schema=@Schema(allowableValues={"CUSTOMER", "ASSET", "DEVICE", "USER", "ENTITY_VIEW", "DASHBOARD", "EDGE"})) @PathVariable(value="groupType") String strGroupType, @Parameter(description="Whether to include shared entity groups.") @RequestParam(required=false) Boolean includeShared, @Parameter(description="Maximum amount of entities in a one page", required=true, schema=@Schema(minimum="1")) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true, schema=@Schema(minimum="0")) @RequestParam int page, @Parameter(description="The case insensitive 'startsWith' filter based on the entity group name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by") @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        EntityType groupType = this.checkStrEntityGroupType("groupType", strGroupType);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        MergedGroupTypePermissionInfo groupTypePermissionInfo = (MergedGroupTypePermissionInfo)this.getCurrentUser().getUserPermissions().getReadGroupPermissions().get(groupType);
        if (groupTypePermissionInfo.isHasGenericRead() || !groupTypePermissionInfo.getEntityGroupIds().isEmpty() && (includeShared == null || includeShared.booleanValue())) {
            if (groupTypePermissionInfo.isHasGenericRead()) {
                TenantId parentEntityId;
                Object object = parentEntityId = this.getCurrentUser().isTenantAdmin() ? this.getCurrentUser().getTenantId() : this.getCurrentUser().getCustomerId();
                if (!groupTypePermissionInfo.getEntityGroupIds().isEmpty() && (includeShared == null || includeShared.booleanValue())) {
                    return this.entityGroupService.findEntityGroupInfosByTypeOrIds(this.getTenantId(), (EntityId)parentEntityId, groupType, groupTypePermissionInfo.getEntityGroupIds(), pageLink);
                }
                return this.entityGroupService.findEntityGroupInfosByType(this.getTenantId(), (EntityId)parentEntityId, groupType, pageLink);
            }
            return this.entityGroupService.findEntityGroupInfosByIds(this.getTenantId(), groupTypePermissionInfo.getEntityGroupIds(), pageLink);
        }
        return PageData.emptyPageData();
    }

    @ApiOperation(value="Get Entity Group Entity Infos by entity type and page link (getEntityGroupEntityInfosByTypeAndPageLink)", notes="Returns a page of Entity Group Entity Info objects based on the provided Entity Type and Page Link. Entity Info is a lightweight object that contains only id and name of the entity group. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for specified group.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/entityGroupInfos/{groupType}"}, params={"pageSize", "page"})
    public PageData<EntityInfo> getEntityGroupEntityInfosByTypeAndPageLink(@Parameter(description="Entity Group type", required=true, schema=@Schema(allowableValues={"CUSTOMER", "ASSET", "DEVICE", "USER", "ENTITY_VIEW", "DASHBOARD", "EDGE"})) @PathVariable(value="groupType") String strGroupType, @Parameter(description="Whether to include shared entity groups.") @RequestParam(required=false) Boolean includeShared, @Parameter(description="Maximum amount of entities in a one page", required=true, schema=@Schema(minimum="1")) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true, schema=@Schema(minimum="0")) @RequestParam int page, @Parameter(description="The case insensitive 'startsWith' filter based on the entity group name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by") @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        EntityType groupType = this.checkStrEntityGroupType("groupType", strGroupType);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        MergedGroupTypePermissionInfo groupTypePermissionInfo = (MergedGroupTypePermissionInfo)this.getCurrentUser().getUserPermissions().getReadGroupPermissions().get(groupType);
        if (groupTypePermissionInfo.isHasGenericRead() || !groupTypePermissionInfo.getEntityGroupIds().isEmpty() && (includeShared == null || includeShared.booleanValue())) {
            if (groupTypePermissionInfo.isHasGenericRead()) {
                TenantId parentEntityId;
                Object object = parentEntityId = this.getCurrentUser().isTenantAdmin() ? this.getCurrentUser().getTenantId() : this.getCurrentUser().getCustomerId();
                if (!groupTypePermissionInfo.getEntityGroupIds().isEmpty() && (includeShared == null || includeShared.booleanValue())) {
                    return this.entityGroupService.findEntityGroupEntityInfosByTypeOrIds(this.getTenantId(), (EntityId)parentEntityId, groupType, groupTypePermissionInfo.getEntityGroupIds(), pageLink);
                }
                return this.entityGroupService.findEntityGroupEntityInfosByType(this.getTenantId(), (EntityId)parentEntityId, groupType, pageLink);
            }
            return this.entityGroupService.findEntityGroupEntityInfosByIds(this.getTenantId(), groupTypePermissionInfo.getEntityGroupIds(), pageLink);
        }
        return PageData.emptyPageData();
    }

    @ApiOperation(value="Get Shared Entity Groups by entity type (getSharedEntityGroupsByType)", notes="Fetch the list of Shared Entity Group Info objects based on the provided Entity Type. Entity group allows you to group multiple entities of the same entity type (Device, Asset, Customer, User, Dashboard, etc). Entity Group always have an owner - particular Tenant or Customer. Each entity may belong to multiple groups simultaneously.Entity Group Info extends Entity Group object and adds 'ownerIds' - a list of owner ids.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for specified group.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/entityGroups/{groupType}/shared"})
    public List<EntityGroupInfo> getSharedEntityGroupsByType(@Parameter(description="Entity Group type", required=true, schema=@Schema(allowableValues={"CUSTOMER", "ASSET", "DEVICE", "USER", "ENTITY_VIEW", "DASHBOARD", "EDGE"})) @PathVariable(value="groupType") String strGroupType) throws ThingsboardException {
        EntityType groupType = this.checkStrEntityGroupType("groupType", strGroupType);
        MergedGroupTypePermissionInfo groupTypePermissionInfo = (MergedGroupTypePermissionInfo)this.getCurrentUser().getUserPermissions().getReadGroupPermissions().get(groupType);
        if (!groupTypePermissionInfo.getEntityGroupIds().isEmpty()) {
            PageData entityGroupInfos = this.entityGroupService.findEntityGroupInfosByIds(this.getTenantId(), groupTypePermissionInfo.getEntityGroupIds(), new PageLink(Integer.MAX_VALUE));
            return entityGroupInfos.getData();
        }
        return Collections.emptyList();
    }

    @ApiOperation(value="Get Shared Entity Groups by entity type and page link (getSharedEntityGroupsByTypeAndPageLink)", notes="Returns a page of Shared Entity Group Info objects based on the provided Entity Type and Page Link. Entity group allows you to group multiple entities of the same entity type (Device, Asset, Customer, User, Dashboard, etc). Entity Group always have an owner - particular Tenant or Customer. Each entity may belong to multiple groups simultaneously.Entity Group Info extends Entity Group object and adds 'ownerIds' - a list of owner ids.You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for specified group.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/entityGroups/{groupType}/shared"}, params={"pageSize", "page"})
    public PageData<EntityGroupInfo> getSharedEntityGroupsByTypeAndPageLink(@Parameter(description="Entity Group type", required=true, schema=@Schema(allowableValues={"CUSTOMER", "ASSET", "DEVICE", "USER", "ENTITY_VIEW", "DASHBOARD", "EDGE"})) @PathVariable(value="groupType") String strGroupType, @Parameter(description="Maximum amount of entities in a one page", required=true, schema=@Schema(minimum="1")) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true, schema=@Schema(minimum="0")) @RequestParam int page, @Parameter(description="The case insensitive 'startsWith' filter based on the entity group name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by") @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        EntityType groupType = this.checkStrEntityGroupType("groupType", strGroupType);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        MergedGroupTypePermissionInfo groupTypePermissionInfo = (MergedGroupTypePermissionInfo)this.getCurrentUser().getUserPermissions().getReadGroupPermissions().get(groupType);
        if (!groupTypePermissionInfo.getEntityGroupIds().isEmpty()) {
            return this.entityGroupService.findEntityGroupInfosByIds(this.getTenantId(), groupTypePermissionInfo.getEntityGroupIds(), pageLink);
        }
        return PageData.emptyPageData();
    }

    @ApiOperation(value="Get Shared Entity Group Entity Infos by entity type and page link (getSharedEntityGroupEntityInfosByTypeAndPageLink)", notes="Returns a page of Shared Entity Group Entity Info objects based on the provided Entity Type and Page Link. Entity Info is a lightweight object that contains only id and name of the entity group. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for specified group.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/entityGroupInfos/{groupType}/shared"}, params={"pageSize", "page"})
    public PageData<EntityInfo> getSharedEntityGroupEntityInfosByTypeAndPageLink(@Parameter(description="Entity Group type", required=true, schema=@Schema(allowableValues={"CUSTOMER", "ASSET", "DEVICE", "USER", "ENTITY_VIEW", "DASHBOARD", "EDGE"})) @PathVariable(value="groupType") String strGroupType, @Parameter(description="Maximum amount of entities in a one page", required=true, schema=@Schema(minimum="1")) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true, schema=@Schema(minimum="0")) @RequestParam int page, @Parameter(description="The case insensitive 'startsWith' filter based on the entity group name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by") @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        EntityType groupType = this.checkStrEntityGroupType("groupType", strGroupType);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        MergedGroupTypePermissionInfo groupTypePermissionInfo = (MergedGroupTypePermissionInfo)this.getCurrentUser().getUserPermissions().getReadGroupPermissions().get(groupType);
        if (!groupTypePermissionInfo.getEntityGroupIds().isEmpty()) {
            return this.entityGroupService.findEntityGroupEntityInfosByIds(this.getTenantId(), groupTypePermissionInfo.getEntityGroupIds(), pageLink);
        }
        return PageData.emptyPageData();
    }

    @ApiOperation(value="Get Entity Groups by owner and entity type (getEntityGroupsByOwnerAndType)", notes="Fetch the list of Entity Group Info objects based on the provided Owner Id and Entity Type. Entity group allows you to group multiple entities of the same entity type (Device, Asset, Customer, User, Dashboard, etc). Entity Group always have an owner - particular Tenant or Customer. Each entity may belong to multiple groups simultaneously.Entity Group Info extends Entity Group object and adds 'ownerIds' - a list of owner ids.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for specified group.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/entityGroups/{ownerType}/{ownerId}/{groupType}"})
    public List<EntityGroupInfo> getEntityGroupsByOwnerAndType(@Parameter(description="Tenant or Customer", required=true, schema=@Schema(allowableValues={"TENANT", "CUSTOMER"})) @PathVariable(value="ownerType") String strOwnerType, @Parameter(description="A string value representing the Tenant or Customer id", required=true, example="784f394c-42b6-435a-983c-b7beff2784f9") @PathVariable(value="ownerId") String strOwnerId, @Parameter(description="Entity Group type", required=true, schema=@Schema(allowableValues={"CUSTOMER", "ASSET", "DEVICE", "USER", "ENTITY_VIEW", "DASHBOARD", "EDGE"})) @PathVariable(value="groupType") String strGroupType) throws ThingsboardException {
        EntityGroupController.checkParameter((String)"ownerId", (String)strOwnerId);
        EntityGroupController.checkParameter((String)"ownerType", (String)strOwnerType);
        EntityId ownerId = EntityIdFactory.getByTypeAndId((String)strOwnerType, (String)strOwnerId);
        EntityType groupType = this.checkStrEntityGroupType("groupType", strGroupType);
        this.checkEntityId(ownerId, Operation.READ);
        MergedGroupTypePermissionInfo groupTypePermissionInfo = (MergedGroupTypePermissionInfo)this.getCurrentUser().getUserPermissions().getReadGroupPermissions().get(groupType);
        if (groupTypePermissionInfo.isHasGenericRead()) {
            PageData entityGroupInfos = this.entityGroupService.findEntityGroupInfosByType(this.getTenantId(), ownerId, groupType, new PageLink(Integer.MAX_VALUE));
            return entityGroupInfos.getData();
        }
        throw this.permissionDenied();
    }

    @ApiOperation(value="Get Entity Groups by owner and entity type and page link (getEntityGroupsByOwnerAndTypeAndPageLink)", notes="Returns a page of Entity Group objects based on the provided Owner Id and Entity Type and Page Link. Entity group allows you to group multiple entities of the same entity type (Device, Asset, Customer, User, Dashboard, etc). Entity Group always have an owner - particular Tenant or Customer. Each entity may belong to multiple groups simultaneously.You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for specified group.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/entityGroups/{ownerType}/{ownerId}/{groupType}"}, params={"pageSize", "page"})
    public PageData<EntityGroupInfo> getEntityGroupsByOwnerAndTypeAndPageLink(@Parameter(description="Tenant or Customer", required=true, schema=@Schema(allowableValues={"TENANT", "CUSTOMER"})) @PathVariable(value="ownerType") String strOwnerType, @Parameter(description="A string value representing the Tenant or Customer id", required=true, example="784f394c-42b6-435a-983c-b7beff2784f9") @PathVariable(value="ownerId") String strOwnerId, @Parameter(description="Entity Group type", required=true, schema=@Schema(allowableValues={"CUSTOMER", "ASSET", "DEVICE", "USER", "ENTITY_VIEW", "DASHBOARD", "EDGE"})) @PathVariable(value="groupType") String strGroupType, @Parameter(description="Maximum amount of entities in a one page", required=true, schema=@Schema(minimum="1")) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true, schema=@Schema(minimum="0")) @RequestParam int page, @Parameter(description="The case insensitive 'startsWith' filter based on the entity group name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by") @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        EntityGroupController.checkParameter((String)"ownerId", (String)strOwnerId);
        EntityGroupController.checkParameter((String)"ownerType", (String)strOwnerType);
        EntityId ownerId = EntityIdFactory.getByTypeAndId((String)strOwnerType, (String)strOwnerId);
        EntityType groupType = this.checkStrEntityGroupType("groupType", strGroupType);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        this.checkEntityId(ownerId, Operation.READ);
        MergedGroupTypePermissionInfo groupTypePermissionInfo = (MergedGroupTypePermissionInfo)this.getCurrentUser().getUserPermissions().getReadGroupPermissions().get(groupType);
        if (groupTypePermissionInfo.isHasGenericRead()) {
            return this.entityGroupService.findEntityGroupInfosByType(this.getTenantId(), ownerId, groupType, pageLink);
        }
        throw this.permissionDenied();
    }

    @ApiOperation(value="Get Entity Group Entity Infos by owner and entity type and page link (getEntityGroupEntityInfosByOwnerAndTypeAndPageLink)", notes="Returns a page of Entity Group Entity Info objects based on the provided Owner Id and Entity Type and Page Link. Entity Info is a lightweight object that contains only id and name of the entity group. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for specified group.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/entityGroupInfos/{ownerType}/{ownerId}/{groupType}"}, params={"pageSize", "page"})
    public PageData<EntityInfo> getEntityGroupEntityInfosByOwnerAndTypeAndPageLink(@Parameter(description="Tenant or Customer", required=true, schema=@Schema(allowableValues={"TENANT", "CUSTOMER"})) @PathVariable(value="ownerType") String strOwnerType, @Parameter(description="A string value representing the Tenant or Customer id", required=true, example="784f394c-42b6-435a-983c-b7beff2784f9") @PathVariable(value="ownerId") String strOwnerId, @Parameter(description="Entity Group type", required=true, schema=@Schema(allowableValues={"CUSTOMER", "ASSET", "DEVICE", "USER", "ENTITY_VIEW", "DASHBOARD", "EDGE"})) @PathVariable(value="groupType") String strGroupType, @Parameter(description="Maximum amount of entities in a one page", required=true, schema=@Schema(minimum="1")) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true, schema=@Schema(minimum="0")) @RequestParam int page, @Parameter(description="The case insensitive 'startsWith' filter based on the entity group name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by") @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        EntityGroupController.checkParameter((String)"ownerId", (String)strOwnerId);
        EntityGroupController.checkParameter((String)"ownerType", (String)strOwnerType);
        EntityId ownerId = EntityIdFactory.getByTypeAndId((String)strOwnerType, (String)strOwnerId);
        EntityType groupType = this.checkStrEntityGroupType("groupType", strGroupType);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        this.checkEntityId(ownerId, Operation.READ);
        MergedGroupTypePermissionInfo groupTypePermissionInfo = (MergedGroupTypePermissionInfo)this.getCurrentUser().getUserPermissions().getReadGroupPermissions().get(groupType);
        if (groupTypePermissionInfo.isHasGenericRead()) {
            return this.entityGroupService.findEntityGroupEntityInfosByType(this.getTenantId(), ownerId, groupType, pageLink);
        }
        throw this.permissionDenied();
    }

    @ApiOperation(value="Get Entity Groups for all owners starting from specified than ending with owner of current user (getEntityGroupsHierarchyByOwnerAndTypeAndPageLink)", notes="Returns a page of Entity Group objects based on the provided Owner Id and Entity Type and Page Link. Entity group allows you to group multiple entities of the same entity type (Device, Asset, Customer, User, Dashboard, etc). Entity Group always have an owner - particular Tenant or Customer. Each entity may belong to multiple groups simultaneously.You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for specified group.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/entityGroupsHierarchy/{ownerType}/{ownerId}/{groupType}"}, params={"pageSize", "page"})
    public PageData<EntityGroupInfo> getEntityGroupsHierarchyByOwnerAndTypeAndPageLink(@Parameter(description="Tenant or Customer", required=true, schema=@Schema(allowableValues={"TENANT", "CUSTOMER"})) @PathVariable(value="ownerType") String strOwnerType, @Parameter(description="A string value representing the Tenant or Customer id", required=true, example="784f394c-42b6-435a-983c-b7beff2784f9") @PathVariable(value="ownerId") String strOwnerId, @Parameter(description="Entity Group type", required=true, schema=@Schema(allowableValues={"CUSTOMER", "ASSET", "DEVICE", "USER", "ENTITY_VIEW", "DASHBOARD", "EDGE"})) @PathVariable(value="groupType") String strGroupType, @Parameter(description="Maximum amount of entities in a one page", required=true, schema=@Schema(minimum="1")) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true, schema=@Schema(minimum="0")) @RequestParam int page, @Parameter(description="The case insensitive 'startsWith' filter based on the entity group name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by") @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        EntityGroupController.checkParameter((String)"ownerId", (String)strOwnerId);
        EntityGroupController.checkParameter((String)"ownerType", (String)strOwnerType);
        EntityId ownerId = EntityIdFactory.getByTypeAndId((String)strOwnerType, (String)strOwnerId);
        EntityType groupType = this.checkStrEntityGroupType("groupType", strGroupType);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        this.checkEntityId(ownerId, Operation.READ);
        Set ownerIds = this.ownersCacheService.fetchOwnersHierarchy(this.getTenantId(), ownerId);
        EntityId currentUserOwnerId = this.getCurrentUser().getOwnerId();
        MergedGroupTypePermissionInfo groupTypePermissionInfo = (MergedGroupTypePermissionInfo)this.getCurrentUser().getUserPermissions().getReadGroupPermissions().get(groupType);
        if (!ownerIds.isEmpty() && ownerIds.contains(currentUserOwnerId) && groupTypePermissionInfo.isHasGenericRead()) {
            List targetOwnerIds = ownerIds.stream().takeWhile(entityId -> !entityId.equals(currentUserOwnerId)).collect(Collectors.toCollection(ArrayList::new));
            targetOwnerIds.add(currentUserOwnerId);
            return this.entityGroupService.findEntityGroupInfosByOwnersAndType(this.getTenantId(), targetOwnerIds, groupType, pageLink);
        }
        throw this.permissionDenied();
    }

    @ApiOperation(value="Get Entity Group Entity Infos for all owners starting from specified than ending with owner of current user (getEntityGroupEntityInfosHierarchyByOwnerAndTypeAndPageLink)", notes="Returns a page of Entity Group Entity Info objects based on the provided Owner Id and Entity Type and Page Link. Entity Info is a lightweight object that contains only id and name of the entity group. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for specified group.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/entityGroupInfosHierarchy/{ownerType}/{ownerId}/{groupType}"}, params={"pageSize", "page"})
    public PageData<EntityInfo> getEntityGroupEntityInfosHierarchyByOwnerAndTypeAndPageLink(@Parameter(description="Tenant or Customer", required=true, schema=@Schema(allowableValues={"TENANT", "CUSTOMER"})) @PathVariable(value="ownerType") String strOwnerType, @Parameter(description="A string value representing the Tenant or Customer id", required=true, example="784f394c-42b6-435a-983c-b7beff2784f9") @PathVariable(value="ownerId") String strOwnerId, @Parameter(description="Entity Group type", required=true, schema=@Schema(allowableValues={"CUSTOMER", "ASSET", "DEVICE", "USER", "ENTITY_VIEW", "DASHBOARD", "EDGE"})) @PathVariable(value="groupType") String strGroupType, @Parameter(description="Maximum amount of entities in a one page", required=true, schema=@Schema(minimum="1")) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true, schema=@Schema(minimum="0")) @RequestParam int page, @Parameter(description="The case insensitive 'startsWith' filter based on the entity group name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by") @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        EntityGroupController.checkParameter((String)"ownerId", (String)strOwnerId);
        EntityGroupController.checkParameter((String)"ownerType", (String)strOwnerType);
        EntityId ownerId = EntityIdFactory.getByTypeAndId((String)strOwnerType, (String)strOwnerId);
        EntityType groupType = this.checkStrEntityGroupType("groupType", strGroupType);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        this.checkEntityId(ownerId, Operation.READ);
        Set ownerIds = this.ownersCacheService.fetchOwnersHierarchy(this.getTenantId(), ownerId);
        EntityId currentUserOwnerId = this.getCurrentUser().getOwnerId();
        MergedGroupTypePermissionInfo groupTypePermissionInfo = (MergedGroupTypePermissionInfo)this.getCurrentUser().getUserPermissions().getReadGroupPermissions().get(groupType);
        if (!ownerIds.isEmpty() && ownerIds.contains(currentUserOwnerId) && groupTypePermissionInfo.isHasGenericRead()) {
            List targetOwnerIds = ownerIds.stream().takeWhile(entityId -> !entityId.equals(currentUserOwnerId)).collect(Collectors.toCollection(ArrayList::new));
            targetOwnerIds.add(currentUserOwnerId);
            return this.entityGroupService.findEntityGroupEntityInfosByOwnersAndType(this.getTenantId(), targetOwnerIds, groupType, pageLink);
        }
        throw this.permissionDenied();
    }

    @ApiOperation(value="Get special group All by owner and entity type (getEntityGroupsByOwnerAndType)", notes="Fetch reserved group 'All' based on the provided Owner Id and Entity Type. Entity group allows you to group multiple entities of the same entity type (Device, Asset, Customer, User, Dashboard, etc). Entity Group always have an owner - particular Tenant or Customer. Each entity may belong to multiple groups simultaneously.Entity Group Info extends Entity Group object and adds 'ownerIds' - a list of owner ids.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for specified group.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/entityGroup/all/{ownerType}/{ownerId}/{groupType}"})
    public EntityGroupInfo getEntityGroupAllByOwnerAndType(@Parameter(description="Tenant or Customer", required=true, schema=@Schema(allowableValues={"TENANT", "CUSTOMER"})) @PathVariable(value="ownerType") String strOwnerType, @Parameter(description="A string value representing the Tenant or Customer id", required=true, example="784f394c-42b6-435a-983c-b7beff2784f9") @PathVariable(value="ownerId") String strOwnerId, @Parameter(description="Entity Group type", required=true, schema=@Schema(allowableValues={"CUSTOMER", "ASSET", "DEVICE", "USER", "ENTITY_VIEW", "DASHBOARD", "EDGE"})) @PathVariable(value="groupType") String strGroupType) throws ThingsboardException {
        EntityGroupController.checkParameter((String)"ownerId", (String)strOwnerId);
        EntityGroupController.checkParameter((String)"ownerType", (String)strOwnerType);
        EntityId ownerId = EntityIdFactory.getByTypeAndId((String)strOwnerType, (String)strOwnerId);
        EntityType groupType = this.checkStrEntityGroupType("groupType", strGroupType);
        this.checkEntityId(ownerId, Operation.READ);
        Optional entityGroup = this.entityGroupService.findEntityGroupInfoByTypeAndName(this.getTenantId(), ownerId, groupType, "All");
        if (entityGroup.isPresent()) {
            this.accessControlService.checkEntityGroupInfoPermission(this.getCurrentUser(), Operation.READ, (EntityGroupInfo)entityGroup.get());
            return (EntityGroupInfo)entityGroup.get();
        }
        throw new ThingsboardException("Requested item wasn't found!", ThingsboardErrorCode.ITEM_NOT_FOUND);
    }

    @ApiOperation(value="Add entities to the group (addEntitiesToEntityGroup)", notes="Add entities to the specified entity group. Entity group allows you to group multiple entities of the same entity type (Device, Asset, Customer, User, Dashboard, etc). Entity Group always have an owner - particular Tenant or Customer. Each entity may belong to multiple groups simultaneously.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'ADD_TO_GROUP' permission for specified group.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/entityGroup/{entityGroupId}/addEntities"})
    @ResponseStatus(value=HttpStatus.OK)
    public void addEntitiesToEntityGroup(@Parameter(description="A string value representing the Entity Group Id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityGroupId") String strEntityGroupId, @Parameter(description="A list of entity ids", required=true) @RequestBody String[] strEntityIds) throws ThingsboardException {
        EntityGroupController.checkParameter((String)"entityGroupId", (String)strEntityGroupId);
        this.checkArrayParameter("entityIds", strEntityIds);
        EntityGroupInfo entityGroup = null;
        ActionType actionType = ActionType.ADDED_TO_ENTITY_GROUP;
        try {
            EntityGroupId entityGroupId = new EntityGroupId(this.toUUID(strEntityGroupId));
            entityGroup = this.checkEntityGroupId(entityGroupId, Operation.ADD_TO_GROUP);
            if (entityGroup.isGroupAll()) {
                throw new ThingsboardException("Unable to add entities to entity group: Addition to entity group 'All' is forbidden!", ThingsboardErrorCode.PERMISSION_DENIED);
            }
            ArrayList<EntityId> entityIds = new ArrayList<EntityId>();
            for (String strEntityId : strEntityIds) {
                EntityId entityId = EntityIdFactory.getByTypeAndId((EntityType)entityGroup.getType(), (String)strEntityId);
                this.checkEntityId(entityId, Operation.READ);
                EntityId entityOwner = this.ownersCacheService.getOwner(this.getTenantId(), entityId);
                if (!entityOwner.equals(entityGroup.getOwnerId())) {
                    throw new ThingsboardException("Unable to add entity with other owner than group. Entity id: " + String.valueOf(entityId), ThingsboardErrorCode.BAD_REQUEST_PARAMS);
                }
                entityIds.add(entityId);
            }
            this.entityGroupService.addEntitiesToEntityGroup(this.getTenantId(), entityGroupId, entityIds);
            if (EntityType.USER.equals((Object)entityGroup.getType())) {
                for (EntityId entityId : entityIds) {
                    this.userPermissionsService.onUserUpdatedOrRemoved(this.userService.findUserById(this.getTenantId(), new UserId(entityId.getId())));
                }
            } else if (EntityType.DEVICE.equals((Object)entityGroup.getType())) {
                DeviceGroupOtaPackage fw = this.deviceGroupOtaPackageService.findDeviceGroupOtaPackageByGroupIdAndType(entityGroupId, OtaPackageType.FIRMWARE);
                DeviceGroupOtaPackage sw = this.deviceGroupOtaPackageService.findDeviceGroupOtaPackageByGroupIdAndType(entityGroupId, OtaPackageType.SOFTWARE);
                if (fw != null || sw != null) {
                    List deviceIds = entityIds.stream().map(id -> new DeviceId(id.getId())).collect(Collectors.toList());
                    this.otaPackageStateService.update(this.getTenantId(), deviceIds, fw != null, sw != null);
                }
            }
            for (EntityId entityId : entityIds) {
                this.logEntityActionService.logEntityAction(this.getTenantId(), entityId, null, actionType, (User)this.getCurrentUser(), new Object[]{entityId.toString(), strEntityGroupId, entityGroup.getName()});
            }
        }
        catch (Exception e) {
            if (entityGroup != null) {
                EntityType entityType = entityGroup.getType();
                String groupName = entityGroup.getName();
                for (String strEntityId : strEntityIds) {
                    this.logEntityActionService.logEntityAction(this.getTenantId(), this.emptyId(entityType), actionType, (User)this.getCurrentUser(), e, new Object[]{strEntityId, strEntityGroupId, groupName});
                }
            }
            throw e;
        }
    }

    @ApiOperation(value="Remove entities from the group (removeEntitiesFromEntityGroup)", notes="Removes entities from the specified entity group. Entity group allows you to group multiple entities of the same entity type (Device, Asset, Customer, User, Dashboard, etc). Entity Group always have an owner - particular Tenant or Customer. Each entity may belong to multiple groups simultaneously.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'REMOVE_FROM_GROUP' permission for specified group.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/entityGroup/{entityGroupId}/deleteEntities"})
    @ResponseStatus(value=HttpStatus.OK)
    public void removeEntitiesFromEntityGroup(@Parameter(description="A string value representing the Entity Group Id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityGroupId") String strEntityGroupId, @Parameter(description="A list of entity ids", required=true) @RequestBody String[] strEntityIds) throws ThingsboardException {
        EntityGroupController.checkParameter((String)"entityGroupId", (String)strEntityGroupId);
        this.checkArrayParameter("entityIds", strEntityIds);
        EntityGroupInfo entityGroup = null;
        try {
            EntityGroupId entityGroupId = new EntityGroupId(this.toUUID(strEntityGroupId));
            entityGroup = this.checkEntityGroupId(entityGroupId, Operation.REMOVE_FROM_GROUP);
            if (entityGroup.isGroupAll()) {
                throw new ThingsboardException("Unable to remove entities from entity group: Removal from entity group 'All' is forbidden!", ThingsboardErrorCode.PERMISSION_DENIED);
            }
            ArrayList<EntityId> entityIds = new ArrayList<EntityId>();
            for (String strEntityId : strEntityIds) {
                EntityId entityId = EntityIdFactory.getByTypeAndId((EntityType)entityGroup.getType(), (String)strEntityId);
                this.checkEntityId(entityId, Operation.READ);
                entityIds.add(entityId);
            }
            this.entityGroupService.removeEntitiesFromEntityGroup(this.getTenantId(), entityGroupId, entityIds);
            if (entityGroup.getType() == EntityType.USER) {
                for (EntityId entityId : entityIds) {
                    this.userPermissionsService.onUserUpdatedOrRemoved(this.userService.findUserById(this.getTenantId(), new UserId(entityId.getId())));
                }
            } else if (entityGroup.getType() == EntityType.DEVICE) {
                DeviceGroupOtaPackage fw = this.deviceGroupOtaPackageService.findDeviceGroupOtaPackageByGroupIdAndType(entityGroupId, OtaPackageType.FIRMWARE);
                DeviceGroupOtaPackage sw = this.deviceGroupOtaPackageService.findDeviceGroupOtaPackageByGroupIdAndType(entityGroupId, OtaPackageType.SOFTWARE);
                if (fw != null || sw != null) {
                    List deviceIds = entityIds.stream().map(id -> new DeviceId(id.getId())).collect(Collectors.toList());
                    this.otaPackageStateService.update(this.getTenantId(), deviceIds, fw != null, sw != null);
                }
            }
            for (EntityId entityId : entityIds) {
                this.logEntityActionService.logEntityAction(this.getTenantId(), entityId, null, ActionType.REMOVED_FROM_ENTITY_GROUP, (User)this.getCurrentUser(), new Object[]{entityId.toString(), strEntityGroupId, entityGroup.getName()});
            }
        }
        catch (Exception e) {
            if (entityGroup != null) {
                EntityType entityType = entityGroup.getType();
                String groupName = entityGroup.getName();
                for (String strEntityId : strEntityIds) {
                    this.logEntityActionService.logEntityAction(this.getTenantId(), this.emptyId(entityType), ActionType.REMOVED_FROM_ENTITY_GROUP, (User)this.getCurrentUser(), e, new Object[]{strEntityId, strEntityGroupId, groupName});
                }
            }
            throw e;
        }
    }

    @ApiOperation(value="Get Group Entity (getGroupEntity)", notes="Fetch the Short Entity View object based on the group and entity id. Short Entity View object contains the entity id and number of fields (attributes, telemetry, etc). List of those fields is configurable and defined in the group configuration.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for specified group.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/entityGroup/{entityGroupId}/{entityId}"})
    public ShortEntityView getGroupEntity(@Parameter(description="A string value representing the Entity Group Id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityGroupId") String strEntityGroupId, @Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityId") String strEntityId) throws ThingsboardException {
        EntityGroupController.checkParameter((String)"entityGroupId", (String)strEntityGroupId);
        EntityGroupController.checkParameter((String)"entityId", (String)strEntityId);
        EntityGroupId entityGroupId = new EntityGroupId(this.toUUID(strEntityGroupId));
        EntityGroupInfo entityGroup = this.checkEntityGroupId(entityGroupId, Operation.READ);
        EntityType entityType = entityGroup.getType();
        this.checkEntityGroupType(entityType);
        EntityId entityId = EntityIdFactory.getByTypeAndId((EntityType)entityType, (String)strEntityId);
        this.checkEntityId(entityId, Operation.READ);
        SecurityUser currentUser = this.getCurrentUser();
        MergedUserPermissions mergedUserPermissions = currentUser.getUserPermissions();
        ShortEntityView result = this.entityGroupService.findGroupEntity(this.getTenantId(), currentUser.getCustomerId(), mergedUserPermissions, entityGroupId, entityId);
        return (ShortEntityView)this.checkNotNull((Object)result);
    }

    @ApiOperation(value="Get Group Entities (getEntities)", notes="Returns a page of Short Entity View objects that belongs to specified Entity Group Id. Short Entity View object contains the entity id and number of fields (attributes, telemetry, etc). List of those fields is configurable and defined in the group configuration.You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for specified group.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/entityGroup/{entityGroupId}/entities"}, params={"pageSize", "page"})
    public PageData<ShortEntityView> getEntities(@Parameter(description="A string value representing the Entity Group Id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityGroupId") String strEntityGroupId, @Parameter(description="Maximum amount of entities in a one page", required=true, schema=@Schema(minimum="1")) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true, schema=@Schema(minimum="0")) @RequestParam int page, @Parameter(description="The case insensitive 'startsWith' filter based on the entity group name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by") @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        EntityGroupController.checkParameter((String)"entityGroupId", (String)strEntityGroupId);
        EntityGroupId entityGroupId = new EntityGroupId(this.toUUID(strEntityGroupId));
        EntityGroupInfo entityGroup = this.checkEntityGroupId(entityGroupId, Operation.READ);
        EntityType entityType = entityGroup.getType();
        this.checkEntityGroupType(entityType);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        SecurityUser currentUser = this.getCurrentUser();
        MergedUserPermissions mergedUserPermissions = currentUser.getUserPermissions();
        return (PageData)this.checkNotNull((Object)this.entityGroupService.findGroupEntities(this.getTenantId(), currentUser.getCustomerId(), mergedUserPermissions, entityGroupId, pageLink));
    }

    @ApiOperation(value="Get Entity Groups by Entity Id (getEntityGroupsForEntity)", notes="Returns a list of groups that contain the specified Entity Id. For example, all device groups that contain specific device. The list always contain at least one element - special group 'All'.You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/entityGroups/{entityType}/{entityId}"})
    public List<EntityGroupId> getEntityGroupsForEntity(@Parameter(description="Entity Group type", required=true, schema=@Schema(allowableValues={"CUSTOMER", "ASSET", "DEVICE", "USER", "ENTITY_VIEW", "DASHBOARD", "EDGE"})) @PathVariable(value="entityType") String strEntityType, @Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityId") String strEntityId) throws ThingsboardException, ExecutionException, InterruptedException {
        EntityGroupController.checkParameter((String)"entityType", (String)strEntityType);
        EntityGroupController.checkParameter((String)"entityId", (String)strEntityId);
        EntityType entityType = this.checkStrEntityGroupType("entityType", strEntityType);
        EntityId entityId = EntityIdFactory.getByTypeAndId((EntityType)entityType, (String)strEntityId);
        this.checkEntityId(entityId, Operation.READ);
        return (List)this.checkNotNull((Object)((List)this.entityGroupService.findEntityGroupsForEntityAsync(this.getTenantId(), entityId).get()));
    }

    @ApiOperation(value="Get Entity Groups by Ids (getEntityGroupsByIds)", notes="Fetch the list of Entity Group Info objects based on the provided entity group ids list. Entity group allows you to group multiple entities of the same entity type (Device, Asset, Customer, User, Dashboard, etc). Entity Group always have an owner - particular Tenant or Customer. Each entity may belong to multiple groups simultaneously.Entity Group Info extends Entity Group object and adds 'ownerIds' - a list of owner ids.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for specified group.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/entityGroups"}, params={"entityGroupIds"})
    public List<EntityGroupInfo> getEntityGroupsByIds(@Parameter(description="A list of group ids, separated by comma ','", array=@ArraySchema(schema=@Schema(type="string"))) @RequestParam(value="entityGroupIds") String[] strEntityGroupIds) throws ThingsboardException {
        this.checkArrayParameter("entityGroupIds", strEntityGroupIds);
        SecurityUser user = this.getCurrentUser();
        TenantId tenantId = user.getTenantId();
        ArrayList<EntityGroupId> entityGroupIds = new ArrayList<EntityGroupId>();
        for (String strEntityGroupId : strEntityGroupIds) {
            entityGroupIds.add(new EntityGroupId(this.toUUID(strEntityGroupId)));
        }
        List entityGroups = (List)this.checkNotNull((Object)this.entityGroupService.findEntityGroupInfosByIds(tenantId, entityGroupIds, new PageLink(Integer.MAX_VALUE)).getData());
        return this.filterEntityGroupsByReadPermission(entityGroups);
    }

    @ApiOperation(value="Get Entity Group Entity Infos by Ids (getEntityGroupEntityInfosByIds)", notes="Fetch the list of Entity Group Entity Info objects based on the provided entity group ids list. Entity Info is a lightweight object that contains only id and name of the entity group. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for specified group.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/entityGroupInfos"}, params={"entityGroupIds"})
    public List<EntityInfo> getEntityGroupEntityInfosByIds(@Parameter(description="A list of group ids, separated by comma ','", array=@ArraySchema(schema=@Schema(type="string"))) @RequestParam(value="entityGroupIds") String[] strEntityGroupIds) throws ThingsboardException {
        this.checkArrayParameter("entityGroupIds", strEntityGroupIds);
        SecurityUser user = this.getCurrentUser();
        TenantId tenantId = user.getTenantId();
        ArrayList<EntityGroupId> entityGroupIds = new ArrayList<EntityGroupId>();
        for (String strEntityGroupId : strEntityGroupIds) {
            entityGroupIds.add(new EntityGroupId(this.toUUID(strEntityGroupId)));
        }
        return (List)this.checkNotNull((Object)this.entityGroupService.findEntityGroupEntityInfosByIds(tenantId, entityGroupIds, new PageLink(Integer.MAX_VALUE)).getData());
    }

    @ApiOperation(value="Get Owners (getOwners)", notes="Provides a rage view of Customers that the current user has READ access to. If the current user is Tenant administrator, the result set also contains the tenant. The call is designed for the UI auto-complete component to show tenant and all possible Customers that the user may select to change the owner of the particular entity or entity group.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/owners"}, params={"pageSize", "page"})
    public PageData<ContactBased<?>> getOwners(@Parameter(description="Maximum amount of entities in a one page", required=true, schema=@Schema(minimum="1")) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true, schema=@Schema(minimum="0")) @RequestParam int page, @Parameter(description="The case insensitive 'startsWith' filter based on the entity group name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by") @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException, ExecutionException, InterruptedException {
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        List<Object> owners = new ArrayList<Object>();
        if (Authority.TENANT_ADMIN.equals((Object)this.getCurrentUser().getAuthority()) && this.accessControlService.hasPermission(this.getCurrentUser(), Resource.TENANT, Operation.READ)) {
            owners.add(this.tenantService.findTenantById(this.getCurrentUser().getTenantId()));
        }
        if (this.accessControlService.hasPermission(this.getCurrentUser(), Resource.CUSTOMER, Operation.READ)) {
            if (Authority.TENANT_ADMIN.equals((Object)this.getCurrentUser().getAuthority())) {
                owners.addAll(this.customerService.findCustomersByTenantId(this.getTenantId(), pageLink).getData().stream().filter(customer -> !customer.isPublic()).toList());
            } else {
                Set ownerIds = this.ownersCacheService.getChildOwners(this.getTenantId(), this.getCurrentUser().getOwnerId());
                if (!ownerIds.isEmpty()) {
                    ArrayList<CustomerId> customerIds = new ArrayList<CustomerId>();
                    for (EntityId ownerId : ownerIds) {
                        customerIds.add(new CustomerId(ownerId.getId()));
                    }
                    owners.addAll(this.customerService.findCustomersByTenantIdAndIds(this.getTenantId(), customerIds).stream().filter(customer -> !customer.isPublic()).toList());
                }
            }
        }
        owners = owners.stream().sorted(this.entityComparator).filter(new BaseController.EntityPageLinkFilter((BaseController)this, pageLink)).collect(Collectors.toList());
        return this.toPageData(owners, pageLink);
    }

    @ApiOperation(value="Get Owner Infos (getOwnerInfos)", notes="Provides a rage view of Customers that the current user has READ access to. If the current user is Tenant administrator, the result set also contains the tenant. The call is designed for the UI auto-complete component to show tenant and all possible Customers that the user may select to change the owner of the particular entity or entity group.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/ownerInfos"}, params={"pageSize", "page"})
    public PageData<EntityInfo> getOwnerInfos(@Parameter(description="Maximum amount of entities in a one page", required=true, schema=@Schema(minimum="1")) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true, schema=@Schema(minimum="0")) @RequestParam int page, @Parameter(description="The case insensitive 'startsWith' filter based on the entity group name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by") @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        if (Authority.TENANT_ADMIN.equals((Object)this.getCurrentUser().getAuthority())) {
            if (this.accessControlService.hasPermission(this.getCurrentUser(), Resource.TENANT, Operation.READ)) {
                if (this.accessControlService.hasPermission(this.getCurrentUser(), Resource.CUSTOMER, Operation.READ)) {
                    return this.ownerService.findCustomerOwnersByTenantIdIncludingTenant(this.getCurrentUser().getTenantId(), pageLink);
                }
                return this.ownerService.findTenantOwnerByTenantId(this.getCurrentUser().getTenantId(), pageLink);
            }
            if (this.accessControlService.hasPermission(this.getCurrentUser(), Resource.CUSTOMER, Operation.READ)) {
                return this.ownerService.findCustomerOwnersByTenantId(this.getCurrentUser().getTenantId(), pageLink);
            }
        } else if (this.accessControlService.hasPermission(this.getCurrentUser(), Resource.CUSTOMER, Operation.READ)) {
            Set ownerIds = this.ownersCacheService.getChildOwners(this.getTenantId(), this.getCurrentUser().getOwnerId());
            List customerIds = ownerIds.stream().map(id -> new CustomerId(id.getId())).collect(Collectors.toList());
            return this.ownerService.findCustomerOwnersByIdsAndTenantId(this.getCurrentUser().getTenantId(), customerIds, pageLink);
        }
        return PageData.emptyPageData();
    }

    @ApiOperation(value="Get Owner Info (getOwnerInfo)", notes="Fetch the owner info (tenant or customer) presented as Entity Info object based on the provided owner Id. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for specified group.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/ownerInfo/{ownerType}/{ownerId}"})
    public EntityInfo getOwnerInfo(@Parameter(description="Tenant or Customer", required=true, schema=@Schema(allowableValues={"TENANT", "CUSTOMER"})) @PathVariable(value="ownerType") String strOwnerType, @Parameter(description="A string value representing the Tenant or Customer id", required=true, example="784f394c-42b6-435a-983c-b7beff2784f9") @PathVariable(value="ownerId") String strOwnerId) throws ThingsboardException {
        EntityGroupController.checkParameter((String)"ownerId", (String)strOwnerId);
        EntityGroupController.checkParameter((String)"ownerType", (String)strOwnerType);
        EntityId ownerId = EntityIdFactory.getByTypeAndId((String)strOwnerType, (String)strOwnerId);
        if (!EntityType.TENANT.equals((Object)ownerId.getEntityType()) && !EntityType.CUSTOMER.equals((Object)ownerId.getEntityType())) {
            throw new ThingsboardException("Unsupported owner type '" + String.valueOf(ownerId.getEntityType()) + "'! Only 'TENANT' or 'CUSTOMER' types are allowed.", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        if (EntityType.TENANT.equals((Object)ownerId.getEntityType())) {
            TenantId tenantId = TenantId.fromUUID((UUID)ownerId.getId());
            Tenant tenant = this.checkTenantId(tenantId, Operation.READ);
            return new EntityInfo(tenant.getUuidId(), EntityType.TENANT.name(), tenant.getTitle());
        }
        CustomerId customerId = new CustomerId(ownerId.getId());
        Customer customer = this.checkCustomerId(customerId, Operation.READ);
        return new EntityInfo(customer.getUuidId(), EntityType.CUSTOMER.name(), customer.getTitle());
    }

    @ApiOperation(value="Make Entity Group Publicly available (makeEntityGroupPublic)", notes="Make the entity group available for non authorized users. Useful for public dashboards that will be embedded into the public websites. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'WRITE' permission for specified group.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/entityGroup/{entityGroupId}/makePublic"})
    @ResponseStatus(value=HttpStatus.OK)
    public void makeEntityGroupPublic(@Parameter(description="A string value representing the Entity Group Id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityGroupId") String strEntityGroupId) throws ThingsboardException {
        EntityGroupController.checkParameter((String)"entityGroupId", (String)strEntityGroupId);
        EntityGroupInfo entityGroup = null;
        try {
            EntityGroupId entityGroupId = new EntityGroupId(this.toUUID(strEntityGroupId));
            entityGroup = this.checkEntityGroupId(entityGroupId, Operation.WRITE);
            if (!this.getCurrentUser().getOwnerId().equals(entityGroup.getOwnerId())) {
                throw this.permissionDenied();
            }
            this.tbEntityGroupService.makePublic(this.getTenantId(), (EntityGroup)entityGroup, (User)this.getCurrentUser());
        }
        catch (Exception e) {
            if (entityGroup != null) {
                this.logEntityActionService.logEntityAction(this.getTenantId(), (EntityId)entityGroup.getId(), ActionType.MADE_PUBLIC, (User)this.getCurrentUser(), e, new Object[]{strEntityGroupId, entityGroup.getName()});
            }
            throw e;
        }
    }

    @ApiOperation(value="Make Entity Group Private (makeEntityGroupPrivate)", notes="Make the entity group not available for non authorized users. Every group is private by default. This call is useful to hide the group that was previously made public.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'WRITE' permission for specified group.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/entityGroup/{entityGroupId}/makePrivate"})
    @ResponseStatus(value=HttpStatus.OK)
    public void makeEntityGroupPrivate(@Parameter(description="A string value representing the Entity Group Id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityGroupId") String strEntityGroupId) throws ThingsboardException {
        EntityGroupController.checkParameter((String)"entityGroupId", (String)strEntityGroupId);
        EntityGroupInfo entityGroup = null;
        try {
            EntityGroupId entityGroupId = new EntityGroupId(this.toUUID(strEntityGroupId));
            entityGroup = this.checkEntityGroupId(entityGroupId, Operation.WRITE);
            if (!this.getCurrentUser().getOwnerId().equals(entityGroup.getOwnerId())) {
                throw this.permissionDenied();
            }
            this.tbEntityGroupService.makePrivate(this.getTenantId(), (EntityGroup)entityGroup, (User)this.getCurrentUser());
        }
        catch (Exception e) {
            if (entityGroup != null) {
                this.logEntityActionService.logEntityAction(this.getTenantId(), (EntityId)entityGroup.getId(), ActionType.MADE_PRIVATE, (User)this.getCurrentUser(), e, new Object[]{strEntityGroupId, entityGroup.getName()});
            }
            throw e;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ApiOperation(value="Share the Entity Group (shareEntityGroup)", notes="Share the entity group with certain user group based on the provided Share Group Request. The request is quite flexible and processing of the request involves multiple security checks using platform RBAC feature.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'WRITE' permission for specified group.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/entityGroup/{entityGroupId}/share"})
    @ResponseStatus(value=HttpStatus.OK)
    public void shareEntityGroup(@Parameter(description="A string value representing the Entity Group Id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityGroupId") String strEntityGroupId, @Parameter(description="The Share Group Request JSON", required=true) @RequestBody ShareGroupRequest shareGroupRequest) throws ThingsboardException {
        EntityGroupController.checkParameter((String)"entityGroupId", (String)strEntityGroupId);
        try {
            List<RoleId> roleIds;
            EntityGroupInfo userGroup;
            this.accessControlService.checkPermission(this.getCurrentUser(), Resource.GROUP_PERMISSION, Operation.CREATE);
            EntityGroupId entityGroupId = new EntityGroupId(this.toUUID(strEntityGroupId));
            EntityGroupInfo entityGroup = this.checkEntityGroupId(entityGroupId, Operation.WRITE);
            this.checkSharableEntityGroupType(entityGroup.getType());
            if (shareGroupRequest.isAllUserGroup()) {
                Optional userGroupOptional = this.entityGroupService.findEntityGroupInfoByTypeAndName(this.getTenantId(), shareGroupRequest.getOwnerId(), EntityType.USER, "All");
                if (!userGroupOptional.isPresent()) throw new ThingsboardException("Requested item wasn't found!", ThingsboardErrorCode.ITEM_NOT_FOUND);
                userGroup = (EntityGroupInfo)userGroupOptional.get();
            } else {
                userGroup = this.entityGroupService.findEntityGroupInfoById(this.getTenantId(), shareGroupRequest.getUserGroupId());
            }
            this.accessControlService.checkEntityGroupInfoPermission(this.getCurrentUser(), Operation.WRITE, userGroup);
            if (shareGroupRequest.getRoleIds() != null && !shareGroupRequest.getRoleIds().isEmpty()) {
                roleIds = shareGroupRequest.getRoleIds();
            } else {
                Role role = shareGroupRequest.isReadElseWrite() ? this.roleService.findOrCreateReadOnlyEntityGroupRole(this.getTenantId(), this.getCurrentUser().getCustomerId()) : this.roleService.findOrCreateWriteEntityGroupRole(this.getTenantId(), this.getCurrentUser().getCustomerId());
                roleIds = Collections.singletonList(role.getId());
            }
            for (RoleId roleId : roleIds) {
                GroupPermission groupPermission = new GroupPermission();
                groupPermission.setTenantId(this.getTenantId());
                groupPermission.setEntityGroupId(entityGroup.getId());
                groupPermission.setEntityGroupType(entityGroup.getType());
                groupPermission.setRoleId(roleId);
                groupPermission.setUserGroupId(userGroup.getId());
                GroupPermission savedGroupPermission = (GroupPermission)this.checkNotNull((Object)this.groupPermissionService.saveGroupPermission(this.getTenantId(), groupPermission));
                this.userPermissionsService.onGroupPermissionUpdated(savedGroupPermission);
                this.logEntityActionService.logEntityAction(this.getTenantId(), (EntityId)savedGroupPermission.getId(), (HasName)savedGroupPermission, ActionType.ADDED, (User)this.getCurrentUser(), new Object[0]);
            }
            return;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(this.getTenantId(), this.emptyId(EntityType.GROUP_PERMISSION), ActionType.ADDED, (User)this.getCurrentUser(), e, new Object[0]);
            throw e;
        }
    }

    @ApiOperation(value="Share the Entity Group with User group (shareEntityGroupToChildOwnerUserGroup)", notes="Share the entity group with specified user group using specified role. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'WRITE' permission for specified group.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/entityGroup/{entityGroupId}/{userGroupId}/{roleId}/share"})
    @ResponseStatus(value=HttpStatus.OK)
    public void shareEntityGroupToChildOwnerUserGroup(@Parameter(description="A string value representing the Entity Group Id that you would like to share. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityGroupId") String strEntityGroupId, @Parameter(description="A string value representing the Entity(User) Group Id that you would like to share with. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="userGroupId") String strUserGroupId, @Parameter(description="A string value representing the Role Id that describes set of permissions you would like to share (read, write, etc). For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="roleId") String strRoleId) throws ThingsboardException, IOException {
        Role role;
        HashSet mergedOperations;
        EntityGroup entityGroup;
        EntityGroupController.checkParameter((String)"entityGroupId", (String)strEntityGroupId);
        EntityGroupController.checkParameter((String)"userGroupId", (String)strUserGroupId);
        EntityGroupController.checkParameter((String)"roleId", (String)strRoleId);
        EntityGroupId userGroupId = new EntityGroupId(this.toUUID(strUserGroupId));
        EntityGroup userGroup = this.entityGroupService.findEntityGroupById(this.getTenantId(), userGroupId);
        if (userGroup == null) {
            throw new ThingsboardException("User group with requested id: " + String.valueOf(userGroupId) + " wasn't found!", ThingsboardErrorCode.ITEM_NOT_FOUND);
        }
        Set userGroupOwnerIds = this.ownersCacheService.fetchOwnersHierarchy(this.getTenantId(), userGroup.getOwnerId());
        EntityId currentUserOwnerId = this.getCurrentUser().getOwnerId();
        if (!CollectionUtils.isEmpty((Collection)userGroupOwnerIds) && userGroupOwnerIds.contains(currentUserOwnerId)) {
            EntityGroupId entityGroupId = new EntityGroupId(this.toUUID(strEntityGroupId));
            entityGroup = this.entityGroupService.findEntityGroupById(this.getTenantId(), entityGroupId);
            if (entityGroup == null) {
                throw new ThingsboardException("Entity group with requested id: " + String.valueOf(entityGroupId) + " wasn't found!", ThingsboardErrorCode.ITEM_NOT_FOUND);
            }
            Set groupToShareOwnerIds = this.ownersCacheService.fetchOwnersHierarchy(this.getTenantId(), entityGroup.getOwnerId());
            mergedOperations = new HashSet();
            MergedUserPermissions userPermissions = this.getCurrentUser().getUserPermissions();
            if (groupToShareOwnerIds.contains(currentUserOwnerId) && this.hasGenenericPermissionToShareGroup(entityGroup.getType())) {
                Map genericPermissions = userPermissions.getGenericPermissions();
                genericPermissions.forEach((resource, operations) -> {
                    if (resource.equals((Object)Resource.ALL) || resource.getEntityTypes().contains(EntityType.ENTITY_GROUP)) {
                        mergedOperations.addAll(operations);
                    }
                });
            }
            if (this.hasGroupPermissionsToShareGroup(entityGroupId)) {
                Map groupPermissions = userPermissions.getGroupPermissions();
                MergedGroupPermissionInfo mergedGroupPermissionInfo = (MergedGroupPermissionInfo)groupPermissions.get(entityGroupId);
                mergedOperations.addAll(mergedGroupPermissionInfo.getOperations());
            }
            RoleId roleId = new RoleId(this.toUUID(strRoleId));
            role = this.roleService.findRoleById(this.getTenantId(), roleId);
            if (role == null) {
                throw new ThingsboardException("Role with requested id: " + String.valueOf(roleId) + " wasn't found!", ThingsboardErrorCode.ITEM_NOT_FOUND);
            }
            Set roleOwnerIds = this.ownersCacheService.fetchOwnersHierarchy(this.getTenantId(), role.getOwnerId());
            if (!roleOwnerIds.contains(currentUserOwnerId) && !userGroupOwnerIds.containsAll(roleOwnerIds)) {
                throw this.permissionDenied();
            }
        } else {
            throw this.permissionDenied();
        }
        this.shareGroup(role, userGroup, entityGroup, mergedOperations);
    }

    @ApiOperation(value="Assign entity group to edge (assignEntityGroupToEdge)", notes="Creates assignment of an existing entity group to an instance of The Edge. Assignment works in async way - first, notification event pushed to edge service queue on platform. Second, remote edge service will receive a copy of assignment entity group (Edge will receive this instantly, if it's currently connected, or once it's going to be connected to platform). Third, once entity group will be delivered to edge service, edge will request entities of this group to be send to edge. Once entities will be delivered to edge service, they are going to be available for usage on remote edge instance.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'WRITE' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/edge/{edgeId}/entityGroup/{entityGroupId}/{groupType}"})
    public EntityGroup assignEntityGroupToEdge(@Parameter(description="A string value representing the edge id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="edgeId") String strEdgeId, @Parameter(description="EntityGroup type", required=true, schema=@Schema(allowableValues={"ASSET", "DEVICE", "USER", "ENTITY_VIEW", "DASHBOARD"})) @PathVariable(value="groupType") String strGroupType, @Parameter(description="A string value representing the Entity Group Id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="entityGroupId") String strEntityGroupId) throws ThingsboardException {
        EntityGroupController.checkParameter((String)"edgeId", (String)strEdgeId);
        EntityGroupController.checkParameter((String)"entityGroupId", (String)strEntityGroupId);
        ActionType actionType = ActionType.ASSIGNED_TO_EDGE;
        try {
            EdgeId edgeId = new EdgeId(this.toUUID(strEdgeId));
            Edge edge = this.checkEdgeId(edgeId, Operation.WRITE);
            EntityGroupId entityGroupId = new EntityGroupId(this.toUUID(strEntityGroupId));
            this.checkEntityGroupId(entityGroupId, Operation.READ);
            EntityType groupType = this.checkStrEntityGroupType("groupType", strGroupType);
            EntityGroup savedEntityGroup = (EntityGroup)this.checkNotNull((Object)this.entityGroupService.assignEntityGroupToEdge(this.getCurrentUser().getTenantId(), entityGroupId, edgeId, groupType));
            this.logEntityActionService.logEntityAction(this.getTenantId(), (EntityId)entityGroupId, (HasName)savedEntityGroup, actionType, (User)this.getCurrentUser(), new Object[]{strEntityGroupId, strEdgeId, edge.getName()});
            return savedEntityGroup;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(this.getTenantId(), this.emptyId(EntityType.ENTITY_GROUP), actionType, (User)this.getCurrentUser(), e, new Object[]{strEntityGroupId, strEdgeId});
            throw e;
        }
    }

    @ApiOperation(value="Unassign entity group from edge (unassignEntityGroupFromEdge)", notes="Clears assignment of the entity group to the edge. Unassignment works in async way - first, 'unassign' notification event pushed to edge queue on platform. Second, remote edge service will receive an 'unassign' command to remove entity group (Edge will receive this instantly, if it's currently connected, or once it's going to be connected to platform). Third, once 'unassign' command will be delivered to edge service, it's going to remove entity group and entities inside this group locally.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'WRITE' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @DeleteMapping(value={"/edge/{edgeId}/entityGroup/{entityGroupId}/{groupType}"})
    public EntityGroup unassignEntityGroupFromEdge(@Parameter(description="A string value representing the edge id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="edgeId") String strEdgeId, @Parameter(description="EntityGroup type", required=true, schema=@Schema(allowableValues={"ASSET", "DEVICE", "USER", "ENTITY_VIEW", "DASHBOARD"})) @PathVariable(value="groupType") String strGroupType, @Parameter(description="A string value representing the Entity Group Id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="entityGroupId") String strEntityGroupId) throws ThingsboardException {
        EntityGroupController.checkParameter((String)"edgeId", (String)strEdgeId);
        EntityGroupController.checkParameter((String)"entityGroupId", (String)strEntityGroupId);
        ActionType actionType = ActionType.UNASSIGNED_FROM_EDGE;
        try {
            EdgeId edgeId = new EdgeId(this.toUUID(strEdgeId));
            Edge edge = this.checkEdgeId(edgeId, Operation.WRITE);
            EntityGroupId entityGroupId = new EntityGroupId(this.toUUID(strEntityGroupId));
            EntityGroupInfo entityGroup = this.checkEntityGroupId(entityGroupId, Operation.READ);
            EntityType groupType = this.checkStrEntityGroupType("groupType", strGroupType);
            EntityGroup savedEntityGroup = (EntityGroup)this.checkNotNull((Object)this.entityGroupService.unassignEntityGroupFromEdge(this.getCurrentUser().getTenantId(), entityGroupId, edgeId, groupType));
            this.logEntityActionService.logEntityAction(this.getTenantId(), (EntityId)entityGroupId, (HasName)entityGroup, actionType, (User)this.getCurrentUser(), new Object[]{strEntityGroupId, strEdgeId, edge.getName()});
            return savedEntityGroup;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(this.getTenantId(), this.emptyId(EntityType.ENTITY_GROUP), actionType, (User)this.getCurrentUser(), e, new Object[]{strEntityGroupId, strEdgeId});
            throw e;
        }
    }

    @ApiOperation(value="Get All Edge Entity Groups by entity type (getAllEdgeEntityGroups)", notes="Fetch the list of Entity Group Info objects based on the provided Entity Type and assigned to the provided Edge entity. Entity group allows you to group multiple entities of the same entity type (Device, Asset, Customer, User, Dashboard, etc). Entity Group always have an owner - particular Tenant or Customer. Each entity may belong to multiple groups simultaneously.Entity Group Info extends Entity Group object and adds 'ownerIds' - a list of owner ids.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/allEntityGroups/edge/{edgeId}/{groupType}"})
    public List<EntityGroupInfo> getAllEdgeEntityGroups(@Parameter(description="A string value representing the edge id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="edgeId") String strEdgeId, @Parameter(description="EntityGroup type", required=true, schema=@Schema(allowableValues={"ASSET", "DEVICE", "USER", "ENTITY_VIEW", "DASHBOARD"})) @PathVariable(value="groupType") String strGroupType) throws ThingsboardException {
        EntityGroupController.checkParameter((String)"edgeId", (String)strEdgeId);
        EdgeId edgeId = new EdgeId(UUID.fromString(strEdgeId));
        EntityType groupType = this.checkStrEntityGroupType("groupType", strGroupType);
        this.checkEdgeId(edgeId, Operation.READ);
        MergedGroupTypePermissionInfo groupTypePermissionInfo = (MergedGroupTypePermissionInfo)this.getCurrentUser().getUserPermissions().getReadGroupPermissions().get(groupType);
        if (groupTypePermissionInfo.isHasGenericRead()) {
            PageLink pageLink = new PageLink(Integer.MAX_VALUE);
            PageData pageData = this.entityGroupService.findEdgeEntityGroupInfosByOwnerIdType(this.getTenantId(), edgeId, this.getCurrentUser().getOwnerId(), groupType, pageLink);
            return pageData.getData();
        }
        throw this.permissionDenied();
    }

    @ApiOperation(value="Get Edge Entity Groups by entity type (getEdgeEntityGroups)", notes="Returns a page of Entity Group Info objects based on the provided Entity Type and assigned to the provided Edge entity. Entity group allows you to group multiple entities of the same entity type (Device, Asset, Customer, User, Dashboard, etc). Entity Group always have an owner - particular Tenant or Customer. Each entity may belong to multiple groups simultaneously.Entity Group Info extends Entity Group object and adds 'ownerIds' - a list of owner ids.You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/entityGroups/edge/{edgeId}/{groupType}"}, params={"pageSize", "page"})
    public PageData<EntityGroupInfo> getEdgeEntityGroups(@Parameter(description="A string value representing the edge id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="edgeId") String strEdgeId, @Parameter(description="EntityGroup type", required=true, schema=@Schema(allowableValues={"ASSET", "DEVICE", "USER", "ENTITY_VIEW", "DASHBOARD"})) @PathVariable(value="groupType") String strGroupType, @Parameter(description="Maximum amount of entities in a one page", required=true, schema=@Schema(minimum="1")) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true, schema=@Schema(minimum="0")) @RequestParam int page, @Parameter(description="The case insensitive 'startsWith' filter based on the entity group name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by") @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        EntityGroupController.checkParameter((String)"edgeId", (String)strEdgeId);
        EdgeId edgeId = new EdgeId(UUID.fromString(strEdgeId));
        EntityType groupType = this.checkStrEntityGroupType("groupType", strGroupType);
        this.checkEdgeId(edgeId, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        MergedGroupTypePermissionInfo groupTypePermissionInfo = (MergedGroupTypePermissionInfo)this.getCurrentUser().getUserPermissions().getReadGroupPermissions().get(groupType);
        if (groupTypePermissionInfo.isHasGenericRead()) {
            return this.entityGroupService.findEdgeEntityGroupInfosByOwnerIdType(this.getTenantId(), edgeId, this.getCurrentUser().getOwnerId(), groupType, pageLink);
        }
        throw this.permissionDenied();
    }

    private void shareGroup(Role role, EntityGroup userGroup, EntityGroup entityGroup, Set<Operation> mergedOperations) throws ThingsboardException, IOException {
        CollectionType collectionType = TypeFactory.defaultInstance().constructCollectionType(List.class, Operation.class);
        List roleOperations = (List)JacksonUtil.readValue((String)role.getPermissions().toString(), (CollectionType)collectionType);
        if (mergedOperations.isEmpty() || !mergedOperations.contains(Operation.ALL) && !mergedOperations.containsAll(roleOperations)) {
            throw this.permissionDenied();
        }
        this.groupPermissionService.saveGroupPermission(this.getTenantId(), new GroupPermission(this.getTenantId(), userGroup.getId(), role.getId(), entityGroup.getId(), entityGroup.getId().getEntityType(), false));
    }

    private boolean hasGenenericPermissionToShareGroup(EntityType type) throws ThingsboardException {
        return this.getCurrentUser().getUserPermissions().hasGenericPermission(Resource.groupResourceFromGroupType((EntityType)type), Operation.SHARE_GROUP);
    }

    private boolean hasGroupPermissionsToShareGroup(EntityGroupId entityGroupId) throws ThingsboardException {
        return this.getCurrentUser().getUserPermissions().hasGroupPermissions(entityGroupId, Operation.SHARE_GROUP);
    }

    private List<EntityGroupInfo> filterEntityGroupsByReadPermission(List<EntityGroupInfo> entityGroups) {
        return entityGroups.stream().filter(entityGroup -> {
            try {
                return this.accessControlService.hasEntityGroupInfoPermission(this.getCurrentUser(), Operation.READ, entityGroup);
            }
            catch (ThingsboardException e) {
                return false;
            }
        }).toList();
    }

    @ConstructorProperties(value={"tbEntityGroupService", "ownersCacheService", "ownerService", "roleService", "userService"})
    @Generated
    public EntityGroupController(TbEntityGroupService tbEntityGroupService, OwnersCacheService ownersCacheService, OwnerService ownerService, RoleService roleService, UserService userService) {
        this.tbEntityGroupService = tbEntityGroupService;
        this.ownersCacheService = ownersCacheService;
        this.ownerService = ownerService;
        this.roleService = roleService;
        this.userService = userService;
    }
}

