/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import java.beans.ConstructorProperties;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.util.Pair;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.integration.api.converter.AbstractDownlinkDataConverter;
import org.thingsboard.integration.api.converter.DedicatedConverterConfig;
import org.thingsboard.integration.api.converter.DedicatedConverterUtil;
import org.thingsboard.integration.api.converter.DedicatedUplinkData;
import org.thingsboard.integration.api.converter.ScriptDownlinkEvaluator;
import org.thingsboard.integration.api.converter.ScriptUplinkEvaluator;
import org.thingsboard.integration.api.converter.wrapper.ConverterUnwrapper;
import org.thingsboard.integration.api.converter.wrapper.ConverterUnwrapperFactory;
import org.thingsboard.integration.api.data.ContentType;
import org.thingsboard.integration.api.data.IntegrationMetaData;
import org.thingsboard.integration.api.data.UplinkMetaData;
import org.thingsboard.script.api.ScriptInvokeService;
import org.thingsboard.script.api.js.JsInvokeService;
import org.thingsboard.script.api.tbel.TbelInvokeService;
import org.thingsboard.server.common.data.EventInfo;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.converter.Converter;
import org.thingsboard.server.common.data.converter.ConverterType;
import org.thingsboard.server.common.data.event.EventType;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.ConverterId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.integration.AbstractIntegration;
import org.thingsboard.server.common.data.integration.Integration;
import org.thingsboard.server.common.data.integration.IntegrationType;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.common.data.script.ScriptLanguage;
import org.thingsboard.server.common.data.util.TbPair;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.AutoCommitController;
import org.thingsboard.server.dao.event.EventService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.converter.TbConverterService;
import org.thingsboard.server.service.security.model.SecurityUser;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class ConverterController
extends AutoCommitController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConverterController.class);
    private final EventService eventService;
    private final JsInvokeService jsInvokeService;
    private final Optional<TbelInvokeService> tbelInvokeService;
    private final TbConverterService tbConverterService;
    private static final Map<IntegrationType, String> converterDefaultMessages = ImmutableMap.builder().put((Object)IntegrationType.LORIOT, (Object)"{\n    \"cmd\": \"rx\",\n    \"seqno\": 3040,\n    \"EUI\": \"1000000000000001\",\n    \"ts\": 1684478801936,\n    \"fcnt\": 2,\n    \"port\": 85,\n    \"freq\": 867500000,\n    \"rssi\": -21,\n    \"snr\": 10,\n    \"toa\": 206,\n    \"dr\": \"SF9 BW125 4/5\",\n    \"ack\": false,\n    \"bat\": 94,\n    \"offline\": false,\n    \"data\": \"01ed03335f0e4c63\"\n}\n").put((Object)IntegrationType.SIGFOX, (Object)"{\n    \"device\": \"2203961\",\n    \"time\": \"1686298419\",\n    \"data\": \"2502af2102462a\",\n    \"seqNumber\": \"570\",\n    \"deviceTypeId\": \"630ceaea10d051194ec0246e\",\n    \"ack\": \"false\",\n    \"customData#int1\": \"37\",\n    \"customData#int2\": \"2\"\n}").put((Object)IntegrationType.TTI, (Object)"{\n    \"end_device_ids\": {\n    \"device_id\": \"eui-1000000000000001\",\n        \"application_ids\": {\n            \"application_id\": \"application-tti-name\"\n        },\n        \"dev_eui\": \"1000000000000001\",\n        \"join_eui\": \"2000000000000001\",\n        \"dev_addr\": \"20000001\"\n    },\n    \"correlation_ids\": [\"as:up:01H0PZDGB1NW6NAPD815NGHPF6\", \"gs:conn:01H0FJRSXSYT7VKNYXJ89F95XT\", \"gs:up:host:01H0FJRSY3MZMGPPFBQ4FZV4T8\", \"gs:uplink:01H0PZDG4HHGFRTXRTXD4PFTH7\", \"ns:uplink:01H0PZDG4JZ3BM0K6J89EQK1J7\", \"rpc:/ttn.lorawan.v3.GsNs/HandleUplink:01H0PZDG4J02F85RYFPCNSNXCR\", \"rpc:/ttn.lorawan.v3.NsAs/HandleUplink:01H0PZDGB081PMP806BJHNHX1A\"],\n    \"received_at\": \"2023-05-18T08:25:26.112483370Z\",\n    \"uplink_message\": {\n    \"session_key_id\": \"AYfg8rhha5n+FWx0ZaAprA==\",\n    \"f_port\": 85,\n    \"f_cnt\": 5017,\n    \"frm_payload\": \"Ae0DM18OTGM=\",\n    \"rx_metadata\": [{\n        \"gateway_ids\": {\n            \"gateway_id\": \"eui-6A7E111A10000000\",\n            \"eui\": \"6A7E111A10000000\"\n        },\n        \"time\": \"2023-05-18T08:25:25.885310Z\",\n        \"timestamp\": 818273765,\n        \"rssi\": -24,\n        \"channel_rssi\": -24,\n        \"snr\": 12,\n        \"frequency_offset\": \"671\",\n        \"uplink_token\": \"CiIKIAoUZXVpLTZBN0UxMTFBMTAwMDAwMDASCCThJP/+9k6eEOW7l4YDGgwI9cGXowYQ5KPhrwMgiI2rp+jpOA=\",\n        \"channel_index\": 2,\n        \"received_at\": \"2023-05-18T08:25:25.869324983Z\"\n    }, {\n        \"gateway_ids\": {\n        \"gateway_id\": \"packetbroker\"\n    },\n        \"packet_broker\": {\n            \"message_id\": \"01H0PZDG4MF9AYSMNY44MAVTDH\",\n            \"forwarder_net_id\": \"000013\",\n            \"forwarder_tenant_id\": \"ttn\",\n            \"forwarder_cluster_id\": \"eu1.cloud.thethings.network\",\n            \"forwarder_gateway_eui\": \"6A7E111A10000000\",\n            \"forwarder_gateway_id\": \"eui-6a7e111a10000000\",\n            \"home_network_net_id\": \"000013\",\n            \"home_network_tenant_id\": \"tenant\",\n            \"home_network_cluster_id\": \"eu1.cloud.thethings.industries\"\n        },\n        \"time\": \"2023-05-18T08:25:25.885310Z\",\n        \"rssi\": -24,\n        \"channel_rssi\": -24,\n        \"snr\": 12,\n        \"frequency_offset\": \"671\",\n        \"uplink_token\": \"eyJnIjoiWlhsS2FHSkhZMmxQYVVwQ1RWUkpORkl3VGs1VE1XTnBURU5LYkdKdFRXbFBhVXBDVFZSSk5GSXdUazVKYVhkcFlWaFphVTlwU201a01uaGhWVlJvZDFSWFVuRmlSM1JtVFcxT2RVbHBkMmxrUjBadVNXcHZhV05ZY0RKT1IyeExaREpSZVZwR1pIUmpNRXBLVlVoR2RFNVZkR3BWVTBvNUxua3paVVJTWVRaM1lXOU1kbTQwVm5sdmIyWmlPWGN1ZUhCZmVrcElaa3hIWlZadGRVUlFVeTVuYlRaVlZXRXdkakpHV0VKMGJUUjZaMjVXUkVoeGVHRjRaMlJKTlVkS1VsbERhemc1VDNCbk5rVk1iM1JDUkVZM1VWbHdZbEJDTkdOblNqWjBlbkphYUV4MFRVMHhZMVZFTTFac01XdExURUo0YURaMFExTnhhMVJsWWw4eE5FdHlVVXcyZUhsRWFFbEhlakJITXpoTE0xaFdlRzR5VUVjMk4wNUViME5WTkhoTmRrazFZVk5oWkUwd2FXVnFjR294VGtoMFduZHlZMDFxVlVGNmRsbERUazlNY2s5eFdVeFpWMk5XTG1WVFFYVkpNVkptT1U5NWRqUTNhSEoxTUZoalYxRT0iLCJhIjp7ImZuaWQiOiIwMDAwMTMiLCJmdGlkIjoidHRuIiwiZmNpZCI6ImV1MS5jbG91ZC50aGV0aGluZ3MubmV0d29yayJ9fQ==\",\n        \"received_at\": \"2023-05-18T08:25:25.906038642Z\"\n    }],\n        \"settings\": {\n            \"data_rate\": {\n                \"lora\": {\n                    \"bandwidth\": 125000,\n                    \"spreading_factor\": 7,\n                    \"coding_rate\": \"4/5\"\n                }\n            },\n            \"frequency\": \"868500000\",\n            \"timestamp\": 818273765,\n            \"time\": \"2023-05-18T08:25:25.885310Z\"\n        },\n        \"received_at\": \"2023-05-18T08:25:25.906399073Z\",\n        \"consumed_airtime\": \"0.097536s\",\n        \"network_ids\": {\n            \"net_id\": \"000013\",\n            \"tenant_id\": \"tenant\",\n            \"cluster_id\": \"eu1\",\n            \"cluster_address\": \"eu1.cloud.thethings.industries\",\n            \"tenant_address\": \"tenant.eu1.cloud.thethings.industries\"\n        }\n    }\n}").put((Object)IntegrationType.TTN, (Object)"{\n    \"end_device_ids\": {\n        \"device_id\": \"eui-1000000000000001\",\n            \"application_ids\": {\n                \"application_id\": \"application-tts-name\"\n            },\n        \"dev_eui\": \"1000000000000001\",\n        \"join_eui\": \"2000000000000001\",\n        \"dev_addr\": \"20000001\"\n    },\n    \"correlation_ids\": [\"as:up:01H0S7ZJQ9MQPMVY49FT3SE07M\", \"gs:conn:01H03BQZ9342X3Y86DJ2P704E5\", \"gs:up:host:01H03BQZ99EGAM52KK1300GFKN\", \"gs:uplink:01H0S7ZJGS6D9TJSKJN8XNTMAV\", \"ns:uplink:01H0S7ZJGS9KKD4HTTPKFEMWCV\", \"rpc:/ttn.lorawan.v3.GsNs/HandleUplink:01H0S7ZJGSF3M38ZRZVTM38DEC\", \"rpc:/ttn.lorawan.v3.NsAs/HandleUplink:01H0S7ZJQ8R2EH5AA269AKM8DX\"],\n    \"received_at\": \"2023-05-19T05:33:35.848446463Z\",\n    \"uplink_message\": {\n    \"session_key_id\": \"AYfqmb0pc/1uRZv9xUydgQ==\",\n    \"f_port\": 85,\n    \"f_cnt\": 10335,\n    \"frm_payload\": \"Ae0DM18OTGM=\",\n    \"rx_metadata\": [{\n        \"gateway_ids\": {\n            \"gateway_id\": \"eui-6a7e111a10000000\",\n            \"eui\": \"6A7E111A10000000\"\n        },\n        \"time\": \"2023-05-19T05:33:35.608982Z\",\n        \"timestamp\": 3893546133,\n        \"rssi\": -35,\n        \"channel_rssi\": -35,\n        \"snr\": 13.2,\n        \"frequency_offset\": \"69\",\n        \"uplink_token\": \"CiIKIAoUZXVpLTZhN2UxMTFhMTAwMDAwMDASCCThJP/+9k6eEJWZy8AOGgwIr5ScowYQvNbUsQIgiMy8y6jwpwE=\",\n        \"channel_index\": 3,\n        \"received_at\": \"2023-05-19T05:33:35.607383681Z\"\n    }],\n    \"settings\": {\n        \"data_rate\": {\n            \"lora\": {\n                \"bandwidth\": 125000,\n                \"spreading_factor\": 7,\n                \"coding_rate\": \"4/5\"\n                }\n            },\n            \"frequency\": \"867100000\",\n            \"timestamp\": 3893546133,\n            \"time\": \"2023-05-19T05:33:35.608982Z\"\n        },\n        \"received_at\": \"2023-05-19T05:33:35.641841782Z\",\n        \"consumed_airtime\": \"0.056576s\",\n            \"network_ids\": {\n                \"net_id\": \"000013\",\n                \"tenant_id\": \"ttn\",\n                \"cluster_id\": \"eu1\",\n                \"cluster_address\": \"eu1.cloud.thethings.network\"\n        }\n    }\n}\n").put((Object)IntegrationType.CHIRPSTACK, (Object)"{\n   \"deduplicationId\": \"57433366-50a6-4dc2-8145-2df1bbc70d9e\",\n   \"time\": \"2023-05-22T07:47:05.404859+00:00\",\n   \"deviceInfo\": {\n       \"tenantId\": \"52f14cd4-c6f1-4fbd-8f87-4025e1d49242\",\n       \"tenantName\": \"ChirpStack\",\n       \"applicationId\": \"ca739e26-7b67-4f14-b69e-d568c22a5a75\",\n       \"applicationName\": \"Chirpstack application\",\n       \"deviceProfileId\": \"605d08d4-65f5-4d2c-8a5a-3d2457662f79\",\n       \"deviceProfileName\": \"Chirpstack default device profile\",\n       \"deviceName\": \"Device name\",\n       \"devEui\": \"1000000000000001\",\n       \"tags\": {}\n    },\n       \"devAddr\": \"20000001\",\n       \"adr\": true,\n       \"dr\": 5,\n       \"fCnt\": 4,\n       \"fPort\": 85,\n       \"confirmed\": false,\n       \"data\": \"Ae0DM18OTGM=\",\n       \"rxInfo\": [{\n           \"gatewayId\": \"6a7e111a10000000\",\n           \"uplinkId\": 24022,\n           \"time\": \"2023-05-22T07:47:05.404859+00:00\",\n           \"rssi\": -35,\n           \"snr\": 11.5,\n           \"channel\": 2,\n           \"rfChain\": 1,\n           \"location\": {},\n           \"context\": \"EFwMtA==\",\n           \"metadata\": {\n               \"region_common_name\": \"EU868\",\n               \"region_config_id\": \"eu868\"\n               },\n           \"crcStatus\": \"CRC_OK\"\n       }],\n       \"txInfo\": {\n           \"frequency\": 868500000,\n           \"modulation\": {\n               \"lora\": {\n                   \"bandwidth\": 125000,\n                   \"spreadingFactor\": 7,\n                   \"codeRate\": \"CR_4_5\"\n           }\n        }\n    }\n}").put((Object)IntegrationType.AZURE_IOT_HUB, (Object)"{\n  \"deviceId\": \"8F4A2C6D\",\n  \"deviceType\": \"Packing machine\",\n  \"temperature\": 25.5,\n  \"pressure\": 1013.25,\n  \"vibration\": {\n    \"x\": 0.02,\n    \"y\": 0.03,\n    \"z\": 0.015\n  },\n  \"location\": {\n    \"latitude\": 37.7749,\n    \"longitude\": -122.4194,\n    \"altitude\": 10\n  },\n  \"timestamp\": \"2023-06-09T10:30:00Z\",\n  \"status\": \"ALARM\",\n  \"alarms\": [\n    {\n      \"type\": \"temperature\",\n      \"severity\": \"high\",\n      \"message\": \"Temperature exceeds threshold.\"\n    },\n    {\n      \"type\": \"vibration\",\n      \"severity\": \"critical\",\n      \"message\": \"Excessive vibration detected.\"\n    }\n  ],\n  \"metadata\": {\n    \"version\": 1,\n    \"batteryLevel\": 100,\n    \"batteryStatus\": \"Charging\",\n    \"manufacturer\": \"Example corporation\"\n  }\n}").put((Object)IntegrationType.AZURE_EVENT_HUB, (Object)"{\n  \"deviceId\": \"8F4A2C6D\",\n  \"deviceType\": \"Packing machine\",\n  \"temperature\": 25.5,\n  \"pressure\": 1013.25,\n  \"vibration\": {\n    \"x\": 0.02,\n    \"y\": 0.03,\n    \"z\": 0.015\n  },\n  \"location\": {\n    \"latitude\": 37.7749,\n    \"longitude\": -122.4194,\n    \"altitude\": 10\n  },\n  \"timestamp\": \"2023-06-09T10:30:00Z\",\n  \"status\": \"ALARM\",\n  \"alarms\": [\n    {\n      \"type\": \"temperature\",\n      \"severity\": \"high\",\n      \"message\": \"Temperature exceeds threshold.\"\n    },\n    {\n      \"type\": \"vibration\",\n      \"severity\": \"critical\",\n      \"message\": \"Excessive vibration detected.\"\n    }\n  ],\n  \"metadata\": {\n    \"version\": 1,\n    \"batteryLevel\": 100,\n    \"batteryStatus\": \"Charging\",\n    \"manufacturer\": \"Example corporation\"\n  }\n}").put((Object)IntegrationType.AZURE_SERVICE_BUS, (Object)"{\n  \"deviceId\": \"8F4A2C6D\",\n  \"deviceType\": \"Packing machine\",\n  \"temperature\": 25.5,\n  \"pressure\": 1013.25,\n  \"vibration\": {\n    \"x\": 0.02,\n    \"y\": 0.03,\n    \"z\": 0.015\n  },\n  \"location\": {\n    \"latitude\": 37.7749,\n    \"longitude\": -122.4194,\n    \"altitude\": 10\n  },\n  \"timestamp\": \"2023-06-09T10:30:00Z\",\n  \"status\": \"ALARM\",\n  \"alarms\": [\n    {\n      \"type\": \"temperature\",\n      \"severity\": \"high\",\n      \"message\": \"Temperature exceeds threshold.\"\n    },\n    {\n      \"type\": \"vibration\",\n      \"severity\": \"critical\",\n      \"message\": \"Excessive vibration detected.\"\n    }\n  ],\n  \"metadata\": {\n    \"version\": 1,\n    \"batteryLevel\": 100,\n    \"batteryStatus\": \"Charging\",\n    \"manufacturer\": \"Example corporation\"\n  }\n}").put((Object)IntegrationType.AWS_IOT, (Object)"{\n  \"device_id\": \"3G7H1j-9zF\",\n  \"timestamp\": \"2023-06-10T12:00:00Z\",\n  \"sensor_data\": {\n    \"temperature\": 25.3,\n    \"humidity\": 62.8,\n    \"pressure\": 1012.5\n  },\n  \"location\": {\n    \"latitude\": 37.7749,\n    \"longitude\": -122.4194\n  },\n  \"status\": \"active\",\n  \"power_status\": \"on\",\n  \"vibration\": {\n    \"x\": 0.02,\n    \"y\": 0.03,\n    \"z\": 0.01\n  },\n  \"fault_codes\": [100, 204, 301],\n  \"battery_level\": 78.5\n}\n").put((Object)IntegrationType.KPN, (Object)"{\n  \"deviceName\":\"Device A\",\n  \"deviceType\":\"thermostat\",\n  \"customerName\":\"customer\",\n  \"groupName\":\"thermostat devices\",\n  \"attributes\": {\n    \"model\":\"Model A\",\n    \"serialNumber\":\"SN111\"\n  },\n  \"telemetry\": {\n    \"temperature\":42,\n    \"humidity\":80\n  }\n}\n").put((Object)IntegrationType.THINGPARK, (Object)"{\n    \"DevEUI_uplink\": {\n        \"Time\": \"2024-11-28T21:08:22.138+00:00\",\n        \"DevEUI\": \"1000000000000001\",\n        \"FPort\": 1,\n        \"FCntUp\": 26,\n        \"LostUplinksAS\": 0,\n        \"ADRbit\": 1,\n        \"MType\": 2,\n        \"FCntDn\": 2,\n        \"payload_hex\": \"01ed03335f0e4c63\",\n        \"mic_hex\": \"e7214986\",\n        \"Lrcid\": \"00000211\",\n        \"LrrRSSI\": -114,\n        \"LrrSNR\": 4.75,\n        \"LrrESP\": -115.2547,\n        \"SpFact\": 9,\n        \"SubBand\": \"G0\",\n        \"Channel\": \"LC1\",\n        \"Lrrid\": \"100019D4\",\n        \"Late\": 0,\n        \"LrrLAT\": 32.516357,\n        \"LrrLON\": -106.824348,\n        \"Lrrs\": {\n            \"Lrr\": [{\n                \"Lrrid\": \"100019D4\",\n                \"Chain\": 0,\n                \"LrrRSSI\": -114,\n                \"LrrSNR\": 4.75,\n                \"LrrESP\": -115.2547\n            }]\n        },\n        \"DevLrrCnt\": 1,\n        \"CustomerID\": \"100045194\",\n        \"CustomerData\": {\n            \"loc\": {\n                \"lat\": \"32.592782\",\n                \"lon\": \"-106.927742\"\n            },\n            \"alr\": {\n                \"pro\": \"DL/TBRG\",\n                \"ver\": \"1\"\n            },\n            \"tags\": [\"EnvironSens\", \"RainGauge\", \"CDRRC\"],\n            \"doms\": [],\n            \"name\": \"RainGauge 5483_Test\"\n        },\n        \"BaseStationData\": {\n            \"doms\": [],\n            \"name\": \"iStation US #6_CDRRC_Summerford\"\n        },\n        \"ModelCfg\": \"0\",\n        \"DriverCfg\": {\n            \"mod\": {\n                \"pId\": \"dl\",\n                \"mId\": \"dl-tbrg\",\n                \"ver\": \"1\"\n            },\n            \"app\": {\n                \"pId\": \"dl\",\n                \"mId\": \"dl-tbrg\",\n                \"ver\": \"1\"\n            }\n        },\n        \"InstantPER\": 0,\n        \"MeanPER\": 0.037037,\n        \"DevAddr\": \"00FDA112\",\n        \"TxPower\": 18,\n        \"NbTrans\": 2,\n        \"Frequency\": 902.5,\n        \"DynamicClass\": \"A\"\n    }\n}").put((Object)IntegrationType.TPE, (Object)"{\n    \"DevEUI_uplink\": {\n        \"Time\": \"2024-11-28T21:08:22.138+00:00\",\n        \"DevEUI\": \"1000000000000001\",\n        \"FPort\": 1,\n        \"FCntUp\": 26,\n        \"LostUplinksAS\": 0,\n        \"ADRbit\": 1,\n        \"MType\": 2,\n        \"FCntDn\": 2,\n        \"payload_hex\": \"01ed03335f0e4c63\",\n        \"mic_hex\": \"e7214986\",\n        \"Lrcid\": \"00000211\",\n        \"LrrRSSI\": -114,\n        \"LrrSNR\": 4.75,\n        \"LrrESP\": -115.2547,\n        \"SpFact\": 9,\n        \"SubBand\": \"G0\",\n        \"Channel\": \"LC1\",\n        \"Lrrid\": \"100019D4\",\n        \"Late\": 0,\n        \"LrrLAT\": 32.516357,\n        \"LrrLON\": -106.824348,\n        \"Lrrs\": {\n            \"Lrr\": [{\n                \"Lrrid\": \"100019D4\",\n                \"Chain\": 0,\n                \"LrrRSSI\": -114,\n                \"LrrSNR\": 4.75,\n                \"LrrESP\": -115.2547\n            }]\n        },\n        \"DevLrrCnt\": 1,\n        \"CustomerID\": \"100045194\",\n        \"CustomerData\": {\n            \"loc\": {\n                \"lat\": \"32.592782\",\n                \"lon\": \"-106.927742\"\n            },\n            \"alr\": {\n                \"pro\": \"DL/TBRG\",\n                \"ver\": \"1\"\n            },\n            \"tags\": [\"EnvironSens\", \"RainGauge\", \"CDRRC\"],\n            \"doms\": [],\n            \"name\": \"RainGauge 5483_Test\"\n        },\n        \"BaseStationData\": {\n            \"doms\": [],\n            \"name\": \"iStation US #6_CDRRC_Summerford\"\n        },\n        \"ModelCfg\": \"0\",\n        \"DriverCfg\": {\n            \"mod\": {\n                \"pId\": \"dl\",\n                \"mId\": \"dl-tbrg\",\n                \"ver\": \"1\"\n            },\n            \"app\": {\n                \"pId\": \"dl\",\n                \"mId\": \"dl-tbrg\",\n                \"ver\": \"1\"\n            }\n        },\n        \"InstantPER\": 0,\n        \"MeanPER\": 0.037037,\n        \"DevAddr\": \"00FDA112\",\n        \"TxPower\": 18,\n        \"NbTrans\": 2,\n        \"Frequency\": 902.5,\n        \"DynamicClass\": \"A\"\n    }\n}").build();
    private static final Map<IntegrationType, String> converterDefaultMetadatas = Map.of(IntegrationType.SIGFOX, "{\n    \"Header:accept-encoding\": \"gzip,deflate\",\n    \"Header:content-type\": \"application/json\",\n    \"Header:content-length\": \"243\",\n    \"Header:user-agent\": \"SIGFOX\",\n    \"Header:accept-charset\": \"UTF-8;q=0.9,*;q=0.7\",\n    \"Header:accept-language\": \"en\"}\n");
    public static final String CONVERTER_ID = "converterId";

    @ApiOperation(value="Get Converter (getConverterById)", notes="Fetch the Converter object based on the provided Converter Id. The server checks that the converter is owned by the same tenant. \n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/converter/{converterId}"})
    public Converter getConverterById(@Parameter(required=true, description="A string value representing the converter id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="converterId") String strConverterId) throws ThingsboardException {
        ConverterController.checkParameter((String)"converterId", (String)strConverterId);
        ConverterId converterId = new ConverterId(this.toUUID(strConverterId));
        return this.checkConverterId(converterId, Operation.READ);
    }

    @ApiOperation(value="Create Or Update Converter (saveConverter)", notes="Create or update the Converter. When creating converter, platform generates Converter Id as [time-based UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_1_(date-time_and_MAC_address)). The newly created converter id will be present in the response. Specify existing Converter id to update the converter. Referencing non-existing converter Id will cause 'Not Found' error. Converter name is unique in the scope of tenant. \n\n# Converter Configuration\n\nConverter configuration (**'configuration'** field) is the JSON object that should contain one of two possible fields: **'decoder'** or **'encoder'**. The former is used when the converter has UPLINK type, the latter is used - when DOWNLINK type. It can contain both 'decoder' and 'encoder' fields, when the correct one is specified for the appropriate converter type, another one can be set to 'null'. See the examples of each one below. \n\n## Uplink Converter Configuration\n\n***Default converter may be different, depending on integration type***.\n\n```json\n{\n   \"decoder\":\"// Decode an uplink message from a buffer\\n// payload - array of bytes\\n// metadata - key/value object\\n\\n/** Decoder **/\\n\\n// decode payload to string\\nvar payloadStr = decodeToString(payload);\\n\\n// decode payload to JSON\\n// var data = decodeToJson(payload);\\n\\nvar deviceName = 'Device A';\\nvar deviceType = 'thermostat';\\nvar customerName = 'customer';\\nvar groupName = 'thermostat devices';\\nvar manufacturer = 'Example corporation';\\n// use assetName and assetType instead of deviceName and deviceType\\n// to automatically create assets instead of devices.\\n// var assetName = 'Asset A';\\n// var assetType = 'building';\\n\\n// Result object with device/asset attributes/telemetry data\\nvar result = {\\n// Use deviceName and deviceType or assetName and assetType, but not both.\\n   deviceName: deviceName,\\n   deviceType: deviceType,\\n// assetName: assetName,\\n// assetType: assetType,\\n   customerName: customerName,\\n   groupName: groupName,\\n   contentAwareAttributeKeys: ['manufacturer'],\\n   attributes: {\\n       model: 'Model A',\\n       serialNumber: 'SN111',\\n       integrationName: metadata['integrationName'],\\n       manufacturer: manufacturer\\n   },\\n   telemetry: {\\n       temperature: 42,\\n       humidity: 80,\\n       rawData: payloadStr\\n   }\\n};\\n\\n/** Helper functions **/\\n\\nfunction decodeToString(payload) {\\n   return String.fromCharCode.apply(String, payload);\\n}\\n\\nfunction decodeToJson(payload) {\\n   // covert payload to string.\\n   var str = decodeToString(payload);\\n\\n   // parse string to JSON\\n   var data = JSON.parse(str);\\n   return data;\\n}\\n\\nreturn result;\",\n   \"encoder\":null\n}\n```\n\nDecoder field in the more readable form:\n\n```text\n// Decode an uplink message from a buffer\n// payload - array of bytes\n// metadata - key/value object\n\n/** Decoder **/\n\n// decode payload to string\nvar payloadStr = decodeToString(payload);\n\n// decode payload to JSON\n// var data = decodeToJson(payload);\n\nvar deviceName = 'Device A';\nvar deviceType = 'thermostat';\nvar customerName = 'customer';\nvar groupName = 'thermostat devices';\nvar manufacturer = 'Example corporation';\n// use assetName and assetType instead of deviceName and deviceType\n// to automatically create assets instead of devices.\n// var assetName = 'Asset A';\n// var assetType = 'building';\n\n// Result object with device/asset attributes/telemetry data\nvar result = {\n// Use deviceName and deviceType or assetName and assetType, but not both.\n   deviceName: deviceName,\n   deviceType: deviceType,\n// assetName: assetName,\n// assetType: assetType,\n   customerName: customerName,\n   groupName: groupName,\n   attributes: {\n       model: 'Model A',\n       serialNumber: 'SN111',\n       integrationName: metadata['integrationName']\n       manufacturer: manufacturer,\n   },\n   telemetry: {\n       temperature: 42,\n       humidity: 80,\n       rawData: payloadStr\n   }\n};\n\n/** Helper functions **/\n\nfunction decodeToString(payload) {\n   return String.fromCharCode.apply(String, payload);\n}\n\nfunction decodeToJson(payload) {\n   // covert payload to string.\n   var str = decodeToString(payload);\n\n   // parse string to JSON\n   var data = JSON.parse(str);\n   return data;\n}\n\nreturn result;\n```\n\n## Downlink Converter Configuration\n\n```json\n{\n   \"decoder\":null,\n   \"encoder\":\"// Encode downlink data from incoming Rule Engine message\\n\\n// msg - JSON message payload downlink message json\\n// msgType - type of message, for ex. 'ATTRIBUTES_UPDATED', 'POST_TELEMETRY_REQUEST', etc.\\n// metadata - list of key-value pairs with additional data about the message\\n// integrationMetadata - list of key-value pairs with additional data defined in Integration executing this converter\\n\\n/** Encoder **/\\n\\nvar data = {};\\n\\n// Process data from incoming message and metadata\\n\\ndata.tempFreq = msg.temperatureUploadFrequency;\\ndata.humFreq = msg.humidityUploadFrequency;\\n\\ndata.devSerialNumber = metadata['ss_serialNumber'];\\n\\n// Result object with encoded downlink payload\\nvar result = {\\n\\n    // downlink data content type: JSON, TEXT or BINARY (base64 format)\\n    contentType: \\\"JSON\\\",\\n\\n    // downlink data\\n    data: JSON.stringify(data),\\n\\n    // Optional metadata object presented in key/value format\\n    metadata: {\\n            topic: metadata['deviceType']+'/'+metadata['deviceName']+'/upload'\\n    }\\n\\n};\\n\\nreturn result;\"\n}\n```\n\nEncoder field in the more readable form:\n\n```text\n// Encode downlink data from incoming Rule Engine message\n\n// msg - JSON message payload downlink message json\n// msgType - type of message, for ex. 'ATTRIBUTES_UPDATED', 'POST_TELEMETRY_REQUEST', etc.\n// metadata - list of key-value pairs with additional data about the message\n// integrationMetadata - list of key-value pairs with additional data defined in Integration executing this converter\n\n/** Encoder **/\n\nvar data = {};\n\n// Process data from incoming message and metadata\n\ndata.tempFreq = msg.temperatureUploadFrequency;\ndata.humFreq = msg.humidityUploadFrequency;\n\ndata.devSerialNumber = metadata['ss_serialNumber'];\n\n// Result object with encoded downlink payload\nvar result = {\n\n    // downlink data content type: JSON, TEXT or BINARY (base64 format)\n    contentType: \"JSON\",\n\n    // downlink data\n    data: JSON.stringify(data),\n\n    // Optional metadata object presented in key/value format\n    metadata: {\n            topic: metadata['deviceType']+'/'+metadata['deviceName']+'/upload'\n    }\n\n};\n\nreturn result;\n```\n\nRemove 'id', 'tenantId' from the request body example (below) to create new converter entity. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/converter"})
    public Converter saveConverter(@RequestBody(required=true, description="A JSON value representing the converter.") @org.springframework.web.bind.annotation.RequestBody Converter converter) throws Exception {
        converter.setTenantId(this.getCurrentUser().getTenantId());
        this.checkEntity((EntityId)converter.getId(), (TenantEntity)converter, Resource.CONVERTER);
        return this.tbConverterService.save(converter, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Get Converters (getConverters)", notes="Returns a page of converters owned by tenant. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/converters"}, params={"pageSize", "page"})
    public PageData<Converter> getConverters(@Parameter(description="Fetch edge template converters") @RequestParam(value="isEdgeTemplate", required=false, defaultValue="false") boolean isEdgeTemplate, @Parameter(required=true, description="Maximum amount of entities in a one page", schema=@Schema(minimum="1")) @RequestParam int pageSize, @Parameter(required=true, description="Sequence number of page starting from 0", schema=@Schema(minimum="0")) @RequestParam int page, @Parameter(description="The case insensitive 'startsWith' filter based on the converter name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "type", "debugMode"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder, @Parameter(description="A string value representing the integration type. One of the following:\nAPACHE_PULSAR, AWS_IOT, AWS_KINESIS, AWS_SQS, AZURE_EVENT_HUB, AZURE_IOT_HUB, AZURE_SERVICE_BUS, CHIRPSTACK, COAP, CUSTOM, HTTP, IBM_WATSON_IOT, KAFKA, LORIOT, MQTT, OCEANCONNECT, OPC_UA, PUB_SUB, RABBITMQ,  SIGFOX,  TCP,  THINGPARK,  TMOBILE_IOT_CDP,  TPE,  TTI,  TTN,  TUYA,  UDP") @RequestParam(required=false) IntegrationType integrationType) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.CONVERTER, Operation.READ);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        if (isEdgeTemplate) {
            return (PageData)this.checkNotNull((Object)this.converterService.findTenantEdgeTemplateConverters(tenantId, integrationType, pageLink));
        }
        return (PageData)this.checkNotNull((Object)this.converterService.findTenantConverters(tenantId, integrationType, pageLink));
    }

    @ApiOperation(value="Delete converter (deleteConverter)", notes="Deletes the converter and all the relations (from and to the converter). Referencing non-existing converter Id will cause an error. If the converter is associated with the integration, it will not be allowed for deletion.\n\n Security check is performed to verify that the user has 'DELETE' permission for the entity (entities).")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @DeleteMapping(value={"/converter/{converterId}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteConverter(@Parameter(required=true, description="A string value representing the converter id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="converterId") String strConverterId) throws ThingsboardException {
        ConverterController.checkParameter((String)"converterId", (String)strConverterId);
        ConverterId converterId = new ConverterId(this.toUUID(strConverterId));
        Converter converter = this.checkConverterId(converterId, Operation.DELETE);
        this.tbConverterService.delete(converter, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Get latest debug input event (getLatestConverterDebugInput)", notes="Returns a JSON object of the latest debug event representing the input message the converter processed. \n\n## Uplink Converter Debug Input Event Example\n\n```json\n{\n   \"inContentType\":\"JSON\",\n   \"inContent\":\"{\\\"temp\\\":40}\",\n   \"inMetadata\":\"{\\\"Header:sec-ch-ua\\\":\\\"\\\\\\\"Chromium\\\\\\\";v=\\\\\\\"94\\\\\\\", \\\\\\\"Google Chrome\\\\\\\";v=\\\\\\\"94\\\\\\\", \\\\\\\";Not A Brand\\\\\\\";v=\\\\\\\"99\\\\\\\"\\\",\\\"Header:user-agent\\\":\\\"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/94.0.4606.71 Safari/537.36\\\",\\\"integrationName\\\":\\\"Integration\\\",\\\"Header:cookie\\\":\\\"GUID=zYSs8hymSwZKv8kHALKY; redirect_to=%2F; JSESSIONID=B0A7C8E481409CE7924E738DB04F62F9\\\",\\\"Header:sec-ch-ua-platform\\\":\\\"\\\\\\\"Linux\\\\\\\"\\\",\\\"Header:accept\\\":\\\"*/*\\\",\\\"Header:origin\\\":\\\"http://localhost:8080\\\",\\\"Header:sec-fetch-site\\\":\\\"same-origin\\\",\\\"Header:connection\\\":\\\"keep-alive\\\",\\\"Header:accept-encoding\\\":\\\"gzip, deflate, br\\\",\\\"Header:content-type\\\":\\\"application/json\\\",\\\"Header:content-length\\\":\\\"16\\\",\\\"Header:sec-fetch-mode\\\":\\\"cors\\\",\\\"Header:sec-ch-ua-mobile\\\":\\\"?0\\\",\\\"Header:sec-fetch-dest\\\":\\\"empty\\\",\\\"Header:host\\\":\\\"localhost:8080\\\",\\\"Header:referer\\\":\\\"http://localhost:8080/swagger-ui.html\\\",\\\"Header:accept-language\\\":\\\"en-US,en;q=0.9,ru-RU;q=0.8,ru;q=0.7,uk;q=0.6,und;q=0.5\\\"}\"\n}\n```\n\n * 'inContentType' - content type of the message received by the integration; \n * 'inContent' - message data received; \n * 'inMetadata' - integration metadata (e.g. headers).\n\n## Downlink Converter Debug Input Event Example\n\n```json\n{\n   \"inContentType\":\"JSON\",\n   \"inContent\":\"{\\\"temp\\\":42,\\\"humidity\\\":77}\",\n   \"inMsgType\":\"POST_TELEMETRY_REQUEST\",\n   \"inMetadata\":\"{\\\"data\\\":\\\"40\\\"}\",\n   \"inIntegrationMetadata\":\"{\\\"integrationName\\\":\\\"Integration\\\"}\"\n}\n```\n\n * 'inContentType' - content type of the message received by the integration; \n * 'inContent' - content of the message pushed from the rule engine; \n * 'inMsgType' - type of the message pushed from the rule engine; \n * 'inMetadata' - content of the message metadata pushed from the rule engine; \n * 'inIntegrationMetadata' - integration metadata. \n\n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/converter/{converterId}/debugIn"})
    public JsonNode getLatestConverterDebugInput(@Parameter(description="A string value representing the converter id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="converterId") String strConverterId, @Parameter(description="A string value representing the converter type. One of the following:\nUPLINK, DOWNLINK") @RequestParam(required=false) String converterType, @Parameter(description="A string value representing the integration type. One of the following:\nAPACHE_PULSAR, AWS_IOT, AWS_KINESIS, AWS_SQS, AZURE_EVENT_HUB, AZURE_IOT_HUB, AZURE_SERVICE_BUS, CHIRPSTACK, COAP, CUSTOM, HTTP, IBM_WATSON_IOT, KAFKA, LORIOT, MQTT, OCEANCONNECT, OPC_UA, PUB_SUB, RABBITMQ,  SIGFOX,  TCP,  THINGPARK,  TMOBILE_IOT_CDP,  TPE,  TTI,  TTN,  TUYA,  UDP") @RequestParam(required=false) String integrationType, @Parameter(description="A string value representing the integration name. For example, 'My New Integration'") @RequestParam(required=false) String integrationName, @Parameter(description="Converter version.") @RequestParam(required=false) Integer converterVersion) throws Exception {
        ConverterController.checkParameter((String)"converterId", (String)strConverterId);
        UUID uuid = this.toUUID(strConverterId);
        Converter converter = null;
        if (!EntityId.NULL_UUID.equals(uuid)) {
            ConverterId converterId = new ConverterId(uuid);
            converter = this.checkConverterId(converterId, Operation.READ);
            List events = this.eventService.findLatestEvents(this.getTenantId(), (EntityId)converterId, EventType.DEBUG_CONVERTER, 1);
            if (events != null && !events.isEmpty()) {
                JsonNode body = ((EventInfo)events.get(0)).getBody();
                return ConverterController.createDebugInFromFoundEvent((JsonNode)body);
            }
        }
        return this.createDefaultDebugIn(converter, converterType, integrationType, integrationName, converterVersion);
    }

    private JsonNode createDefaultDebugIn(Converter converter, String converterType, String integrationType, String integrationName, Integer converterVersion) throws ThingsboardException {
        if (converter == null && !ConverterType.UPLINK.name().equals(converterType) || converter != null && !ConverterType.UPLINK.equals((Object)converter.getType())) {
            return null;
        }
        Pair targetIntegrationInfo = this.getTargetIntegrationTypeAndName(converter, integrationType);
        if (targetIntegrationInfo == null) {
            return null;
        }
        IntegrationType targetIntegrationType = (IntegrationType)targetIntegrationInfo.getFirst();
        if (StringUtils.isBlank((String)integrationName)) {
            integrationName = (String)targetIntegrationInfo.getSecond();
        }
        if (converterVersion == null) {
            converterVersion = converter != null ? converter.getConverterVersion() : null;
        }
        return this.createDebugIn(integrationName, targetIntegrationType, converterVersion);
    }

    private JsonNode createDebugIn(String integrationName, IntegrationType targetIntegrationType, Integer converterVersion) {
        ObjectNode debugIn = JacksonUtil.newObjectNode();
        ObjectNode metadata = JacksonUtil.newObjectNode();
        metadata.put("integrationName", integrationName);
        metadata.put("includeGatewayInfo", false);
        String inContent = (String)converterDefaultMessages.get(targetIntegrationType);
        if (converterDefaultMetadatas.containsKey(targetIntegrationType)) {
            metadata.setAll((ObjectNode)JacksonUtil.fromString((String)((String)converterDefaultMetadatas.get(targetIntegrationType)), ObjectNode.class));
        }
        ContentType contentType = ContentType.JSON;
        debugIn.put("inMetadata", JacksonUtil.toString((Object)metadata));
        debugIn.put("inContent", inContent);
        debugIn.put("inContentType", contentType.name());
        return debugIn.isEmpty() ? null : debugIn;
    }

    private Pair<IntegrationType, String> getTargetIntegrationTypeAndName(Converter converter, String integrationType) throws ThingsboardException {
        IntegrationType targetIntegrationType = null;
        Object targetIntegrationName = "";
        if (converter != null) {
            Integration integration = this.getIntegration(converter.getId());
            if (integration != null) {
                targetIntegrationType = integration.getType();
                targetIntegrationName = integration.getName();
            } else if (converter.getIntegrationType() != null) {
                targetIntegrationType = converter.getIntegrationType();
            }
        }
        if (StringUtils.isNotBlank((String)integrationType) && targetIntegrationType == null) {
            targetIntegrationType = IntegrationType.valueOf((String)integrationType);
        }
        if (targetIntegrationType != null && StringUtils.isBlank((String)targetIntegrationName)) {
            targetIntegrationName = "Test " + targetIntegrationType.getDirectory();
        }
        return targetIntegrationType == null ? null : Pair.of((Object)targetIntegrationType, (Object)targetIntegrationName);
    }

    private Integration getIntegration(ConverterId converterId) throws ThingsboardException {
        List relatedIntegrations = this.integrationService.findIntegrationsByConverterId(this.getTenantId(), converterId);
        if (!relatedIntegrations.isEmpty() && relatedIntegrations.stream().map(AbstractIntegration::getType).distinct().limit(2L).count() == 1L) {
            return (Integration)relatedIntegrations.get(0);
        }
        return null;
    }

    private static ObjectNode createDebugInFromFoundEvent(JsonNode body) {
        String type;
        ObjectNode debugIn = JacksonUtil.newObjectNode();
        if (body.has("type") && ((type = body.get("type").asText()).equals("Uplink") || type.equals("Downlink"))) {
            String inContentType = body.get("inMessageType").asText();
            debugIn.put("inContentType", inContentType);
            if (type.equals("Uplink")) {
                String inContent = body.get("in").asText();
                debugIn.put("inContent", inContent);
                JsonNode rawMetadata = body.get("metadata");
                ObjectNode metadataNode = rawMetadata == null ? JacksonUtil.newObjectNode() : (rawMetadata.isObject() ? (ObjectNode)rawMetadata : (ObjectNode)JacksonUtil.fromString((String)rawMetadata.asText(), ObjectNode.class));
                if (!metadataNode.has("includeGatewayInfo")) {
                    metadataNode.put("includeGatewayInfo", false);
                }
                debugIn.put("inMetadata", metadataNode.toString());
            } else {
                String inContent = "";
                String inMsgType = "";
                String inMetadata = "";
                String in = body.get("in").asText();
                JsonNode inJson = JacksonUtil.toJsonNode((String)in);
                if (inJson.isArray() && !inJson.isEmpty()) {
                    JsonNode msgJson = inJson.get(inJson.size() - 1);
                    JsonNode msg = msgJson.get("msg");
                    if (msg.isTextual()) {
                        inContent = "";
                    } else if (msg.isObject()) {
                        inContent = JacksonUtil.toString((Object)msg);
                    }
                    inMsgType = msgJson.get("msgType").asText();
                    inMetadata = JacksonUtil.toString((Object)msgJson.get("metadata"));
                }
                debugIn.put("inContent", inContent);
                debugIn.put("inMsgType", inMsgType);
                debugIn.put("inMetadata", inMetadata);
                String inIntegrationMetadata = body.get("metadata").asText();
                debugIn.put("inIntegrationMetadata", inIntegrationMetadata);
            }
        }
        return debugIn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="Test converter function (testUpLinkConverter)", notes="Returns a JSON object representing the result of the processed incoming message. \n\n## Request Body Example\n\n```json\n{\n   \"metadata\":{\n   },\n   \"payload\":\"ewogICAgImRhdGEiOiAiZGF0YSIKfQ==\",\n   \"decoder\":\"// Decode an uplink message from a buffer\\n// payload - array of bytes\\n// metadata - key/value object\\n\\n/** Decoder **/\\n\\n// decode payload to string\\nvar payloadStr = decodeToString(payload);\\n\\n// decode payload to JSON\\n// var data = decodeToJson(payload);\\n\\nvar deviceName = 'Device A';\\nvar deviceType = 'thermostat';\\nvar customerName = 'customer';\\nvar groupName = 'thermostat devices';\\nvar manufacturer = 'Example corporation';\\n// use assetName and assetType instead of deviceName and deviceType\\n// to automatically create assets instead of devices.\\n// var assetName = 'Asset A';\\n// var assetType = 'building';\\n\\n// Result object with device/asset attributes/telemetry data\\nvar result = {\\n// Use deviceName and deviceType or assetName and assetType, but not both.\\n   deviceName: deviceName,\\n   deviceType: deviceType,\\n// assetName: assetName,\\n// assetType: assetType,\\n   customerName: customerName,\\n   groupName: groupName,\\n   attributes: {\\n       model: 'Model A',\\n       serialNumber: 'SN111',\\n       integrationName: metadata['integrationName']\\n       manufacturer: manufacturer\\n   },\\n   telemetry: {\\n       temperature: 42,\\n       humidity: 80,\\n       rawData: payloadStr\\n   }\\n};\\n\\n/** Helper functions **/\\n\\nfunction decodeToString(payload) {\\n   return String.fromCharCode.apply(String, payload);\\n}\\n\\nfunction decodeToJson(payload) {\\n   // covert payload to string.\\n   var str = decodeToString(payload);\\n\\n   // parse string to JSON\\n   var data = JSON.parse(str);\\n   return data;\\n}\\n\\nreturn result;\"\n}\n```\n\n * 'metadata' - integration metadata; \n * 'payload' - base64 string representation of the data; \n * 'decoder' - string representation of the decoder configuration; \n * 'converter' - JSON object representing converter.\n\n## Response Body Example\n\n```json\n{\n   \"output\":\"{\\\"deviceName\\\":\\\"Device A\\\",\\\"deviceType\\\":\\\"thermostat\\\",\\\"customerName\\\":\\\"customer\\\",\\\"groupName\\\":\\\"thermostat devices\\\",\\\"attributes\\\":{\\\"model\\\":\\\"Model A\\\",\\\"serialNumber\\\":\\\"SN111\\\"},\\\"telemetry\\\":{\\\"temperature\\\":42,\\\"humidity\\\":80,\\\"rawData\\\":\\\"{\\\\n    \\\\\\\"data\\\\\\\": \\\\\\\"data\\\\\\\"\\\\n}\\\"}}\",\n   \"error\":\"\"\n}\n```\n\n * 'output' - string representation of the output message; \n * 'error' - string representation of the error message. \n")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/converter/testUpLink"})
    public JsonNode testUpLinkConverter(@Parameter(description="Script language: JS or TBEL") @RequestParam(required=false) ScriptLanguage scriptLang, @RequestBody(required=true, description="A JSON value representing the input to the converter function.") @org.springframework.web.bind.annotation.RequestBody JsonNode inputParams) {
        Converter converter;
        String payloadBase64 = inputParams.get("payload").asText();
        byte[] payload = Base64.getDecoder().decode(payloadBase64);
        JsonNode metadata = inputParams.get("metadata");
        String decoder = inputParams.get("decoder").asText();
        Map metadataMap = (Map)JacksonUtil.convertValue((Object)metadata, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        UplinkMetaData uplinkMetaData = new UplinkMetaData(ContentType.JSON, metadataMap);
        String output = "";
        String errorText = "";
        ScriptUplinkEvaluator scriptUplinkEvaluator = null;
        try {
            scriptUplinkEvaluator = new ScriptUplinkEvaluator(this.getTenantId(), this.getScriptInvokeService(scriptLang), (EntityId)this.getCurrentUser().getId(), decoder);
            output = (String)scriptUplinkEvaluator.execute(payload, uplinkMetaData).get();
        }
        catch (Exception e) {
            log.error("Error evaluating JS UpLink Converter function", (Throwable)e);
            errorText = e.getMessage();
        }
        finally {
            if (scriptUplinkEvaluator != null) {
                scriptUplinkEvaluator.destroy();
            }
        }
        ObjectNode result = JacksonUtil.newObjectNode();
        result.put("output", output);
        result.put("error", errorText);
        if (StringUtils.isNotEmpty((String)output) && inputParams.has("converter") && (converter = (Converter)JacksonUtil.treeToValue((JsonNode)inputParams.get("converter"), Converter.class)).isDedicated() && ConverterUnwrapperFactory.getUnwrapper((IntegrationType)converter.getIntegrationType()).isPresent()) {
            DedicatedConverterConfig config = (DedicatedConverterConfig)JacksonUtil.treeToValue((JsonNode)converter.getConfiguration(), DedicatedConverterConfig.class);
            JsonElement jsonOutput = JsonParser.parseString((String)output);
            Object outputMsg = null;
            if (jsonOutput.isJsonArray()) {
                ArrayList<DedicatedUplinkData> resultList = new ArrayList<DedicatedUplinkData>();
                for (JsonElement uplinkJson : jsonOutput.getAsJsonArray()) {
                    resultList.add(DedicatedConverterUtil.parseUplinkData((DedicatedConverterConfig)config, (JsonObject)uplinkJson.getAsJsonObject(), (UplinkMetaData)uplinkMetaData));
                }
                outputMsg = resultList;
            } else if (jsonOutput.isJsonObject()) {
                outputMsg = DedicatedConverterUtil.parseUplinkData((DedicatedConverterConfig)config, (JsonObject)jsonOutput.getAsJsonObject(), (UplinkMetaData)uplinkMetaData);
            }
            if (outputMsg != null) {
                result.set("outputMsg", JacksonUtil.valueToTree((Object)outputMsg));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="Test converter function (testDownLinkConverter)", notes="Returns a JSON object representing the result of the processed incoming message. \n\n## Request Body Example\n\n```json\n{\n   \"metadata\":{\n      \"data\":\"40\"\n   },\n   \"msg\":\"{\\n    \\\"temp\\\": 42,\\n    \\\"humidity\\\": 77\\n}\",\n   \"msgType\":\"POST_TELEMETRY_REQUEST\",\n   \"integrationMetadata\":{\n      \"integrationName\":\"Integration\"\n   },\n   \"encoder\":\"// Encode downlink data from incoming Rule Engine message\\n\\n// msg - JSON message payload downlink message json\\n// msgType - type of message, for ex. 'ATTRIBUTES_UPDATED', 'POST_TELEMETRY_REQUEST', etc.\\n// metadata - list of key-value pairs with additional data about the message\\n// integrationMetadata - list of key-value pairs with additional data defined in Integration executing this converter\\n\\n/** Encoder **/\\n\\nvar data = {};\\n\\n// Process data from incoming message and metadata\\n\\ndata.tempValue = msg.temp;\\ndata.humValue = msg.humidity;\\n\\ndata.devSerialNumber = metadata['ss_serialNumber'];\\n\\n// Result object with encoded downlink payload\\nvar result = {\\n\\n    // downlink data content type: JSON, TEXT or BINARY (base64 format)\\n    contentType: \\\"JSON\\\",\\n\\n    // downlink data\\n    data: JSON.stringify(data),\\n\\n    // Optional metadata object presented in key/value format\\n    metadata: {\\n            topic: metadata['deviceType']+'/'+metadata['deviceName']+'/upload'\\n    }\\n\\n};\\n\\nreturn result;\"\n}\n```\n\n * 'metadata' - message metadata pushed from the rule engine; \n * 'msg' - message data pushed from the rule engine; \n * 'msgType' - type of the message pushed from the rule engine; \n * 'integrationMetadata' - integration metadata object; \n * 'encoder' - string representation of the encoder configuration.\n\n## Response Body Example\n\n```json\n{\n   \"contentType\":\"JSON\",\n   \"data\":\"{\\\"tempValue\\\":42,\\\"humValue\\\":77}\",\n   \"metadata\":{\n      \"topic\":\"sensor/Temp Sensor/upload\"\n   }\n}\n```\n\n * 'contentType' - downlink data content type; \n * 'data' - downlink data; \n * 'metadata' - optional metadata object. \n")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/converter/testDownLink"})
    public JsonNode testDownLinkConverter(@Parameter(description="Script language: JS or TBEL") @RequestParam(required=false) ScriptLanguage scriptLang, @RequestBody(required=true, description="A JSON value representing the input to the converter function.") @org.springframework.web.bind.annotation.RequestBody JsonNode inputParams) throws Exception {
        String data = inputParams.get("msg").asText();
        JsonNode metadata = inputParams.get("metadata");
        String msgType = inputParams.get("msgType").asText();
        JsonNode integrationMetadata = inputParams.get("integrationMetadata");
        String encoder = inputParams.get("encoder").asText();
        Map metadataMap = (Map)JacksonUtil.convertValue((Object)metadata, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        Map integrationMetadataMap = (Map)JacksonUtil.convertValue((Object)integrationMetadata, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        IntegrationMetaData integrationMetaData = new IntegrationMetaData(integrationMetadataMap);
        JsonNode output = null;
        String errorText = "";
        ScriptDownlinkEvaluator scriptDownlinkEvaluator = null;
        try {
            TbMsg inMsg = TbMsg.newMsg().type(msgType).metaData(new TbMsgMetaData(metadataMap)).data(data).build();
            scriptDownlinkEvaluator = new ScriptDownlinkEvaluator(this.getTenantId(), this.getScriptInvokeService(scriptLang), (EntityId)this.getCurrentUser().getId(), encoder);
            output = scriptDownlinkEvaluator.execute(inMsg, integrationMetaData);
            this.validateDownLinkOutput(output);
        }
        catch (Exception e) {
            log.error("Error evaluating JS Downlink Converter function", (Throwable)e);
            errorText = e.getMessage();
        }
        finally {
            if (scriptDownlinkEvaluator != null) {
                scriptDownlinkEvaluator.destroy();
            }
        }
        ObjectNode result = JacksonUtil.newObjectNode();
        result.put("output", JacksonUtil.toString(output));
        result.put("error", errorText);
        return result;
    }

    private ScriptInvokeService getScriptInvokeService(ScriptLanguage scriptLang) {
        JsInvokeService scriptInvokeService;
        if (scriptLang == null) {
            scriptLang = ScriptLanguage.JS;
        }
        if (ScriptLanguage.JS.equals((Object)scriptLang)) {
            scriptInvokeService = this.jsInvokeService;
        } else {
            if (this.tbelInvokeService.isEmpty()) {
                throw new IllegalArgumentException("TBEL script engine is disabled!");
            }
            scriptInvokeService = (ScriptInvokeService)this.tbelInvokeService.get();
        }
        return scriptInvokeService;
    }

    private void validateDownLinkOutput(JsonNode output) throws Exception {
        if (output.isArray()) {
            for (JsonNode downlinkJson : output) {
                if (downlinkJson.isObject()) {
                    this.validateDownLinkObject(downlinkJson);
                    continue;
                }
                throw new JsonParseException("Invalid downlink output format!");
            }
        } else if (output.isObject()) {
            this.validateDownLinkObject(output);
        } else {
            throw new JsonParseException("Invalid downlink output format!");
        }
    }

    private void validateDownLinkObject(JsonNode src) throws Exception {
        AbstractDownlinkDataConverter.parseDownlinkData((JsonNode)src);
    }

    @ApiOperation(value="Get Converters By Ids (getConvertersByIds)", notes="Requested converters must be owned by tenant which is performing the request. \n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/converters"}, params={"converterIds"})
    public List<Converter> getConvertersByIds(@Parameter(description="A list of converter ids, separated by comma ','", array=@ArraySchema(schema=@Schema(type="string")), required=true) @RequestParam(value="converterIds") String[] strConverterIds) throws Exception {
        this.checkArrayParameter("converterIds", strConverterIds);
        if (!this.accessControlService.hasPermission(this.getCurrentUser(), Resource.CONVERTER, Operation.READ)) {
            return Collections.emptyList();
        }
        SecurityUser user = this.getCurrentUser();
        TenantId tenantId = user.getTenantId();
        ArrayList<ConverterId> converterIds = new ArrayList<ConverterId>();
        for (String strConverterId : strConverterIds) {
            converterIds.add(new ConverterId(this.toUUID(strConverterId)));
        }
        List converters = (List)this.checkNotNull((Object)((List)this.converterService.findConvertersByIdsAsync(tenantId, converterIds).get()));
        return this.filterConvertersByReadPermission(converters);
    }

    @ApiOperation(value="Transform input raw payload to the dedicated converter data (unwrapRawPayload)", notes="Returns a JSON object representing the result of the unwrapped incoming raw message. \n\n## Request Body Example\n\n```json\n{\n   \"metadata\":{\n   },\n   \"payload\":\"ewogICAgImRhdGEiOiAiZGF0YSIKfQ==\",\n}\n``` * 'metadata' - integration metadata; \n * 'payload' - JSON object representing the input raw message.\n\n## Response Body Example\n\n * 'metadata' - integration metadata enriched with the data from the input message; \n * 'payload' - base64 string representation of the payload from the unwrapped input message; \n * 'contentType' - string representation payload contentType.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/converter/unwrap/{integrationType}"})
    public JsonNode unwrapRawPayload(@Parameter(description="A string value representing the integration type. One of the following:\nAPACHE_PULSAR, AWS_IOT, AWS_KINESIS, AWS_SQS, AZURE_EVENT_HUB, AZURE_IOT_HUB, AZURE_SERVICE_BUS, CHIRPSTACK, COAP, CUSTOM, HTTP, IBM_WATSON_IOT, KAFKA, LORIOT, MQTT, OCEANCONNECT, OPC_UA, PUB_SUB, RABBITMQ,  SIGFOX,  TCP,  THINGPARK,  TMOBILE_IOT_CDP,  TPE,  TTI,  TTN,  TUYA,  UDP") @PathVariable IntegrationType integrationType, @RequestBody(required=true, description="A JSON value representing the input message.") @org.springframework.web.bind.annotation.RequestBody JsonNode inputParams) throws Exception {
        JsonNode payloadJson = inputParams.get("payload");
        byte[] payload = JacksonUtil.writeValueAsBytes((Object)payloadJson);
        JsonNode metadata = inputParams.get("metadata");
        Map metadataMap = (Map)JacksonUtil.convertValue((Object)metadata, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        UplinkMetaData uplinkMetaData = new UplinkMetaData(ContentType.JSON, metadataMap);
        ConverterUnwrapper unwrapper = (ConverterUnwrapper)ConverterUnwrapperFactory.getUnwrapper((IntegrationType)integrationType).orElseThrow(() -> new IllegalArgumentException("Unsupported integrationType: " + String.valueOf(integrationType)));
        TbPair wrappedPair = unwrapper.unwrap(payload, uplinkMetaData);
        payload = (byte[])wrappedPair.getFirst();
        uplinkMetaData = (UplinkMetaData)wrappedPair.getSecond();
        ObjectNode result = JacksonUtil.newObjectNode();
        result.put("contentType", uplinkMetaData.getContentType().toString());
        result.set("metadata", JacksonUtil.valueToTree((Object)uplinkMetaData.getKvMap()));
        String payloadValue = uplinkMetaData.getContentType() == ContentType.BINARY ? Base64.getEncoder().encodeToString(payload) : new String(payload, StandardCharsets.UTF_8);
        result.put("payload", payloadValue);
        return result;
    }

    private List<Converter> filterConvertersByReadPermission(List<Converter> converters) {
        return converters.stream().filter(converter -> {
            try {
                return this.accessControlService.hasPermission(this.getCurrentUser(), Resource.CONVERTER, Operation.READ, (EntityId)converter.getId(), (TenantEntity)converter);
            }
            catch (ThingsboardException e) {
                return false;
            }
        }).toList();
    }

    @ConstructorProperties(value={"eventService", "jsInvokeService", "tbelInvokeService", "tbConverterService"})
    @Generated
    public ConverterController(EventService eventService, JsInvokeService jsInvokeService, Optional<TbelInvokeService> tbelInvokeService, TbConverterService tbConverterService) {
        this.eventService = eventService;
        this.jsInvokeService = jsInvokeService;
        this.tbelInvokeService = tbelInvokeService;
        this.tbConverterService = tbConverterService;
    }
}

