/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.JobManager;
import org.thingsboard.script.api.tbel.TbelCfArg;
import org.thingsboard.script.api.tbel.TbelCfCtx;
import org.thingsboard.script.api.tbel.TbelCfSingleValueArg;
import org.thingsboard.script.api.tbel.TbelCfTsDoubleVal;
import org.thingsboard.script.api.tbel.TbelCfTsRollingArg;
import org.thingsboard.script.api.tbel.TbelInvokeService;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.EventInfo;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.cf.CalculatedField;
import org.thingsboard.server.common.data.cf.CalculatedFieldFilter;
import org.thingsboard.server.common.data.cf.CalculatedFieldInfo;
import org.thingsboard.server.common.data.cf.CalculatedFieldType;
import org.thingsboard.server.common.data.cf.configuration.CalculatedFieldConfiguration;
import org.thingsboard.server.common.data.event.EventType;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CalculatedFieldId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.job.CfReprocessingJobConfiguration;
import org.thingsboard.server.common.data.job.Job;
import org.thingsboard.server.common.data.job.JobConfiguration;
import org.thingsboard.server.common.data.job.JobType;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.controller.CalculatedFieldController;
import org.thingsboard.server.dao.event.EventService;
import org.thingsboard.server.dao.job.JobService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldTbelScriptEngine;
import org.thingsboard.server.service.entitiy.cf.CalculatedFieldReprocessingValidator;
import org.thingsboard.server.service.entitiy.cf.TbCalculatedFieldService;
import org.thingsboard.server.service.security.model.SecurityUser;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class CalculatedFieldController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CalculatedFieldController.class);
    private final TbCalculatedFieldService tbCalculatedFieldService;
    private final EventService eventService;
    private final TbelInvokeService tbelInvokeService;
    private final JobManager jobManager;
    private final JobService jobService;
    public static final String CALCULATED_FIELD_ID = "calculatedFieldId";
    public static final int TIMEOUT = 20;
    private static final String TEST_SCRIPT_EXPRESSION = "Execute the Script expression and return the result. The format of request: \n\n```json\n{\n  \"expression\": \"var temp = 0; foreach(element: temperature.values) {temp += element.value;} var avgTemperature = temp / temperature.values.size(); var adjustedTemperature = avgTemperature + 0.1 * humidity.value; return {\\\"adjustedTemperature\\\": adjustedTemperature};\",\n  \"arguments\": {\n    \"temperature\": {\n      \"type\": \"TS_ROLLING\",\n      \"timeWindow\": {\n        \"startTs\": 1739775630002,\n        \"endTs\": 65432211,\n        \"limit\": 5\n      },\n      \"values\": [\n        { \"ts\": 1739775639851, \"value\": 23 },\n        { \"ts\": 1739775664561, \"value\": 43 },\n        { \"ts\": 1739775713079, \"value\": 15 },\n        { \"ts\": 1739775999522, \"value\": 34 },\n        { \"ts\": 1739776228452, \"value\": 22 }\n      ]\n    },\n    \"humidity\": { \"type\": \"SINGLE_VALUE\", \"ts\": 1739776478057, \"value\": 23 }\n  }\n}\n```\n\n Expected result JSON contains \"output\" and \"error\".";

    @ApiOperation(value="Create Or Update Calculated Field (saveCalculatedField)", notes="Creates or Updates the Calculated Field. When creating calculated field, platform generates Calculated Field Id as [time-based UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_1_(date-time_and_MAC_address)). The newly created Calculated Field Id will be present in the response. Specify existing Calculated Field Id to update the calculated field. Referencing non-existing Calculated Field Id will cause 'Not Found' error. Remove 'id', 'tenantId' from the request body example (below) to create new Calculated Field entity. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/calculatedField"})
    public CalculatedField saveCalculatedField(@RequestBody(description="A JSON value representing the calculated field.") @org.springframework.web.bind.annotation.RequestBody CalculatedField calculatedField) throws Exception {
        calculatedField.setTenantId(this.getTenantId());
        this.checkEntityId(calculatedField.getEntityId(), Operation.WRITE_CALCULATED_FIELD);
        this.checkReferencedEntities(calculatedField.getConfiguration());
        return this.tbCalculatedFieldService.save(calculatedField, this.getCurrentUser());
    }

    @ApiOperation(value="Get Calculated Field (getCalculatedFieldById)", notes="Fetch the Calculated Field object based on the provided Calculated Field Id.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/calculatedField/{calculatedFieldId}"})
    public CalculatedField getCalculatedFieldById(@Parameter @PathVariable(value="calculatedFieldId") String strCalculatedFieldId) throws ThingsboardException {
        CalculatedFieldController.checkParameter((String)"calculatedFieldId", (String)strCalculatedFieldId);
        CalculatedFieldId calculatedFieldId = new CalculatedFieldId(this.toUUID(strCalculatedFieldId));
        CalculatedField calculatedField = this.tbCalculatedFieldService.findById(calculatedFieldId, this.getCurrentUser());
        this.checkNotNull((Object)calculatedField);
        this.checkEntityId(calculatedField.getEntityId(), Operation.READ_CALCULATED_FIELD);
        return calculatedField;
    }

    @ApiOperation(value="Get Calculated Fields by Entity Id (getCalculatedFieldsByEntityId)", notes="Fetch the Calculated Fields based on the provided Entity Id.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/{entityType}/{entityId}/calculatedFields"}, params={"pageSize", "page"})
    public PageData<CalculatedField> getCalculatedFieldsByEntityId(@Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true, schema=@Schema(defaultValue="DEVICE")) @PathVariable(value="entityType") String entityType, @Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityId") String entityIdStr, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="Calculated field type. If not specified, all types will be returned.") @RequestParam(required=false) CalculatedFieldType type, @Parameter(description="The case insensitive 'substring' filter based on the calculated field name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        CalculatedFieldController.checkParameter((String)"entityId", (String)entityIdStr);
        EntityId entityId = EntityIdFactory.getByTypeAndUuid((String)entityType, (String)entityIdStr);
        this.checkEntityId(entityId, Operation.READ_CALCULATED_FIELD);
        return (PageData)this.checkNotNull((Object)this.tbCalculatedFieldService.findByTenantIdAndEntityId(this.getTenantId(), entityId, type, pageLink));
    }

    @ApiOperation(value="Get calculated fields (getCalculatedFields)", notes="Fetch tenant calculated fields based on the filter.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/calculatedFields"})
    public PageData<CalculatedFieldInfo> getCalculatedFields(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="Calculated field types filter.") @RequestParam(required=false) Set<CalculatedFieldType> types, @Parameter(description="Entity type filter. If not specified, calculated fields for all supported entity types will be returned.") @RequestParam(required=false) EntityType entityType, @Parameter(description="Entities filter. If not specified, calculated fields for entity type filter will be returned.") @RequestParam(required=false) Set<UUID> entities, @Parameter(description="Name filter. To specify multiple names, duplicate 'name' parameter for each name, for example '?name=name1&name=name2") @RequestParam(required=false) String name, @Parameter(description="The case insensitive 'substring' filter based on the calculated field name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder, @RequestParam MultiValueMap<String, String> params) throws ThingsboardException {
        Set<Object> entityTypes;
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        SecurityUser user = this.getCurrentUser();
        if (CollectionUtils.isEmpty(types)) {
            types = EnumSet.allOf(CalculatedFieldType.class);
            types.remove(CalculatedFieldType.ALARM);
        }
        if (entityType == null) {
            Set<CalculatedFieldType> finalTypes = types;
            entityTypes = CalculatedField.SUPPORTED_ENTITIES.entrySet().stream().filter(entry -> CollectionUtils.containsAny((Collection)((Collection)entry.getValue()), (Collection)finalTypes)).map(Map.Entry::getKey).filter(t -> {
                try {
                    return this.accessControlService.hasPermission(user, Resource.resourceFromEntityType((EntityType)t), Operation.READ_CALCULATED_FIELD);
                }
                catch (ThingsboardException e) {
                    return false;
                }
            }).collect(Collectors.toSet());
        } else {
            this.accessControlService.checkPermission(user, Resource.resourceFromEntityType((EntityType)entityType), Operation.READ_CALCULATED_FIELD);
            entityTypes = EnumSet.of(entityType);
        }
        CalculatedFieldFilter filter = CalculatedFieldFilter.builder().types(types).entityTypes(entityTypes).entityIds(entities).names((Set)Optional.ofNullable((List)params.get((Object)"name")).map(HashSet::new).orElse(null)).build();
        return this.calculatedFieldService.findCalculatedFieldsByTenantIdAndFilter(user.getTenantId(), filter, pageLink);
    }

    @ApiOperation(value="Get calculated field names (getCalculatedFieldNames)", notes="Fetch the list of calculated field names for specified type.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/calculatedFields/names"})
    public PageData<String> getCalculatedFieldNames(@Parameter(description="Calculated field type filter.") @RequestParam CalculatedFieldType type, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the calculated field name.") @RequestParam(required=false) String textSearch, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, "name", sortOrder);
        return this.calculatedFieldService.findCalculatedFieldNamesByTenantIdAndType(this.getTenantId(), type, pageLink);
    }

    @ApiOperation(value="Delete Calculated Field (deleteCalculatedField)", notes="Deletes the calculated field. Referencing non-existing Calculated Field Id will cause an error.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @DeleteMapping(value={"/calculatedField/{calculatedFieldId}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteCalculatedField(@PathVariable(value="calculatedFieldId") String strCalculatedFieldId) throws Exception {
        CalculatedFieldController.checkParameter((String)"calculatedFieldId", (String)strCalculatedFieldId);
        CalculatedFieldId calculatedFieldId = new CalculatedFieldId(this.toUUID(strCalculatedFieldId));
        CalculatedField calculatedField = this.tbCalculatedFieldService.findById(calculatedFieldId, this.getCurrentUser());
        this.checkEntityId(calculatedField.getEntityId(), Operation.WRITE_CALCULATED_FIELD);
        this.tbCalculatedFieldService.delete(calculatedField, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Get latest calculated field debug event (getLatestCalculatedFieldDebugEvent)", notes="Gets latest calculated field debug event for specified calculated field id. Referencing non-existing calculated field id will cause an error. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/calculatedField/{calculatedFieldId}/debug"})
    public JsonNode getLatestCalculatedFieldDebugEvent(@Parameter @PathVariable(value="calculatedFieldId") String strCalculatedFieldId) throws ThingsboardException {
        CalculatedFieldController.checkParameter((String)"calculatedFieldId", (String)strCalculatedFieldId);
        CalculatedFieldId calculatedFieldId = new CalculatedFieldId(this.toUUID(strCalculatedFieldId));
        CalculatedField calculatedField = this.tbCalculatedFieldService.findById(calculatedFieldId, this.getCurrentUser());
        this.checkEntityId(calculatedField.getEntityId(), Operation.READ_CALCULATED_FIELD);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        return Optional.ofNullable(this.eventService.findLatestEvents(tenantId, (EntityId)calculatedFieldId, EventType.DEBUG_CALCULATED_FIELD, 1)).flatMap(events -> events.stream().map(EventInfo::getBody).findFirst()).orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="Test Script expression", notes="Execute the Script expression and return the result. The format of request: \n\n```json\n{\n  \"expression\": \"var temp = 0; foreach(element: temperature.values) {temp += element.value;} var avgTemperature = temp / temperature.values.size(); var adjustedTemperature = avgTemperature + 0.1 * humidity.value; return {\\\"adjustedTemperature\\\": adjustedTemperature};\",\n  \"arguments\": {\n    \"temperature\": {\n      \"type\": \"TS_ROLLING\",\n      \"timeWindow\": {\n        \"startTs\": 1739775630002,\n        \"endTs\": 65432211,\n        \"limit\": 5\n      },\n      \"values\": [\n        { \"ts\": 1739775639851, \"value\": 23 },\n        { \"ts\": 1739775664561, \"value\": 43 },\n        { \"ts\": 1739775713079, \"value\": 15 },\n        { \"ts\": 1739775999522, \"value\": 34 },\n        { \"ts\": 1739776228452, \"value\": 22 }\n      ]\n    },\n    \"humidity\": { \"type\": \"SINGLE_VALUE\", \"ts\": 1739776478057, \"value\": 23 }\n  }\n}\n```\n\n Expected result JSON contains \"output\" and \"error\".\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/calculatedField/testScript"})
    public JsonNode testScript(@RequestBody(description="Test calculated field TBEL expression.") @org.springframework.web.bind.annotation.RequestBody JsonNode inputParams) {
        String expression = inputParams.get("expression").asText();
        Map arguments = Objects.requireNonNullElse((Map)JacksonUtil.convertValue((Object)inputParams.get("arguments"), (TypeReference)new /* Unavailable Anonymous Inner Class!! */), Collections.emptyMap());
        ArrayList<String> ctxAndArgNames = new ArrayList<String>(arguments.size() + 1);
        ctxAndArgNames.add("ctx");
        ctxAndArgNames.addAll(arguments.keySet());
        String output = "";
        String errorText = "";
        CalculatedFieldTbelScriptEngine engine = null;
        try {
            if (this.tbelInvokeService == null) {
                throw new IllegalArgumentException("TBEL script engine is disabled!");
            }
            engine = new CalculatedFieldTbelScriptEngine(this.getTenantId(), this.tbelInvokeService, expression, (String[])ctxAndArgNames.toArray(String[]::new));
            Object[] args = new Object[ctxAndArgNames.size()];
            args[0] = new TbelCfCtx(arguments, this.getLatestTimestamp(arguments));
            for (int i = 1; i < ctxAndArgNames.size(); ++i) {
                TbelCfArg arg = (TbelCfArg)arguments.get(ctxAndArgNames.get(i));
                if (arg instanceof TbelCfSingleValueArg) {
                    TbelCfSingleValueArg svArg = (TbelCfSingleValueArg)arg;
                    args[i] = svArg.getValue();
                    continue;
                }
                args[i] = arg;
            }
            JsonNode json = (JsonNode)engine.executeJsonAsync(args).get(20L, TimeUnit.SECONDS);
            output = JacksonUtil.toString((Object)json);
        }
        catch (Exception e) {
            log.error("Error evaluating expression", (Throwable)e);
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            errorText = (String)ObjectUtils.firstNonNull((Object[])new String[]{rootCause.getMessage(), e.getMessage(), e.getClass().getSimpleName()});
        }
        finally {
            if (engine != null) {
                engine.destroy();
            }
        }
        return JacksonUtil.newObjectNode().put("output", output).put("error", errorText);
    }

    @ApiOperation(value="Reprocess Calculated Field (reprocessCalculatedField)", notes="Reprocesses the calculated field.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/calculatedField/{calculatedFieldId}/reprocess"}, params={"startTs", "endTs"})
    public Job reprocessCalculatedField(@PathVariable(value="calculatedFieldId") String strCalculatedFieldId, @RequestParam(name="startTs") Long startTs, @RequestParam(name="endTs") Long endTs) throws Exception {
        CalculatedFieldController.checkParameter((String)"calculatedFieldId", (String)strCalculatedFieldId);
        CalculatedFieldId calculatedFieldId = new CalculatedFieldId(this.toUUID(strCalculatedFieldId));
        CalculatedField calculatedField = this.tbCalculatedFieldService.findById(calculatedFieldId, this.getCurrentUser());
        this.checkNotNull((Object)calculatedField);
        EntityId entityId = calculatedField.getEntityId();
        this.checkEntityId(entityId, Operation.READ_CALCULATED_FIELD);
        CalculatedFieldReprocessingValidator.CfReprocessingValidationResult validationResult = this.tbCalculatedFieldService.validateForReprocessing(calculatedField);
        if (!validationResult.isValid()) {
            throw new IllegalArgumentException(validationResult.message());
        }
        return (Job)this.jobManager.submitJob(Job.builder().tenantId(calculatedField.getTenantId()).type(JobType.CF_REPROCESSING).key(calculatedField.getId().toString()).entityId(entityId).configuration((JobConfiguration)CfReprocessingJobConfiguration.builder().calculatedFieldId(calculatedField.getId()).calculatedFieldName(calculatedField.getName()).startTs(startTs.longValue()).endTs(endTs.longValue()).build()).build()).get();
    }

    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/calculatedField/{calculatedFieldId}/reprocess/job"})
    public Job getLastCalculatedFieldReprocessingJob(@PathVariable(value="calculatedFieldId") UUID id) throws ThingsboardException {
        CalculatedFieldId calculatedFieldId = new CalculatedFieldId(id);
        CalculatedField calculatedField = this.tbCalculatedFieldService.findById(calculatedFieldId, this.getCurrentUser());
        this.checkNotNull((Object)calculatedField);
        EntityId entityId = calculatedField.getEntityId();
        this.checkEntityId(entityId, Operation.READ_CALCULATED_FIELD);
        return this.jobService.findLatestJobByKey(calculatedField.getTenantId(), calculatedField.getId().toString());
    }

    @ApiOperation(value="Validate reprocessing capability of a calculated field (validateCalculatedFieldReprocessing)", notes="Checks whether the specified calculated field can be reprocessed. Returns a validation result indicating if reprocessing is allowed and, if not, provides a reason. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/calculatedField/{calculatedFieldId}/reprocess/validate"})
    public CalculatedFieldReprocessingValidator.CfReprocessingValidationResult validateCalculatedFieldReprocessing(@PathVariable(value="calculatedFieldId") String strCalculatedFieldId) throws ThingsboardException {
        CalculatedFieldController.checkParameter((String)"calculatedFieldId", (String)strCalculatedFieldId);
        CalculatedFieldId calculatedFieldId = new CalculatedFieldId(this.toUUID(strCalculatedFieldId));
        CalculatedField calculatedField = this.tbCalculatedFieldService.findById(calculatedFieldId, this.getCurrentUser());
        this.checkNotNull((Object)calculatedField);
        EntityId entityId = calculatedField.getEntityId();
        this.checkEntityId(entityId, Operation.READ_CALCULATED_FIELD);
        return this.tbCalculatedFieldService.validateForReprocessing(calculatedField);
    }

    private long getLatestTimestamp(Map<String, TbelCfArg> arguments) {
        long lastUpdateTimestamp = -1L;
        for (TbelCfArg entry : arguments.values()) {
            if (entry instanceof TbelCfSingleValueArg) {
                TbelCfSingleValueArg singleValueArg = (TbelCfSingleValueArg)entry;
                long ts = singleValueArg.getTs();
                lastUpdateTimestamp = Math.max(lastUpdateTimestamp, ts);
                continue;
            }
            if (!(entry instanceof TbelCfTsRollingArg)) continue;
            TbelCfTsRollingArg tsRollingArg = (TbelCfTsRollingArg)entry;
            long maxTs = tsRollingArg.getValues().stream().mapToLong(TbelCfTsDoubleVal::getTs).max().orElse(-1L);
            lastUpdateTimestamp = Math.max(lastUpdateTimestamp, maxTs);
        }
        return lastUpdateTimestamp == -1L ? System.currentTimeMillis() : lastUpdateTimestamp;
    }

    private void checkReferencedEntities(CalculatedFieldConfiguration calculatedFieldConfig) throws ThingsboardException {
        Set referencedEntityIds = calculatedFieldConfig.getReferencedEntities();
        block4: for (EntityId referencedEntityId : referencedEntityIds) {
            EntityType entityType = referencedEntityId.getEntityType();
            switch (2.$SwitchMap$org$thingsboard$server$common$data$EntityType[entityType.ordinal()]) {
                case 1: {
                    return;
                }
                case 2: 
                case 3: 
                case 4: {
                    this.checkEntityId(referencedEntityId, Operation.READ);
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Calculated fields do not support '" + String.valueOf(entityType) + "' for referenced entities.");
        }
    }

    @ConstructorProperties(value={"tbCalculatedFieldService", "eventService", "tbelInvokeService", "jobManager", "jobService"})
    @Generated
    public CalculatedFieldController(TbCalculatedFieldService tbCalculatedFieldService, EventService eventService, TbelInvokeService tbelInvokeService, JobManager jobManager, JobService jobService) {
        this.tbCalculatedFieldService = tbCalculatedFieldService;
        this.eventService = eventService;
        this.tbelInvokeService = tbelInvokeService;
        this.jobManager = jobManager;
        this.jobService = jobService;
    }
}

