/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.blob.BlobEntity;
import org.thingsboard.server.common.data.blob.BlobEntityInfo;
import org.thingsboard.server.common.data.blob.BlobEntityWithCustomerInfo;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.BlobEntityId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.TimePageLink;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.blob.TbBlobService;
import org.thingsboard.server.service.security.model.SecurityUser;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class BlobEntityController
extends BaseController {
    public static final String BLOB_ENTITY_ID = "blobEntityId";
    public static final String INVALID_BLOB_ENTITY_ID = "Referencing non-existing Blob entity Id will cause an error.";
    public static final String BLOB_ENTITY_DESCRIPTION = "The platform uses Blob(binary large object) entities in the reporting feature, in order to store Dashboard states snapshots of different content types in base64 format. ";
    public static final String BLOB_ENTITY_INFO_DESCRIPTION = "The platform uses Blob(binary large object) entities in the reporting feature, in order to store Dashboard states snapshots of different content types in base64 format. BlobEntityInfo represents an object that contains base info about the blob entity(name, type, contentType, etc.). See the 'Model' tab of the Response Class for more details.";
    public static final String BLOB_ENTITY_INFO_WITH_CUSTOMER_INFO_DESCRIPTION = "The platform uses Blob(binary large object) entities in the reporting feature, in order to store Dashboard states snapshots of different content types in base64 format. BlobEntityWithCustomerInfo represents an object that contains base info about the blob entity(name, type, contentType, etc.) and info about the customer(customerTitle, customerIsPublic) of the user that scheduled generation of the dashboard report. ";
    public static final String BLOB_ENTITY_QUERY_START_TIME_DESCRIPTION = "The start timestamp in milliseconds of the search time range over the BlobEntityWithCustomerInfo class field: 'createdTime'.";
    public static final String BLOB_ENTITY_QUERY_END_TIME_DESCRIPTION = "The end timestamp in milliseconds of the search time range over the BlobEntityWithCustomerInfo class field: 'createdTime'.";
    private final TbBlobService tbBlobService;

    @ApiOperation(value="Get Blob Entity With Customer Info (getBlobEntityInfoById)", notes="Fetch the BlobEntityWithCustomerInfo object based on the provided Blob entity Id. The platform uses Blob(binary large object) entities in the reporting feature, in order to store Dashboard states snapshots of different content types in base64 format. BlobEntityWithCustomerInfo represents an object that contains base info about the blob entity(name, type, contentType, etc.) and info about the customer(customerTitle, customerIsPublic) of the user that scheduled generation of the dashboard report. Referencing non-existing Blob entity Id will cause an error.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/blobEntity/info/{blobEntityId}"})
    public BlobEntityWithCustomerInfo getBlobEntityInfoById(@Parameter(description="A string value representing the blob entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="blobEntityId") String strBlobEntityId) throws ThingsboardException {
        BlobEntityController.checkParameter((String)"blobEntityId", (String)strBlobEntityId);
        BlobEntityId blobEntityId = new BlobEntityId(this.toUUID(strBlobEntityId));
        return this.checkBlobEntityInfoId(blobEntityId, Operation.READ);
    }

    @ApiOperation(value="Download Blob Entity By Id (downloadBlobEntity)", notes="Download report file based on the provided Blob entity Id. Referencing non-existing Blob entity Id will cause an error.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/blobEntity/{blobEntityId}/download"})
    public ResponseEntity<ByteArrayResource> downloadBlobEntity(@Parameter(description="A string value representing the blob entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="blobEntityId") String strBlobEntityId) throws ThingsboardException {
        BlobEntityController.checkParameter((String)"blobEntityId", (String)strBlobEntityId);
        BlobEntityId blobEntityId = new BlobEntityId(this.toUUID(strBlobEntityId));
        BlobEntity blobEntity = this.checkBlobEntityId(blobEntityId, Operation.READ);
        ByteArrayResource resource = new ByteArrayResource(blobEntity.getData().array());
        ContentDisposition cd = ContentDisposition.attachment().filename(blobEntity.getName(), StandardCharsets.UTF_8).build();
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{cd.toString()})).header("x-filename", new String[]{blobEntity.getName()})).contentLength(resource.contentLength()).contentType(this.parseMediaType(blobEntity.getContentType())).body((Object)resource);
    }

    @ApiOperation(value="Delete Blob Entity (deleteBlobEntity)", notes="Delete Blob entity based on the provided Blob entity Id. Referencing non-existing Blob entity Id will cause an error.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.\n\n Security check is performed to verify that the user has 'DELETE' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @DeleteMapping(value={"/blobEntity/{blobEntityId}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteBlobEntity(@Parameter(description="A string value representing the blob entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="blobEntityId") String strBlobEntityId) throws ThingsboardException {
        BlobEntityController.checkParameter((String)"blobEntityId", (String)strBlobEntityId);
        BlobEntityId blobEntityId = new BlobEntityId(this.toUUID(strBlobEntityId));
        BlobEntityWithCustomerInfo blobEntityInfo = this.checkBlobEntityInfoId(blobEntityId, Operation.DELETE);
        this.tbBlobService.delete((BlobEntityInfo)blobEntityInfo, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Get Blob Entities (getBlobEntities)", notes="Returns a page of BlobEntityWithCustomerInfo object that are available for the current user. The platform uses Blob(binary large object) entities in the reporting feature, in order to store Dashboard states snapshots of different content types in base64 format. BlobEntityWithCustomerInfo represents an object that contains base info about the blob entity(name, type, contentType, etc.) and info about the customer(customerTitle, customerIsPublic) of the user that scheduled generation of the dashboard report. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/blobEntities"})
    public PageData<BlobEntityWithCustomerInfo> getBlobEntities(@Parameter(description="Maximum amount of entities in a one page") @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0") @RequestParam int page, @Parameter(description="A string value representing the blob entity type. For example, 'report'") @RequestParam(required=false) String type, @Parameter(description="The case insensitive 'startsWith' filter based on the blob entity name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "type", "contentType", "customerTitle"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder, @Parameter(description="The start timestamp in milliseconds of the search time range over the BlobEntityWithCustomerInfo class field: 'createdTime'.") @RequestParam(required=false) Long startTime, @Parameter(description="The end timestamp in milliseconds of the search time range over the BlobEntityWithCustomerInfo class field: 'createdTime'.") @RequestParam(required=false) Long endTime) throws ThingsboardException {
        TimePageLink pageLink = this.createTimePageLink(pageSize, page, textSearch, sortProperty, sortOrder, startTime, endTime);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        if (!this.accessControlService.hasPermission(this.getCurrentUser(), Resource.BLOB_ENTITY, Operation.READ)) {
            return new PageData();
        }
        if (Authority.TENANT_ADMIN.equals((Object)this.getCurrentUser().getAuthority())) {
            if (StringUtils.isNotBlank((String)type)) {
                return (PageData)this.checkNotNull((Object)this.blobEntityService.findBlobEntitiesByTenantIdAndType(tenantId, type, pageLink));
            }
            return (PageData)this.checkNotNull((Object)this.blobEntityService.findBlobEntitiesByTenantId(tenantId, pageLink));
        }
        CustomerId customerId = this.getCurrentUser().getCustomerId();
        if (StringUtils.isNotBlank((String)type)) {
            return (PageData)this.checkNotNull((Object)this.blobEntityService.findBlobEntitiesByTenantIdAndCustomerIdAndType(tenantId, customerId, type, pageLink));
        }
        return (PageData)this.checkNotNull((Object)this.blobEntityService.findBlobEntitiesByTenantIdAndCustomerId(tenantId, customerId, pageLink));
    }

    @ApiOperation(value="Get Blob Entities By Ids (getBlobEntitiesByIds)", notes="Requested blob entities must be owned by tenant or assigned to customer which user is performing the request. The platform uses Blob(binary large object) entities in the reporting feature, in order to store Dashboard states snapshots of different content types in base64 format. BlobEntityInfo represents an object that contains base info about the blob entity(name, type, contentType, etc.). See the 'Model' tab of the Response Class for more details.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/blobEntities"}, params={"blobEntityIds"})
    public List<BlobEntityInfo> getBlobEntitiesByIds(@Parameter(description="A list of blob entity ids, separated by comma ','", array=@ArraySchema(schema=@Schema(type="string")), required=true) @RequestParam(value="blobEntityIds") String[] strBlobEntityIds) throws ThingsboardException, ExecutionException, InterruptedException {
        this.checkArrayParameter("blobEntityIds", strBlobEntityIds);
        if (!this.accessControlService.hasPermission(this.getCurrentUser(), Resource.BLOB_ENTITY, Operation.READ)) {
            return Collections.emptyList();
        }
        SecurityUser user = this.getCurrentUser();
        TenantId tenantId = user.getTenantId();
        ArrayList<BlobEntityId> blobEntityIds = new ArrayList<BlobEntityId>();
        for (String strBlobEntityId : strBlobEntityIds) {
            blobEntityIds.add(new BlobEntityId(this.toUUID(strBlobEntityId)));
        }
        List blobEntities = (List)this.checkNotNull((Object)((List)this.blobEntityService.findBlobEntityInfoByIdsAsync(tenantId, blobEntityIds).get()));
        return this.filterBlobEntitiesByReadPermission(blobEntities);
    }

    private List<BlobEntityInfo> filterBlobEntitiesByReadPermission(List<BlobEntityInfo> blobEntities) {
        return blobEntities.stream().filter(blobEntity -> {
            try {
                return this.accessControlService.hasPermission(this.getCurrentUser(), Resource.BLOB_ENTITY, Operation.READ, (EntityId)blobEntity.getId(), (TenantEntity)blobEntity);
            }
            catch (ThingsboardException e) {
                return false;
            }
        }).toList();
    }

    @ConstructorProperties(value={"tbBlobService"})
    @Generated
    public BlobEntityController(TbBlobService tbBlobService) {
        this.tbBlobService = tbBlobService;
    }
}

