/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.audit.AuditLog;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.TimePageLink;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.queue.util.TbCoreComponent;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class AuditLogController
extends BaseController {
    private static final String RBAC_AUDIT_LOG_CHECK = " Security check is performed to verify that the user has 'READ' permission for the audit logs.";
    private static final String AUDIT_LOG_QUERY_START_TIME_DESCRIPTION = "The start timestamp in milliseconds of the search time range over the AuditLog class field: 'createdTime'.";
    private static final String AUDIT_LOG_QUERY_END_TIME_DESCRIPTION = "The end timestamp in milliseconds of the search time range over the AuditLog class field: 'createdTime'.";
    private static final String AUDIT_LOG_QUERY_ACTION_TYPES_DESCRIPTION = "A String value representing comma-separated list of action types. This parameter is optional, but it can be used to filter results to fetch only audit logs of specific action types. For example, 'LOGIN', 'LOGOUT'. See the 'Model' tab of the Response Class for more details.";
    private static final String AUDIT_LOG_SORT_PROPERTY_DESCRIPTION = "Property of audit log to sort by. See the 'Model' tab of the Response Class for more details. Note: entityType sort property is not defined in the AuditLog class, however, it can be used to sort audit logs by types of entities that were logged.";

    @ApiOperation(value="Get audit logs by customer id (getAuditLogsByCustomerId)", notes="Returns a page of audit logs related to the targeted customer entities (devices, assets, etc.), and users actions (login, logout, etc.) that belong to this customer. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the audit logs.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/audit/logs/customer/{customerId}"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<AuditLog> getAuditLogsByCustomerId(@Parameter(description="A string value representing the customer id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="customerId") String strCustomerId, @Parameter(description="Maximum amount of entities in a one page") @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0") @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on one of the next properties: entityType, entityName, userName, actionType, actionStatus.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of audit log to sort by. See the 'Model' tab of the Response Class for more details. Note: entityType sort property is not defined in the AuditLog class, however, it can be used to sort audit logs by types of entities that were logged.", schema=@Schema(allowableValues={"createdTime", "entityType", "entityName", "userName", "actionType", "actionStatus"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder, @Parameter(description="The start timestamp in milliseconds of the search time range over the AuditLog class field: 'createdTime'.") @RequestParam(required=false) Long startTime, @Parameter(description="The end timestamp in milliseconds of the search time range over the AuditLog class field: 'createdTime'.") @RequestParam(required=false) Long endTime, @Parameter(description="A String value representing comma-separated list of action types. This parameter is optional, but it can be used to filter results to fetch only audit logs of specific action types. For example, 'LOGIN', 'LOGOUT'. See the 'Model' tab of the Response Class for more details.") @RequestParam(name="actionTypes", required=false) String actionTypesStr) throws ThingsboardException {
        AuditLogController.checkParameter((String)"CustomerId", (String)strCustomerId);
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.AUDIT_LOG, Operation.READ);
        CustomerId customerId = new CustomerId(this.toUUID(strCustomerId));
        this.checkCustomerId(customerId, Operation.READ);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        TimePageLink pageLink = this.createTimePageLink(pageSize, page, textSearch, sortProperty, sortOrder, this.getStartTime(startTime), this.getEndTime(endTime));
        List actionTypes = this.parseActionTypesStr(actionTypesStr);
        return (PageData)this.checkNotNull((Object)this.auditLogService.findAuditLogsByTenantIdAndCustomerId(tenantId, new CustomerId(UUID.fromString(strCustomerId)), actionTypes, pageLink));
    }

    @ApiOperation(value="Get audit logs by user id (getAuditLogsByUserId)", notes="Returns a page of audit logs related to the actions of targeted user. For example, RPC call to a particular device, or alarm acknowledgment for a specific device, etc. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the audit logs.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/audit/logs/user/{userId}"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<AuditLog> getAuditLogsByUserId(@Parameter(description="A string value representing the user id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="userId") String strUserId, @Parameter(description="Maximum amount of entities in a one page") @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0") @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on one of the next properties: entityType, entityName, userName, actionType, actionStatus.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of audit log to sort by. See the 'Model' tab of the Response Class for more details. Note: entityType sort property is not defined in the AuditLog class, however, it can be used to sort audit logs by types of entities that were logged.", schema=@Schema(allowableValues={"createdTime", "entityType", "entityName", "userName", "actionType", "actionStatus"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder, @Parameter(description="The start timestamp in milliseconds of the search time range over the AuditLog class field: 'createdTime'.") @RequestParam(required=false) Long startTime, @Parameter(description="The end timestamp in milliseconds of the search time range over the AuditLog class field: 'createdTime'.") @RequestParam(required=false) Long endTime, @Parameter(description="A String value representing comma-separated list of action types. This parameter is optional, but it can be used to filter results to fetch only audit logs of specific action types. For example, 'LOGIN', 'LOGOUT'. See the 'Model' tab of the Response Class for more details.") @RequestParam(name="actionTypes", required=false) String actionTypesStr) throws ThingsboardException {
        AuditLogController.checkParameter((String)"UserId", (String)strUserId);
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.AUDIT_LOG, Operation.READ);
        UserId userId = new UserId(this.toUUID(strUserId));
        this.checkUserId(userId, Operation.READ);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        TimePageLink pageLink = this.createTimePageLink(pageSize, page, textSearch, sortProperty, sortOrder, this.getStartTime(startTime), this.getEndTime(endTime));
        List actionTypes = this.parseActionTypesStr(actionTypesStr);
        return (PageData)this.checkNotNull((Object)this.auditLogService.findAuditLogsByTenantIdAndUserId(tenantId, new UserId(UUID.fromString(strUserId)), actionTypes, pageLink));
    }

    @ApiOperation(value="Get audit logs by entity id (getAuditLogsByEntityId)", notes="Returns a page of audit logs related to the actions on the targeted entity. Basically, this API call is used to get the full lifecycle of some specific entity. For example to see when a device was created, updated, assigned to some customer, or even deleted from the system. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the audit logs.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/audit/logs/entity/{entityType}/{entityId}"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<AuditLog> getAuditLogsByEntityId(@Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true, schema=@Schema(defaultValue="DEVICE")) @PathVariable(value="entityType") String strEntityType, @Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityId") String strEntityId, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on one of the next properties: entityType, entityName, userName, actionType, actionStatus.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of audit log to sort by. See the 'Model' tab of the Response Class for more details. Note: entityType sort property is not defined in the AuditLog class, however, it can be used to sort audit logs by types of entities that were logged.", schema=@Schema(allowableValues={"createdTime", "entityType", "entityName", "userName", "actionType", "actionStatus"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder, @Parameter(description="The start timestamp in milliseconds of the search time range over the AuditLog class field: 'createdTime'.") @RequestParam(required=false) Long startTime, @Parameter(description="The end timestamp in milliseconds of the search time range over the AuditLog class field: 'createdTime'.") @RequestParam(required=false) Long endTime, @Parameter(description="A String value representing comma-separated list of action types. This parameter is optional, but it can be used to filter results to fetch only audit logs of specific action types. For example, 'LOGIN', 'LOGOUT'. See the 'Model' tab of the Response Class for more details.") @RequestParam(name="actionTypes", required=false) String actionTypesStr) throws ThingsboardException {
        AuditLogController.checkParameter((String)"EntityId", (String)strEntityId);
        AuditLogController.checkParameter((String)"EntityType", (String)strEntityType);
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.AUDIT_LOG, Operation.READ);
        EntityId entityId = EntityIdFactory.getByTypeAndId((String)strEntityType, (String)strEntityId);
        this.checkEntityId(entityId, Operation.READ);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        TimePageLink pageLink = this.createTimePageLink(pageSize, page, textSearch, sortProperty, sortOrder, this.getStartTime(startTime), this.getEndTime(endTime));
        List actionTypes = this.parseActionTypesStr(actionTypesStr);
        return (PageData)this.checkNotNull((Object)this.auditLogService.findAuditLogsByTenantIdAndEntityId(tenantId, EntityIdFactory.getByTypeAndId((String)strEntityType, (String)strEntityId), actionTypes, pageLink));
    }

    @ApiOperation(value="Get all audit logs (getAuditLogs)", notes="Returns a page of audit logs related to all entities in the scope of the current user's Tenant. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the audit logs.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/audit/logs"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<AuditLog> getAuditLogs(@Parameter(description="Maximum amount of entities in a one page") @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0") @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on one of the next properties: entityType, entityName, userName, actionType, actionStatus.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of audit log to sort by. See the 'Model' tab of the Response Class for more details. Note: entityType sort property is not defined in the AuditLog class, however, it can be used to sort audit logs by types of entities that were logged.", schema=@Schema(allowableValues={"createdTime", "entityType", "entityName", "userName", "actionType", "actionStatus"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder, @Parameter(description="The start timestamp in milliseconds of the search time range over the AuditLog class field: 'createdTime'.") @RequestParam(required=false) Long startTime, @Parameter(description="The end timestamp in milliseconds of the search time range over the AuditLog class field: 'createdTime'.") @RequestParam(required=false) Long endTime, @Parameter(description="A String value representing comma-separated list of action types. This parameter is optional, but it can be used to filter results to fetch only audit logs of specific action types. For example, 'LOGIN', 'LOGOUT'. See the 'Model' tab of the Response Class for more details.") @RequestParam(name="actionTypes", required=false) String actionTypesStr) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.AUDIT_LOG, Operation.READ);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        TimePageLink pageLink = this.createTimePageLink(pageSize, page, textSearch, sortProperty, sortOrder, this.getStartTime(startTime), this.getEndTime(endTime));
        List actionTypes = this.parseActionTypesStr(actionTypesStr);
        Authority authority = this.getCurrentUser().getAuthority();
        if (Authority.TENANT_ADMIN.equals((Object)authority)) {
            return (PageData)this.checkNotNull((Object)this.auditLogService.findAuditLogsByTenantId(tenantId, actionTypes, pageLink));
        }
        return (PageData)this.checkNotNull((Object)this.auditLogService.findAuditLogsByTenantIdAndCustomerId(tenantId, this.getCurrentUser().getCustomerId(), actionTypes, pageLink));
    }

    private List<ActionType> parseActionTypesStr(String actionTypesStr) {
        List result = null;
        if (StringUtils.isNoneBlank((String[])new String[]{actionTypesStr})) {
            String[] tmp = actionTypesStr.split(",");
            result = Arrays.stream(tmp).map(at -> ActionType.valueOf((String)at.toUpperCase())).collect(Collectors.toList());
        }
        return result;
    }

    private Long getStartTime(Long startTime) {
        if (startTime == null) {
            return 1L;
        }
        return startTime;
    }

    private Long getEndTime(Long endTime) {
        if (endTime == null) {
            return System.currentTimeMillis();
        }
        return endTime;
    }
}

