/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.ApiKeyId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.pat.ApiKey;
import org.thingsboard.server.common.data.pat.ApiKeyInfo;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.dao.pat.ApiKeyService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.security.model.SecurityUser;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class ApiKeyController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiKeyController.class);
    private final ApiKeyService apiKeyService;

    @ApiOperation(value="Save API key for user (saveApiKey)", notes="Creates an API key for the given user and returns the token ONCE as 'ApiKey <value>'.\n\nAvailable for any authorized user. ")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN','TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/apiKey"})
    public ApiKey saveApiKey(@Parameter(description="A JSON value representing the API key.") @RequestBody @Valid ApiKeyInfo apiKeyInfo) throws ThingsboardException {
        User user = this.checkUserId(apiKeyInfo.getUserId(), Operation.WRITE);
        apiKeyInfo.setTenantId(user.getTenantId());
        this.checkEntity((EntityId)apiKeyInfo.getId(), (TenantEntity)apiKeyInfo, Resource.API_KEY);
        if (apiKeyInfo.getId() == null && apiKeyInfo.isInternal()) {
            throw new ThingsboardException("Internal API key cannot be created!", ThingsboardErrorCode.PERMISSION_DENIED);
        }
        return (ApiKey)this.checkNotNull((Object)this.apiKeyService.saveApiKey(apiKeyInfo.getTenantId(), apiKeyInfo));
    }

    @ApiOperation(value="Rotate internal API key (rotateInternalApiKey)", notes="Regenerates the value of an internal API key.\n\nAvailable for users with 'SYS_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('SYS_ADMIN')")
    @PostMapping(value={"/apiKey/{id}/rotate"})
    @Hidden
    public ApiKey rotateInternalApiKey(@Parameter(description="A string value representing the api key id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable UUID id) throws ThingsboardException {
        ApiKeyId apiKeyId = new ApiKeyId(id);
        ApiKey apiKey = this.checkApiKeyId(apiKeyId, Operation.WRITE);
        this.checkUserId(apiKey.getUserId(), Operation.WRITE);
        return (ApiKey)this.checkNotNull((Object)this.apiKeyService.rotateInternalApiKey(TenantId.SYS_TENANT_ID, (ApiKeyInfo)apiKey));
    }

    @ApiOperation(value="Get User Api Keys (getUserApiKeys)", notes="Returns a page of api keys owned by user. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for any authorized user. ")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN','TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/apiKeys/{userId}"})
    public PageData<ApiKeyInfo> getUserApiKeys(@Parameter(description="A string value representing the user id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="userId") String userIdStr, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the description.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "expirationTime", "description", "enabled"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        SecurityUser securityUser = this.getCurrentUser();
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        UserId userId = new UserId(this.toUUID(userIdStr));
        this.accessControlService.checkPermission(securityUser, Resource.API_KEY, Operation.READ);
        User user = this.checkUserId(userId, Operation.READ);
        return this.apiKeyService.findApiKeysByUserId(user.getTenantId(), userId, pageLink);
    }

    @ApiOperation(value="Update API key Description", notes="Updates the description of the existing API key by apiKeyId. Only the description can be updated. Referencing a non-existing ApiKey Id will cause a 'Not Found' error.\n\nAvailable for any authorized user. ")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN','TENANT_ADMIN', 'CUSTOMER_USER')")
    @PutMapping(value={"/apiKey/{id}/description"})
    public ApiKeyInfo updateApiKeyDescription(@Parameter(description="A string value representing the api key id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable UUID id, @Parameter(description="New description for the API key", example="Description") @RequestBody Optional<String> description) throws Exception {
        ApiKeyId apiKeyId = new ApiKeyId(id);
        ApiKey apiKey = this.checkApiKeyId(apiKeyId, Operation.WRITE);
        this.checkUserId(apiKey.getUserId(), Operation.WRITE);
        apiKey.setDescription((String)description.orElse(null));
        return this.apiKeyService.saveApiKey(apiKey.getTenantId(), (ApiKeyInfo)apiKey);
    }

    @ApiOperation(value="Enable or disable API key (enableApiKey)", notes="Updates api key with enabled = true/false. \n\nAvailable for any authorized user. ")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN','TENANT_ADMIN', 'CUSTOMER_USER')")
    @PutMapping(value={"/apiKey/{id}/enabled/{enabledValue}"})
    public ApiKeyInfo enableApiKey(@Parameter(description="Unique identifier of the API key to enable/disable", required=true) @PathVariable UUID id, @Parameter(description="Enabled or disabled api key", required=true) @PathVariable(value="enabledValue") Boolean enabledValue) throws ThingsboardException {
        ApiKeyId apiKeyId = new ApiKeyId(id);
        ApiKey apiKey = this.checkApiKeyId(apiKeyId, Operation.WRITE);
        this.checkUserId(apiKey.getUserId(), Operation.WRITE);
        apiKey.setEnabled(enabledValue.booleanValue());
        return this.apiKeyService.saveApiKey(apiKey.getTenantId(), (ApiKeyInfo)apiKey);
    }

    @ApiOperation(value="Delete API key by ID (deleteApiKey)", notes="Deletes the API key. Referencing non-existing ApiKey Id will cause an error.\n\nAvailable for any authorized user. ")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN','TENANT_ADMIN', 'CUSTOMER_USER')")
    @DeleteMapping(value={"/apiKey/{id}"})
    public void deleteApiKey(@PathVariable UUID id) throws ThingsboardException {
        ApiKeyId apiKeyId = new ApiKeyId(id);
        ApiKey apiKey = this.checkApiKeyId(apiKeyId, Operation.DELETE);
        this.checkUserId(apiKey.getUserId(), Operation.WRITE);
        this.apiKeyService.deleteApiKey(apiKey.getTenantId(), apiKey, false);
    }

    @ConstructorProperties(value={"apiKeyService"})
    @Generated
    public ApiKeyController(ApiKeyService apiKeyService) {
        this.apiKeyService = apiKeyService;
    }
}

