/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.actors.service;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.actors.AbstractTbActor;
import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.actors.ProcessFailureStrategy;
import org.thingsboard.server.common.msg.TbActorMsg;

public abstract class ContextAwareActor
extends AbstractTbActor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContextAwareActor.class);
    public static final int ENTITY_PACK_LIMIT = 1024;
    protected final ActorSystemContext systemContext;

    public ContextAwareActor(ActorSystemContext systemContext) {
        this.systemContext = systemContext;
    }

    public boolean process(TbActorMsg msg) {
        if (log.isDebugEnabled()) {
            log.debug("Processing msg: {}", (Object)msg);
        }
        if (!this.doProcess(msg)) {
            log.warn("Unprocessed message: {}!", (Object)msg);
        }
        return false;
    }

    protected abstract boolean doProcess(TbActorMsg var1);

    public ProcessFailureStrategy onProcessFailure(TbActorMsg msg, Throwable t) {
        log.debug("[{}] Processing failure for msg {}", new Object[]{this.getActorRef().getActorId(), msg, t});
        return this.doProcessFailure(t);
    }

    protected ProcessFailureStrategy doProcessFailure(Throwable t) {
        if (t instanceof Error) {
            return ProcessFailureStrategy.stop();
        }
        return ProcessFailureStrategy.resume();
    }
}

