/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.actors.ruleChain;

import java.io.Serializable;
import java.util.Set;
import lombok.Generated;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.RuleNodeId;
import org.thingsboard.server.common.msg.MsgType;
import org.thingsboard.server.common.msg.TbActorStopReason;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbRuleEngineActorMsg;
import org.thingsboard.server.common.msg.queue.RuleEngineException;

public class RuleNodeToRuleChainTellNextMsg
extends TbRuleEngineActorMsg
implements Serializable {
    private static final long serialVersionUID = 4577026446412871820L;
    private final RuleChainId ruleChainId;
    private final RuleNodeId originator;
    private final Set<String> relationTypes;
    private final String failureMessage;

    public RuleNodeToRuleChainTellNextMsg(RuleChainId ruleChainId, RuleNodeId originator, Set<String> relationTypes, TbMsg tbMsg, String failureMessage) {
        super(tbMsg);
        this.ruleChainId = ruleChainId;
        this.originator = originator;
        this.relationTypes = relationTypes;
        this.failureMessage = failureMessage;
    }

    public void onTbActorStopped(TbActorStopReason reason) {
        String message = reason == TbActorStopReason.STOPPED ? String.format("Rule chain [%s] stopped", this.ruleChainId.getId()) : String.format("Failed to initialize rule chain [%s]!", this.ruleChainId.getId());
        this.msg.getCallback().onFailure(new RuleEngineException(message));
    }

    public MsgType getMsgType() {
        return MsgType.RULE_TO_RULE_CHAIN_TELL_NEXT_MSG;
    }

    @Generated
    public RuleChainId getRuleChainId() {
        return this.ruleChainId;
    }

    @Generated
    public RuleNodeId getOriginator() {
        return this.originator;
    }

    @Generated
    public Set<String> getRelationTypes() {
        return this.relationTypes;
    }

    @Generated
    public String getFailureMessage() {
        return this.failureMessage;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuleNodeToRuleChainTellNextMsg)) {
            return false;
        }
        RuleNodeToRuleChainTellNextMsg other = (RuleNodeToRuleChainTellNextMsg)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RuleChainId this$ruleChainId = this.getRuleChainId();
        RuleChainId other$ruleChainId = other.getRuleChainId();
        if (this$ruleChainId == null ? other$ruleChainId != null : !this$ruleChainId.equals(other$ruleChainId)) {
            return false;
        }
        RuleNodeId this$originator = this.getOriginator();
        RuleNodeId other$originator = other.getOriginator();
        if (this$originator == null ? other$originator != null : !this$originator.equals(other$originator)) {
            return false;
        }
        Set this$relationTypes = this.getRelationTypes();
        Set other$relationTypes = other.getRelationTypes();
        if (this$relationTypes == null ? other$relationTypes != null : !((Object)this$relationTypes).equals(other$relationTypes)) {
            return false;
        }
        String this$failureMessage = this.getFailureMessage();
        String other$failureMessage = other.getFailureMessage();
        return !(this$failureMessage == null ? other$failureMessage != null : !this$failureMessage.equals(other$failureMessage));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RuleNodeToRuleChainTellNextMsg;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        RuleChainId $ruleChainId = this.getRuleChainId();
        result = result * 59 + ($ruleChainId == null ? 43 : $ruleChainId.hashCode());
        RuleNodeId $originator = this.getOriginator();
        result = result * 59 + ($originator == null ? 43 : $originator.hashCode());
        Set $relationTypes = this.getRelationTypes();
        result = result * 59 + ($relationTypes == null ? 43 : ((Object)$relationTypes).hashCode());
        String $failureMessage = this.getFailureMessage();
        result = result * 59 + ($failureMessage == null ? 43 : $failureMessage.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RuleNodeToRuleChainTellNextMsg(ruleChainId=" + String.valueOf(this.getRuleChainId()) + ", originator=" + String.valueOf(this.getOriginator()) + ", relationTypes=" + String.valueOf(this.getRelationTypes()) + ", failureMessage=" + this.getFailureMessage() + ")";
    }
}

