/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.actors.ruleChain;

import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.actors.TbActorId;
import org.thingsboard.server.actors.TbActorRef;
import org.thingsboard.server.actors.TbEntityActorId;
import org.thingsboard.server.actors.TbEntityTypeActorIdPredicate;
import org.thingsboard.server.actors.ruleChain.RuleChainActor;
import org.thingsboard.server.actors.service.ContextAwareActor;
import org.thingsboard.server.actors.shared.RuleChainErrorActor;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageDataIterable;
import org.thingsboard.server.common.data.rule.RuleChain;
import org.thingsboard.server.common.data.rule.RuleChainType;
import org.thingsboard.server.common.msg.TbActorMsg;
import org.thingsboard.server.common.msg.queue.RuleEngineException;
import org.thingsboard.server.dao.rule.RuleChainService;

public abstract class RuleChainManagerActor
extends ContextAwareActor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleChainManagerActor.class);
    protected final TenantId tenantId;
    private final RuleChainService ruleChainService;
    protected RuleChain rootChain;
    protected TbActorRef rootChainActor;
    protected boolean ruleChainsInitialized;

    public RuleChainManagerActor(ActorSystemContext systemContext, TenantId tenantId) {
        super(systemContext);
        this.tenantId = tenantId;
        this.ruleChainService = systemContext.getRuleChainService();
    }

    protected void initRuleChains() {
        log.debug("[{}] Initializing rule chains", (Object)this.tenantId);
        for (RuleChain ruleChain : new PageDataIterable(link -> this.ruleChainService.findTenantRuleChainsByType(this.tenantId, RuleChainType.CORE, link), 1024)) {
            RuleChainId ruleChainId = ruleChain.getId();
            log.debug("[{}|{}] Creating rule chain actor", (Object)ruleChainId.getEntityType(), (Object)ruleChain.getId());
            TbActorRef actorRef = this.getOrCreateActor(ruleChainId, id -> ruleChain);
            this.visit(ruleChain, actorRef);
            log.debug("[{}|{}] Rule Chain actor created.", (Object)ruleChainId.getEntityType(), (Object)ruleChainId.getId());
        }
        this.ruleChainsInitialized = true;
    }

    protected void destroyRuleChains() {
        log.debug("[{}] Destroying rule chains", (Object)this.tenantId);
        for (RuleChain ruleChain : new PageDataIterable(link -> this.ruleChainService.findTenantRuleChainsByType(this.tenantId, RuleChainType.CORE, link), 1024)) {
            this.ctx.stop((TbActorId)new TbEntityActorId((EntityId)ruleChain.getId()));
        }
        this.ruleChainsInitialized = false;
    }

    protected void visit(RuleChain entity, TbActorRef actorRef) {
        if (entity != null && entity.isRoot() && entity.getType().equals((Object)RuleChainType.CORE)) {
            this.rootChain = entity;
            this.rootChainActor = actorRef;
        }
    }

    protected TbActorRef getOrCreateActor(RuleChainId ruleChainId) {
        return this.getOrCreateActor(ruleChainId, eId -> this.ruleChainService.findRuleChainById(TenantId.SYS_TENANT_ID, eId));
    }

    protected TbActorRef getOrCreateActor(RuleChainId ruleChainId, Function<RuleChainId, RuleChain> provider) {
        return this.ctx.getOrCreateChildActor((TbActorId)new TbEntityActorId((EntityId)ruleChainId), () -> "rule-dispatcher", () -> {
            RuleChain ruleChain = (RuleChain)provider.apply(ruleChainId);
            if (ruleChain == null) {
                return new RuleChainErrorActor.ActorCreator(this.systemContext, this.tenantId, ruleChainId, new RuleEngineException("Rule Chain with id: " + String.valueOf(ruleChainId) + " not found!"));
            }
            return new RuleChainActor.ActorCreator(this.systemContext, this.tenantId, ruleChain);
        }, () -> true);
    }

    protected TbActorRef getEntityActorRef(EntityId entityId) {
        TbActorRef target = null;
        if (entityId.getEntityType() == EntityType.RULE_CHAIN) {
            target = this.getOrCreateActor((RuleChainId)entityId);
        }
        return target;
    }

    protected void broadcast(TbActorMsg msg) {
        this.ctx.broadcastToChildren(msg, (Predicate)new TbEntityTypeActorIdPredicate(EntityType.RULE_CHAIN));
    }

    @Generated
    public RuleChain getRootChain() {
        return this.rootChain;
    }

    @Generated
    public TbActorRef getRootChainActor() {
        return this.rootChainActor;
    }
}

