/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.actors.calculatedField;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.function.TriConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.actors.TbActorCtx;
import org.thingsboard.server.actors.TbActorId;
import org.thingsboard.server.actors.TbActorRef;
import org.thingsboard.server.actors.TbCalculatedFieldEntityActorId;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldAlarmActionMsg;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldArgumentResetMsg;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldEntityActionEventMsg;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldEntityActorCreator;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldEntityDeleteMsg;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldException;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldLinkedTelemetryMsg;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldManagerMessageProcessor;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldReevaluateMsg;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldRelationActionMsg;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldStateRestoreMsg;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldTelemetryMsg;
import org.thingsboard.server.actors.calculatedField.EntityCalculatedFieldLinkedTelemetryMsg;
import org.thingsboard.server.actors.calculatedField.EntityCalculatedFieldTelemetryMsg;
import org.thingsboard.server.actors.calculatedField.EntityInitCalculatedFieldMsg;
import org.thingsboard.server.actors.calculatedField.MultipleTbCallback;
import org.thingsboard.server.actors.shared.AbstractContextAwareMsgProcessor;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ProfileEntityIdInfo;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.asset.AssetProfile;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.cf.CalculatedField;
import org.thingsboard.server.common.data.cf.CalculatedFieldEventType;
import org.thingsboard.server.common.data.cf.CalculatedFieldLink;
import org.thingsboard.server.common.data.cf.CalculatedFieldType;
import org.thingsboard.server.common.data.cf.configuration.CalculatedFieldConfiguration;
import org.thingsboard.server.common.data.cf.configuration.HasRelationPathLevel;
import org.thingsboard.server.common.data.cf.configuration.aggregation.RelatedEntitiesAggregationCalculatedFieldConfiguration;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.CalculatedFieldId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageDataIterable;
import org.thingsboard.server.common.data.plugin.ComponentLifecycleEvent;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.relation.EntityRelationPathQuery;
import org.thingsboard.server.common.data.relation.EntitySearchDirection;
import org.thingsboard.server.common.data.relation.RelationPathLevel;
import org.thingsboard.server.common.data.tenant.profile.DefaultTenantProfileConfiguration;
import org.thingsboard.server.common.msg.CalculatedFieldStatePartitionRestoreMsg;
import org.thingsboard.server.common.msg.TbActorMsg;
import org.thingsboard.server.common.msg.cf.CalculatedFieldCacheInitMsg;
import org.thingsboard.server.common.msg.cf.CalculatedFieldEntityLifecycleMsg;
import org.thingsboard.server.common.msg.cf.CalculatedFieldPartitionChangeMsg;
import org.thingsboard.server.common.msg.plugin.ComponentLifecycleMsg;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TbCallback;
import org.thingsboard.server.dao.asset.AssetService;
import org.thingsboard.server.dao.cf.CalculatedFieldService;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.dao.relation.RelationService;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.settings.TbQueueCalculatedFieldSettings;
import org.thingsboard.server.service.cf.CalculatedFieldProcessingService;
import org.thingsboard.server.service.cf.CalculatedFieldStateService;
import org.thingsboard.server.service.cf.cache.TenantEntityProfileCache;
import org.thingsboard.server.service.cf.ctx.CalculatedFieldEntityCtxId;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldCtx;
import org.thingsboard.server.service.profile.TbAssetProfileCache;
import org.thingsboard.server.service.profile.TbDeviceProfileCache;
import org.thingsboard.server.service.security.permission.OwnersCacheService;
import org.thingsboard.server.utils.CalculatedFieldUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CalculatedFieldManagerMessageProcessor
extends AbstractContextAwareMsgProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CalculatedFieldManagerMessageProcessor.class);
    private final Map<CalculatedFieldId, CalculatedFieldCtx> calculatedFields = new HashMap();
    private final Map<EntityId, List<CalculatedFieldCtx>> entityIdCalculatedFields = new HashMap();
    private final Map<EntityId, List<CalculatedFieldLink>> entityIdCalculatedFieldLinks = new HashMap();
    private final Map<EntityId, Set<EntityId>> ownerEntities = new HashMap();
    private ScheduledFuture<?> cfsReevaluationTask;
    private final CalculatedFieldProcessingService cfExecService;
    private final CalculatedFieldStateService cfStateService;
    private final CalculatedFieldService cfDaoService;
    private final DeviceService deviceService;
    private final AssetService assetService;
    private final CustomerService customerService;
    private final RelationService relationService;
    private final TbAssetProfileCache assetProfileCache;
    private final TbDeviceProfileCache deviceProfileCache;
    private final TenantEntityProfileCache entityProfileCache;
    private final OwnersCacheService ownersCacheService;
    private final TbQueueCalculatedFieldSettings cfSettings;
    protected final TenantId tenantId;
    private long cfCheckInterval;
    protected TbActorCtx ctx;

    CalculatedFieldManagerMessageProcessor(ActorSystemContext systemContext, TenantId tenantId) {
        super(systemContext);
        this.cfExecService = systemContext.getCalculatedFieldProcessingService();
        this.cfStateService = systemContext.getCalculatedFieldStateService();
        this.cfDaoService = systemContext.getCalculatedFieldService();
        this.deviceService = systemContext.getDeviceService();
        this.assetService = systemContext.getAssetService();
        this.customerService = systemContext.getCustomerService();
        this.relationService = systemContext.getRelationService();
        this.assetProfileCache = systemContext.getAssetProfileCache();
        this.deviceProfileCache = systemContext.getDeviceProfileCache();
        this.entityProfileCache = new TenantEntityProfileCache();
        this.ownersCacheService = systemContext.getOwnersCacheService();
        this.cfSettings = systemContext.getCalculatedFieldSettings();
        this.tenantId = tenantId;
    }

    void init(TbActorCtx ctx) {
        this.ctx = ctx;
    }

    public void stop() {
        log.info("[{}] Stopping CF manager actor.", (Object)this.tenantId);
        this.calculatedFields.values().forEach(CalculatedFieldCtx::close);
        this.calculatedFields.clear();
        this.entityIdCalculatedFields.clear();
        this.entityIdCalculatedFieldLinks.clear();
        this.cancelReevaluationTask();
        this.ctx.stop(this.ctx.getSelf());
    }

    public void onCacheInitMsg(CalculatedFieldCacheInitMsg msg) {
        log.debug("[{}] Processing CF actor init message.", (Object)msg.getTenantId().getId());
        this.initEntitiesCache();
        this.initCalculatedFields();
        this.cfCheckInterval = this.systemContext.getApiLimitService().getLimit(this.tenantId, DefaultTenantProfileConfiguration::getCfReevaluationCheckInterval);
        this.scheduleCfsReevaluation();
        msg.getCallback().onSuccess();
    }

    public void onStateRestoreMsg(CalculatedFieldStateRestoreMsg msg) {
        CalculatedFieldId cfId = msg.getId().cfId();
        CalculatedFieldCtx ctx = (CalculatedFieldCtx)this.calculatedFields.get(cfId);
        if (ctx != null) {
            msg.setCtx(ctx);
            log.debug("[{}] Pushing CF state restore msg to specific actor [{}]", (Object)this.tenantId, (Object)msg.getId().entityId());
            this.getOrCreateActor(msg.getId().entityId()).tellWithHighPriority((TbActorMsg)msg);
        } else if (msg.getState() != null) {
            log.debug("[{}] Received CF state restore msg for non-existing CF [{}]. Removing state", (Object)this.tenantId, (Object)cfId);
            this.cfStateService.deleteState(msg.getId(), msg.getCallback());
        } else {
            msg.getCallback().onSuccess();
        }
    }

    public void onStatePartitionRestoreMsg(CalculatedFieldStatePartitionRestoreMsg msg) {
        this.ctx.broadcastToChildren((TbActorMsg)msg, true);
    }

    private void scheduleCfsReevaluation() {
        this.cfsReevaluationTask = this.systemContext.getScheduler().scheduleWithFixedDelay(() -> {
            try {
                this.calculatedFields.values().forEach(cf -> {
                    if (cf.requiresScheduledReevaluation()) {
                        this.applyToTargetCfEntityActors(cf, TbCallback.EMPTY, (entityId, callback) -> {
                            log.debug("[{}][{}] Pushing scheduled CF reevaluate msg", entityId, (Object)cf.getCfId());
                            this.getOrCreateActor(entityId).tell((TbActorMsg)new CalculatedFieldReevaluateMsg(this.tenantId, cf));
                        });
                    }
                });
            }
            catch (Exception e) {
                log.warn("[{}] Failed to trigger CFs reevaluation", (Object)this.tenantId, (Object)e);
            }
        }, this.cfCheckInterval, this.cfCheckInterval, TimeUnit.SECONDS);
    }

    public void onEntityLifecycleMsg(CalculatedFieldEntityLifecycleMsg msg) throws CalculatedFieldException {
        ComponentLifecycleEvent event = msg.getData().getEvent();
        if (ComponentLifecycleEvent.RELATION_UPDATED.equals((Object)event) || ComponentLifecycleEvent.RELATION_DELETED.equals((Object)event)) {
            log.debug("Processing relation [{}] event from entity: [{}]", (Object)event, (Object)msg.getData().getEntityId());
            this.onRelationChangedEvent(msg.getData(), msg.getCallback());
            return;
        }
        log.debug("Processing entity lifecycle event: [{}] for entity: [{}]", (Object)event, (Object)msg.getData().getEntityId());
        EntityType entityType = msg.getData().getEntityId().getEntityType();
        block0 : switch (3.$SwitchMap$org$thingsboard$server$common$data$EntityType[entityType.ordinal()]) {
            case 1: {
                switch (3.$SwitchMap$org$thingsboard$server$common$data$plugin$ComponentLifecycleEvent[event.ordinal()]) {
                    case 1: {
                        this.onCfCreated(msg.getData(), msg.getCallback());
                        break block0;
                    }
                    case 2: {
                        this.onCfUpdated(msg.getData(), msg.getCallback());
                        break block0;
                    }
                    case 3: {
                        this.onCfDeleted(msg.getData(), msg.getCallback());
                        break block0;
                    }
                }
                msg.getCallback().onSuccess();
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                switch (3.$SwitchMap$org$thingsboard$server$common$data$plugin$ComponentLifecycleEvent[event.ordinal()]) {
                    case 1: {
                        this.onEntityCreated(msg.getData(), msg.getCallback());
                        break block0;
                    }
                    case 2: {
                        this.onEntityUpdated(msg.getData(), msg.getCallback());
                        break block0;
                    }
                    case 3: {
                        this.onEntityDeleted(msg.getData(), msg.getCallback());
                        break block0;
                    }
                }
                msg.getCallback().onSuccess();
                break;
            }
            case 5: 
            case 6: {
                switch (3.$SwitchMap$org$thingsboard$server$common$data$plugin$ComponentLifecycleEvent[event.ordinal()]) {
                    case 3: {
                        this.onProfileDeleted(msg.getData(), msg.getCallback());
                        break block0;
                    }
                }
                msg.getCallback().onSuccess();
                break;
            }
            case 7: {
                switch (3.$SwitchMap$org$thingsboard$server$common$data$plugin$ComponentLifecycleEvent[event.ordinal()]) {
                    case 2: {
                        this.onTenantProfileUpdated(msg.getData(), msg.getCallback());
                        break block0;
                    }
                }
                msg.getCallback().onSuccess();
                break;
            }
            default: {
                msg.getCallback().onSuccess();
            }
        }
    }

    public void onEntityActionEventMsg(CalculatedFieldEntityActionEventMsg msg) {
        switch (3.$SwitchMap$org$thingsboard$server$common$data$audit$ActionType[msg.getAction().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                Alarm alarm = (Alarm)JacksonUtil.treeToValue((JsonNode)msg.getEntity(), Alarm.class);
                CalculatedFieldAlarmActionMsg alarmActionMsg = CalculatedFieldAlarmActionMsg.builder().tenantId(this.tenantId).alarm(alarm).action(msg.getAction()).callback(msg.getCallback()).build();
                this.getOrCreateActor(alarm.getOriginator()).tellWithHighPriority((TbActorMsg)alarmActionMsg);
                break;
            }
            default: {
                msg.getCallback().onSuccess();
            }
        }
    }

    private void onProfileDeleted(ComponentLifecycleMsg msg, TbCallback callback) {
        this.entityProfileCache.removeProfileId(msg.getEntityId());
        callback.onSuccess();
    }

    private void onTenantProfileUpdated(ComponentLifecycleMsg msg, TbCallback callback) {
        this.checkCfIntervalForUpdate();
        long maxRelatedEntitiesPerCfArgument = this.systemContext.getApiLimitService().getLimit(this.tenantId, DefaultTenantProfileConfiguration::getMaxRelatedEntitiesToReturnPerCfArgument);
        ArrayList cfsToReinit = new ArrayList();
        Stream.concat(this.calculatedFields.values().stream(), this.entityIdCalculatedFields.values().stream().flatMap(Collection::stream)).forEach(ctx -> {
            if (ctx.hasRelatedEntities() && ctx.getMaxRelatedEntitiesPerCfArgument() != maxRelatedEntitiesPerCfArgument) {
                cfsToReinit.add(ctx);
            }
            ctx.setTenantProfileProperties();
        });
        if (!cfsToReinit.isEmpty()) {
            MultipleTbCallback cfsReinitCallback = new MultipleTbCallback(cfsToReinit.size(), callback);
            cfsToReinit.forEach(ctx -> this.applyToTargetCfEntityActors(ctx, (TbCallback)cfsReinitCallback, (id, cb) -> this.initCfForEntity(id, ctx, EntityInitCalculatedFieldMsg.StateAction.REINIT, CalculatedFieldEventType.TENANT_PROFILE_UPDATED, cb)));
        } else {
            callback.onSuccess();
        }
    }

    private void checkCfIntervalForUpdate() {
        long updatedCfCheckInterval = this.systemContext.getApiLimitService().getLimit(this.tenantId, DefaultTenantProfileConfiguration::getCfReevaluationCheckInterval);
        if (this.cfCheckInterval != updatedCfCheckInterval) {
            this.cfCheckInterval = updatedCfCheckInterval;
            this.cancelReevaluationTask();
            this.scheduleCfsReevaluation();
        }
    }

    private void onEntityCreated(ComponentLifecycleMsg msg, TbCallback callback) {
        EntityId entityId = msg.getEntityId();
        EntityId profileId = this.getProfileId(this.tenantId, entityId);
        if (profileId != null) {
            this.entityProfileCache.add(profileId, entityId);
        }
        this.updateEntityOwner(entityId);
        if (!this.isMyPartition(entityId, callback)) {
            return;
        }
        List entityIdFields = this.getCalculatedFieldsByEntityId(entityId);
        List profileIdFields = this.getCalculatedFieldsByEntityId(profileId);
        int fieldsCount = entityIdFields.size() + profileIdFields.size();
        if (fieldsCount > 0) {
            MultipleTbCallback multiCallback = new MultipleTbCallback(fieldsCount, callback);
            entityIdFields.forEach(ctx -> this.initCfForEntity(entityId, ctx, EntityInitCalculatedFieldMsg.StateAction.INIT, CalculatedFieldEventType.INITIALIZED, (TbCallback)multiCallback));
            profileIdFields.forEach(ctx -> this.initCfForEntity(entityId, ctx, EntityInitCalculatedFieldMsg.StateAction.INIT, CalculatedFieldEventType.INITIALIZED, (TbCallback)multiCallback));
        } else {
            callback.onSuccess();
        }
    }

    private void onEntityUpdated(ComponentLifecycleMsg msg, TbCallback callback) {
        if (msg.getOldProfileId() != null && !msg.getOldProfileId().equals(msg.getProfileId())) {
            this.entityProfileCache.update(msg.getOldProfileId(), msg.getProfileId(), msg.getEntityId());
            if (!this.isMyPartition(msg.getEntityId(), callback)) {
                return;
            }
            List oldProfileCfs = this.getCalculatedFieldsByEntityId(msg.getOldProfileId());
            List newProfileCfs = this.getCalculatedFieldsByEntityId(msg.getProfileId());
            int fieldsCount = oldProfileCfs.size() + newProfileCfs.size();
            if (fieldsCount > 0) {
                MultipleTbCallback multiCallback = new MultipleTbCallback(fieldsCount, callback);
                EntityId entityId = msg.getEntityId();
                oldProfileCfs.forEach(ctx -> this.deleteCfForEntity(entityId, ctx.getCfId(), (TbCallback)multiCallback));
                newProfileCfs.forEach(ctx -> this.initCfForEntity(entityId, ctx, EntityInitCalculatedFieldMsg.StateAction.INIT, CalculatedFieldEventType.INITIALIZED, (TbCallback)multiCallback));
            } else {
                callback.onSuccess();
            }
        } else if (msg.isOwnerChanged()) {
            this.onEntityOwnerChanged(msg, callback);
        } else {
            callback.onSuccess();
        }
    }

    private void onEntityDeleted(ComponentLifecycleMsg msg, TbCallback callback) {
        switch (3.$SwitchMap$org$thingsboard$server$common$data$EntityType[msg.getEntityId().getEntityType().ordinal()]) {
            case 2: 
            case 3: {
                this.entityProfileCache.removeEntityId(msg.getEntityId());
                break;
            }
            case 4: {
                this.ownerEntities.remove(msg.getEntityId());
            }
        }
        this.ownerEntities.values().forEach(entities -> entities.remove(msg.getEntityId()));
        if (this.isMyPartition(msg.getEntityId(), callback)) {
            log.debug("Pushing entity lifecycle msg to specific actor [{}]", (Object)msg.getEntityId());
            this.getOrCreateActor(msg.getEntityId()).tell((TbActorMsg)new CalculatedFieldEntityDeleteMsg(this.tenantId, msg.getEntityId(), callback));
        }
    }

    private void onRelationChangedEvent(ComponentLifecycleMsg msg, TbCallback callback) {
        Function<EntityId, TriConsumer> relationAction;
        switch (3.$SwitchMap$org$thingsboard$server$common$data$plugin$ComponentLifecycleEvent[msg.getEvent().ordinal()]) {
            case 4: {
                Function<EntityId, TriConsumer> function = relatedId -> (entityId, ctx, cb) -> this.initRelatedEntity(entityId, relatedId, ctx, cb);
                break;
            }
            case 5: {
                Function<EntityId, TriConsumer> function = relatedId -> (entityId, ctx, cb) -> this.deleteRelatedEntity(entityId, relatedId, ctx, cb);
                break;
            }
            default: {
                Function<EntityId, TriConsumer> function = relationAction = null;
            }
        }
        if (relationAction == null) {
            callback.onSuccess();
            return;
        }
        EntityRelation entityRelation = (EntityRelation)JacksonUtil.treeToValue((JsonNode)msg.getInfo(), EntityRelation.class);
        EntityId toId = entityRelation.getTo();
        EntityId fromId = entityRelation.getFrom();
        String relationType = entityRelation.getType();
        if (!CalculatedField.isSupportedRefEntity((EntityId)toId) && !CalculatedField.isSupportedRefEntity((EntityId)fromId)) {
            callback.onSuccess();
            return;
        }
        MultipleTbCallback callbackForToAndFrom = new MultipleTbCallback(2, callback);
        this.processRelationByDirection(EntitySearchDirection.TO, relationType, toId, callbackForToAndFrom, relationAction.apply(fromId));
        this.processRelationByDirection(EntitySearchDirection.FROM, relationType, fromId, callbackForToAndFrom, relationAction.apply(toId));
    }

    private void processRelationByDirection(EntitySearchDirection direction, String relationType, EntityId mainId, MultipleTbCallback parentCallback, TriConsumer<EntityId, CalculatedFieldCtx, TbCallback> relationAction) {
        if (!this.isMyPartition(mainId, (TbCallback)parentCallback)) {
            return;
        }
        List cfsByEntityIdAndProfile = this.getCalculatedFieldsByEntityIdAndProfile(mainId);
        if (cfsByEntityIdAndProfile.isEmpty()) {
            parentCallback.onSuccess();
            return;
        }
        List<CalculatedFieldCtx> matchingCfs = cfsByEntityIdAndProfile.stream().filter(cf -> {
            CalculatedFieldConfiguration patt21253$temp = cf.getCalculatedField().getConfiguration();
            if (patt21253$temp instanceof HasRelationPathLevel) {
                HasRelationPathLevel config = (HasRelationPathLevel)patt21253$temp;
                RelationPathLevel relation = config.getRelation();
                return direction.equals((Object)relation.direction()) && relationType.equals(relation.relationType());
            }
            return false;
        }).toList();
        MultipleTbCallback directionCallback = new MultipleTbCallback(matchingCfs.size(), (TbCallback)parentCallback);
        matchingCfs.forEach(ctx -> relationAction.accept((Object)mainId, ctx, (Object)directionCallback));
    }

    private void onCfCreated(ComponentLifecycleMsg msg, TbCallback callback) throws CalculatedFieldException {
        CalculatedFieldId cfId = new CalculatedFieldId(msg.getEntityId().getId());
        if (this.calculatedFields.containsKey(cfId)) {
            log.debug("[{}] CF was already initialized [{}]", (Object)this.tenantId, (Object)cfId);
            callback.onSuccess();
        } else {
            CalculatedField cf = this.cfDaoService.findById(msg.getTenantId(), cfId);
            if (cf == null) {
                log.debug("[{}] Failed to lookup CF by id [{}]", (Object)this.tenantId, (Object)cfId);
                callback.onSuccess();
            } else {
                CalculatedFieldCtx cfCtx = this.getCfCtx(cf);
                try {
                    cfCtx.init();
                }
                catch (Exception e) {
                    throw CalculatedFieldException.builder().ctx(cfCtx).eventEntity(cf.getEntityId()).cause(e).errorMessage("Failed to initialize CF context").build();
                }
                this.calculatedFields.put(cf.getId(), cfCtx);
                this.entityIdCalculatedFields.computeIfAbsent(cf.getEntityId(), id -> new CopyOnWriteArrayList()).add(cfCtx);
                this.addLinks(cf);
                this.applyToTargetCfEntityActors(cfCtx, callback, (id, cb) -> this.initCfForEntity(id, cfCtx, EntityInitCalculatedFieldMsg.StateAction.INIT, CalculatedFieldEventType.INITIALIZED, cb));
            }
        }
    }

    private CalculatedFieldCtx getCfCtx(CalculatedField cf) {
        return new CalculatedFieldCtx(cf, this.systemContext);
    }

    private void onCfUpdated(ComponentLifecycleMsg msg, TbCallback callback) throws CalculatedFieldException {
        CalculatedFieldId cfId = new CalculatedFieldId(msg.getEntityId().getId());
        CalculatedFieldCtx oldCfCtx = (CalculatedFieldCtx)this.calculatedFields.get(cfId);
        if (oldCfCtx == null) {
            this.onCfCreated(msg, callback);
        } else {
            CalculatedField newCf = this.cfDaoService.findById(msg.getTenantId(), cfId);
            if (newCf == null) {
                log.debug("[{}] Failed to lookup CF by id [{}]", (Object)this.tenantId, (Object)cfId);
                callback.onSuccess();
            } else {
                EntityInitCalculatedFieldMsg.StateAction stateAction;
                CalculatedFieldCtx newCfCtx = this.getCfCtx(newCf);
                try {
                    newCfCtx.init();
                }
                catch (Exception e) {
                    throw CalculatedFieldException.builder().ctx(newCfCtx).eventEntity(newCfCtx.getEntityId()).cause(e).errorMessage("Failed to initialize CF context").build();
                }
                finally {
                    this.calculatedFields.put(newCf.getId(), newCfCtx);
                    List oldCfList = (List)this.entityIdCalculatedFields.get(newCf.getEntityId());
                    CopyOnWriteArrayList<CalculatedFieldCtx> newCfList = new CopyOnWriteArrayList<CalculatedFieldCtx>();
                    boolean found = false;
                    for (CalculatedFieldCtx oldCtx : oldCfList) {
                        if (oldCtx.getCfId().equals((Object)newCf.getId())) {
                            newCfList.add(newCfCtx);
                            found = true;
                            continue;
                        }
                        newCfList.add(oldCtx);
                    }
                    if (!found) {
                        newCfList.add(newCfCtx);
                    }
                    this.entityIdCalculatedFields.put(newCf.getEntityId(), newCfList);
                    this.deleteLinks(oldCfCtx);
                    this.addLinks(newCf);
                }
                if (newCfCtx.getCfType() != oldCfCtx.getCfType()) {
                    stateAction = EntityInitCalculatedFieldMsg.StateAction.RECREATE;
                } else if (newCfCtx.hasStateChanges(oldCfCtx)) {
                    stateAction = EntityInitCalculatedFieldMsg.StateAction.REINIT;
                } else if (newCfCtx.hasContextOnlyChanges(oldCfCtx)) {
                    stateAction = EntityInitCalculatedFieldMsg.StateAction.REPROCESS;
                } else if (newCfCtx.hasRefreshContextOnlyChanges(oldCfCtx)) {
                    stateAction = EntityInitCalculatedFieldMsg.StateAction.REFRESH_CTX;
                } else {
                    callback.onSuccess();
                    return;
                }
                this.applyToTargetCfEntityActors(newCfCtx, (TbCallback)new /* Unavailable Anonymous Inner Class!! */, (id, cb) -> this.initCfForEntity(id, newCfCtx, stateAction, CalculatedFieldEventType.UPDATED, cb));
            }
        }
    }

    private void onCfDeleted(ComponentLifecycleMsg msg, TbCallback callback) {
        CalculatedFieldId cfId = new CalculatedFieldId(msg.getEntityId().getId());
        CalculatedFieldCtx cfCtx = (CalculatedFieldCtx)this.calculatedFields.remove(cfId);
        if (cfCtx == null) {
            log.debug("[{}] CF was already deleted [{}]", (Object)this.tenantId, (Object)cfId);
            callback.onSuccess();
            return;
        }
        ((List)this.entityIdCalculatedFields.get(cfCtx.getEntityId())).remove(cfCtx);
        this.deleteLinks(cfCtx);
        this.applyToTargetCfEntityActors(cfCtx, (TbCallback)new /* Unavailable Anonymous Inner Class!! */, (id, cb) -> this.deleteCfForEntity(id, cfId, cb));
    }

    public void onTelemetryMsg(CalculatedFieldTelemetryMsg msg) {
        EntityId entityId = msg.getEntityId();
        log.debug("Received telemetry msg from entity [{}]", (Object)entityId);
        MultipleTbCallback callback = new MultipleTbCallback(4, msg.getCallback());
        List entityIdFields = this.getCalculatedFieldsByEntityId(entityId);
        List profileIdFields = this.getCalculatedFieldsByEntityId(this.getProfileId(this.tenantId, entityId));
        if (!entityIdFields.isEmpty() || !profileIdFields.isEmpty()) {
            log.debug("Pushing telemetry msg to specific actor [{}]", (Object)entityId);
            this.getOrCreateActor(entityId).tell((TbActorMsg)new EntityCalculatedFieldTelemetryMsg(msg, entityIdFields, profileIdFields, (TbCallback)callback));
        } else {
            callback.onSuccess();
        }
        List linkedCalculatedFields = this.filterCalculatedFieldLinks(msg);
        int linksSize = linkedCalculatedFields.size();
        if (linksSize > 0) {
            this.cfExecService.pushMsgToLinks(msg, linkedCalculatedFields, (TbCallback)callback);
        } else {
            callback.onSuccess();
        }
        if (entityId.getEntityType().isOneOf(new EntityType[]{EntityType.TENANT, EntityType.CUSTOMER})) {
            List ownedEntitiesCFs = this.filterOwnedEntitiesCFs(msg);
            if (!ownedEntitiesCFs.isEmpty()) {
                this.cfExecService.pushMsgToLinks(msg, ownedEntitiesCFs, (TbCallback)callback);
            } else {
                callback.onSuccess();
            }
        } else {
            callback.onSuccess();
        }
        List aggregationCalculatedFields = this.filterAggregationCfs(msg);
        if (!aggregationCalculatedFields.isEmpty()) {
            this.cfExecService.pushMsgToLinks(msg, aggregationCalculatedFields, (TbCallback)callback);
        } else {
            callback.onSuccess();
        }
    }

    private List<CalculatedFieldEntityCtxId> filterAggregationCfs(CalculatedFieldTelemetryMsg msg) {
        EntityId entityId = msg.getEntityId();
        return this.calculatedFields.values().stream().filter(cf -> CalculatedFieldType.RELATED_ENTITIES_AGGREGATION.equals((Object)cf.getCfType())).filter(cf -> cf.relatedEntityMatches(msg.getProto())).flatMap(cf -> this.findRelationsForCf(entityId, cf).stream()).toList();
    }

    private List<CalculatedFieldEntityCtxId> findRelationsForCf(EntityId entityId, CalculatedFieldCtx cf) {
        ArrayList<CalculatedFieldEntityCtxId> result = new ArrayList<CalculatedFieldEntityCtxId>();
        CalculatedFieldConfiguration calculatedFieldConfiguration = cf.getCalculatedField().getConfiguration();
        if (calculatedFieldConfiguration instanceof RelatedEntitiesAggregationCalculatedFieldConfiguration) {
            RelatedEntitiesAggregationCalculatedFieldConfiguration configuration = (RelatedEntitiesAggregationCalculatedFieldConfiguration)calculatedFieldConfiguration;
            RelationPathLevel relation = configuration.getRelation();
            EntitySearchDirection inverseDirection = switch (3.$SwitchMap$org$thingsboard$server$common$data$relation$EntitySearchDirection[relation.direction().ordinal()]) {
                default -> throw new IncompatibleClassChangeError();
                case 1 -> EntitySearchDirection.TO;
                case 2 -> EntitySearchDirection.FROM;
            };
            RelationPathLevel inverseRelation = new RelationPathLevel(inverseDirection, relation.relationType());
            List byRelationPathQuery = this.relationService.findByRelationPathQuery(this.tenantId, new EntityRelationPathQuery(entityId, List.of(inverseRelation)));
            EntityId cfEntityId = cf.getEntityId();
            Predicate<EntityId> matchesCfEntity = relatedEntity -> cfEntityId.equals(relatedEntity) || cfEntityId.equals(this.getProfileId(this.tenantId, relatedEntity));
            if (byRelationPathQuery != null && !byRelationPathQuery.isEmpty()) {
                switch (3.$SwitchMap$org$thingsboard$server$common$data$relation$EntitySearchDirection[relation.direction().ordinal()]) {
                    case 1: {
                        byRelationPathQuery.stream().filter(entityRelation -> matchesCfEntity.test(entityRelation.getFrom())).forEach(entityRelation -> result.add(new CalculatedFieldEntityCtxId(this.tenantId, cf.getCfId(), entityRelation.getFrom())));
                        break;
                    }
                    case 2: {
                        byRelationPathQuery.stream().filter(entityRelation -> matchesCfEntity.test(entityRelation.getTo())).forEach(entityRelation -> result.add(new CalculatedFieldEntityCtxId(this.tenantId, cf.getCfId(), entityRelation.getTo())));
                    }
                }
            }
        }
        return result;
    }

    public void onLinkedTelemetryMsg(CalculatedFieldLinkedTelemetryMsg msg) {
        EntityId sourceEntityId = msg.getEntityId();
        log.debug("Received linked telemetry msg from entity [{}]", (Object)sourceEntityId);
        TransportProtos.CalculatedFieldLinkedTelemetryMsgProto proto = msg.getProto();
        TbCallback callback = msg.getCallback();
        List linksList = proto.getLinksList();
        if (linksList.isEmpty()) {
            log.debug("[{}] No CF links to process new telemetry.", (Object)msg.getTenantId());
            callback.onSuccess();
        }
        for (TransportProtos.CalculatedFieldEntityCtxIdProto linkProto : linksList) {
            CalculatedFieldEntityCtxId link = CalculatedFieldUtils.fromProto((TransportProtos.CalculatedFieldEntityCtxIdProto)linkProto);
            CalculatedFieldCtx cf = (CalculatedFieldCtx)this.calculatedFields.get(link.cfId());
            this.withTargetEntities(link.entityId(), callback, (ids, cb) -> {
                EntityCalculatedFieldLinkedTelemetryMsg linkedTelemetryMsg = new EntityCalculatedFieldLinkedTelemetryMsg(this.tenantId, sourceEntityId, proto.getMsg(), cf, cb);
                ids.forEach(id -> this.linkedTelemetryMsgForEntity(id, linkedTelemetryMsg));
            });
        }
    }

    private void onEntityOwnerChanged(ComponentLifecycleMsg msg, TbCallback msgCallback) {
        EntityId entityId = msg.getEntityId();
        log.debug("Received changed owner msg from entity [{}]", (Object)entityId);
        this.updateEntityOwner(entityId);
        List cfs = this.getCalculatedFieldsByEntityIdAndProfile(entityId);
        if (cfs.isEmpty()) {
            msgCallback.onSuccess();
            return;
        }
        MultipleTbCallback callback = new MultipleTbCallback(cfs.size(), msgCallback);
        cfs.forEach(cf -> {
            if (this.isMyPartition(entityId, (TbCallback)callback)) {
                if (cf.hasCurrentOwnerSourceArguments()) {
                    CalculatedFieldArgumentResetMsg argResetMsg = new CalculatedFieldArgumentResetMsg(this.tenantId, cf, CalculatedFieldEventType.OWNER_CHANGED, (TbCallback)callback);
                    log.debug("Pushing CF argument reset msg to specific actor [{}]", (Object)entityId);
                    this.getOrCreateActor(entityId).tell((TbActorMsg)argResetMsg);
                } else {
                    callback.onSuccess();
                }
            }
        });
    }

    private List<CalculatedFieldEntityCtxId> filterCalculatedFieldLinks(CalculatedFieldTelemetryMsg msg) {
        EntityId entityId = msg.getEntityId();
        TransportProtos.CalculatedFieldTelemetryMsgProto proto = msg.getProto();
        ArrayList<CalculatedFieldEntityCtxId> result = new ArrayList<CalculatedFieldEntityCtxId>();
        for (CalculatedFieldLink link : this.getCalculatedFieldLinksByEntityId(entityId)) {
            CalculatedFieldCtx ctx = (CalculatedFieldCtx)this.calculatedFields.get(link.calculatedFieldId());
            if (!ctx.linkMatches(entityId, proto)) continue;
            result.add(ctx.toCalculatedFieldEntityCtxId());
        }
        return result;
    }

    private List<CalculatedFieldEntityCtxId> filterOwnedEntitiesCFs(CalculatedFieldTelemetryMsg msg) {
        Set entities = this.getOwnedEntities(msg.getEntityId());
        TransportProtos.CalculatedFieldTelemetryMsgProto proto = msg.getProto();
        ArrayList<CalculatedFieldEntityCtxId> result = new ArrayList<CalculatedFieldEntityCtxId>();
        for (EntityId entityId : entities) {
            List ownerEntityCFs = this.getCalculatedFieldsByEntityId(entityId);
            for (CalculatedFieldCtx ctx : ownerEntityCFs) {
                if (!ctx.dynamicSourceMatches(proto)) continue;
                result.add(new CalculatedFieldEntityCtxId(this.tenantId, ctx.getCfId(), entityId));
            }
            List ownerEntityProfileCFs = this.getCalculatedFieldsByEntityId(this.getProfileId(this.tenantId, entityId));
            for (CalculatedFieldCtx ctx : ownerEntityProfileCFs) {
                if (!ctx.dynamicSourceMatches(proto)) continue;
                result.add(new CalculatedFieldEntityCtxId(this.tenantId, ctx.getCfId(), entityId));
            }
        }
        return result;
    }

    private List<CalculatedFieldCtx> getCalculatedFieldsByEntityId(EntityId entityId) {
        if (entityId == null) {
            return Collections.emptyList();
        }
        List<CalculatedFieldCtx> result = (List<CalculatedFieldCtx>)this.entityIdCalculatedFields.get(entityId);
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    private List<CalculatedFieldCtx> getCalculatedFieldsByEntityIdAndProfile(EntityId entityId) {
        ArrayList<CalculatedFieldCtx> cfsByEntityIdAndProfile = new ArrayList<CalculatedFieldCtx>();
        cfsByEntityIdAndProfile.addAll(this.getCalculatedFieldsByEntityId(entityId));
        EntityId profileId = this.getProfileId(this.tenantId, entityId);
        if (profileId != null) {
            cfsByEntityIdAndProfile.addAll(this.getCalculatedFieldsByEntityId(profileId));
        }
        return cfsByEntityIdAndProfile;
    }

    private List<CalculatedFieldLink> getCalculatedFieldLinksByEntityId(EntityId entityId) {
        if (entityId == null) {
            return Collections.emptyList();
        }
        List<CalculatedFieldLink> result = (List<CalculatedFieldLink>)this.entityIdCalculatedFieldLinks.get(entityId);
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    private Set<EntityId> getOwnedEntities(EntityId entityId) {
        if (entityId == null) {
            return Collections.emptySet();
        }
        Set<EntityId> result = (Set<EntityId>)this.ownerEntities.get(entityId);
        if (result == null) {
            result = Collections.emptySet();
        }
        return result;
    }

    private void linkedTelemetryMsgForEntity(EntityId entityId, EntityCalculatedFieldLinkedTelemetryMsg msg) {
        log.debug("Pushing linked telemetry msg to specific actor [{}]", (Object)entityId);
        this.getOrCreateActor(entityId).tell((TbActorMsg)msg);
    }

    private void deleteRelatedEntity(EntityId entityId, EntityId relatedEntityId, CalculatedFieldCtx cf, TbCallback callback) {
        log.debug("Pushing delete related entity msg to specific actor [{}]", (Object)relatedEntityId);
        this.getOrCreateActor(entityId).tell((TbActorMsg)new CalculatedFieldRelationActionMsg(this.tenantId, relatedEntityId, ActionType.DELETED, cf, callback));
    }

    private void initRelatedEntity(EntityId entityId, EntityId relatedEntityId, CalculatedFieldCtx cf, TbCallback callback) {
        log.debug("Pushing init related entity msg to specific actor [{}]", (Object)relatedEntityId);
        this.getOrCreateActor(entityId).tell((TbActorMsg)new CalculatedFieldRelationActionMsg(this.tenantId, relatedEntityId, ActionType.UPDATED, cf, callback));
    }

    private void deleteCfForEntity(EntityId entityId, CalculatedFieldId cfId, TbCallback callback) {
        log.debug("Pushing delete CF msg to specific actor [{}]", (Object)entityId);
        this.getOrCreateActor(entityId).tell((TbActorMsg)new CalculatedFieldEntityDeleteMsg(this.tenantId, (EntityId)cfId, callback));
    }

    private void initCfForEntity(EntityId entityId, CalculatedFieldCtx cfCtx, EntityInitCalculatedFieldMsg.StateAction stateAction, CalculatedFieldEventType eventType, TbCallback callback) {
        log.debug("Pushing entity init CF msg to specific actor [{}]", (Object)entityId);
        this.getOrCreateActor(entityId).tell((TbActorMsg)new EntityInitCalculatedFieldMsg(this.tenantId, cfCtx, stateAction, eventType, callback));
    }

    private boolean isMyPartition(EntityId entityId, TbCallback callback) {
        if (!this.systemContext.getPartitionService().resolve(ServiceType.TB_RULE_ENGINE, "CalculatedFields", this.tenantId, entityId).isMyPartition()) {
            log.debug("[{}] Entity belongs to external partition.", (Object)entityId);
            callback.onSuccess();
            return false;
        }
        return true;
    }

    private static boolean isProfileEntity(EntityType entityType) {
        return EntityType.DEVICE_PROFILE.equals((Object)entityType) || EntityType.ASSET_PROFILE.equals((Object)entityType);
    }

    private EntityId getProfileId(TenantId tenantId, EntityId entityId) {
        return switch (3.$SwitchMap$org$thingsboard$server$common$data$EntityType[entityId.getEntityType().ordinal()]) {
            case 3 -> Optional.ofNullable(this.assetProfileCache.get(tenantId, (AssetId)entityId)).map(AssetProfile::getId).orElse(null);
            case 2 -> Optional.ofNullable(this.deviceProfileCache.get(tenantId, (DeviceId)entityId)).map(DeviceProfile::getId).orElse(null);
            default -> null;
        };
    }

    private TbActorRef getOrCreateActor(EntityId entityId) {
        return this.ctx.getOrCreateChildActor((TbActorId)new TbCalculatedFieldEntityActorId(entityId), () -> "cf-entity-dispatcher", () -> new CalculatedFieldEntityActorCreator(this.systemContext, this.tenantId, entityId), () -> true);
    }

    private void addLinks(CalculatedField newCf) {
        List newLinks = newCf.getConfiguration().buildCalculatedFieldLinks(this.tenantId, newCf.getEntityId(), newCf.getId());
        newLinks.forEach(link -> this.entityIdCalculatedFieldLinks.computeIfAbsent(link.entityId(), id -> new CopyOnWriteArrayList()).add(link));
    }

    private void deleteLinks(CalculatedFieldCtx cfCtx) {
        CalculatedField oldCf = cfCtx.getCalculatedField();
        List oldLinks = oldCf.getConfiguration().buildCalculatedFieldLinks(this.tenantId, oldCf.getEntityId(), oldCf.getId());
        oldLinks.forEach(link -> this.entityIdCalculatedFieldLinks.computeIfAbsent(link.entityId(), id -> new CopyOnWriteArrayList()).remove(link));
    }

    public void onPartitionChange(CalculatedFieldPartitionChangeMsg msg) {
        this.ctx.broadcastToChildren((TbActorMsg)msg, true);
    }

    public void initCalculatedFields() {
        PageDataIterable cfs = new PageDataIterable(pageLink -> this.cfDaoService.findCalculatedFieldsByTenantId(this.tenantId, pageLink), this.cfSettings.getInitTenantFetchPackSize());
        cfs.forEach(cf -> {
            log.trace("Processing calculated field record: {}", cf);
            try {
                this.initCalculatedField(cf);
                this.initCalculatedFieldLinks(cf);
            }
            catch (CalculatedFieldException e) {
                log.error("Failed to process calculated field record: {}", cf, (Object)e);
            }
        });
    }

    private void initCalculatedField(CalculatedField cf) throws CalculatedFieldException {
        CalculatedFieldCtx cfCtx = new CalculatedFieldCtx(cf, this.systemContext);
        try {
            cfCtx.init();
        }
        catch (Exception e) {
            throw CalculatedFieldException.builder().ctx(cfCtx).eventEntity(cf.getEntityId()).cause(e).errorMessage("Failed to initialize CF context").build();
        }
        finally {
            this.calculatedFields.put(cf.getId(), cfCtx);
            this.entityIdCalculatedFields.computeIfAbsent(cf.getEntityId(), id -> new CopyOnWriteArrayList()).add(cfCtx);
        }
    }

    private void initCalculatedFieldLinks(CalculatedField cf) {
        List links = cf.getConfiguration().buildCalculatedFieldLinks(cf.getTenantId(), cf.getEntityId(), cf.getId());
        for (CalculatedFieldLink link : links) {
            this.entityIdCalculatedFieldLinks.computeIfAbsent(link.entityId(), id -> new CopyOnWriteArrayList()).add(link);
        }
    }

    private void initEntitiesCache() {
        PageDataIterable deviceIdInfos = new PageDataIterable(pageLink -> this.deviceService.findProfileEntityIdInfosByTenantId(this.tenantId, pageLink), this.cfSettings.getInitTenantFetchPackSize());
        for (Object idInfo : deviceIdInfos) {
            log.trace("Processing device record: {}", idInfo);
            try {
                this.entityProfileCache.add(idInfo.getProfileId(), idInfo.getEntityId());
                this.ownerEntities.computeIfAbsent(idInfo.getOwnerId(), __ -> new HashSet()).add(idInfo.getEntityId());
            }
            catch (Exception e) {
                log.error("Failed to process device record: {}", idInfo, (Object)e);
            }
        }
        PageDataIterable assetIdInfos = new PageDataIterable(pageLink -> this.assetService.findProfileEntityIdInfosByTenantId(this.tenantId, pageLink), this.cfSettings.getInitTenantFetchPackSize());
        for (ProfileEntityIdInfo idInfo : assetIdInfos) {
            log.trace("Processing asset record: {}", (Object)idInfo);
            try {
                this.entityProfileCache.add(idInfo.getProfileId(), idInfo.getEntityId());
                this.ownerEntities.computeIfAbsent(idInfo.getOwnerId(), __ -> new HashSet()).add(idInfo.getEntityId());
            }
            catch (Exception e) {
                log.error("Failed to process asset record: {}", (Object)idInfo, (Object)e);
            }
        }
        PageDataIterable customers = new PageDataIterable(pageLink -> this.customerService.findCustomersByTenantId(this.tenantId, pageLink), this.cfSettings.getInitTenantFetchPackSize());
        for (Customer customer : customers) {
            log.trace("Processing customer record: {}", (Object)customer);
            try {
                this.ownerEntities.computeIfAbsent(customer.getOwnerId(), __ -> new HashSet()).add(customer.getId());
            }
            catch (Exception e) {
                log.error("Failed to process customer record: {}", (Object)customer, (Object)e);
            }
        }
    }

    private void updateEntityOwner(EntityId entityId) {
        this.ownerEntities.values().forEach(entities -> entities.remove(entityId));
        EntityId owner = this.ownersCacheService.getOwner(this.tenantId, entityId);
        this.ownerEntities.computeIfAbsent(owner, ownerId -> new HashSet()).add(entityId);
    }

    private void applyToTargetCfEntityActors(CalculatedFieldCtx ctx, TbCallback callback, BiConsumer<EntityId, TbCallback> action) {
        this.withTargetEntities(ctx.getEntityId(), callback, (ids, cb) -> ids.forEach(id -> action.accept((EntityId)id, (TbCallback)cb)));
    }

    private void withTargetEntities(EntityId entityId, TbCallback parentCallback, BiConsumer<List<EntityId>, TbCallback> consumer) {
        if (CalculatedFieldManagerMessageProcessor.isProfileEntity((EntityType)entityId.getEntityType())) {
            Collection ids = this.entityProfileCache.getEntityIdsByProfileId(entityId);
            if (ids.isEmpty()) {
                parentCallback.onSuccess();
                return;
            }
            MultipleTbCallback multiCallback = new MultipleTbCallback(ids.size(), parentCallback);
            List<EntityId> profileEntityIds = ids.stream().filter(id -> this.isMyPartition(id, (TbCallback)multiCallback)).toList();
            if (profileEntityIds.isEmpty()) {
                return;
            }
            consumer.accept(profileEntityIds, (TbCallback)multiCallback);
            return;
        }
        if (this.isMyPartition(entityId, parentCallback)) {
            consumer.accept(List.of(entityId), parentCallback);
        }
    }

    private void cancelReevaluationTask() {
        if (this.cfsReevaluationTask != null) {
            this.cfsReevaluationTask.cancel(true);
            this.cfsReevaluationTask = null;
        }
    }
}

