/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.actors.calculatedField;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.actors.TbActorCtx;
import org.thingsboard.server.actors.TbActorException;
import org.thingsboard.server.actors.calculatedField.AbstractCalculatedFieldActor;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldAlarmActionMsg;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldArgumentResetMsg;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldEntityActor;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldEntityDeleteMsg;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldEntityMessageProcessor;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldException;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldReevaluateMsg;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldRelationActionMsg;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldStateRestoreMsg;
import org.thingsboard.server.actors.calculatedField.EntityCalculatedFieldLinkedTelemetryMsg;
import org.thingsboard.server.actors.calculatedField.EntityCalculatedFieldTelemetryMsg;
import org.thingsboard.server.actors.calculatedField.EntityInitCalculatedFieldMsg;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.msg.CalculatedFieldStatePartitionRestoreMsg;
import org.thingsboard.server.common.msg.TbActorStopReason;
import org.thingsboard.server.common.msg.ToCalculatedFieldSystemMsg;
import org.thingsboard.server.common.msg.cf.CalculatedFieldPartitionChangeMsg;

public class CalculatedFieldEntityActor
extends AbstractCalculatedFieldActor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CalculatedFieldEntityActor.class);
    private final CalculatedFieldEntityMessageProcessor processor;

    CalculatedFieldEntityActor(ActorSystemContext systemContext, TenantId tenantId, EntityId entityId) {
        super(systemContext, tenantId);
        this.processor = new CalculatedFieldEntityMessageProcessor(systemContext, tenantId, entityId);
    }

    public void init(TbActorCtx ctx) throws TbActorException {
        super.init(ctx);
        log.debug("[{}][{}] Starting CF entity actor.", (Object)this.processor.tenantId, (Object)this.processor.entityId);
        try {
            this.processor.init(ctx);
            log.debug("[{}][{}] CF entity actor started.", (Object)this.processor.tenantId, (Object)this.processor.entityId);
        }
        catch (Exception e) {
            log.warn("[{}][{}] Unknown failure", new Object[]{this.processor.tenantId, this.processor.entityId, e});
            throw new TbActorException("Failed to initialize CF entity actor", (Throwable)e);
        }
    }

    public void destroy(TbActorStopReason stopReason, Throwable cause) throws TbActorException {
        log.debug("[{}] Stopping CF entity actor.", (Object)this.processor.tenantId);
        this.processor.stop(false);
    }

    protected boolean doProcessCfMsg(ToCalculatedFieldSystemMsg msg) throws CalculatedFieldException {
        switch (1.$SwitchMap$org$thingsboard$server$common$msg$MsgType[msg.getMsgType().ordinal()]) {
            case 1: {
                this.processor.process((CalculatedFieldPartitionChangeMsg)msg);
                break;
            }
            case 2: {
                this.processor.process((CalculatedFieldStateRestoreMsg)msg);
                break;
            }
            case 3: {
                this.processor.process((CalculatedFieldStatePartitionRestoreMsg)msg);
                break;
            }
            case 4: {
                this.processor.process((EntityInitCalculatedFieldMsg)msg);
                break;
            }
            case 5: {
                this.processor.process((CalculatedFieldEntityDeleteMsg)msg);
                break;
            }
            case 6: {
                this.processor.process((CalculatedFieldRelationActionMsg)msg);
                break;
            }
            case 7: {
                this.processor.process((EntityCalculatedFieldTelemetryMsg)msg);
                break;
            }
            case 8: {
                this.processor.process((EntityCalculatedFieldLinkedTelemetryMsg)msg);
                break;
            }
            case 9: {
                this.processor.process((CalculatedFieldArgumentResetMsg)msg);
                break;
            }
            case 10: {
                this.processor.process((CalculatedFieldReevaluateMsg)msg);
                break;
            }
            case 11: {
                this.processor.process((CalculatedFieldAlarmActionMsg)msg);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    void logProcessingException(Exception e) {
        log.warn("[{}][{}] Processing failure", new Object[]{this.tenantId, this.processor.entityId, e});
    }
}

