### 💡 Solution Description

The **Site Fleet Tracking** template is your accelerator for heavy industry IoT. Whether you are managing a clay mine, a quarry, or a large-scale construction site, this template provides the essential tools to visualize assets, enforce safety protocols, and optimize haulage cycles.

#### 🌟 Why use this template?

* **⚡ Zero-Code Geofencing:** Forget complex coordinate math. We provide a ready-to-use asset structure where machines automatically "know" if they are in a Loading or Restricted zone.
* **🛡️ Enhanced Safety:** Deploy a digital safety net. Instantly detect if a haul truck enters a danger zone or if an excavator is operating under critical hydraulic pressure.
* **🚀 Instant Visibility:** From the moment you install, you get a bird's-eye view of your entire operation, fuel consumption trends, and active alarms.

#### ✨ Key Features

* **Real-Time Position Tracking:** Monitor the exact latitude/longitude and movement history of your fleet on a satellite map 📍.
* **Zone Awareness:** The system automatically calculates "Time in Zone" and tracks movement cycles between Loading and Unloading areas.
* **Critical Alerts:** Don't just watch dots on a map. Get actionable alerts for Overloads, Low Fuel, and Speed Violations to prevent downtime and accidents 🚨.

#### 🌍 Real-World Applications

This template serves as a robust foundation for extractive industries:

* **⛏️ Open-Pit Mining:**
  Optimize the "Load-Haul-Dump" cycle by tracking exactly how long trucks wait in loading zones.

* **🚧 Large Construction Sites:**
  Manage diverse fleets of machinery and ensure equipment stays within authorized boundaries.

* **⛰️ Quarry Operations:**
  Monitor fuel usage across heavy assets to reduce operational costs and carbon footprint.
