/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.ws;

import java.util.Optional;
import lombok.Generated;
import org.thingsboard.server.service.ws.SessionEvent;

public class SessionEvent {
    private final SessionEventType eventType;
    private final Optional<Throwable> error;

    private SessionEvent(SessionEventType eventType, Throwable error) {
        this.eventType = eventType;
        this.error = Optional.ofNullable(error);
    }

    public static SessionEvent onEstablished() {
        return new SessionEvent(SessionEventType.ESTABLISHED, null);
    }

    public static SessionEvent onClosed() {
        return new SessionEvent(SessionEventType.CLOSED, null);
    }

    public static SessionEvent onError(Throwable t) {
        return new SessionEvent(SessionEventType.ERROR, t);
    }

    @Generated
    public String toString() {
        return "SessionEvent(eventType=" + String.valueOf(this.getEventType()) + ", error=" + String.valueOf(this.getError()) + ")";
    }

    @Generated
    public SessionEventType getEventType() {
        return this.eventType;
    }

    @Generated
    public Optional<Throwable> getError() {
        return this.error;
    }
}

