/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.trendz;

import java.beans.ConstructorProperties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.ThingsBoardThreadFactory;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.dao.trendz.TrendzSyncService;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.util.AfterStartUp;
import org.thingsboard.server.queue.util.TbCoreComponent;

@Component
@TbCoreComponent
@ConditionalOnProperty(prefix="trendz", name={"enabled"}, havingValue="true")
public class TrendzStartupSynchronizer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TrendzStartupSynchronizer.class);
    private final TrendzSyncService trendzSyncService;
    private final PartitionService partitionService;

    @AfterStartUp(order=11)
    private void startSyncProcess() {
        if (!this.partitionService.isSystemPartitionMine(ServiceType.TB_CORE)) {
            return;
        }
        ExecutorService executor = Executors.newSingleThreadExecutor((ThreadFactory)ThingsBoardThreadFactory.forName((String)"trendz-startup-sync"));
        executor.submit(() -> {
            try {
                this.trendzSyncService.performSyncIfNeeded();
            }
            catch (Exception e) {
                log.error("Failed to perform Trendz startup synchronization", (Throwable)e);
            }
            finally {
                executor.shutdown();
            }
        });
    }

    @ConstructorProperties(value={"trendzSyncService", "partitionService"})
    @Generated
    public TrendzStartupSynchronizer(TrendzSyncService trendzSyncService, PartitionService partitionService) {
        this.trendzSyncService = trendzSyncService;
        this.partitionService = partitionService;
    }
}

