/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.trendz;

import com.fasterxml.jackson.databind.JsonNode;
import jakarta.annotation.PostConstruct;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.page.SortOrder;
import org.thingsboard.server.common.data.pat.ApiKey;
import org.thingsboard.server.common.data.trendz.TrendzConfiguration;
import org.thingsboard.server.common.data.trendz.TrendzHealthcheckResult;
import org.thingsboard.server.common.data.trendz.TrendzPaginationData;
import org.thingsboard.server.common.data.trendz.TrendzSettings;
import org.thingsboard.server.common.data.trendz.TrendzSummary;
import org.thingsboard.server.common.data.trendz.TrendzSynchronizationResult;
import org.thingsboard.server.common.data.trendz.TrendzSynchronizationResultType;
import org.thingsboard.server.common.data.trendz.TrendzSynchronizationStatus;
import org.thingsboard.server.common.data.trendz.TrendzUsage;
import org.thingsboard.server.common.data.trendz.TrendzViewConfig;
import org.thingsboard.server.common.data.trendz.TrendzViewConfigLite;
import org.thingsboard.server.dao.pat.ApiKeyService;
import org.thingsboard.server.dao.trendz.TrendzSettingsService;

@Component
public class TrendzClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TrendzClient.class);
    public static final String TRENDZ_API_KEY_HEADER = "X-Trendz-Api-Key";
    public static final String TRENDZ_TENANT_ID_HEADER = "X-Trendz-Tenant-Id";
    public static final String TRENDZ_CUSTOMER_ID_HEADER = "X-Trendz-Customer-Id";
    public static final String TRENDZ_USER_ID_HEADER = "X-Trendz-User-Id";
    public static final String TRENDZ_INFO_URI = "/apiTrendz/publicApi/info";
    public static final String TRENDZ_SYNC_INIT_URI = "/apiTrendz/publicApi/sync/init";
    public static final String TRENDZ_HEALTHCHECK_URI = "/apiTrendz/publicApi/sync/check";
    public static final String TRENDZ_VIEW_CONFIGS_GET_ALL_URI = "/apiTrendz/view/config/all";
    public static final String TRENDZ_VIEW_CONFIGS_GET_BY_ID_URI = "/apiTrendz/view/config/%s";
    public static final String TRENDZ_SUMMARY_URI = "/apiTrendz/summary";
    public static final String TRENDZ_USAGE_URI = "/apiTrendz/summary/usage";
    private static final Set<String> HOP_BY_HOP_HEADERS = Set.of("Transfer-Encoding".toLowerCase(), "Connection".toLowerCase(), "Content-Length".toLowerCase(), "Keep-Alive".toLowerCase(), "Proxy-Authenticate".toLowerCase(), "Proxy-Authorization".toLowerCase(), "TE".toLowerCase(), "Trailer".toLowerCase(), "Upgrade".toLowerCase());
    @Value(value="${trendz.request_timeout_ms:15000}")
    private int requestTimeoutMs;
    @Value(value="${trendz.usage_request_timeout_ms:3000}")
    private int usageRequestTimeoutMs;
    @Value(value="${trendz.enabled:true}")
    private boolean trendzEnabled;
    private final TrendzSettingsService trendzSettingsService;
    private final ApiKeyService apiKeyService;
    private RestTemplate restTemplate;
    private RestTemplate usageRestTemplate;

    @PostConstruct
    private void init() {
        this.restTemplate = new RestTemplateBuilder(new RestTemplateCustomizer[0]).connectTimeout(Duration.ofMillis(this.requestTimeoutMs)).readTimeout(Duration.ofMillis(this.requestTimeoutMs)).build();
        this.usageRestTemplate = new RestTemplateBuilder(new RestTemplateCustomizer[0]).connectTimeout(Duration.ofMillis(this.usageRequestTimeoutMs)).readTimeout(Duration.ofMillis(this.usageRequestTimeoutMs)).build();
    }

    public JsonNode checkTrendzReachability(String trendzUrl) {
        return (JsonNode)this.sendTrendzRequest(trendzUrl, TRENDZ_INFO_URI, HttpMethod.GET, null, JsonNode.class, "Checking Trendz reachability");
    }

    public TrendzHealthcheckResult processTrendzInitRequest(String trendzUrl, String internalTbUrl, String externalTbUrl, String currentApiKey, String prevApiKey) {
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("internalTbUrl", internalTbUrl);
        requestBody.put("externalTbUrl", externalTbUrl);
        requestBody.put("currentTbAccessToken", currentApiKey);
        requestBody.put("prevTbAccessToken", prevApiKey);
        return (TrendzHealthcheckResult)this.sendTrendzRequest(trendzUrl, TRENDZ_SYNC_INIT_URI, HttpMethod.POST, requestBody, TrendzHealthcheckResult.class, "Initiating Trendz sync");
    }

    public TrendzHealthcheckResult sendHealthcheckRequest(String trendzUrl, String apiKey) {
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("apiKey", apiKey);
        TrendzHealthcheckResult result = (TrendzHealthcheckResult)this.sendTrendzRequest(trendzUrl, TRENDZ_HEALTHCHECK_URI, HttpMethod.POST, requestBody, TrendzHealthcheckResult.class, "Performing Trendz healthcheck");
        if (result == null) {
            return new TrendzHealthcheckResult(null, TrendzSynchronizationResultType.TRENDZ_URL_UNREACHABLE, TrendzSynchronizationStatus.AVAILABLE, TrendzSynchronizationResultType.TRENDZ_URL_UNREACHABLE.getMessage());
        }
        return result;
    }

    public TrendzViewConfig getTrendzViewById(UUID viewId, User user) throws ThingsboardException {
        return (TrendzViewConfig)this.sendTrendzRequest(HttpMethod.GET, TRENDZ_VIEW_CONFIGS_GET_BY_ID_URI.formatted(viewId), Collections.emptyMap(), null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, user, "Get Trendz view config by id");
    }

    public TrendzPaginationData<TrendzViewConfigLite> getAllTrendzViews(PageLink pageLink, User user) throws ThingsboardException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("prefix", pageLink.getTextSearch());
        params.put("page", pageLink.getPage());
        params.put("pageSize", pageLink.getPageSize());
        params.put("sort", this.toTrendzSortParameter(pageLink.getSortOrder()));
        return (TrendzPaginationData)this.sendTrendzRequest(HttpMethod.GET, TRENDZ_VIEW_CONFIGS_GET_ALL_URI, params, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, user, "Get all Trendz view configs");
    }

    public TrendzSummary getTrendzSummary(User user) throws ThingsboardException {
        return (TrendzSummary)this.sendTrendzRequest(HttpMethod.GET, TRENDZ_SUMMARY_URI, Collections.emptyMap(), null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, user, "Get Trendz summary");
    }

    public TrendzUsage getTrendzUsage(User user) throws ThingsboardException {
        return (TrendzUsage)this.sendTrendzRequest(HttpMethod.GET, TRENDZ_USAGE_URI, Collections.emptyMap(), null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, user, "Get Trendz usage", this.usageRestTemplate);
    }

    public ResponseEntity<byte[]> sendTrendzProxyRequest(String uriPath, Map<String, String[]> params, HttpMethod method, byte[] body, HttpHeaders headers) throws ThingsboardException {
        String trendzUrl = this.getBaseTrendzUrl();
        try {
            UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)trendzUrl).path(uriPath);
            params.forEach((arg_0, arg_1) -> ((UriComponentsBuilder)uriBuilder).queryParam(arg_0, arg_1));
            URI uri = uriBuilder.build(false).toUri();
            headers.set("Host", uri.getHost());
            log.debug("Trendz proxy request at: {}", (Object)uri);
            ResponseEntity response = this.restTemplate.exchange(uri, method, new HttpEntity((Object)body, (MultiValueMap)headers), byte[].class);
            log.debug("Trendz proxy request completed successfully");
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)response.getStatusCode()).headers(this.clearResponseHeaders(response.getHeaders()))).body((Object)((byte[])response.getBody()));
        }
        catch (RestClientResponseException e) {
            log.debug("Trendz proxy request received non-successful response: {}", (Object)e.getStatusCode());
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)e.getStatusCode()).headers(this.clearResponseHeaders(e.getResponseHeaders()))).body((Object)e.getResponseBodyAsByteArray());
        }
        catch (Exception e) {
            log.debug("Trendz proxy request failed at {} [{}]: {}", new Object[]{trendzUrl, uriPath, e.getMessage(), e});
            throw new ThingsboardException("Unexpected error during Trendz proxy request", (Throwable)e, ThingsboardErrorCode.GENERAL);
        }
    }

    private HttpHeaders clearResponseHeaders(HttpHeaders original) {
        if (original == null) {
            return null;
        }
        HttpHeaders cleared = new HttpHeaders();
        original.forEach((key, values) -> {
            if (!HOP_BY_HOP_HEADERS.contains(key.toLowerCase())) {
                cleared.put(key, values);
            }
        });
        return cleared;
    }

    private <T> T sendTrendzRequest(String trendzUrl, String uriPath, HttpMethod method, Map<String, Object> requestBody, Class<T> responseType, String operationName) {
        try {
            String url = this.normalizeUrl(trendzUrl) + uriPath;
            log.debug("{} at: {}", (Object)operationName, (Object)url);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity request = new HttpEntity(requestBody, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, method, request, responseType, new Object[0]);
            return (T)this.fetchContent(response, operationName);
        }
        catch (Exception e) {
            log.debug("{} failed at {} [{}]: {}", new Object[]{operationName, trendzUrl, uriPath, e.getMessage(), e});
            return null;
        }
    }

    private <T> T sendTrendzRequest(HttpMethod method, String uriPath, Map<String, Object> params, Object requestBody, ParameterizedTypeReference<T> typeReference, User user, String operationName) throws ThingsboardException {
        return (T)this.sendTrendzRequest(method, uriPath, params, requestBody, typeReference, user, operationName, this.restTemplate);
    }

    private <T> T sendTrendzRequest(HttpMethod method, String uriPath, Map<String, Object> params, Object requestBody, ParameterizedTypeReference<T> typeReference, User user, String operationName, RestTemplate restTemplate) throws ThingsboardException {
        String trendzUrl = this.getBaseTrendzUrl();
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)uriPath);
        params.forEach((x$0, xva$1) -> uriBuilder.queryParam(x$0, new Object[]{xva$1}));
        String urlWithParams = uriBuilder.toUriString();
        HttpHeaders headers = this.getTrendzAuthHeaders(user);
        HttpEntity entity = new HttpEntity(requestBody, (MultiValueMap)headers);
        try {
            ResponseEntity response = restTemplate.exchange(trendzUrl + urlWithParams, method, entity, typeReference, new Object[0]);
            return (T)this.fetchContent(response, operationName);
        }
        catch (HttpClientErrorException.NotFound e) {
            log.debug("{} not found at {} [{}]: {}", new Object[]{operationName, trendzUrl, uriPath, e.getMessage(), e});
            throw new ThingsboardException("%s. Item wasn't found".formatted(operationName), ThingsboardErrorCode.ITEM_NOT_FOUND);
        }
        catch (HttpClientErrorException.BadRequest e) {
            log.debug("{} bad request at {} [{}]: {}", new Object[]{operationName, trendzUrl, uriPath, e.getMessage(), e});
            throw new ThingsboardException("%s. Bad request.".formatted(operationName), ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        catch (Exception e) {
            log.warn("{} failed at {} [{}]: {}", new Object[]{operationName, trendzUrl, uriPath, e.getMessage(), e});
            throw new ThingsboardException("%s. Unexpected error during Trendz request.".formatted(operationName), ThingsboardErrorCode.GENERAL);
        }
    }

    private <T> T fetchContent(ResponseEntity<T> response, String operationName) {
        if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null) {
            log.debug("{} completed successfully", (Object)operationName);
            return (T)response.getBody();
        }
        log.debug("{} received non-successful response: {}", (Object)operationName, (Object)response.getStatusCode());
        return null;
    }

    private HttpHeaders getTrendzAuthHeaders(User user) throws ThingsboardException {
        String trendzApiKey = Optional.ofNullable(this.apiKeyService.findInternalApiKeyByDescription(TenantId.SYS_TENANT_ID, "Internal API key used to authenticate with Trendz")).map(ApiKey::getValue).orElseThrow(() -> new ThingsboardException("Trendz API key is not configured. Please configure the Trendz API key in system settings.", ThingsboardErrorCode.GENERAL));
        HttpHeaders headers = new HttpHeaders();
        headers.add(TRENDZ_API_KEY_HEADER, trendzApiKey);
        if (!user.isSystemAdmin()) {
            headers.add(TRENDZ_TENANT_ID_HEADER, user.getTenantId().getId().toString());
            headers.add(TRENDZ_CUSTOMER_ID_HEADER, user.getCustomerId().getId().toString());
            headers.add(TRENDZ_USER_ID_HEADER, user.getUuidId().toString());
        }
        return headers;
    }

    private String getBaseTrendzUrl() throws ThingsboardException {
        if (!this.trendzEnabled) {
            throw new ThingsboardException("Trendz is disabled.", ThingsboardErrorCode.GENERAL);
        }
        Optional<TrendzSettings> trendzSettings = Optional.ofNullable(this.trendzSettingsService.findTrendzSettings());
        trendzSettings.map(TrendzSettings::synchronizationResult).map(TrendzSynchronizationResult::status).orElseThrow(() -> new ThingsboardException("Trendz is not synced. Please sync before using it.", ThingsboardErrorCode.GENERAL));
        return trendzSettings.map(TrendzSettings::configuration).map(TrendzConfiguration::trendzUrl).map(arg_0 -> this.normalizeUrl(arg_0)).orElseThrow(() -> new ThingsboardException("Trendz URL is not configured. Please configure the Trendz URL in system settings.", ThingsboardErrorCode.GENERAL));
    }

    private String toTrendzSortParameter(SortOrder sortOrder) {
        if (sortOrder == null || sortOrder.getProperty() == null || sortOrder.getDirection() == null) {
            return null;
        }
        return "%s:%s".formatted(sortOrder.getProperty(), sortOrder.getDirection());
    }

    private String normalizeUrl(String url) {
        return url != null && url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
    }

    @ConstructorProperties(value={"trendzSettingsService", "apiKeyService"})
    @Generated
    public TrendzClient(TrendzSettingsService trendzSettingsService, ApiKeyService apiKeyService) {
        this.trendzSettingsService = trendzSettingsService;
        this.apiKeyService = apiKeyService;
    }
}

