/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.transport;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.beans.ConstructorProperties;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.server.common.stats.MessagesStats;
import org.thingsboard.server.common.stats.StatsFactory;
import org.thingsboard.server.common.stats.StatsType;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueConsumer;
import org.thingsboard.server.queue.TbQueueHandler;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.TbQueueResponseTemplate;
import org.thingsboard.server.queue.common.DefaultTbQueueResponseTemplate;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.provider.TbCoreQueueFactory;
import org.thingsboard.server.queue.util.AfterStartUp;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.transport.TransportApiService;

@Service
@TbCoreComponent
public class TbCoreTransportApiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbCoreTransportApiService.class);
    private final TbCoreQueueFactory tbCoreQueueFactory;
    private final TransportApiService transportApiService;
    private final StatsFactory statsFactory;
    @Value(value="${queue.transport_api.max_pending_requests:10000}")
    private int maxPendingRequests;
    @Value(value="${queue.transport_api.max_requests_timeout:10000}")
    private long requestTimeout;
    @Value(value="${queue.transport_api.request_poll_interval:25}")
    private int responsePollDuration;
    @Value(value="${queue.transport_api.max_callback_threads:10}")
    private int maxCallbackThreads;
    private ExecutorService transportCallbackExecutor;
    private TbQueueResponseTemplate<TbProtoQueueMsg<TransportProtos.TransportApiRequestMsg>, TbProtoQueueMsg<TransportProtos.TransportApiResponseMsg>> transportApiTemplate;

    @PostConstruct
    public void init() {
        this.transportCallbackExecutor = ThingsBoardExecutors.newWorkStealingPool((int)this.maxCallbackThreads, this.getClass());
        TbQueueProducer producer = this.tbCoreQueueFactory.createTransportApiResponseProducer();
        TbQueueConsumer consumer = this.tbCoreQueueFactory.createTransportApiRequestConsumer();
        String key = StatsType.TRANSPORT.getName();
        MessagesStats queueStats = this.statsFactory.createMessagesStats(key);
        DefaultTbQueueResponseTemplate.DefaultTbQueueResponseTemplateBuilder builder = DefaultTbQueueResponseTemplate.builder();
        builder.requestTemplate(consumer);
        builder.responseTemplate(producer);
        builder.maxPendingRequests(this.maxPendingRequests);
        builder.requestTimeout(this.requestTimeout);
        builder.pollInterval((long)this.responsePollDuration);
        builder.executor(this.transportCallbackExecutor);
        builder.stats(queueStats);
        this.transportApiTemplate = builder.build();
    }

    @AfterStartUp(order=11)
    public void onApplicationEvent(ApplicationReadyEvent applicationReadyEvent) {
        log.info("Received application ready event. Starting polling for events.");
        this.transportApiTemplate.subscribe();
        this.transportApiTemplate.launch((TbQueueHandler)this.transportApiService);
    }

    @PreDestroy
    public void destroy() {
        if (this.transportApiTemplate != null) {
            this.transportApiTemplate.stop();
        }
        if (this.transportCallbackExecutor != null) {
            this.transportCallbackExecutor.shutdownNow();
        }
    }

    @ConstructorProperties(value={"tbCoreQueueFactory", "transportApiService", "statsFactory"})
    @Generated
    public TbCoreTransportApiService(TbCoreQueueFactory tbCoreQueueFactory, TransportApiService transportApiService, StatsFactory statsFactory) {
        this.tbCoreQueueFactory = tbCoreQueueFactory;
        this.transportApiService = transportApiService;
        this.statsFactory = statsFactory;
    }
}

