/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.translation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.translation.TranslationInfo;
import org.thingsboard.server.common.data.wl.WhiteLabeling;
import org.thingsboard.server.common.data.wl.WhiteLabelingType;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.dao.translation.CustomTranslationService;
import org.thingsboard.server.dao.wl.WhiteLabelingService;
import org.thingsboard.server.service.translation.DefaultTbCustomTranslationService;
import org.thingsboard.server.service.translation.TranslationService;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DefaultTranslationService
implements TranslationService {
    public static final String LOCALE_FILES_DIRECTORY_PATH = "public/assets/locale";
    public static final Pattern LOCALE_FILE_PATTERN = Pattern.compile("locale\\.constant-(.*?)\\.json");
    public static final String DEFAULT_LOCALE_CODE = "en_US";
    public static final Set<String> DEFAULT_LOCALE_KEYS;
    private static final Map<String, JsonNode> TRANSLATION_VALUE_MAP;
    private static final Map<String, TranslationInfo> TRANSLATION_INFO_MAP;
    private final CustomTranslationService customTranslationService;
    private final WhiteLabelingService whiteLabelingService;
    private final CustomerService customerService;

    public List<TranslationInfo> getTranslationInfos(TenantId tenantId, CustomerId customerId) {
        Map translationInfos = (Map)JacksonUtil.clone((Object)TRANSLATION_INFO_MAP);
        Set customizedLocales = this.getMergedCustomizedLocales(tenantId, customerId);
        Set currentCustomizedLocales = this.customTranslationService.getCurrentCustomizedLocales(tenantId, customerId);
        Set engLocaleKeys = JacksonUtil.extractKeys((JsonNode)this.getFullTranslation(tenantId, customerId, "en_US"));
        for (String customizedLocale : customizedLocales) {
            JsonNode customTranslation = this.getMergedCustomTranslation(tenantId, customerId, customizedLocale);
            if (translationInfos.containsKey(customizedLocale)) {
                JsonNode resourceTranslation = DefaultTranslationService.readResourceLocaleTranslation((String)customizedLocale);
                customTranslation = JacksonUtil.merge((JsonNode)resourceTranslation, (JsonNode)customTranslation);
            }
            boolean customized = currentCustomizedLocales.contains(customizedLocale);
            translationInfos.put(customizedLocale, DefaultTranslationService.createTranslationInfo((Set)engLocaleKeys, (String)customizedLocale, (JsonNode)customTranslation, (boolean)customized));
        }
        return new ArrayList<TranslationInfo>(translationInfos.values());
    }

    public Set<String> getAvailableLocaleCodes(TenantId tenantId, CustomerId customerId) {
        HashSet<String> availableLocaleCodes = new HashSet<String>(TRANSLATION_INFO_MAP.keySet());
        Set customizedLocales = this.getMergedCustomizedLocales(tenantId, customerId);
        availableLocaleCodes.addAll(customizedLocales);
        return availableLocaleCodes;
    }

    public JsonNode getLoginTranslation(String localeCode, String domainName) {
        JsonNode fullTranslation;
        WhiteLabeling whiteLabeling = this.whiteLabelingService.findWhiteLabelingByDomainAndType(domainName, WhiteLabelingType.LOGIN);
        if (whiteLabeling != null) {
            TenantId tenantId = whiteLabeling.getTenantId();
            CustomerId customerId = whiteLabeling.getCustomerId();
            fullTranslation = this.getFullTranslation(tenantId, customerId, localeCode);
        } else {
            fullTranslation = TRANSLATION_VALUE_MAP.getOrDefault(localeCode, (JsonNode)TRANSLATION_VALUE_MAP.get("en_US")).deepCopy();
        }
        ObjectNode loginPageTranslation = JacksonUtil.newObjectNode();
        ObjectNode securityNode = JacksonUtil.newObjectNode();
        securityNode.set("2fa", fullTranslation.get("security").get("2fa"));
        securityNode.set("password-requirement", fullTranslation.get("security").get("password-requirement"));
        loginPageTranslation.set("login", fullTranslation.get("login"));
        loginPageTranslation.set("signup", fullTranslation.get("signup"));
        loginPageTranslation.set("common", fullTranslation.get("common"));
        loginPageTranslation.set("action", fullTranslation.get("action"));
        loginPageTranslation.set("security", (JsonNode)securityNode);
        loginPageTranslation.set("access", fullTranslation.get("access"));
        loginPageTranslation.set("user", JacksonUtil.newObjectNode().set("invalid-email-format", fullTranslation.get("user").get("invalid-email-format")));
        return loginPageTranslation;
    }

    public JsonNode getFullTranslation(TenantId tenantId, CustomerId customerId, String localeCode) {
        JsonNode customTranslation = this.getMergedCustomTranslation(tenantId, customerId, localeCode);
        JsonNode defaultTranslation = TRANSLATION_VALUE_MAP.getOrDefault(localeCode, (JsonNode)TRANSLATION_VALUE_MAP.get("en_US")).deepCopy();
        JsonNode merged = JacksonUtil.merge((JsonNode)defaultTranslation, (JsonNode)customTranslation);
        JsonNode defaultCustomTranslation = this.getMergedCustomTranslation(tenantId, customerId, "en_US");
        this.addNonExisting(merged, defaultCustomTranslation);
        return merged;
    }

    public JsonNode getTranslationForBasicEdit(TenantId tenantId, CustomerId customerId, String localeCode) {
        JsonNode fullTranslation = this.getFullTranslation(tenantId, customerId, localeCode).deepCopy();
        JsonNode currentCustomTranslation = this.customTranslationService.getCurrentCustomTranslation(tenantId, customerId, localeCode);
        JsonNode originalTranslation = this.getTranslatedOnly(tenantId, customerId, "en_US", ((JsonNode)TRANSLATION_VALUE_MAP.get("en_US")).deepCopy());
        JsonNode parentOriginalTranslation = this.getParentTranslatedOnly(tenantId, customerId, "en_US", ((JsonNode)TRANSLATION_VALUE_MAP.get("en_US")).deepCopy());
        ObjectNode resourceTranslation = TRANSLATION_VALUE_MAP.containsKey(localeCode) ? DefaultTranslationService.readResourceLocaleTranslation((String)localeCode) : JacksonUtil.newObjectNode();
        JsonNode translated = this.getTranslatedOnly(tenantId, customerId, localeCode, resourceTranslation.deepCopy());
        JsonNode parentTranslated = this.getParentTranslatedOnly(tenantId, customerId, localeCode, resourceTranslation.deepCopy());
        this.buildTranslationInfoForEdit(fullTranslation, translated, parentTranslated, originalTranslation, currentCustomTranslation, parentOriginalTranslation);
        return fullTranslation;
    }

    private static TranslationInfo createTranslationInfo(Set<String> engLocaleKeys, String localeCode, JsonNode translation, boolean customized) {
        int progress = DefaultTranslationService.calculateTranslationProgress(engLocaleKeys, (JsonNode)translation);
        Locale locale = Locale.forLanguageTag(localeCode.replace("_", "-"));
        return TranslationInfo.builder().customized(customized).localeCode(localeCode).country(locale.getDisplayCountry()).language(StringUtils.capitalize((String)(locale.getDisplayLanguage(locale) + " (" + locale.getDisplayLanguage() + ")"))).progress(progress).build();
    }

    private JsonNode getMergedCustomTranslation(TenantId tenantId, CustomerId customerId, String localeCode) {
        JsonNode customTranslation = tenantId.isSysTenantId() ? this.customTranslationService.getCurrentCustomTranslation(TenantId.SYS_TENANT_ID, null, localeCode) : (customerId == null || customerId.isNullUid() ? this.customTranslationService.getMergedTenantCustomTranslation(tenantId, localeCode) : this.customTranslationService.getMergedCustomerCustomTranslation(tenantId, customerId, localeCode));
        return customTranslation;
    }

    private Set<String> getMergedCustomizedLocales(TenantId tenantId, CustomerId customerId) {
        Set customizedLocales = tenantId.isSysTenantId() ? this.customTranslationService.getCurrentCustomizedLocales(TenantId.SYS_TENANT_ID, null) : (customerId == null || customerId.isNullUid() ? this.customTranslationService.getMergedTenantCustomizedLocales(tenantId) : this.customTranslationService.getMergedCustomerCustomizedLocales(tenantId, customerId));
        return customizedLocales;
    }

    private static JsonNode readResourceLocaleTranslation(String localeCode) {
        JsonNode jsonNode;
        block8: {
            String filePath = "public/assets/locale/locale.constant-" + localeCode + ".json";
            InputStream in = DefaultTbCustomTranslationService.class.getClassLoader().getResourceAsStream(filePath);
            try {
                jsonNode = JacksonUtil.OBJECT_MAPPER.readTree(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to read locale translation for " + localeCode + "!", e);
                }
            }
            in.close();
        }
        return jsonNode;
    }

    private static Set<String> getAvailableResourceLocaleCodes() {
        ArrayList filenames = new ArrayList();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            Resource[] resources = resolver.getResources("classpath:public/assets/locale/*.json");
            Arrays.stream(resources).forEach(resource -> filenames.add(resource.getFilename()));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get list of system locales!", e);
        }
        return filenames.stream().map(DefaultTranslationService::getLocaleFromFileName).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static String getLocaleFromFileName(String filename) {
        Matcher matcher = LOCALE_FILE_PATTERN.matcher(filename);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private static int calculateTranslationProgress(Set<String> defaultLocaleKeys, JsonNode translation) {
        Set localeKeys = JacksonUtil.extractKeys((JsonNode)translation);
        long translated = defaultLocaleKeys.stream().filter(localeKeys::contains).count();
        return (int)(translated * 100L / (long)defaultLocaleKeys.size());
    }

    private void buildTranslationInfoForEdit(JsonNode fullTranslation, JsonNode translated, JsonNode parentTranslated, JsonNode original, JsonNode custom, JsonNode parentOrigin) {
        Iterator fieldNamesIterator = fullTranslation.fieldNames();
        while (fieldNamesIterator.hasNext()) {
            JsonNode parentOriginNode;
            String fieldName = (String)fieldNamesIterator.next();
            JsonNode fullNode = fullTranslation.get(fieldName);
            JsonNode customNode = custom == null ? null : custom.get(fieldName);
            JsonNode parentTranslatedNode = parentTranslated == null ? null : parentTranslated.get(fieldName);
            JsonNode originNode = original == null ? null : original.get(fieldName);
            JsonNode translatedNode = translated == null ? null : translated.get(fieldName);
            JsonNode jsonNode = parentOriginNode = parentOrigin == null ? null : parentOrigin.get(fieldName);
            if (fullNode.isObject()) {
                this.buildTranslationInfoForEdit(fullNode, translatedNode, parentTranslatedNode, originNode, customNode, parentOriginNode);
                continue;
            }
            ObjectNode info = JacksonUtil.newObjectNode();
            if (originNode != null) {
                info.put("o", originNode.asText());
            }
            if (parentTranslatedNode != null) {
                info.put("p", parentTranslatedNode.asText());
            }
            if (customNode != null) {
                info.put("s", "C");
                info.put("t", customNode.asText());
            } else if (translatedNode != null) {
                info.put("t", translatedNode.asText());
                info.put("s", "T");
            } else {
                info.put("s", "U");
            }
            if (parentTranslatedNode == null && parentOriginNode == null) {
                info.put("s", "A");
            }
            ((ObjectNode)fullTranslation).set(fieldName, (JsonNode)info);
        }
    }

    private JsonNode getTranslatedOnly(TenantId tenantId, CustomerId customerId, String localeCode, JsonNode resourceTranslation) {
        JsonNode customTranslation = this.getMergedCustomTranslation(tenantId, customerId, localeCode);
        if (resourceTranslation != null) {
            return JacksonUtil.merge((JsonNode)resourceTranslation, (JsonNode)customTranslation);
        }
        return customTranslation;
    }

    private JsonNode getParentTranslatedOnly(TenantId tenantId, CustomerId customerId, String localeCode, JsonNode resourceTranslation) {
        Customer customer;
        JsonNode parentTranslation = customerId != null && !customerId.isNullUid() ? ((customer = this.customerService.findCustomerById(tenantId, customerId)).isSubCustomer() ? this.getTranslatedOnly(tenantId, customer.getParentCustomerId(), localeCode, resourceTranslation) : this.getTranslatedOnly(tenantId, null, localeCode, resourceTranslation)) : (tenantId.isSysTenantId() ? resourceTranslation : this.getTranslatedOnly(TenantId.SYS_TENANT_ID, null, localeCode, resourceTranslation));
        return parentTranslation;
    }

    private void addNonExisting(JsonNode mainNode, JsonNode newNode) {
        Iterator fieldNames = newNode.fieldNames();
        while (fieldNames.hasNext()) {
            JsonNode value;
            String fieldName = (String)fieldNames.next();
            JsonNode jsonNode = mainNode.get(fieldName);
            if (jsonNode != null) {
                if (jsonNode.isObject()) {
                    this.addNonExisting(jsonNode, newNode.get(fieldName));
                    continue;
                }
                if (!jsonNode.isArray()) continue;
                for (int i = 0; i < jsonNode.size(); ++i) {
                    this.addNonExisting(jsonNode.get(i), newNode.get(fieldName).get(i));
                }
                continue;
            }
            if (!(mainNode instanceof ObjectNode) || (value = newNode.get(fieldName)).isNull()) continue;
            ((ObjectNode)mainNode).set(fieldName, value);
        }
    }

    @ConstructorProperties(value={"customTranslationService", "whiteLabelingService", "customerService"})
    @Generated
    public DefaultTranslationService(CustomTranslationService customTranslationService, WhiteLabelingService whiteLabelingService, CustomerService customerService) {
        this.customTranslationService = customTranslationService;
        this.whiteLabelingService = whiteLabelingService;
        this.customerService = customerService;
    }

    static {
        TRANSLATION_VALUE_MAP = new HashMap();
        TRANSLATION_INFO_MAP = new HashMap();
        JsonNode defaultTranslation = DefaultTranslationService.readResourceLocaleTranslation((String)"en_US");
        DEFAULT_LOCALE_KEYS = JacksonUtil.extractKeys((JsonNode)defaultTranslation);
        Set systemLocaleCodes = DefaultTranslationService.getAvailableResourceLocaleCodes();
        for (String localeCode : systemLocaleCodes) {
            JsonNode resourceLocaleTranslation = DefaultTranslationService.readResourceLocaleTranslation((String)localeCode);
            TRANSLATION_INFO_MAP.put(localeCode, DefaultTranslationService.createTranslationInfo((Set)DEFAULT_LOCALE_KEYS, (String)localeCode, (JsonNode)resourceLocaleTranslation, (boolean)false));
            TRANSLATION_VALUE_MAP.put(localeCode, JacksonUtil.merge((JsonNode)defaultTranslation.deepCopy(), (JsonNode)resourceLocaleTranslation));
        }
    }
}

