/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.telemetry;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.common.util.ThingsBoardThreadFactory;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.discovery.TbApplicationEventListener;
import org.thingsboard.server.queue.discovery.event.PartitionChangeEvent;
import org.thingsboard.server.service.subscription.SubscriptionManagerService;

public abstract class AbstractSubscriptionService
extends TbApplicationEventListener<PartitionChangeEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractSubscriptionService.class);
    protected final Set<TopicPartitionInfo> currentPartitions = ConcurrentHashMap.newKeySet();
    @Autowired
    protected TbClusterService clusterService;
    @Autowired
    protected PartitionService partitionService;
    @Autowired
    protected Optional<SubscriptionManagerService> subscriptionManagerService;
    protected ExecutorService wsCallBackExecutor;

    protected abstract String getExecutorPrefix();

    @PostConstruct
    public void initExecutor() {
        this.wsCallBackExecutor = Executors.newSingleThreadExecutor((ThreadFactory)ThingsBoardThreadFactory.forName((String)(this.getExecutorPrefix() + "-service-ws-callback")));
    }

    @PreDestroy
    public void shutdownExecutor() {
        if (this.wsCallBackExecutor != null) {
            this.wsCallBackExecutor.shutdownNow();
        }
    }

    protected void onTbApplicationEvent(PartitionChangeEvent partitionChangeEvent) {
        if (ServiceType.TB_CORE.equals((Object)partitionChangeEvent.getServiceType())) {
            this.currentPartitions.clear();
            this.currentPartitions.addAll(partitionChangeEvent.getCorePartitions());
        }
    }

    protected void forwardToSubscriptionManagerService(TenantId tenantId, EntityId entityId, Consumer<SubscriptionManagerService> toSubscriptionManagerService, Supplier<TransportProtos.ToCoreMsg> toCore) {
        TopicPartitionInfo tpi = this.partitionService.resolve(ServiceType.TB_CORE, tenantId, entityId);
        if (this.currentPartitions.contains(tpi)) {
            if (this.subscriptionManagerService.isPresent()) {
                toSubscriptionManagerService.accept((SubscriptionManagerService)this.subscriptionManagerService.get());
            } else {
                log.warn("Possible misconfiguration because subscriptionManagerService is null!");
            }
        } else {
            TransportProtos.ToCoreMsg toCoreMsg = toCore.get();
            this.clusterService.pushMsgToCore(tpi, entityId.getId(), toCoreMsg, null);
        }
    }

    protected <T> void addWsCallback(ListenableFuture<T> saveFuture, Consumer<T> callback) {
        this.addCallback(saveFuture, callback, (Executor)this.wsCallBackExecutor);
    }

    protected <T> void addCallback(ListenableFuture<T> saveFuture, Consumer<T> callback, Executor executor) {
        Futures.addCallback(saveFuture, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */, (Executor)executor);
    }

    protected static Consumer<Throwable> safeCallback(FutureCallback<Void> callback) {
        if (callback != null) {
            return arg_0 -> callback.onFailure(arg_0);
        }
        return throwable -> {};
    }
}

