/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.vc.data;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.sync.ie.EntityExportSettings;
import org.thingsboard.server.common.data.sync.vc.request.create.VersionCreateConfig;
import org.thingsboard.server.common.data.sync.vc.request.create.VersionCreateRequest;
import org.thingsboard.server.service.sync.vc.data.CommitGitRequest;

public abstract class EntitiesExportCtx<R extends VersionCreateRequest> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntitiesExportCtx.class);
    protected final User user;
    protected final CommitGitRequest commit;
    protected final R request;
    private final List<ListenableFuture<Void>> futures;
    private final Map<EntityId, EntityId> externalIdMap;
    private final boolean exportRelatedCustomers;
    private final boolean exportRelatedEntities;

    public EntitiesExportCtx(User user, CommitGitRequest commit, R request, boolean exportRelatedCustomers, boolean exportRelatedEntities) {
        this.user = user;
        this.commit = commit;
        this.request = request;
        this.futures = new ArrayList();
        this.externalIdMap = new HashMap();
        this.exportRelatedCustomers = exportRelatedCustomers;
        this.exportRelatedEntities = exportRelatedEntities;
    }

    protected <T extends R> EntitiesExportCtx(EntitiesExportCtx<T> other) {
        this.user = other.getUser();
        this.commit = other.getCommit();
        this.request = other.getRequest();
        this.futures = other.getFutures();
        this.externalIdMap = other.getExternalIdMap();
        this.exportRelatedCustomers = other.isExportRelatedCustomers();
        this.exportRelatedEntities = other.isExportRelatedEntities();
    }

    public void add(ListenableFuture<Void> future) {
        this.futures.add(future);
    }

    public TenantId getTenantId() {
        return this.user.getTenantId();
    }

    protected static EntityExportSettings buildExportSettings(VersionCreateConfig config) {
        return EntityExportSettings.builder().exportRelations(config.isSaveRelations()).exportAttributes(config.isSaveAttributes()).exportCredentials(config.isSaveCredentials()).exportCalculatedFields(config.isSaveCalculatedFields()).exportGroupEntities(config.isSaveGroupEntities()).exportPermissions(config.isSavePermissions()).build();
    }

    public abstract EntityExportSettings getSettings();

    public <ID extends EntityId> ID getExternalId(ID internalId) {
        EntityId result = (EntityId)this.externalIdMap.get(internalId);
        log.debug("[{}][{}] Local cache {} for id", new Object[]{internalId.getEntityType(), internalId.getId(), result != null ? "hit" : "miss"});
        return (ID)result;
    }

    public void putExternalId(EntityId internalId, EntityId externalId) {
        log.debug("[{}][{}] Local cache put: {}", new Object[]{internalId.getEntityType(), internalId.getId(), externalId});
        this.externalIdMap.put(internalId, externalId != null ? externalId : internalId);
    }

    public boolean shouldExportEntities(EntityType entityType) {
        return entityType != EntityType.USER;
    }

    @Generated
    public User getUser() {
        return this.user;
    }

    @Generated
    public CommitGitRequest getCommit() {
        return this.commit;
    }

    @Generated
    public R getRequest() {
        return (R)this.request;
    }

    @Generated
    public List<ListenableFuture<Void>> getFutures() {
        return this.futures;
    }

    @Generated
    public Map<EntityId, EntityId> getExternalIdMap() {
        return this.externalIdMap;
    }

    @Generated
    public boolean isExportRelatedCustomers() {
        return this.exportRelatedCustomers;
    }

    @Generated
    public boolean isExportRelatedEntities() {
        return this.exportRelatedEntities;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntitiesExportCtx)) {
            return false;
        }
        EntitiesExportCtx other = (EntitiesExportCtx)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isExportRelatedCustomers() != other.isExportRelatedCustomers()) {
            return false;
        }
        if (this.isExportRelatedEntities() != other.isExportRelatedEntities()) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        CommitGitRequest this$commit = this.getCommit();
        CommitGitRequest other$commit = other.getCommit();
        if (this$commit == null ? other$commit != null : !this$commit.equals(other$commit)) {
            return false;
        }
        VersionCreateRequest this$request = this.getRequest();
        VersionCreateRequest other$request = other.getRequest();
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        List this$futures = this.getFutures();
        List other$futures = other.getFutures();
        if (this$futures == null ? other$futures != null : !((Object)this$futures).equals(other$futures)) {
            return false;
        }
        Map this$externalIdMap = this.getExternalIdMap();
        Map other$externalIdMap = other.getExternalIdMap();
        return !(this$externalIdMap == null ? other$externalIdMap != null : !((Object)this$externalIdMap).equals(other$externalIdMap));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EntitiesExportCtx;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isExportRelatedCustomers() ? 79 : 97);
        result = result * 59 + (this.isExportRelatedEntities() ? 79 : 97);
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        CommitGitRequest $commit = this.getCommit();
        result = result * 59 + ($commit == null ? 43 : $commit.hashCode());
        VersionCreateRequest $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        List $futures = this.getFutures();
        result = result * 59 + ($futures == null ? 43 : ((Object)$futures).hashCode());
        Map $externalIdMap = this.getExternalIdMap();
        result = result * 59 + ($externalIdMap == null ? 43 : ((Object)$externalIdMap).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EntitiesExportCtx(user=" + String.valueOf(this.getUser()) + ", commit=" + String.valueOf(this.getCommit()) + ", request=" + String.valueOf(this.getRequest()) + ", futures=" + String.valueOf(this.getFutures()) + ", externalIdMap=" + String.valueOf(this.getExternalIdMap()) + ", exportRelatedCustomers=" + this.isExportRelatedCustomers() + ", exportRelatedEntities=" + this.isExportRelatedEntities() + ")";
    }
}

