/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.vc.data;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import lombok.Generated;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.sync.ie.EntityExportSettings;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.sync.vc.data.CommitGitRequest;

public class BasicExportCtx {
    protected final SecurityUser user;
    private final CommitGitRequest commit;
    private final List<ListenableFuture<Void>> futures;
    private final EntityExportSettings settings;

    public BasicExportCtx(SecurityUser user, CommitGitRequest commit, List<ListenableFuture<Void>> futures, EntityExportSettings settings) {
        this.user = user;
        this.commit = commit;
        this.futures = futures;
        this.settings = settings;
    }

    public TenantId getTenantId() {
        return this.user.getTenantId();
    }

    public void add(ListenableFuture<Void> future) {
        this.futures.add(future);
    }

    @Generated
    public SecurityUser getUser() {
        return this.user;
    }

    @Generated
    public CommitGitRequest getCommit() {
        return this.commit;
    }

    @Generated
    public List<ListenableFuture<Void>> getFutures() {
        return this.futures;
    }

    @Generated
    public EntityExportSettings getSettings() {
        return this.settings;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasicExportCtx)) {
            return false;
        }
        BasicExportCtx other = (BasicExportCtx)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        SecurityUser this$user = this.getUser();
        SecurityUser other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        CommitGitRequest this$commit = this.getCommit();
        CommitGitRequest other$commit = other.getCommit();
        if (this$commit == null ? other$commit != null : !this$commit.equals(other$commit)) {
            return false;
        }
        List this$futures = this.getFutures();
        List other$futures = other.getFutures();
        if (this$futures == null ? other$futures != null : !((Object)this$futures).equals(other$futures)) {
            return false;
        }
        EntityExportSettings this$settings = this.getSettings();
        EntityExportSettings other$settings = other.getSettings();
        return !(this$settings == null ? other$settings != null : !this$settings.equals(other$settings));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BasicExportCtx;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SecurityUser $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        CommitGitRequest $commit = this.getCommit();
        result = result * 59 + ($commit == null ? 43 : $commit.hashCode());
        List $futures = this.getFutures();
        result = result * 59 + ($futures == null ? 43 : ((Object)$futures).hashCode());
        EntityExportSettings $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : $settings.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BasicExportCtx(user=" + String.valueOf(this.getUser()) + ", commit=" + String.valueOf(this.getCommit()) + ", futures=" + String.valueOf(this.getFutures()) + ", settings=" + String.valueOf(this.getSettings()) + ")";
    }
}

